/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import oracle.dmt.dataminer.res.DataMinerIcons;
import oracle.dmt.dataminer.res.Icons;
import oracle.dmt.dataminer.workflow.dialog.build.BuildEditorLrb;
import oracle.javatools.icons.OracleIcons;

public class MiningTypeUIHelper {
    public static final String MULTI_SELECT_RES = BuildEditorLrb.get("BUILD_DATA_USAGE_MULTI_SELECT");
    public static final String CATEGORICAL = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_CAT");
    public static final String NUMERICAL = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_NUM");
    public static final String TEXT = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_TXT");
    public static final String TEXT_CUSTOM = BuildEditorLrb.get("BUILD_DATA_USAGE_MINING_TYPE_TXTCUST");

    public static MiningTypeComboRenderer createMiningTypeComboRenderer() {
        return new MiningTypeComboRenderer();
    }

    public static MiningTypeRenderer createMiningTypeRenderer() {
        return new MiningTypeRenderer();
    }

    public static class MiningTypeComboRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = (String)object;
            this.setText(string);
            if (string.equals(NUMERICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_NUMERICAL));
            } else if (string.equals(CATEGORICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CATEGORICAL));
            } else if (string.equals(TEXT)) {
                this.setIcon(OracleIcons.getIcon((String)"openbook.png"));
            } else if (string.equals(TEXT_CUSTOM)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CUSTOM_TEXT));
            } else if (string.equals(MULTI_SELECT_RES)) {
                this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
            }
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }

    public static class MiningTypeRenderer
    extends DefaultTableCellRenderer {
        public MiningTypeRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            String string = (String)object;
            int n3 = jTable.convertRowIndexToModel(n);
            int n4 = jTable.convertColumnIndexToModel(n2);
            boolean bl3 = jTable.getModel().isCellEditable(n3, n4);
            this.setEnabled(bl3);
            if (string.equals(NUMERICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_NUMERICAL));
            } else if (string.equals(CATEGORICAL)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CATEGORICAL));
            } else if (string.equals(TEXT)) {
                this.setIcon(OracleIcons.getIcon((String)"openbook.png"));
            } else if (string.equals(TEXT_CUSTOM)) {
                this.setIcon(DataMinerIcons.get(Icons.MTYPE_CUSTOM_TEXT));
            } else if (string.equals(MULTI_SELECT_RES)) {
                this.setIcon(DataMinerIcons.get(Icons.UNKNOWN_SETTING));
            }
            if (bl) {
                this.setBackground(jTable.getSelectionBackground());
                this.setForeground(jTable.getSelectionForeground());
            } else {
                this.setBackground(jTable.getBackground());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }
}

