/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import oracle.dmt.dataminer.CommonLrb;
import oracle.dmt.dataminer.DataminerGUIPanel;
import oracle.dmt.dataminer.controls.ControlsLrb;
import oracle.dmt.dataminer.controls.DataMinerSearchControl;
import oracle.dmt.dataminer.core.dal.ConnectionManager;
import oracle.dmt.dataminer.core.dal.Query;
import oracle.dmt.dataminer.core.dal.sql.SqlDataAccessObject;
import oracle.dmt.dataminer.core.dal.sql.queries.StringSearchQuery;
import oracle.dmt.dataminer.core.dal.sql.utils.SqlUtils;
import oracle.dmt.dataminer.navigator.ConnectionFolder;
import oracle.dmt.dataminer.partition.PartitionsLrb;
import oracle.dmt.dataminer.utils.ODMrSwingWorker;
import oracle.ide.Context;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.ui.ghost.GhostPointingPalette;
import oracle.javatools.ui.ghost.UIConstants;
import oracle.javatools.ui.infotip.InfoTip;
import oracle.javatools.ui.infotip.InfoTipStyles;
import oracle.javatools.ui.infotip.templates.BalloonTemplate;
import oracle.javatools.ui.infotip.templates.Template;
import oracle.javatools.util.Version;

public final class DataMinerFindValuesPanel
extends JPanel
implements DataminerGUIPanel {
    private static final Logger LOGGER = Logger.getLogger(DataMinerFindValuesPanel.class.getName());
    private SqlDataAccessObject dao;
    private Version dbVersion;
    private GhostPointingPalette ghostPalette;
    private BalloonTemplate balloonTemplate;
    private StringSearchQuery query;
    private DisplayMode displayMode;
    private String selectedValue;
    private InfoTip infoTip;
    private DefaultListModel<String> messageModel;
    private DefaultListModel<String> listModel;
    private String multiSelectionDelimiter;
    private JButton cancelButton;
    private JButton okButton;
    private JPanel panel;
    private JRadioButton radioButtonContains;
    private ButtonGroup radioButtonGroup;
    private JRadioButton radioButtonStartsWith;
    private JCheckBox sampleCheckBox;
    private JLabel sampleLabel;
    private JSpinner sampleSpinner;
    private DataMinerSearchControl searchControl;
    private JList<String> valuesList;
    private JScrollPane valuesScrollPane;

    public DataMinerFindValuesPanel(Context context, StringSearchQuery stringSearchQuery, DisplayMode displayMode) {
        assert (context != null) : "Context cannot be null.";
        assert (stringSearchQuery != null) : "Query cannot be null.";
        ConnectionFolder connectionFolder = ConnectionFolder.getConnectionFolder(context);
        this.dao = new SqlDataAccessObject((ConnectionManager)connectionFolder);
        this.dbVersion = connectionFolder.getDbVersion();
        this.query = stringSearchQuery;
        this.displayMode = displayMode == null ? DisplayMode.GHOST : displayMode;
        this.messageModel = new DefaultListModel();
        this.listModel = new DefaultListModel();
        this.multiSelectionDelimiter = ";";
        this.initComponents();
        this.initUI();
        this.initRes();
    }

    private void initComponents() {
        this.radioButtonGroup = new ButtonGroup();
        this.panel = new JPanel();
        this.valuesScrollPane = new JScrollPane();
        this.valuesList = new JList();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.searchControl = new DataMinerSearchControl();
        this.sampleCheckBox = new JCheckBox();
        this.sampleSpinner = new JSpinner();
        this.sampleLabel = new JLabel();
        this.radioButtonStartsWith = new JRadioButton();
        this.radioButtonContains = new JRadioButton();
        this.valuesScrollPane.setAutoscrolls(true);
        this.valuesScrollPane.setMaximumSize(new Dimension(258, 130));
        this.valuesList.setSelectionMode(0);
        this.valuesList.setAutoscrolls(false);
        this.valuesList.setMaximumSize(new Dimension(256, 130));
        this.valuesScrollPane.setViewportView(this.valuesList);
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.setPreferredSize(new Dimension(80, 25));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setPreferredSize(new Dimension(80, 25));
        this.sampleCheckBox.setText("Find Using Sample (Faster)");
        this.sampleSpinner.setValue(2000);
        this.sampleLabel.setText("Sample Size:");
        this.radioButtonGroup.add(this.radioButtonStartsWith);
        this.radioButtonStartsWith.setSelected(true);
        this.radioButtonStartsWith.setText("Starts With");
        this.radioButtonGroup.add(this.radioButtonContains);
        this.radioButtonContains.setText("Contains");
        GroupLayout groupLayout = new GroupLayout(this.panel);
        this.panel.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.searchControl, -2, 0, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.valuesScrollPane, -1, -1, Short.MAX_VALUE).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addComponent(this.radioButtonStartsWith).addGap(18, 18, 18).addComponent(this.radioButtonContains)).addComponent(this.sampleCheckBox).addGroup(groupLayout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.sampleLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sampleSpinner, -2, 108, -2)).addGroup(groupLayout.createSequentialGroup().addGap(102, 102, 102).addComponent(this.cancelButton, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.searchControl, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sampleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sampleSpinner, -2, -1, -2).addComponent(this.sampleLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.radioButtonStartsWith).addComponent(this.radioButtonContains)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.valuesScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.okButton, -2, -1, -2)).addContainerGap()));
        GroupLayout groupLayout2 = new GroupLayout(this);
        this.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.panel, -2, -1, -2).addContainerGap()));
    }

    @Override
    public void initRes() {
        ResourceUtils.resSpinner((JLabel)this.sampleLabel, (JSpinner)this.sampleSpinner, (String)ControlsLrb.get("FIND_VALUES_CONTROL_SAMPLE_SIZE"));
        ResourceUtils.resButton((AbstractButton)this.sampleCheckBox, (String)ControlsLrb.get("FIND_VALUES_CONTROL_USE_SAMPLE"));
        ResourceUtils.resButton((AbstractButton)this.radioButtonStartsWith, (String)PartitionsLrb.get("VALUE_SELECTOR_STARTS"));
        ResourceUtils.resButton((AbstractButton)this.radioButtonContains, (String)PartitionsLrb.get("VALUE_SELECTOR_CONTAINS"));
        ResourceUtils.resButton((AbstractButton)this.okButton, (String)CommonLrb.get("OK"));
        ResourceUtils.resButton((AbstractButton)this.cancelButton, (String)CommonLrb.get("CANCEL"));
    }

    @Override
    public void initUI() {
        if (DisplayMode.BALLOON.equals((Object)this.displayMode)) {
            this.balloonTemplate = new BalloonTemplate();
            this.balloonTemplate.setTitle(OracleIcons.getIcon((String)"find.png"), ControlsLrb.get("FIND_VALUES_CONTROL_TITLE"));
            this.infoTip = new InfoTip((Template)this.balloonTemplate, InfoTipStyles.DEFAULT);
        }
        this.valuesList.addListSelectionListener(listSelectionEvent -> {
            this.selectedValue = this.valuesList.getSelectedValue();
            if (this.selectedValue != null) {
                this.okButton.setEnabled(true);
            }
        });
        this.sampleCheckBox.addChangeListener(changeEvent -> this.sampleSpinner.setEnabled(this.sampleCheckBox.isSelected()));
        this.sampleSpinner.setModel(new SpinnerNumberModel(2000, 1, Integer.MAX_VALUE, 100));
        this.searchControl.addActionListener(true, actionEvent -> {
            SearchWorker searchWorker = new SearchWorker();
            searchWorker.execute();
        });
        this.cancelButton.addActionListener(actionEvent -> {
            if (DisplayMode.GHOST.equals((Object)this.displayMode)) {
                this.closeGhostDialog(true);
            } else {
                this.closeTooltipDialog(true);
            }
        });
    }

    private void showAsTooltipDialog(JComponent jComponent) {
        if (this.infoTip.isShowing()) {
            return;
        }
        this.balloonTemplate.setContent((JComponent)this);
        this.infoTip.show(jComponent);
    }

    private void showAsGhostPointingPalette(JComponent jComponent, UIConstants.Look look) {
        if (this.ghostPalette != null && this.ghostPalette.isShowing()) {
            return;
        }
        this.ghostPalette = new GhostPointingPalette();
        this.ghostPalette.setTitle(ControlsLrb.get("FIND_VALUES_CONTROL_TITLE"));
        this.ghostPalette.setLook(look == null ? UIConstants.Look.LIGHT : look);
        this.ghostPalette.setHideOnLoseFocus(true);
        this.ghostPalette.setCloseVisible(false);
        this.ghostPalette.setReceivesFocus(true);
        int n = jComponent.getSize().height - 2;
        this.ghostPalette.setPointing(jComponent, new Point(2, n));
        this.ghostPalette.add((Component)this);
        this.ghostPalette.pack();
        this.ghostPalette.show(true, true);
    }

    public void clear() {
        this.selectedValue = null;
        this.okButton.setEnabled(false);
        this.sampleCheckBox.setSelected(false);
        this.radioButtonStartsWith.setSelected(true);
        this.valuesList.setModel(new DefaultListModel());
        this.searchControl.setSearchText("");
    }

    public void show(JComponent jComponent) {
        this.valuesList.clearSelection();
        if (DisplayMode.GHOST.equals((Object)this.displayMode)) {
            this.showAsGhostPointingPalette(jComponent, UIConstants.Look.LIGHT);
        } else {
            this.showAsTooltipDialog(jComponent);
        }
    }

    public void show(JComponent jComponent, UIConstants.Look look) {
        this.valuesList.clearSelection();
        if (DisplayMode.GHOST.equals((Object)this.displayMode)) {
            this.showAsGhostPointingPalette(jComponent, look);
        } else {
            this.showAsTooltipDialog(jComponent);
        }
    }

    public void close(boolean bl) {
        if (DisplayMode.GHOST.equals((Object)this.displayMode)) {
            this.closeGhostDialog(bl);
        } else {
            this.closeTooltipDialog(bl);
        }
    }

    private void closeTooltipDialog(boolean bl) {
        if (this.infoTip != null && this.infoTip.isShowing()) {
            this.infoTip.hide();
            if (bl) {
                this.clear();
            }
        }
    }

    private void closeGhostDialog(boolean bl) {
        if (this.ghostPalette != null && this.ghostPalette.isShowing()) {
            this.ghostPalette.hidePanel();
            if (bl) {
                this.clear();
            }
        }
    }

    public void addOKListener(ActionListener actionListener) {
        this.okButton.addActionListener(actionListener);
    }

    public String getSelectedValue() {
        return this.valuesList.getSelectedValuesList().stream().collect(Collectors.joining(this.multiSelectionDelimiter));
    }

    public boolean isSampledSearch() {
        return this.sampleCheckBox.isSelected();
    }

    public Integer getSampleSize() {
        return this.sampleSpinner.isEnabled() ? (Integer)this.sampleSpinner.getValue() : null;
    }

    public boolean searchStartsWith() {
        return this.radioButtonStartsWith.isSelected();
    }

    public String getSearchText() {
        return this.searchControl.getSearchText();
    }

    public void setMultiSelectionDelimiter(String string) {
        this.multiSelectionDelimiter = string;
    }

    public void setListModel(DefaultListModel<String> defaultListModel) {
        this.valuesList.setModel(defaultListModel);
        this.okButton.setEnabled(false);
    }

    public void setMultiSelection(boolean bl) {
        if (bl) {
            this.valuesList.setSelectionMode(2);
        } else {
            this.valuesList.setSelectionMode(0);
        }
    }

    public void setQuery(StringSearchQuery stringSearchQuery) {
        this.query = stringSearchQuery;
    }

    public static enum DisplayMode {
        GHOST,
        BALLOON;

    }

    private class SearchWorker
    extends ODMrSwingWorker<DefaultListModel<String>, Void> {
        private SearchWorker() {
            super(DataMinerFindValuesPanel.this);
            DataMinerFindValuesPanel.this.messageModel.clear();
            DataMinerFindValuesPanel.this.messageModel.addElement(CommonLrb.get("LOADING"));
            DataMinerFindValuesPanel.this.setListModel(DataMinerFindValuesPanel.this.messageModel);
        }

        @Override
        protected DefaultListModel<String> doInBackground() throws Exception {
            DataMinerFindValuesPanel.this.query.setSearchString(DataMinerFindValuesPanel.this.getSearchText().toUpperCase());
            DataMinerFindValuesPanel.this.query.setLikeSearchMode(DataMinerFindValuesPanel.this.searchStartsWith() ? SqlUtils.LikeMode.STARTS : SqlUtils.LikeMode.CONTAINS);
            List list = DataMinerFindValuesPanel.this.isSampledSearch() ? DataMinerFindValuesPanel.this.dao.readItems((Query)DataMinerFindValuesPanel.this.query, 0, DataMinerFindValuesPanel.this.getSampleSize().intValue()) : DataMinerFindValuesPanel.this.dao.readItems((Query)DataMinerFindValuesPanel.this.query);
            DataMinerFindValuesPanel.this.listModel.clear();
            if (list.isEmpty()) {
                DataMinerFindValuesPanel.this.messageModel.clear();
                DataMinerFindValuesPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
                return DataMinerFindValuesPanel.this.messageModel;
            }
            list.forEach(string -> DataMinerFindValuesPanel.this.listModel.addElement((String)string));
            return DataMinerFindValuesPanel.this.listModel;
        }

        @Override
        protected void onSuccess(DefaultListModel<String> defaultListModel) throws Exception {
            DataMinerFindValuesPanel.this.setListModel(defaultListModel);
        }

        @Override
        protected void onFailure(Throwable throwable) {
            LOGGER.log(Level.SEVERE, throwable.getLocalizedMessage(), throwable);
            DataMinerFindValuesPanel.this.messageModel.clear();
            DataMinerFindValuesPanel.this.messageModel.addElement(PartitionsLrb.get("VALUE_SELECTOR_NO_MATCH"));
            DataMinerFindValuesPanel.this.setListModel(DataMinerFindValuesPanel.this.messageModel);
        }
    }
}

