/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import oracle.ide.model.UpdateMessage;

public abstract class PropertyChangeEventProvider {
    public static PropertyChangeEventProvider get(PropertyChangeEvent event) {
        return new SinglePropertyChangeEventProvider(event);
    }

    public static PropertyChangeEventProvider get(Collection<PropertyChangeEvent> event) {
        return new MultiplePropertyChangeEventProvider(event);
    }

    public static PropertyChangeEventProvider get(UpdateMessage message) {
        return new UpdateMessagePropertyChangeEventProvider(message);
    }

    abstract PropertyChangeEvent getPropertyChangeEvent(String var1);

    private static final class SinglePropertyChangeEventProvider
    extends PropertyChangeEventProvider {
        private final PropertyChangeEvent event;

        SinglePropertyChangeEventProvider(PropertyChangeEvent event) {
            this.event = event;
        }

        @Override
        public PropertyChangeEvent getPropertyChangeEvent(String name) {
            if (name.equals(this.event.getPropertyName())) {
                return this.event;
            }
            return null;
        }
    }

    private static class MultiplePropertyChangeEventProvider
    extends PropertyChangeEventProvider {
        private final Map<String, PropertyChangeEvent> events;

        MultiplePropertyChangeEventProvider(Collection<PropertyChangeEvent> events) {
            this.events = new HashMap<String, PropertyChangeEvent>(events.size());
            for (PropertyChangeEvent event : events) {
                this.events.put(event.getPropertyName(), event);
            }
        }

        @Override
        public PropertyChangeEvent getPropertyChangeEvent(String name) {
            return this.events.get(name);
        }
    }

    private static final class UpdateMessagePropertyChangeEventProvider
    extends PropertyChangeEventProvider {
        private final UpdateMessage message;

        UpdateMessagePropertyChangeEventProvider(UpdateMessage message) {
            this.message = message;
        }

        @Override
        public PropertyChangeEvent getPropertyChangeEvent(String name) {
            Object property = this.message.getProperty(name);
            if (property instanceof PropertyChangeEvent) {
                return (PropertyChangeEvent)property;
            }
            return null;
        }
    }
}

