/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.DeferredElementVisitorHook;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.util.MetaClass;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.Version;
import oracle.ide.extension.MetaClassList;
import oracle.ide.extension.rules.RuleEngine;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.net.FileLocator;
import oracle.ide.net.URLPath;
import oracle.ide.osgi.boot.api.IdeBootProperties;
import oracle.ide.util.VersionNumber;
import oracle.javatools.exports.comment.RemediationCommentsReader;
import oracle.javatools.exports.common.Iterables;
import oracle.javatools.exports.common.StringPool;
import oracle.javatools.exports.file.Paths;
import oracle.javatools.exports.library.ClassPathEntry;
import oracle.javatools.exports.library.ExportLibraryReader;
import oracle.javatools.exports.library.FileExportLibrary;
import oracle.javatools.exports.library.LibraryDependency;
import oracle.javatools.exports.message.Log;
import oracle.javatools.exports.message.Message;
import oracle.javatools.exports.message.Severity;
import oracle.javatools.exports.message.Tag;
import oracle.javatools.exports.name.NameSpace;
import oracle.javatools.exports.specification.ExportLinkage;
import oracle.javatools.exports.specification.ExportSpecificationReader;
import oracle.jdeveloper.library.AbstractLibraryHook;
import oracle.jdeveloper.library.AddinJDK;
import oracle.jdeveloper.library.AddinLibrary;
import oracle.jdeveloper.library.DerivedLibrary;
import oracle.jdeveloper.library.DynamicLibraryProvider;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.JLibraryNode;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.ManifestLibrary;
import oracle.jdevimpl.library.LibraryProxy;
import org.xml.sax.SAXException;

public final class LibrariesHook
extends AbstractLibraryHook {
    public static final ElementName ELEMENT = LibrariesHook.e("libraries");
    private static LibrariesHook INSTANCE;
    private static final String LIBRARY = "Library";
    private static final boolean VERIFY_DOC_PATHS;
    private static final String NS = "http://xmlns.oracle.com/jdeveloper/1013/jdev-libraries";
    private final Path MIDDLEWARE_HOME = Paths.get((String)IdeBootProperties.getMiddlewareHome(), (String[])new String[0]);
    private final ElementVisitor _libraryHandler = new LibraryHandler();
    private final ElementVisitor _aliasHandler = new AliasHandler();
    private final ElementVisitor _dynamicLibraryHandler = new DynamicLibraryHandler();
    private final ElementVisitor _derivedLibraryHandler = new DerivedLibraryHandler();
    private final ElementVisitor _libraryListHandler = new LibraryListHandler();
    private final ElementVisitor _jdkHandler = new JdkHandler();
    private final ElementVisitor _overrideHandler = new OverrideHandler();
    private final ElementVisitor _fragmentHandler = new FragmentHandler();
    private final Map<String, String> _aliases = Collections.synchronizedMap(new HashMap());
    private final Map<String, JLibrary> _addinLibraries = Collections.synchronizedMap(new HashMap());
    private final Map<String, AddinJDK> _jdks = Collections.synchronizedMap(new HashMap());
    private final Queue<JdkInfo> _jdkInfos = new ConcurrentLinkedQueue<JdkInfo>();
    private final List<DynamicLibraryProviderInfo> _dynamicLibraryProviders = new ArrayList<DynamicLibraryProviderInfo>();
    private final Map<String, MetaClass<DerivedLibrary>> _derivedLibraries = Collections.synchronizedMap(new HashMap());
    private final MetaClassList<LibraryList> _libraryLists = MetaClassList.get(LibraryList.class);
    private final List<OverrideInfo> _overrides = new CopyOnWriteArrayList<OverrideInfo>();
    private final ExportLibraryReader libraryReader;
    private volatile List<FileExportLibrary> exportLibraries = new ArrayList<FileExportLibrary>();
    private URL extensionUrl;
    private static final oracle.javatools.util.Log LOG;

    public static synchronized LibrariesHook getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new LibrariesHook();
        }
        return INSTANCE;
    }

    private static Logger getLogger() {
        return Logger.getLogger(LibrariesHook.class.getName());
    }

    private static boolean isSanityBuild() {
        return Version.DEBUG_BUILD != 0 && Version.BUILD_LABEL.endsWith(".S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LibrariesHook() {
        Log log;
        FileExportLibrary library;
        int i;
        boolean validating = Boolean.getBoolean("ide.library.schema.validate");
        ExportSpecificationReader specificationReader = new ExportSpecificationReader(NameSpace.defaultNameSpace(), null, validating, !validating);
        RemediationCommentsReader commentReader = new RemediationCommentsReader(StringPool.synchronizedPool(), validating, !validating);
        this.libraryReader = new ExportLibraryReader(specificationReader, commentReader, validating, !validating);
        LOG.trace("initializing LibrariesHook");
        ExtensionRegistry extensionRegistry = ExtensionRegistry.getExtensionRegistry();
        DeferredElementVisitorHook hookHandler = (DeferredElementVisitorHook)extensionRegistry.getHook(ELEMENT);
        long extensionsStart = System.currentTimeMillis();
        hookHandler.attachElementVisitor((ElementVisitor)this);
        int extensionLibraryCount = this.exportLibraries.size();
        long manifestsStart = System.currentTimeMillis();
        LOG.trace("{0} libraries defined by extensions in {1}ms", extensionLibraryCount, (int)(manifestsStart - extensionsStart));
        Path librariesPath = Paths.get((String)"plugins", (String[])new String[]{new File(Ide.getOracleHomeDirectory()).getName(), "libraries"});
        try (DirectoryStream<Path> productStream = Files.newDirectoryStream(this.MIDDLEWARE_HOME, x$0 -> Files.isDirectory(x$0, new LinkOption[0]));){
            for (Object productDirectory : Iterables.sortedList(productStream)) {
                Path librariesDirectory = productDirectory.resolve(librariesPath);
                if (!Files.isDirectory(librariesDirectory, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> libraryStream = Files.newDirectoryStream(librariesDirectory, "*.library");
                    try {
                        for (Path libraryPath : Iterables.sortedList(libraryStream)) {
                            Log log2 = Log.newLog((Tag[])new Tag[0]);
                            try {
                                FileExportLibrary library2 = this.libraryReader.read(libraryPath, Collections.emptyMap(), log2);
                                this.exportLibraries.add(library2);
                            }
                            catch (ExportLibraryReader.LegacyFormatException e) {
                                JLibraryNode legacyLibrary = new JLibraryNode(Paths.toUrl((Path)libraryPath), false);
                                EnumSet<FileExportLibrary.LibraryFlag> flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
                                if (legacyLibrary.getDeployedByDefault().booleanValue()) {
                                    flags.add(FileExportLibrary.LibraryFlag.DEPLOYED);
                                }
                                if (legacyLibrary.isLocked()) {
                                    flags.add(FileExportLibrary.LibraryFlag.LOCKED);
                                }
                                FileExportLibrary library3 = new FileExportLibrary(Paths.toUrl((Path)libraryPath), null, legacyLibrary.getName(), legacyLibrary.getId(), legacyLibrary.getDescription(), flags, legacyLibrary.getSuppliedClassPathEntries(), legacyLibrary.getExportSpecificationPaths(), legacyLibrary.getRemediationCommentsPaths(), legacyLibrary.getDependencies(), legacyLibrary.getSourcePath().asList(), legacyLibrary.getDocPath().asList(), null, null, null);
                                this.exportLibraries.add(library3);
                            }
                            catch (IOException | ParserConfigurationException | SAXException e) {
                                LibrariesHook.getLogger().severe(String.format("library %s not read: %s", libraryPath, e));
                            }
                            finally {
                                for (Message message : log2.getMessages()) {
                                    if (message.getSeverity() != Severity.ERROR) continue;
                                    LibrariesHook.getLogger().log(message.getLevel(), message.getMessage());
                                }
                            }
                        }
                    }
                    finally {
                        if (libraryStream == null) continue;
                        libraryStream.close();
                    }
                }
                catch (IOException e) {
                    LibrariesHook.getLogger().severe(String.format("middleware plugins directory %s not scanned: %s", librariesDirectory, e));
                }
            }
        }
        catch (IOException e) {
            LibrariesHook.getLogger().severe(String.format("middleware home %s plugin directories not scanned: %s", this.MIDDLEWARE_HOME, e));
        }
        LOG.trace("{0} libraries defined by manifests in {1}ms", this.exportLibraries.size() - extensionLibraryCount, (int)(System.currentTimeMillis() - manifestsStart));
        LinkedHashMap<String, FileExportLibrary> resolver = new LinkedHashMap<String, FileExportLibrary>();
        HashMap manifestCache = new HashMap();
        for (FileExportLibrary library4 : this.exportLibraries) {
            this.addLibrary(library4.getId(), "id", library4, resolver, LibrariesHook.getLogger());
            this.addLibrary(library4.getName(), "name", library4, resolver, LibrariesHook.getLogger());
            this.addLibrary(library4.getSyntheticId(), "synthetic id", library4, resolver, LibrariesHook.getLogger());
        }
        block25: for (Map.Entry<String, String> entry : this._aliases.entrySet()) {
            String alias = entry.getKey();
            String target = entry.getValue();
            FileExportLibrary overriddenLibrary = (FileExportLibrary)resolver.get(alias);
            if (overriddenLibrary != null) {
                LibrariesHook.getLogger().warning(String.format("library alias \"%s\" (to \"%s\") overrides explicit definition of \"%s\" from %s", alias, target, alias, Paths.relativize((URL)overriddenLibrary.getOrigin(), (Path)this.MIDDLEWARE_HOME)));
            }
            ArrayList<String> targets = new ArrayList<String>();
            String name = target;
            while (true) {
                if (targets.contains(name)) {
                    targets.add(name);
                    LibrariesHook.getLogger().severe(String.format("library alias \"%s\" is cyclical: %s", alias, this.chain(alias, targets, "")));
                    continue block25;
                }
                targets.add(name);
                if (!resolver.containsKey(name)) {
                    if (!this._aliases.containsKey(name)) {
                        LibrariesHook.getLogger().severe(String.format("library alias \"%s\" does not resolve to a library: %s", alias, this.chain(alias, targets, " (undefined)")));
                        continue block25;
                    }
                } else {
                    if (targets.size() <= 1) continue block25;
                    LibrariesHook.getLogger().warning(String.format("library alias \"%s\" resolves indirectly: %s", alias, this.chain(alias, targets, "")));
                    continue block25;
                }
                name = this._aliases.get(name);
            }
        }
        long resolveStart = System.currentTimeMillis();
        for (i = 0; i < extensionLibraryCount; ++i) {
            library = this.exportLibraries.get(i);
            log = Log.newLog((Tag[])new Tag[0]);
            library.resolve(this.libraryReader.getExportSpecificationReader(), this.libraryReader.getRemediationCommentsReader(), id -> resolver.get(this.resolveAlias((String)id)), manifestCache, log);
            for (Message message : log.getMessages()) {
                if (message.getSeverity() != Severity.ERROR) continue;
                LibrariesHook.getLogger().log(message.getLevel(), message.getMessage());
            }
            this._addinLibraries.putIfAbsent(library.getName(), new AddinLibrary(library));
        }
        for (i = extensionLibraryCount; i < this.exportLibraries.size(); ++i) {
            library = this.exportLibraries.get(i);
            log = Log.newLog((Tag[])new Tag[0]);
            library.resolve(this.libraryReader.getExportSpecificationReader(), this.libraryReader.getRemediationCommentsReader(), id -> resolver.get(this.resolveAlias((String)id)), manifestCache, log);
            for (Message message : log.getMessages()) {
                if (message.getSeverity() != Severity.ERROR) continue;
                LibrariesHook.getLogger().log(message.getLevel(), message.getMessage());
            }
            this._addinLibraries.putIfAbsent(library.getName(), new ManifestLibrary(library));
        }
        long resolveEnd = System.currentTimeMillis();
        LOG.trace("library resolution completed in {0}ms", (int)(resolveEnd - resolveStart));
        this.exportLibraries = null;
        LOG.trace("completed initializing LibrariesHook in {0}ms", (int)(resolveEnd - extensionsStart));
    }

    private String chain(String alias, List<String> targets, String tail) {
        StringBuilder builder = new StringBuilder();
        builder.append('\"').append(alias).append("\" -> ");
        for (int i = 0; i < targets.size() - 1; ++i) {
            builder.append('\"').append(targets.get(i)).append("\" -> ");
        }
        builder.append('\"').append(targets.get(targets.size() - 1)).append('\"').append(tail);
        return builder.toString();
    }

    private boolean addLibrary(String key, String by, FileExportLibrary library, Map<String, FileExportLibrary> map, Logger logger) {
        FileExportLibrary predecessor = map.putIfAbsent(key, library);
        if (predecessor != null && predecessor != library) {
            logger.warning(String.format("duplicate definition for library %s \"%s\": %s precedes %s", by, key, Paths.relativize((URL)predecessor.getOrigin(), (Path)this.MIDDLEWARE_HOME), Paths.relativize((URL)library.getOrigin(), (Path)this.MIDDLEWARE_HOME)));
        }
        return predecessor == null;
    }

    private static ElementName e(String name) {
        return new ElementName(NS, name);
    }

    public String resolveAlias(String name) {
        String realName = this._aliases.get(name);
        return realName == null ? name : realName;
    }

    public JLibrary getLibrary(String id) {
        LOG.trace("getting library {0} from LibrariesHook", (Object)id);
        return this._addinLibraries.get(id);
    }

    public AddinJDK getJDK(String id) {
        this.processJdkInfoQueue();
        return this._jdks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JLibrary> getLibraries() {
        ArrayList<JLibrary> libraries;
        LOG.trace("getting addin library list from LibrariesHook");
        Map<String, JLibrary> map = this._addinLibraries;
        synchronized (map) {
            libraries = new ArrayList<JLibrary>(this._addinLibraries.values());
        }
        return Collections.unmodifiableCollection(libraries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<AddinJDK> getJDKs() {
        ArrayList<AddinJDK> jdks;
        this.processJdkInfoQueue();
        Map<String, AddinJDK> map = this._jdks;
        synchronized (map) {
            jdks = new ArrayList<AddinJDK>(this._jdks.values());
        }
        return Collections.unmodifiableCollection(jdks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynamicLibraryProvider> getDynamicLibraryProviders(String[] technologyKeys) {
        ArrayList<DynamicLibraryProvider> providers = new ArrayList<DynamicLibraryProvider>();
        List<DynamicLibraryProviderInfo> list = this._dynamicLibraryProviders;
        synchronized (list) {
            for (DynamicLibraryProviderInfo info : this._dynamicLibraryProviders) {
                if (!info.hasTechnology(technologyKeys)) continue;
                providers.add(info.getInstance());
            }
            return Collections.unmodifiableList(providers);
        }
    }

    public List<LibraryList> getExtensionLibraryLists() {
        return this._libraryLists.getInstances();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<? extends DerivedLibrary> getDerivedLibraryClass(Class<?> sourceClass) {
        Map<String, MetaClass<DerivedLibrary>> map = this._derivedLibraries;
        synchronized (map) {
            for (Class<?> current = sourceClass; current != null; current = current.getSuperclass()) {
                MetaClass<DerivedLibrary> libraryClass = this._derivedLibraries.get(current.getName());
                if (libraryClass == null) continue;
                try {
                    return libraryClass.toClass();
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find derived library class " + libraryClass.getClassName(), e);
                }
            }
        }
        return null;
    }

    public JLibrary getLibraryOverride(Workspace workspace, Project project, JLibrary original) {
        if (!this._overrides.isEmpty()) {
            Context context = new Context();
            context.setWorkspace(workspace);
            context.setProject(project);
            JLibrary current = original;
            for (OverrideInfo info : this._overrides) {
                String ruleId = info.getRuleId();
                if (ruleId != null && !RuleEngine.getInstance().evaluateRule(ruleId, context)) continue;
                current = LibraryProxy.get(workspace, project, current, info.getOverrideInstance());
            }
            return current;
        }
        return original;
    }

    public void addLibraryOverride(Class<?> overrideClass) {
        this._overrides.add(new OverrideInfo(new MetaClass(overrideClass.getClassLoader(), overrideClass.getName()), "always-enabled"));
    }

    public void removeLibraryOverride(Class<?> overrideClass) {
        for (OverrideInfo info : this._overrides) {
            if (!info.overrideClass.getClassName().equals(overrideClass.getName()) || !info.overrideClass.getClassLoader().equals(overrideClass.getClassLoader())) continue;
            this._overrides.remove(info);
            break;
        }
    }

    private void processJdkInfoQueue() {
        JDK defaultJdk;
        JdkInfo jdkInfo = this._jdkInfos.poll();
        if (jdkInfo != null && (defaultJdk = JLibraryManager.getDefaultJDK()) != null) {
            while (jdkInfo != null) {
                this._jdks.put(jdkInfo.getName(), this.getJdk(jdkInfo, defaultJdk));
                jdkInfo = this._jdkInfos.poll();
            }
        }
    }

    private AddinJDK getJdk(JdkInfo jdkInfo, JDK defaultJdk) {
        String name = jdkInfo.getName();
        String version = jdkInfo.getVersion();
        return new AddinJDK(name, jdkInfo._classPath.size() > 0 ? jdkInfo._classPath : defaultJdk.getClassPath(), jdkInfo._srcPath.size() > 0 ? jdkInfo._srcPath : defaultJdk.getSourcePath(), jdkInfo._docPath.size() > 0 ? jdkInfo._docPath : defaultJdk.getDocPath(), defaultJdk.getJavaExecutable(), version == null ? defaultJdk.getJavaVersion() : new VersionNumber(version), defaultJdk.getSDKBinDir());
    }

    public void start(ElementStartContext context) {
        try {
            this.extensionUrl = FileLocator.resolve((URL)context.getExtensionSourceURI().toURL());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        LOG.trace("processing <libraries> in {0}", (Object)this.extensionUrl);
        context.registerChildVisitor(LibrariesHook.e("library"), this._libraryHandler);
        context.registerChildVisitor(LibrariesHook.e("alias"), this._aliasHandler);
        context.registerChildVisitor(LibrariesHook.e("dynamic-library"), this._dynamicLibraryHandler);
        context.registerChildVisitor(LibrariesHook.e("derived-library"), this._derivedLibraryHandler);
        context.registerChildVisitor(LibrariesHook.e("library-list"), this._libraryListHandler);
        context.registerChildVisitor(LibrariesHook.e("jdk"), this._jdkHandler);
        context.registerChildVisitor(LibrariesHook.e("override"), this._overrideHandler);
        context.registerChildVisitor(LibrariesHook.e("fragment"), this._fragmentHandler);
        if (this.exportLibraries == null) {
            LOG.trace("<libraries> element encountered after trigger hook completion from " + this.extensionUrl);
        }
    }

    private String getLocation(ElementStartContext context) {
        LocationAdapter adapter = (LocationAdapter)context.getScopeData().get("xml.locator");
        if (adapter == null) {
            return "<location unavailable>";
        }
        return adapter.getSystemId() + ":" + adapter.getLineNumber();
    }

    static {
        VERIFY_DOC_PATHS = !LibrariesHook.isSanityBuild() || Boolean.getBoolean("ide.library.verify.doc.paths");
        LOG = new oracle.javatools.util.Log("library-init");
    }

    private class LibraryHandler
    extends ElementVisitor {
        private String id;
        private String name;
        private String description;
        private EnumSet<FileExportLibrary.LibraryFlag> flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
        private Map<ClassPathEntry, ClassPathEntry> classPathEntries = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
        private Map<String, List<URL>> exportSpecificationPaths = new HashMap<String, List<URL>>();
        private List<URL> remediationCommentsPaths = new ArrayList<URL>();
        private List<LibraryDependency> dependencies = new ArrayList<LibraryDependency>();
        private URLPath sourcePath = new URLPath();
        private URLPath docPath = new URLPath();
        private URLPath endorsedDirs = new URLPath();
        private URLPath endorsedSourcePath = new URLPath();
        private URLPath endorsedDocPath = new URLPath();

        private LibraryHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("description"), (ElementVisitor)new DescriptionHandler());
            context.registerChildVisitor(LibrariesHook.e("dependency"), (ElementVisitor)new DependencyHandler());
            context.registerChildVisitor(LibrariesHook.e("classpath"), (ElementVisitor)new ClassPathHandler());
            context.registerChildVisitor(LibrariesHook.e("export-specification"), (ElementVisitor)new ExportSpecificationHandler());
            context.registerChildVisitor(LibrariesHook.e("remediation-comments"), (ElementVisitor)new RemediationCommentsHandler());
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SourcePathHandler());
            context.registerChildVisitor(LibrariesHook.e("sourcepath"), (ElementVisitor)new SourcePathHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-dirs"), (ElementVisitor)new EndorsedDirsHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-docpath"), (ElementVisitor)new EndorsedDocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-srcpath"), (ElementVisitor)new EndorsedSourcePathHandler());
            context.registerChildVisitor(LibrariesHook.e("endorsed-sourcepath"), (ElementVisitor)new EndorsedSourcePathHandler());
            this.id = context.getAttributeValue("id");
            this.name = context.getAttributeValue("name");
            this.description = null;
            this.flags = EnumSet.noneOf(FileExportLibrary.LibraryFlag.class);
            for (FileExportLibrary.LibraryFlag flag : FileExportLibrary.LibraryFlag.values()) {
                String value = context.getAttributeValue(flag.getAttributeName());
                if (!Boolean.parseBoolean(value)) continue;
                this.flags.add(flag);
            }
            String lazy = context.getAttributeValue("lazy");
            String force = context.getAttributeValue("forceExtensionInitialization");
            if (lazy == null && force != null && !force.trim().isEmpty() && !Boolean.parseBoolean(force)) {
                this.flags.add(FileExportLibrary.LibraryFlag.LAZY);
            }
            LOG.trace("loading {0} from {1} in LibrariesHook", (Object)this.name, (Object)LibrariesHook.this.extensionUrl);
            if (!this.classPathEntries.isEmpty()) {
                this.classPathEntries = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            }
            if (!this.exportSpecificationPaths.isEmpty()) {
                this.exportSpecificationPaths = new HashMap<String, List<URL>>();
            }
            if (!this.remediationCommentsPaths.isEmpty()) {
                this.remediationCommentsPaths = new ArrayList<URL>();
            }
            if (!this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<LibraryDependency>();
            }
            if (this.sourcePath.size() > 0) {
                this.sourcePath = new URLPath();
            }
            if (this.docPath.size() > 0) {
                this.docPath = new URLPath();
            }
            if (this.endorsedDirs.size() > 0) {
                this.endorsedDirs = new URLPath();
            }
            if (this.endorsedSourcePath.size() > 0) {
                this.endorsedSourcePath = new URLPath();
            }
            if (this.endorsedDocPath.size() > 0) {
                this.endorsedDocPath = new URLPath();
            }
        }

        public void end(ElementEndContext context) {
            FileExportLibrary library = new FileExportLibrary(LibrariesHook.this.extensionUrl, context.getExtension().getID(), this.name, this.id, this.description, this.flags, this.classPathEntries.isEmpty() ? Collections.emptyList() : new ArrayList<ClassPathEntry>(this.classPathEntries.keySet()), this.exportSpecificationPaths.isEmpty() ? Collections.emptyMap() : this.exportSpecificationPaths, this.remediationCommentsPaths.isEmpty() ? Collections.emptyList() : this.remediationCommentsPaths, this.dependencies.isEmpty() ? Collections.emptyList() : this.dependencies, this.sourcePath.size() == 0 ? Collections.emptyList() : this.sourcePath.asList(), this.docPath.size() == 0 ? Collections.emptyList() : this.docPath.asList(), this.endorsedDirs.size() == 0 ? Collections.emptyList() : this.endorsedDirs.asList(), this.endorsedSourcePath.size() == 0 ? Collections.emptyList() : this.endorsedSourcePath.asList(), this.endorsedDocPath.size() == 0 ? Collections.emptyList() : this.endorsedDocPath.asList());
            if (!this.classPathEntries.isEmpty()) {
                this.classPathEntries = new LinkedHashMap<ClassPathEntry, ClassPathEntry>();
            }
            if (!this.exportSpecificationPaths.isEmpty()) {
                this.exportSpecificationPaths = new HashMap<String, List<URL>>();
            }
            if (!this.remediationCommentsPaths.isEmpty()) {
                this.remediationCommentsPaths = new ArrayList<URL>();
            }
            if (!this.dependencies.isEmpty()) {
                this.dependencies = new ArrayList<LibraryDependency>();
            }
            Log log = Log.newLog((Tag[])new Tag[0]);
            List<FileExportLibrary> libraries = LibrariesHook.this.exportLibraries;
            if (libraries != null) {
                libraries.add(library);
            } else {
                library.resolve(LibrariesHook.this.libraryReader.getExportSpecificationReader(), LibrariesHook.this.libraryReader.getRemediationCommentsReader(), id -> null, null, log);
                LibrariesHook.this._addinLibraries.putIfAbsent(library.getName(), new AddinLibrary(library));
            }
            for (Message message : log.getMessages()) {
                if (message.getSeverity() != Severity.ERROR) continue;
                LibrariesHook.getLogger().log(message.getLevel(), message.getMessage());
            }
        }

        private final class DescriptionHandler
        extends ElementVisitor {
            private DescriptionHandler() {
            }

            public void end(ElementEndContext context) {
                LibraryHandler.this.description = context.getText();
            }
        }

        private final class DependencyHandler
        extends ElementVisitor {
            private boolean reexport;

            private DependencyHandler() {
            }

            public void start(ElementStartContext context) {
                this.reexport = Boolean.parseBoolean(context.getAttributeValue("reexport"));
            }

            public void end(ElementEndContext context) {
                LibraryDependency dependency = new LibraryDependency(context.getText(), this.reexport);
                LibraryHandler.this.dependencies.add(dependency);
            }
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            private ExportLinkage type;
            private String key;
            private boolean manifestExport;

            private ClassPathHandler() {
            }

            public void start(ElementStartContext context) {
                String value;
                String text = context.getAttributeValue("export");
                if (text != null && !(text = text.trim().toLowerCase()).isEmpty()) {
                    switch (text) {
                        case "none": {
                            this.type = ExportLinkage.NONE;
                            break;
                        }
                        case "embedded": {
                            this.type = ExportLinkage.EMBEDDED;
                            break;
                        }
                        case "library": {
                            this.type = ExportLinkage.LIBRARY;
                            break;
                        }
                        case "all": {
                            this.type = ExportLinkage.ALL;
                            break;
                        }
                        default: {
                            context.getLogger().severe("export attribute value \"" + text + "\" must be one of \"none\", \"embedded\", \"library\", or \"all\"");
                            break;
                        }
                    }
                } else {
                    this.type = ExportLinkage.NULL;
                }
                this.key = context.getAttributeValue("key");
                if (this.key == null) {
                    this.key = "";
                }
                if ((value = context.getAttributeValue("manifest-export")) == null) {
                    value = context.getAttributeValue("manifest");
                }
                this.manifestExport = Boolean.parseBoolean(value);
            }

            public void end(ElementEndContext context) {
                URLPath path = new URLPath();
                LibrariesHook.this.addURLPath(context, path, true);
                LocationAdapter location = (LocationAdapter)context.getScopeData().get("xml.locator");
                for (URL url : path) {
                    ClassPathEntry entry = new ClassPathEntry(url, this.type, this.key, this.manifestExport, location != null ? location.getLineNumber() : -1);
                    LibraryHandler.this.classPathEntries.put(entry, entry);
                }
            }
        }

        private final class ExportSpecificationHandler
        extends ElementVisitor {
            private String key;

            private ExportSpecificationHandler() {
            }

            public void start(ElementStartContext context) {
                this.key = context.getAttributeValue("key");
                if (this.key == null) {
                    this.key = "";
                }
            }

            public void end(ElementEndContext context) {
                URLPath path = new URLPath();
                LibrariesHook.this.addURLPath(context, path, true);
                LibraryHandler.this.exportSpecificationPaths.computeIfAbsent(this.key, v -> new ArrayList()).addAll(path.asList());
            }
        }

        private final class RemediationCommentsHandler
        extends ElementVisitor {
            private RemediationCommentsHandler() {
            }

            public void end(ElementEndContext context) {
                URLPath path = new URLPath();
                LibrariesHook.this.addURLPath(context, path, true);
                LibraryHandler.this.remediationCommentsPaths.addAll(path.asList());
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, LibraryHandler.this.docPath, VERIFY_DOC_PATHS);
            }
        }

        private final class SourcePathHandler
        extends ElementVisitor {
            private SourcePathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, LibraryHandler.this.sourcePath, true);
            }
        }

        private final class EndorsedDirsHandler
        extends ElementVisitor {
            private EndorsedDirsHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, LibraryHandler.this.endorsedDirs, true);
            }
        }

        private final class EndorsedDocPathHandler
        extends ElementVisitor {
            private EndorsedDocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, LibraryHandler.this.endorsedDocPath, VERIFY_DOC_PATHS);
            }
        }

        private final class EndorsedSourcePathHandler
        extends ElementVisitor {
            private EndorsedSourcePathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, LibraryHandler.this.endorsedSourcePath, true);
            }
        }
    }

    private class AliasHandler
    extends ElementVisitor {
        private AliasHandler() {
        }

        public void start(ElementStartContext context) {
            String from = context.getAttributeValue("from");
            String to = context.getAttributeValue("to");
            if (from == null || from.isEmpty() || to == null || to.isEmpty()) {
                LibrariesHook.getLogger().severe(String.format("missing or empty names in library alias: %s", LibrariesHook.this.getLocation(context)));
                return;
            }
            if (from.equals(to)) {
                LibrariesHook.getLogger().severe(String.format("library alias is trivially cyclical: %s", LibrariesHook.this.getLocation(context)));
                return;
            }
            LibrariesHook.this._aliases.put(from, to);
        }
    }

    private class DynamicLibraryHandler
    extends ElementVisitor {
        private DynamicLibraryHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start(ElementStartContext context) {
            String providerClassName = context.getAttributeValue("provider-class");
            if (providerClassName != null) {
                providerClassName = providerClassName.trim();
            }
            if (providerClassName == null || providerClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing provider-class for dynamic library");
            } else {
                String technologyKeys = context.getAttributeValue("technology-keys");
                if (technologyKeys != null) {
                    technologyKeys = technologyKeys.trim();
                }
                if (technologyKeys == null || technologyKeys.isEmpty()) {
                    this.log((ElementContext)context, Level.SEVERE, "Missing technology-keys for dynamic library");
                } else {
                    String[] keys = technologyKeys.split(",");
                    MetaClass providerClass = new MetaClass(this.getMetaClassLoader((ElementContext)context), providerClassName);
                    List<DynamicLibraryProviderInfo> list = LibrariesHook.this._dynamicLibraryProviders;
                    synchronized (list) {
                        LibrariesHook.this._dynamicLibraryProviders.add(new DynamicLibraryProviderInfo((MetaClass<DynamicLibraryProvider>)providerClass, keys));
                    }
                }
            }
        }
    }

    private class DerivedLibraryHandler
    extends ElementVisitor {
        private DerivedLibraryHandler() {
        }

        public void start(ElementStartContext context) {
            String libraryClassName;
            String sourceClassName = context.getAttributeValue("source-class");
            if (sourceClassName != null) {
                sourceClassName = sourceClassName.trim();
            }
            if ((libraryClassName = context.getAttributeValue("library-class")) != null) {
                libraryClassName = libraryClassName.trim();
            }
            if (sourceClassName == null || sourceClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing source-class for derived library");
            } else if (libraryClassName == null || libraryClassName.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing library-class for derived library");
            } else {
                ClassLoader classLoader = this.getMetaClassLoader((ElementContext)context);
                MetaClass libraryClass = new MetaClass(classLoader, libraryClassName);
                LibrariesHook.this._derivedLibraries.put(sourceClassName, (MetaClass<DerivedLibrary>)libraryClass);
            }
        }
    }

    private class LibraryListHandler
    extends ElementVisitor {
        private LibraryListHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            if (className != null) {
                className = className.trim();
            }
            if (className == null || className.isEmpty()) {
                this.log((ElementContext)context, Level.SEVERE, "Missing class for library list");
            } else {
                LibrariesHook.this._libraryLists.add(new MetaClass(this.getMetaClassLoader((ElementContext)context), className));
            }
        }
    }

    private class JdkHandler
    extends ElementVisitor {
        private JdkHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("classpath"), (ElementVisitor)new ClassPathHandler());
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            String name = context.getAttributeValue("name");
            String version = context.getAttributeValue("version");
            context.getScopeData().put(LibrariesHook.LIBRARY, new JdkInfo(name, version));
        }

        public void end(ElementEndContext context) {
            LibrariesHook.this._jdkInfos.add(this.getJdk((ElementContext)context));
        }

        private JdkInfo getJdk(ElementContext context) {
            return (JdkInfo)context.getScopeData().get(LibrariesHook.LIBRARY);
        }

        private final class ClassPathHandler
        extends ElementVisitor {
            private ClassPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._classPath, true);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._docPath, VERIFY_DOC_PATHS);
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, JdkHandler.this.getJdk((ElementContext)context)._srcPath, true);
            }
        }
    }

    private class OverrideHandler
    extends ElementVisitor {
        private OverrideHandler() {
        }

        public void start(ElementStartContext context) {
            String className = context.getAttributeValue("class");
            String ruleId = context.getAttributeValue("rule");
            if (ruleId != null) {
                if (RuleEngine.getInstance().validateRuleReference(ruleId, (ElementContext)context)) {
                    LibrariesHook.this._overrides.add(new OverrideInfo(new MetaClass(this.getMetaClassLoader((ElementContext)context), className), ruleId));
                }
            } else {
                this.log((ElementContext)context, Level.SEVERE, "Missing mandatory rule for library override");
            }
        }
    }

    private class FragmentHandler
    extends ElementVisitor {
        private String libraryName;
        private URLPath fragmentSourcePath;
        private URLPath fragmentDocPath;

        private FragmentHandler() {
        }

        public void start(ElementStartContext context) {
            context.registerChildVisitor(LibrariesHook.e("docpath"), (ElementVisitor)new DocPathHandler());
            context.registerChildVisitor(LibrariesHook.e("srcpath"), (ElementVisitor)new SrcPathHandler());
            this.libraryName = context.getAttributeValue("name");
            this.fragmentSourcePath = new URLPath();
            this.fragmentDocPath = new URLPath();
        }

        public void end(ElementEndContext context) {
            LOG.trace("adding fragment to {0} in {1}", (Object)this.libraryName, (Object)LibrariesHook.this.extensionUrl);
            int index = -1;
            for (int i = 0; i < LibrariesHook.this.exportLibraries.size(); ++i) {
                if (!LibrariesHook.this.exportLibraries.get(i).getName().equals(this.libraryName)) continue;
                index = i;
                break;
            }
            if (index >= 0) {
                FileExportLibrary library = LibrariesHook.this.exportLibraries.get(index);
                URLPath sourcePath = new URLPath();
                sourcePath.add((Collection)library.getSourcePath());
                sourcePath.add(this.fragmentSourcePath);
                URLPath docPath = new URLPath();
                docPath.add((Collection)library.getSourcePath());
                docPath.add(this.fragmentDocPath);
                LibrariesHook.this.exportLibraries.set(index, new FileExportLibrary(library.getOrigin(), library.getExtensionId(), library.getName(), library.getSyntheticId(), library.isIdSynthetic() ? null : library.getId(), library.getDescription(), library.getFlags(), library.getSuppliedClassPathEntries(), library.getExportSpecificationPaths(), library.getRemediationCommentsPaths(), library.getDependencies(), sourcePath.asList(), docPath.asList(), library.getEndorsedDirectoriesPath(), library.getEndorsedSourcePath(), library.getEndorsedDocPath()));
            } else {
                this.log((ElementContext)context, Level.SEVERE, "No library definition for " + this.libraryName);
            }
        }

        private final class DocPathHandler
        extends ElementVisitor {
            private DocPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, FragmentHandler.this.fragmentDocPath, VERIFY_DOC_PATHS);
            }
        }

        private final class SrcPathHandler
        extends ElementVisitor {
            private SrcPathHandler() {
            }

            public void end(ElementEndContext context) {
                LibrariesHook.this.addURLPath(context, FragmentHandler.this.fragmentSourcePath, true);
            }
        }
    }

    private static final class DynamicLibraryProviderInfo {
        private final MetaClass<DynamicLibraryProvider> providerClass;
        private final Set<String> technologyKeys;
        private DynamicLibraryProvider instance;

        public DynamicLibraryProviderInfo(MetaClass<DynamicLibraryProvider> providerClass, String[] technologyKeys) {
            this.providerClass = providerClass;
            this.technologyKeys = technologyKeys == null ? null : new HashSet<String>(Arrays.asList(technologyKeys));
        }

        public synchronized DynamicLibraryProvider getInstance() {
            if (this.instance == null) {
                try {
                    this.instance = (DynamicLibraryProvider)this.providerClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate dynamic library provider class " + this.providerClass.getClassName(), e);
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find dynamic library provider class " + this.providerClass.getClassName(), e);
                }
            }
            return this.instance;
        }

        public boolean hasTechnology(String[] technologyKeys) {
            if (this.technologyKeys == null) {
                return true;
            }
            for (String key : technologyKeys) {
                if (!this.technologyKeys.contains(key)) continue;
                return true;
            }
            return false;
        }
    }

    private static final class OverrideInfo {
        private final MetaClass<?> overrideClass;
        private final String ruleId;
        private Object instance;

        public OverrideInfo(MetaClass<?> overrideClass, String ruleId) {
            this.overrideClass = overrideClass;
            this.ruleId = ruleId;
        }

        public String getRuleId() {
            return this.ruleId;
        }

        public synchronized Object getOverrideInstance() {
            if (this.instance == null) {
                try {
                    this.instance = this.overrideClass.newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to instantiate library override class " + this.overrideClass.getClassName(), e);
                }
                catch (ClassNotFoundException e) {
                    LibrariesHook.getLogger().log(Level.SEVERE, "Unable to find library override class " + this.overrideClass.getClassName(), e);
                }
            }
            return this.instance;
        }
    }

    private static class JdkInfo {
        private final String _name;
        private final String _version;
        private final URLPath _classPath = new URLPath();
        private final URLPath _srcPath = new URLPath();
        private final URLPath _docPath = new URLPath();

        JdkInfo(String name, String version) {
            this._name = name;
            this._version = version;
        }

        public String getName() {
            return this._name;
        }

        public String getVersion() {
            return this._version;
        }
    }
}

