/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.extension.rules;

import java.util.Map;
import oracle.ide.extension.rules.RuleEvaluationContext;
import oracle.ide.extension.rules.RuleEvaluationException;
import oracle.ide.extension.rules.RuleFunction;
import oracle.ide.extension.rules.RuleFunctionParameter;
import oracle.ide.model.Project;
import oracle.ide.util.VersionNumber;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.JProjectLibraries;

public final class JavaBaseVersion
extends RuleFunction {
    private static final String _VERSION_NUMBER_KEY = "version-number";

    public boolean evaluate(RuleEvaluationContext ruleContext, Map<String, RuleFunctionParameter> parameters) throws RuleEvaluationException {
        RuleFunctionParameter param = this.getRequiredParameterOrThrow(parameters, _VERSION_NUMBER_KEY);
        Project project = ruleContext.getIdeContext().getProject();
        if (project == null) {
            return false;
        }
        String version = param.getValue();
        VersionNumber minNumber = new VersionNumber(version);
        boolean ret = false;
        JProjectLibraries jpl = JProjectLibraries.getInstance((PropertyStorage)project);
        if (jpl != null) {
            VersionNumber jdkVersionNumber = jpl.getJdkVersionNumber();
            ret = jdkVersionNumber.isAfter(minNumber, true);
        }
        return ret;
    }
}

