/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.net.URL;
import java.util.Iterator;
import java.util.NoSuchElementException;
import oracle.ide.config.GlobalIgnoreList;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.model.PathsConfiguration;

public final class ApplicationContent
extends HashStructureAdapter {
    private final URL _workspaceURL;
    public static final String PATHS_CONFIGURATION_DATA_KEY = PathsConfiguration.class.getName();
    public static final String APPLICATION_SRC_CONTENT_SET_LOCAL_KEY = "ApplicationSrcContentSet";
    public static final String APPLICATION_SRC_CONTENT_SET_KEY = PATHS_CONFIGURATION_DATA_KEY + "/ApplicationSrcContentSet";
    private static final String DEFAULT_ADF_DIR = ".adf";
    private static final String DEFAULT_SRC_DIR = "src";
    private static final String ADF_DIRECTORY_KEY = "adf-directory";
    public static final String APPLICATION_PACKAGE_PREFIX_KEY = "application-package-prefix";

    public static ApplicationContent getInstance(PropertyStorage psWorkspace, URL workspaceURL) {
        return new ApplicationContent(psWorkspace.getProperties(), workspaceURL);
    }

    public static ApplicationContent getInstance(HashStructure hash, URL workspaceURL) {
        return new ApplicationContent(hash, workspaceURL);
    }

    public static ApplicationContent getInstance(Workspace workspace) {
        return new ApplicationContent(workspace.getProperties(), workspace.getURL());
    }

    private ApplicationContent(HashStructure hash, URL workspaceURL) {
        super(hash);
        if (workspaceURL == null) {
            throw new NullPointerException("workspaceURL must be specified");
        }
        this._workspaceURL = workspaceURL;
    }

    public ContentSet getContentSet(String contentSetKey) {
        return new ContentSet(this._hash.getOrCreateHashStructure(contentSetKey));
    }

    public URL getMetaInfURL() {
        return this.getADFMetaInfURL();
    }

    public URL getADFMetaInfURL() {
        URL adfSourceURL = this.getADFSourceURL();
        if (adfSourceURL != null) {
            return URLFactory.newDirURL((URL)adfSourceURL, (String)"META-INF");
        }
        return null;
    }

    public URL getADFSourceURL() {
        URL url = this._hash.getURL(ADF_DIRECTORY_KEY);
        if (url == null) {
            return this.getDefaultADFSourceURL();
        }
        return url;
    }

    public URL getSourceURL() {
        ContentSet set = this.getContentSet(APPLICATION_SRC_CONTENT_SET_KEY);
        URLPath appSrcContentSet = set.getAllRootDirs();
        URL url = appSrcContentSet.getFirstEntry();
        if (url == null) {
            url = this.getDefaultApplicationSourceURL();
        }
        return url;
    }

    public void setSourceURL(URL url) {
        ContentSet appSrcContentSet = this.getContentSet(APPLICATION_SRC_CONTENT_SET_KEY);
        appSrcContentSet.getURLPath().setEntries(new URL[]{url});
    }

    public URL getApplicationMetaInfURL() {
        URL srcURL = this.getSourceURL();
        if (srcURL != null) {
            return URLFactory.newDirURL((URL)srcURL, (String)"META-INF");
        }
        return null;
    }

    private URL getApplicationHomeURL() {
        return URLFileSystem.getParent((URL)this._workspaceURL);
    }

    private URL getDefaultApplicationSourceURL() {
        URL applicationURL = this.getApplicationHomeURL();
        if (applicationURL != null) {
            return URLFactory.newDirURL((URL)applicationURL, (String)DEFAULT_SRC_DIR);
        }
        return null;
    }

    private URL getDefaultADFSourceURL() {
        URL applicationURL = this.getApplicationHomeURL();
        if (applicationURL != null) {
            return URLFactory.newDirURL((URL)applicationURL, (String)DEFAULT_ADF_DIR);
        }
        return null;
    }

    public String getAppPackagePrefix() {
        String prefix = this._hash.getString(APPLICATION_PACKAGE_PREFIX_KEY);
        return prefix;
    }

    public void setAppPackagePrefix(String prefix) {
        if (prefix != null && prefix.trim().length() > 0) {
            this._hash.putString(APPLICATION_PACKAGE_PREFIX_KEY, prefix);
        } else {
            this._hash.remove(APPLICATION_PACKAGE_PREFIX_KEY);
        }
    }

    public Iterator getDescriptors() {
        return new DescriptorIterator(this.getApplicationMetaInfURL());
    }

    public Iterator getDescriptors(URL url) {
        return new DescriptorIterator(url);
    }

    private static class DescriptorIterator
    implements Iterator {
        private URL[] _childURLs;
        private int _index = 0;
        private Object _next = null;

        DescriptorIterator(URL url) {
            URLFilter filter = GlobalIgnoreList.getURLFilter();
            this._childURLs = URLFileSystem.isDirectory((URL)url) ? URLFileSystem.list((URL)url, (URLFilter)filter) : new URL[0];
        }

        @Override
        public boolean hasNext() {
            if (this._next != null) {
                return true;
            }
            if (this._childURLs == null) {
                return false;
            }
            while (this._index < this._childURLs.length) {
                this._next = DescriptorIterator.toNode(this._childURLs[this._index]);
                ++this._index;
                if (this._next == null) continue;
                return true;
            }
            return false;
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object result = this._next;
            this._next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private static Node toNode(URL url) {
            try {
                return NodeFactory.findOrCreate((URL)url);
            }
            catch (IllegalAccessException ex) {
                return null;
            }
            catch (InstantiationException ex) {
                return null;
            }
        }
    }
}

