/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Project;

public class ProjectLibraryChangeEvent {
    private final Project project;
    private final Set<URL> modifiedJars;
    private final List<URL> addedJars;
    private final List<URL> removedJars;
    private final Set<URL> jarsRemovedFromClasspath;
    private final Set<URL> jarsAddedToClasspath;
    private final Map<String, Integer> deletedLibs;
    private final Map<String, Integer> addedLibs;

    public ProjectLibraryChangeEvent(Project project, Set<URL> modifiedJars, Set<URL> jarsAddedToClasspath, Set<URL> jarsRemovedFromClasspath) {
        this(project, modifiedJars, null, null, jarsAddedToClasspath, jarsRemovedFromClasspath, null, null);
    }

    public ProjectLibraryChangeEvent(Project project, Set<URL> modifiedJars, List<URL> addedJars, List<URL> removedJars, Set<URL> jarsAddedToClasspath, Set<URL> jarsRemovedFromClasspath) {
        this(project, modifiedJars, addedJars, removedJars, jarsAddedToClasspath, jarsRemovedFromClasspath, null, null);
    }

    public ProjectLibraryChangeEvent(Project project, Set<URL> modifiedJars, List<URL> addedJars, List<URL> removedJars, Set<URL> jarsAddedToClasspath, Set<URL> jarsRemovedFromClasspath, Map<String, Integer> addedLibs, Map<String, Integer> deletedLibs) {
        this.project = project;
        this.modifiedJars = ProjectLibraryChangeEvent.toImmutable(modifiedJars);
        this.addedJars = ProjectLibraryChangeEvent.toImmutable(addedJars, jarsAddedToClasspath);
        this.removedJars = ProjectLibraryChangeEvent.toImmutable(removedJars, jarsRemovedFromClasspath);
        this.jarsAddedToClasspath = ProjectLibraryChangeEvent.toImmutable(jarsAddedToClasspath);
        this.jarsRemovedFromClasspath = ProjectLibraryChangeEvent.toImmutable(jarsRemovedFromClasspath);
        this.addedLibs = ProjectLibraryChangeEvent.toImmutable(addedLibs);
        this.deletedLibs = ProjectLibraryChangeEvent.toImmutable(deletedLibs);
    }

    ProjectLibraryChangeEvent(Project project, Set<URL> modifiedJars) {
        this(project, modifiedJars, null, null, null, null, null, null);
    }

    private static List<URL> toImmutable(List<URL> source, Set<URL> alt) {
        if (source == null || source.isEmpty()) {
            if (alt == null || alt.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<URL> target = new ArrayList<URL>();
            target.addAll(alt);
            return Collections.unmodifiableList(target);
        }
        ArrayList<URL> target = new ArrayList<URL>();
        target.addAll(source);
        return Collections.unmodifiableList(target);
    }

    private static Set<URL> toImmutable(Set<URL> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<URL> target = new HashSet<URL>();
        target.addAll(source);
        return Collections.unmodifiableSet(target);
    }

    private static Map<String, Integer> toImmutable(Map<String, Integer> source) {
        if (source == null || source.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, Integer> target = new LinkedHashMap<String, Integer>();
        target.putAll(source);
        return Collections.unmodifiableMap(target);
    }

    public Project getProject() {
        return this.project;
    }

    public List<URL> getAddedJars() {
        return this.addedJars;
    }

    public List<URL> getRemovedJars() {
        return this.removedJars;
    }

    public Set<URL> getJarsAddedToClasspath() {
        return this.jarsAddedToClasspath;
    }

    public Set<URL> getJarsRemovedFromClasspath() {
        return this.jarsRemovedFromClasspath;
    }

    public Set<URL> getModifiedJars() {
        return this.modifiedJars;
    }

    public Map<String, Integer> getLibsAddedToClasspath() {
        return this.addedLibs;
    }

    public Map<String, Integer> getLibsRemovedFromClasspath() {
        return this.deletedLibs;
    }

    public String toString() {
        return "Project: " + this.project.getLongLabel() + "\nSize of modified jars: " + this.modifiedJars.size() + "\nSize of added jars: " + this.addedJars.size() + "\nSize of removed jars: " + this.removedJars.size() + "\nSize of added jars (classpath): " + this.jarsAddedToClasspath.size() + "\nSize of removed jars (classpath): " + this.jarsRemovedFromClasspath.size() + "\nSize of added libs: " + this.addedLibs.size() + "\nSize of removed libs: " + this.deletedLibs.size();
    }
}

