/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JDKAdapter;
import oracle.jdeveloper.library.JDKUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryList;
import oracle.jdeveloper.library.MutableLibraryList;

public class ListWrapper
implements MutableLibraryList {
    public static final int LIBRARY_LIST = 0;
    public static final int JDK_LIST = 1;
    public static final int BOTH_LISTS = 2;
    private LibraryList _list;
    private List _initialLibStates;
    private int _initialLibCount;
    private HashMap _masterLibMap;
    private HashMap _redirectLibMap;
    private List _initialJDKStates;
    private int _initialJDKCount;
    private HashMap _masterJDKMap;
    private HashMap _redirectJDKMap;

    public ListWrapper(LibraryList list) {
        this(list, 2);
    }

    public ListWrapper(LibraryList list, int mode) {
        int i;
        this._list = list;
        if (mode == 0 || mode == 2) {
            this._initialLibStates = this._list.getLibraryList();
            if (this._initialLibStates == null) {
                this._initialLibStates = new ArrayList();
            }
            this._initialLibCount = this._initialLibStates.size();
            this._masterLibMap = new HashMap();
            this._redirectLibMap = new HashMap();
            for (i = 0; i < this._initialLibCount; ++i) {
                JLibrary lib = (JLibrary)this._initialLibStates.get(i);
                this._masterLibMap.put(i, lib.getID());
                this._redirectLibMap.put(lib.getID(), lib);
            }
        }
        if (mode == 1 || mode == 2) {
            this._initialJDKStates = this._list.getJdkList();
            if (this._initialJDKStates == null) {
                this._initialJDKStates = new ArrayList();
            }
            this._initialJDKCount = this._initialJDKStates.size();
            this._masterJDKMap = new HashMap();
            this._redirectJDKMap = new HashMap();
            for (i = 0; i < this._initialJDKCount; ++i) {
                JDK jdk = (JDK)this._initialJDKStates.get(i);
                this._masterJDKMap.put(i, jdk.getID());
                this._redirectJDKMap.put(jdk.getID(), jdk);
            }
        }
    }

    @Override
    public JDK findJDK(Object id) {
        return this._redirectJDKMap != null ? (JDK)this._redirectJDKMap.get(id) : null;
    }

    @Override
    public JLibrary findLibrary(Object id) {
        return this._redirectLibMap != null ? (JLibrary)this._redirectLibMap.get(id) : null;
    }

    @Override
    public List getJdkList() {
        if (this._redirectJDKMap != null) {
            ArrayList list = new ArrayList();
            Collection values = this._redirectJDKMap.values();
            list.addAll(values);
            return list;
        }
        return null;
    }

    @Override
    public List getLibraryList() {
        if (this._redirectLibMap != null) {
            ArrayList list = new ArrayList();
            Collection values = this._redirectLibMap.values();
            list.addAll(values);
            return list;
        }
        return null;
    }

    @Override
    public String getListName() {
        return this._list != null ? this._list.getListName() : null;
    }

    @Override
    public boolean isTransient() {
        return this._list != null ? this._list.isTransient() : true;
    }

    public String getShortLabel() {
        return this._list != null ? this._list.getShortLabel() : null;
    }

    public String getLongLabel() {
        return this._list != null ? this._list.getLongLabel() : null;
    }

    public Icon getIcon() {
        return this._list != null ? this._list.getIcon() : null;
    }

    public String getToolTipText() {
        return this._list != null ? this._list.getToolTipText() : null;
    }

    @Override
    public void setJdkList(List jdks) {
    }

    @Override
    public void setLibraryList(List libraries) {
    }

    @Override
    public void setListName(String name) {
    }

    @Override
    public JDK addJDK(String name, URL exeURL) {
        JDK jdk = null;
        if (this._list instanceof MutableLibraryList && this._redirectJDKMap != null) {
            String jdkOldName;
            Object id = ((MutableLibraryList)this._list).createIDFromName(name, true);
            jdk = (JDK)this._redirectJDKMap.get(id);
            boolean createdJdk = false;
            String string = jdkOldName = jdk != null ? jdk.getName() : null;
            if (jdk == null) {
                HashStructure hash = HashStructure.newInstance();
                jdk = new JDKAdapter(hash);
                jdk.setName(name);
                ((JDKAdapter)jdk).setID(id);
                createdJdk = true;
            } else {
                jdk.setName(name);
            }
            if (!JDKUtil.initJDK(jdk, exeURL)) {
                jdk.setName(jdkOldName);
                jdk = null;
            } else if (createdJdk) {
                this._initialJDKStates.add(null);
                this._masterJDKMap.put(this._initialJDKStates.size() - 1, id);
                this._redirectJDKMap.put(id, jdk);
            }
        }
        return jdk;
    }

    @Override
    public JLibrary addLibrary(String name) {
        JLibrary lib = null;
        if (this._list instanceof MutableLibraryList && this._redirectLibMap != null) {
            Object id = ((MutableLibraryList)this._list).createIDFromName(name, false);
            lib = (JLibrary)this._redirectLibMap.get(id);
            if (lib == null) {
                HashStructure hash = HashStructure.newInstance();
                lib = new JLibraryAdapter(hash);
                lib.setName(name);
                ((JLibraryAdapter)lib).setIcon(((MutableLibraryList)this._list).getDefaultIcon());
                ((JLibraryAdapter)lib).setID(id);
                this._initialLibStates.add(null);
                this._masterLibMap.put(this._initialLibStates.size() - 1, id);
                this._redirectLibMap.put(id, lib);
            } else {
                lib.setName(name);
            }
        }
        return lib;
    }

    @Override
    public boolean remove(Library library) {
        block8: {
            Object id;
            block7: {
                Iterator i;
                Object object = id = library != null ? library.getID() : null;
                if (id == null) {
                    return false;
                }
                if (!(this._list instanceof MutableLibraryList)) {
                    return false;
                }
                if (!(library instanceof JDK)) break block7;
                if (this._redirectJDKMap == null) break block8;
                Set set = this._masterJDKMap.keySet();
                Iterator iterator = i = set != null ? set.iterator() : null;
                if (i != null) {
                    while (i.hasNext()) {
                        Object masterKey = i.next();
                        if (!id.equals(this._masterJDKMap.get(masterKey))) continue;
                        this._masterJDKMap.put(masterKey, null);
                        this._redirectJDKMap.remove(id);
                        return true;
                    }
                }
                break block8;
            }
            if (library instanceof JLibrary && this._redirectLibMap != null) {
                Iterator i;
                Set set = this._masterLibMap.keySet();
                Iterator iterator = i = set != null ? set.iterator() : null;
                if (i != null) {
                    while (i.hasNext()) {
                        Object masterKey = i.next();
                        if (!id.equals(this._masterLibMap.get(masterKey))) continue;
                        this._masterLibMap.put(masterKey, null);
                        this._redirectLibMap.remove(id);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    @Override
    public Object createIDFromName(String name, boolean isJDK) {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).createIDFromName(name, isJDK) : null;
    }

    public LibraryList getWrappedList() {
        return this._list;
    }

    public void commit(boolean notify) {
        if (this._list instanceof MutableLibraryList) {
            if (this._redirectLibMap != null) {
                this.commit(this._masterLibMap, this._redirectLibMap, this._initialLibStates, this._initialLibCount, notify, false);
            }
            if (this._redirectJDKMap != null) {
                this.commit(this._masterJDKMap, this._redirectJDKMap, this._initialJDKStates, this._initialJDKCount, notify, true);
            }
        }
    }

    public String toString() {
        return this._list.toString();
    }

    private void commit(HashMap masterMap, HashMap redirectMap, List initialStates, int initialCount, boolean notify, boolean isJDK) {
        if (redirectMap != null) {
            int i;
            MutableLibraryList list = (MutableLibraryList)this._list;
            ArrayList<Object> additions = new ArrayList<Object>();
            ArrayList deletions = new ArrayList();
            ArrayList<Library> modifications = new ArrayList<Library>();
            int size = initialStates.size();
            for (i = 0; i < size; ++i) {
                Library current;
                Integer masterKey = i;
                Object redirectKey = masterMap.get(masterKey);
                if (i >= initialCount) {
                    if (redirectKey == null) continue;
                    additions.add(redirectMap.get(redirectKey));
                    continue;
                }
                if (redirectKey == null) {
                    deletions.add(initialStates.get(i));
                    continue;
                }
                Library original = (Library)initialStates.get(i);
                if (original == null || original.equivalent(current = (Library)redirectMap.get(redirectKey))) continue;
                original.initFromLibrary(current);
                modifications.add(original);
            }
            size = deletions.size();
            if (size > 0) {
                for (i = 0; i < size; ++i) {
                    list.remove((Library)deletions.get(i));
                }
                if (notify) {
                    UpdateMessage.fireChildrenRemoved((Subject)JLibraryManager.getInstance(), deletions);
                }
            }
            if ((size = additions.size()) > 0) {
                for (i = size - 1; i >= 0; --i) {
                    Library template = (Library)additions.get(i);
                    Library newLib = null;
                    newLib = isJDK ? list.addJDK(template.getName(), ((JDK)template).getJavaExecutable()) : list.addLibrary(template.getName());
                    if (newLib != null) {
                        newLib.initFromLibrary(template);
                        if (newLib instanceof Node) {
                            try {
                                ((Node)newLib).save();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        additions.set(i, newLib);
                        continue;
                    }
                    additions.remove(i);
                }
                if (notify) {
                    UpdateMessage.fireChildrenAdded((Subject)JLibraryManager.getInstance(), additions);
                }
            }
            if ((size = modifications.size()) > 0) {
                for (i = size - 1; i >= 0; --i) {
                    Library lib = (Library)modifications.get(i);
                    if (!(lib instanceof Node)) continue;
                    try {
                        ((Node)lib).save();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (notify) {
                    UpdateMessage.fireStructureChanged((Subject)JLibraryManager.getInstance(), modifications);
                }
            }
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return this._list instanceof MutableLibraryList ? ((MutableLibraryList)this._list).getDefaultIcon() : null;
    }
}

