/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.VersionNumber;
import oracle.javatools.marshal.TransientMarker;
import oracle.jdeveloper.library.LibraryElement;
import oracle.jdeveloper.resource.ControlsArb;

public final class LegacyJDK
extends LibraryElement {
    private static final String CFG_FILE = "jvm.cfg";
    private URLPath _clsPath;
    private URLPath _srcPath;
    private URLPath _docPath;
    private boolean _isLocked;
    private URL _javaExecutable;
    private String[] _installedVMs;
    private VersionNumber _javaVersion;
    private String _name;
    private URL _binDir;

    public String getShortLabel() {
        return this.getName();
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public URLPath getClassPath() {
        return new URLPath(this._clsPath);
    }

    public void setClassPath(URLPath path) {
        if (ModelUtil.areDifferent((Object)path, (Object)this._clsPath)) {
            this._clsPath = new URLPath(path);
            this.markDirty(true);
        }
    }

    public URLPath getSourcePath() {
        return new URLPath(this._srcPath);
    }

    public void setSourcePath(URLPath path) {
        if (ModelUtil.areDifferent((Object)path, (Object)this._srcPath)) {
            this._srcPath = new URLPath(path);
            this.markDirty(true);
        }
    }

    public URLPath getDocPath() {
        return new URLPath(this._docPath);
    }

    public void setDocPath(URLPath path) {
        if (ModelUtil.areDifferent((Object)path, (Object)this._docPath)) {
            this._docPath = new URLPath(path);
            this.markDirty(true);
        }
    }

    public boolean isLocked() {
        return this._isLocked;
    }

    public void setLocked(boolean locked) {
        if (locked != this._isLocked) {
            this._isLocked = locked;
            this.markDirty(true);
        }
    }

    public URL getJavaExecutable() {
        return this._javaExecutable;
    }

    public void setJavaExecutable(URL javaExecutable) {
        if (ModelUtil.areDifferent((Object)this._javaExecutable, (Object)javaExecutable)) {
            this._javaExecutable = javaExecutable;
            this.markDirty(true);
        }
    }

    public VersionNumber getJavaVersion() {
        return this._javaVersion;
    }

    public void setJavaVersion(VersionNumber ver) {
        if (ModelUtil.areDifferent((Object)this._javaVersion, (Object)ver)) {
            this._javaVersion = ver;
            this.markDirty(true);
        }
    }

    public URL getSDKBinDir() {
        return this._binDir;
    }

    public void setSDKBinDir(URL binDir) {
        if (ModelUtil.areDifferent((Object)this._binDir, (Object)binDir)) {
            this._binDir = binDir;
            this.markDirty(true);
        }
    }

    public String[] getInstalledVMs() throws TransientMarker {
        String[] vms = null;
        if (this._installedVMs == null && this._binDir != null) {
            URL parent = URLFileSystem.getParent((URL)this._binDir);
            URL jreDir = URLFactory.newDirURL((URL)parent, (String)"jre");
            if (!URLFileSystem.exists((URL)jreDir)) {
                jreDir = parent;
            }
            this._installedVMs = LegacyJDK._getVMChoices(jreDir);
        }
        if (this._installedVMs != null) {
            vms = new String[this._installedVMs.length];
            System.arraycopy(this._installedVMs, 0, vms, 0, this._installedVMs.length);
        }
        return vms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] _getVMChoices(URL homeURL) {
        URL cfg;
        ArrayList<String> vmList = new ArrayList<String>();
        URL libURL = URLFactory.newURL((URL)homeURL, (String)"lib/");
        if (libURL == null) {
            libURL = homeURL;
        }
        if ((cfg = LegacyJDK._findJvmCfg(libURL)) != null) {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(cfg.openStream()));
                while (true) {
                    String line;
                    if ((line = reader.readLine()) == null) {
                    }
                    if (line.startsWith("#")) continue;
                    String vmName = null;
                    String attribute = null;
                    StringTokenizer st = new StringTokenizer(line);
                    if (st.hasMoreTokens()) {
                        vmName = st.nextToken();
                        if (st.hasMoreTokens()) {
                            attribute = st.nextToken();
                        }
                    }
                    if (vmName == null || attribute != null && !attribute.equalsIgnoreCase("KNOWN") && !attribute.equalsIgnoreCase("ALIASED_TO")) continue;
                    if (vmName.startsWith("-")) {
                        vmName = vmName.substring(1);
                    }
                    vmList.add(vmName);
                }
            }
            catch (Exception line) {
            }
            finally {
                try {
                    reader.close();
                }
                catch (Exception line) {}
            }
        } else {
            URL[] contents;
            URL binURL = URLFactory.newDirURL((URL)homeURL, (String)"bin");
            if (URLFileSystem.exists((URL)binURL) && (contents = URLFileSystem.list((URL)binURL, (URLFilter)new URLFilter(){

                public boolean accept(URL url) {
                    return URLFileSystem.isDirectory((URL)url) && URLFileSystem.exists((URL)URLFactory.newURL((URL)url, (String)"jvm.dll"));
                }
            })) != null) {
                for (int i = 0; i < contents.length; ++i) {
                    String vmName = URLFileSystem.getFileName((URL)contents[i]);
                    vmList.add(vmName);
                }
                int idx = vmList.indexOf("classic");
                if (idx != -1) {
                    Object o = vmList.remove(idx);
                    vmList.add(0, (String)o);
                }
            }
        }
        return vmList.toArray(new String[0]);
    }

    private static URL _findJvmCfg(URL baseURL) {
        URL cfg = LegacyJDK._checkLocation(baseURL);
        if (cfg != null) {
            return cfg;
        }
        String arch = System.getProperty("os.arch");
        if ("x86".equals(arch)) {
            arch = "i386";
        }
        if ((cfg = LegacyJDK._checkLocation(URLFactory.newDirURL((URL)baseURL, (String)arch))) != null) {
            return cfg;
        }
        return LegacyJDK._checkChildren(baseURL);
    }

    private static URL _checkLocation(URL dir) {
        if (dir == null) {
            return null;
        }
        URL cfg = URLFactory.newURL((URL)dir, (String)CFG_FILE);
        return cfg != null && URLFileSystem.exists((URL)cfg) ? cfg : null;
    }

    private static URL _checkChildren(URL baseURL) {
        URL[] children = URLFileSystem.list((URL)baseURL, (URLFilter)new URLFilter(){

            public boolean accept(URL url) {
                return URLFileSystem.isDirectory((URL)url);
            }
        });
        if (children != null) {
            for (int i = children.length - 1; i >= 0; --i) {
                URL cfg = LegacyJDK._checkLocation(children[i]);
                if (cfg != null) {
                    return cfg;
                }
                cfg = LegacyJDK._checkChildren(children[i]);
                if (cfg == null) continue;
                return cfg;
            }
        }
        return null;
    }

    public static class JDKExeFilter
    implements URLFilter {
        public boolean accept(URL url) {
            String fName;
            boolean result = false;
            if (url != null && "file".equals(url.getProtocol()) && URLFileSystem.isRegularFile((URL)url) && (fName = URLFileSystem.getFileName((URL)url)) != null) {
                result = (fName = fName.toLowerCase()).equals("java") || fName.equals("java.exe");
            }
            return result;
        }

        public boolean equals(Object o) {
            return o instanceof JDKExeFilter;
        }

        public String toString() {
            return ControlsArb.getString(53);
        }
    }
}

