/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Libraries;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.library.LibraryAdapter;

public class JLibraryAdapter
extends LibraryAdapter
implements JLibrary {
    private transient Icon icon;
    private transient URLPath manifestClassPath;

    public JLibraryAdapter(HashStructure hash) {
        super(hash);
    }

    @Override
    public boolean equivalent(Library lib) {
        if (!super.equivalent(lib)) {
            return false;
        }
        if (lib instanceof JLibrary) {
            return ModelUtil.areDifferent((Object)((JLibrary)lib).getDeployedByDefault(), (Object)this.getDeployedByDefault());
        }
        return true;
    }

    @Override
    public void initFromLibrary(Library lib) {
        if (lib instanceof JLibrary) {
            Boolean deployed = ((JLibrary)lib).getDeployedByDefault();
            super.initFromLibrary(lib);
            if (ModelUtil.areDifferent((Object)deployed, (Object)this.getDeployedByDefault())) {
                this.setDeployedByDefault(deployed);
            }
        }
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    @Override
    public Icon getIcon() {
        if (this.icon != null) {
            return this.icon;
        }
        if (!this.isLocked()) {
            return OracleIcons.getIcon((String)"library.png");
        }
        if (URLFileSystem.isDirectory((URL)this.getClassPath().getFirstEntry())) {
            return OracleIcons.getIcon((String)"pathlib.png");
        }
        return OracleIcons.getIcon((String)"pathlib.png");
    }

    @Override
    public Boolean getDeployedByDefault() throws AttributeMarker {
        return this._hash.getBoolean("deployedByDefault", false) ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public void setDeployedByDefault(Boolean deploy) {
        if (deploy == null) {
            this._hash.remove("deployedByDefault");
        } else {
            this._hash.putBoolean("deployedByDefault", deploy.booleanValue());
        }
    }

    public URLPath getManifestClassPath() {
        return this.manifestClassPath != null ? this.manifestClassPath : (this.manifestClassPath = Libraries.getDeferredManifestClassPath(this.getClassPath()));
    }

    public void setManifestClassPath(URLPath path) {
        this.manifestClassPath = path;
    }
}

