/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.library;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ExtensionHook;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.SimpleGlobMatcher;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import org.openide.util.RequestProcessor;

public abstract class AbstractLibraryHook
extends ExtensionHook {
    private static final RequestProcessor urlProcessor = new RequestProcessor("Library Path Validation");

    protected void addURLPath(ElementEndContext context, URLPath path) {
        this.addURLPath(context, path, false);
    }

    protected void addURLPath(ElementEndContext context, URLPath path, boolean checkExistence) {
        int end;
        String text = context.getText();
        if (text == null || (text = text.trim()).length() == 0) {
            this.log((ElementContext)context, Level.SEVERE, "Element must not be empty");
            return;
        }
        int start = 0;
        while ((end = text.indexOf(44, start)) >= 0) {
            this.addURLPath(text.substring(start, end).trim(), context, path, checkExistence);
            start = end + 1;
        }
        this.addURLPath(text.substring(start).trim(), context, path, checkExistence);
    }

    protected void addURLPath(String text, ElementEndContext context, URLPath path) {
        this.addURLPath(text, context, path, false);
    }

    protected void addURLPath(String text, ElementEndContext context, URLPath path, boolean checkExistence) {
        if (text == null || text.length() == 0) {
            this.log((ElementContext)context, Level.SEVERE, "Element must not be empty");
            return;
        }
        if ((text = text.replace('\\', '/')).indexOf(59) >= 0) {
            this.log((ElementContext)context, Level.WARNING, "Use of path separator is no longer supported");
        }
        if (text.startsWith("http") || text.startsWith("https")) {
            path.add(URLFactory.intern((URL)URLFactory.newURL((String)text)));
        } else {
            int posOfWildcard = -1;
            int posOfSeparator = -1;
            for (int i = text.length() - 1; i >= 0; --i) {
                char c = text.charAt(i);
                if (c == '*') {
                    posOfWildcard = i;
                }
                if (c != '/') continue;
                posOfSeparator = i;
                break;
            }
            if (posOfWildcard >= 0) {
                VirtualFileSystem vfs;
                URI[] entries;
                if (posOfSeparator >= posOfWildcard) {
                    this.log((ElementContext)context, Level.SEVERE, "Wilcards cannot be used in the path of a library entry.");
                }
                this.log((ElementContext)context, Level.FINE, "Expanding wildcard path entry: " + text);
                String pathText = text.substring(0, posOfSeparator);
                String filterText = text.substring(posOfSeparator + 1);
                URI parent = this.resolvePath((ElementContext)context, pathText);
                if (parent != null && (entries = (vfs = VirtualFileSystem.getVirtualFileSystem()).list(parent)) != null) {
                    SimpleGlobMatcher matcher = new SimpleGlobMatcher(filterText);
                    for (URI entry : entries) {
                        String fileName = vfs.getFileName(entry);
                        if (!matcher.matches(fileName)) continue;
                        this.processPathElement(entry, text, context, path, checkExistence);
                    }
                }
            } else {
                URI uri = this.resolvePath((ElementContext)context, text);
                this.processPathElement(uri, text, context, path, checkExistence);
            }
        }
    }

    private void processPathElement(URI uri, String text, ElementEndContext context, URLPath path, boolean checkExistence) {
        String[] archiveExtensions = new String[]{".jar", ".war", ".ear", ".zip"};
        if (Arrays.asList(archiveExtensions).contains(VirtualFileSystem.getVirtualFileSystem().getSuffix(uri).toLowerCase())) {
            uri = URIFactory.newJarURI((URI)uri, (String)"");
        } else {
            String resultString = uri.toString();
            int bangSlash = resultString.indexOf("!/");
            if (bangSlash > 0) {
                String jarUri = resultString.substring(0, bangSlash);
                String entryUri = resultString.substring(bangSlash + 2);
                uri = URIFactory.newJarURI((URI)URIFactory.newURI((String)jarUri), (String)entryUri);
            }
        }
        try {
            String urlPath;
            URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
            if (text.length() > 0 && '/' == text.charAt(text.length() - 1) && "file".equals(url.getProtocol()) && (urlPath = url.getPath()).length() > 0 && urlPath.charAt(urlPath.length() - 1) != '/') {
                url = URLFactory.newDirURL((String)(urlPath + "/"));
            }
            if (checkExistence && URLFileSystem.isLocal((URL)url)) {
                this.checkExistence(url, context);
            }
            path.add(URLFactory.intern((URL)url));
        }
        catch (MalformedURLException mue) {
            this.log((ElementContext)context, Level.SEVERE, "Malformed URL: " + uri);
        }
    }

    private void checkExistence(URL url, ElementEndContext context) {
        urlProcessor.post((Runnable)new UrlTask(url, context));
    }

    private static class UrlTask
    implements Runnable {
        private final URL url;
        private final ElementEndContext context;
        private final ExtensionLogRecord record;

        UrlTask(URL url, ElementEndContext context) {
            this.url = url;
            this.context = context;
            this.record = new ExtensionLogRecord((ElementContext)context, Level.WARNING, "Path entry does not exist: " + url);
        }

        @Override
        public void run() {
            if (!URLFileSystem.exists((URL)this.url)) {
                this.context.getLogger().log((LogRecord)this.record);
            }
        }
    }
}

