/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.observable;

import java.util.Objects;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import oracle.dbtools.raptor.metrics.listener.DXTableChanges;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.observable.Key;
import oracle.dbtools.raptor.metrics.observable.Row;
import oracle.dbtools.raptor.metrics.observable.StructuredItemChangeAdapter;

class TableItemChangeListAdapter
extends StructuredItemChangeAdapter {
    private final ListProperty<DXRow> property;

    TableItemChangeListAdapter(ListProperty<DXRow> listProperty, String string) {
        super(string);
        this.property = listProperty;
    }

    @Override
    Class<DXTableChanges> getItemClass() {
        return DXTableChanges.class;
    }

    @Override
    void clearStructuredProperty() {
        this.property.clear();
    }

    @Override
    void updateStructuredProperty(DXTableChanges dXTableChanges) {
        int n;
        for (DXTableChanges.Key object : dXTableChanges.getRemovedRowKeys()) {
            n = this.findRowIndex(object);
            if (n < 0) continue;
            this.property.remove(n);
        }
        for (DXTableChanges.Row row : dXTableChanges.getChangedRows()) {
            n = this.findRowIndex(row.getRowKey());
            if (n < 0) continue;
            DXRow dXRow = (DXRow)this.property.get(n);
            for (String string : dXRow.getNames()) {
                Comparable comparable;
                ObjectProperty<Comparable<?>> objectProperty = dXRow.get(string);
                Comparable comparable2 = (Comparable)objectProperty.get();
                if (Objects.equals(comparable2, comparable = row.getCellValue(string, Comparable.class))) continue;
                objectProperty.set((Object)comparable);
            }
        }
        for (DXTableChanges.Row row : dXTableChanges.getAddedRows()) {
            Row row2 = new Row(row);
            this.property.add((Object)row2);
        }
    }

    private int findRowIndex(DXTableChanges.Key key) {
        int n = 0;
        Key key2 = new Key(key);
        for (DXRow dXRow : this.property) {
            if (((Object)key2).equals(dXRow.getKey())) {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

