/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.DefaultProperty;
import javafx.beans.binding.MapExpression;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.MapChangeListener;
import oracle.dbtools.raptor.metrics.facet.TimeSeriesMonitor;
import oracle.dbtools.raptor.metrics.observable.DXKey;
import oracle.dbtools.raptor.metrics.observable.DXRow;
import oracle.dbtools.raptor.metrics.panel.Context;
import oracle.dbtools.raptor.metrics.panel.DataObject;
import oracle.dbtools.raptor.metrics.panel.GenericMapDataObject;

@DefaultProperty(value="item")
public class QueriedTimeSeriesMonitor
extends TimeSeriesMonitor {
    private final StringProperty seriesNameRowItemProperty = new SimpleStringProperty();
    private final StringProperty valueRowItem = new SimpleStringProperty();
    private final ObjectProperty<GenericMapDataObject<DXKey, DXRow>> itemProperty = new SimpleObjectProperty((Object)this, "item");
    private final List<TimeSeriesMonitor.SeriesSource> seriesSources = new ArrayList<TimeSeriesMonitor.SeriesSource>();

    public QueriedTimeSeriesMonitor() {
        this.init(new Listener());
    }

    public String getSeriesNameRowItem() {
        return (String)this.seriesNameRowItemProperty.get();
    }

    public void setSeriesNameRowItem(String string) {
        this.seriesNameRowItemProperty.set((Object)string);
    }

    public StringProperty seriesNameRowItemProperty() {
        return this.seriesNameRowItemProperty;
    }

    public String getValueRowItem() {
        return (String)this.valueRowItem.get();
    }

    public void setValueRowItem(String string) {
        this.valueRowItem.set((Object)string);
    }

    public StringProperty valueRowItemProperty() {
        return this.valueRowItem;
    }

    public GenericMapDataObject<DXKey, DXRow> getItem() {
        return (GenericMapDataObject)this.itemProperty.get();
    }

    public void setItem(GenericMapDataObject<DXKey, DXRow> genericMapDataObject) {
        this.itemProperty.set(genericMapDataObject);
    }

    public ObjectProperty<GenericMapDataObject<DXKey, DXRow>> itemProperty() {
        return this.itemProperty;
    }

    @Override
    public List<DataObject<?>> getDataObjects(Context context) {
        return Collections.singletonList((DataObject)this.itemProperty.get());
    }

    @Override
    protected List<TimeSeriesMonitor.SeriesSource> getSeriesSources() {
        return this.seriesSources;
    }

    private void addSeriesSource(String string, ObservableValue<? extends Number> observableValue) {
        this.seriesSources.add(new TimeSeriesMonitor.SeriesSource(string, observableValue));
    }

    protected class Listener
    extends TimeSeriesMonitor.Listener {
        protected Listener() {
            super(QueriedTimeSeriesMonitor.this);
        }

        @Override
        public void onOpen(Context context) {
            MapExpression<DXKey, DXRow> mapExpression = QueriedTimeSeriesMonitor.this.getItem().valueProperty();
            mapExpression.addListener((MapChangeListener)new SourceMapChangeListener());
            super.onOpen(context);
        }
    }

    private class SourceMapChangeListener
    implements MapChangeListener<DXKey, DXRow> {
        private SourceMapChangeListener() {
        }

        public void onChanged(MapChangeListener.Change<? extends DXKey, ? extends DXRow> change) {
            if (QueriedTimeSeriesMonitor.this.getItem().availableProperty().get()) {
                QueriedTimeSeriesMonitor.this.getItem().valueProperty().removeListener((MapChangeListener)this);
            } else if (change.wasAdded()) {
                DXRow dXRow = (DXRow)change.getValueAdded();
                QueriedTimeSeriesMonitor.this.addSeriesSource((String)dXRow.get(QueriedTimeSeriesMonitor.this.getSeriesNameRowItem(), String.class).get(), (ObservableValue<? extends Number>)dXRow.get(QueriedTimeSeriesMonitor.this.getValueRowItem(), Double.class));
            }
        }
    }
}

