/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.facet;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.scene.chart.NumberAxis;
import oracle.dbtools.raptor.metrics.facet.PointAxisProperties;

public abstract class FloatingAxisProperties
extends PointAxisProperties {
    private final BooleanProperty includeZeroProperty = new SimpleBooleanProperty((Object)this, "includeZero", true);
    private final DoubleProperty lowerBound = new SimpleDoubleProperty();
    private final DoubleProperty upperBound = new SimpleDoubleProperty();
    private final DoubleProperty tickUnit = new SimpleDoubleProperty();

    public boolean isIncludeZero() {
        return this.includeZeroProperty.get();
    }

    public void setIncludeZero(boolean bl) {
        this.includeZeroProperty.set(bl);
    }

    public BooleanProperty includeZeroProperty() {
        return this.includeZeroProperty;
    }

    @Override
    void initialize(NumberAxis numberAxis) {
        super.initialize(numberAxis);
        numberAxis.autoRangingProperty().bind((ObservableValue)this.falseValue);
        numberAxis.tickUnitProperty().bind((ObservableValue)this.tickUnit);
        numberAxis.upperBoundProperty().bind((ObservableValue)this.upperBound);
        numberAxis.lowerBoundProperty().bind((ObservableValue)this.lowerBound);
        this.tickUnit.set(1.0);
        this.upperBound.set(1.0);
        this.lowerBound.set(0.0);
    }

    @Override
    void update(double d, double d2) {
        if (this.isIncludeZero() && d > 0.0) {
            d = 0.0;
        }
        int n = this.getMaximumTickIntervalCount();
        double d3 = this.getRoundedTickUnit((d2 - d) / (double)n);
        int n2 = (int)(1.0 + (d2 - d) / d3);
        this.tickUnit.set(d3);
        int n3 = (int)Math.ceil(d2 / d3);
        d2 = d3 * (double)n3;
        if (d != 0.0) {
            d = d2 - d3 * (double)n2;
        }
        this.upperBound.set(d2);
        this.lowerBound.set(d);
    }
}

