/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.Map;
import oracle.dbtools.raptor.metrics.engine.AbstractInstanceObject;
import oracle.dbtools.raptor.metrics.engine.ContainerInstanceObject;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.DXIds;
import oracle.dbtools.raptor.metrics.engine.InstanceProperty;
import oracle.dbtools.raptor.metrics.engine.MergeSet;
import oracle.dbtools.raptor.metrics.engine.RunnableAutomaton;
import oracle.dbtools.raptor.metrics.engine.RunnableAutomatonActions;
import oracle.dbtools.raptor.metrics.engine.RunnableType;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;

public abstract class RunnableInstance
extends ContainerInstanceObject {
    private final String runLabel;
    private long lastRunElapsedTime;
    private long lastRunCPUTime;
    private DXException lastRunException;
    private volatile boolean runCanceled;

    protected RunnableInstance(RunnableType runnableType, SourceInstance sourceInstance, Map<String, String> map) {
        super(DXIds.newId(sourceInstance.getSourceType().getConnectionTypeName(), sourceInstance.getConnectionName(), runnableType.getPath(), sourceInstance.getParameters(), map));
        this.runLabel = sourceInstance.getConnectionDisplayName() + "/" + runnableType.getPath();
        MergeSet mergeSet = runnableType.getMergeSet();
        if (mergeSet != null) {
            runnableType.getMergeSet().addRunnable();
        }
    }

    public abstract RunnableType getRunnableType();

    public abstract SourceInstance getSource();

    protected abstract boolean cancel();

    protected boolean isRunCanceled() {
        return this.runCanceled;
    }

    protected long getLastRunElapsedTime() {
        return this.lastRunElapsedTime;
    }

    protected long getLastRunCPUTime() {
        return this.lastRunCPUTime;
    }

    protected DXException getLastRunException() {
        return this.lastRunException;
    }

    boolean isRunning() {
        RunnableAutomatonActions runnableAutomatonActions = (RunnableAutomatonActions)this.getAutomaton().getState();
        return runnableAutomatonActions != null ? runnableAutomatonActions.isRunning() : false;
    }

    abstract RunnableAutomaton<? extends RunnableAutomatonActions<?>> getAutomaton();

    String getRunLabel() {
        return this.runLabel;
    }

    void cancelRun() {
        this.runCanceled = this.cancel();
    }

    void setRunStatistics(long l, long l2, DXException dXException) {
        this.lastRunElapsedTime = l;
        this.lastRunCPUTime = l2;
        this.lastRunException = dXException;
    }

    void remove() {
        this.getContext().getObjectManager().releaseMergeSetRunnable(this);
        for (InstanceProperty<?> instanceProperty : this.getProperties()) {
            instanceProperty.release();
        }
    }

    @Override
    AbstractInstanceObject getEnclosingInstance(Class<? extends AbstractInstanceObject> clazz) {
        if (clazz.isAssignableFrom(this.getClass())) {
            return this;
        }
        SourceInstance sourceInstance = this.getSource();
        if (clazz.isAssignableFrom(sourceInstance.getClass())) {
            return sourceInstance;
        }
        return null;
    }
}

