/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.engine;

import java.util.logging.Level;
import oracle.dbtools.raptor.metrics.engine.Context;
import oracle.dbtools.raptor.metrics.engine.DXException;
import oracle.dbtools.raptor.metrics.engine.EngineObjectProperty;
import oracle.dbtools.raptor.metrics.engine.ExecutionService;
import oracle.dbtools.raptor.metrics.engine.Handle;
import oracle.dbtools.raptor.metrics.engine.ItemInstance;
import oracle.dbtools.raptor.metrics.engine.JobInstance;
import oracle.dbtools.raptor.metrics.engine.Notification;
import oracle.dbtools.raptor.metrics.engine.ObjectManager;
import oracle.dbtools.raptor.metrics.engine.OperationInstance;
import oracle.dbtools.raptor.metrics.engine.SourceInstance;
import oracle.dbtools.raptor.metrics.listener.DXBindEvent;
import oracle.dbtools.raptor.metrics.listener.DXConnectionEvent;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.DXEvent;
import oracle.dbtools.raptor.metrics.listener.DXItemListener;
import oracle.dbtools.raptor.metrics.listener.DXItemUpdateEvent;
import oracle.dbtools.raptor.metrics.listener.DXOperationCallback;

class ObjectService {
    private Context context;

    ObjectService() {
    }

    void setContext(Context context) {
        this.context = context;
    }

    void requestSourceKeepAlive(Handle handle) {
        ObjectManager objectManager = this.context.getObjectManager();
        SourceInstance sourceInstance = objectManager.getSource(handle);
        if (sourceInstance != null) {
            this.context.getExecutionService().addEvent(sourceInstance.getAutomaton().createRequestKeepAlive());
        }
    }

    void requestJobRun(Handle handle) {
        ObjectManager objectManager = this.context.getObjectManager();
        JobInstance jobInstance = objectManager.getJob(handle);
        if (jobInstance != null) {
            this.context.getExecutionService().addEvent(jobInstance.getAutomaton().createRequestRun());
        }
    }

    <T> T getProperty(Handle handle, Class<T> clazz, String string) {
        EngineObjectProperty<T> engineObjectProperty = this.context.getObjectManager().getProperty(handle, clazz, string);
        if (engineObjectProperty != null) {
            return engineObjectProperty.get();
        }
        throw new DXException("unable to get '" + string + "' for '" + handle.getId() + "' because property does not exist");
    }

    <T> void setProperty(Handle handle, Class<T> clazz, String string, T t, boolean bl) {
        EngineObjectProperty<T> engineObjectProperty = this.context.getObjectManager().getProperty(handle, clazz, string);
        if (engineObjectProperty == null) {
            throw new DXException("unable to set '" + string + "' for '" + handle.getId() + "' because property does not exist");
        }
        engineObjectProperty.set(t, bl);
    }

    <T> void useDefaultProperty(Handle handle, Class<T> clazz, String string, boolean bl) {
        EngineObjectProperty<T> engineObjectProperty = this.context.getObjectManager().getProperty(handle, clazz, string);
        if (engineObjectProperty == null) {
            throw new DXException("unable to unset '" + string + "' for '" + handle.getId() + "' because property does not exist");
        }
        engineObjectProperty.unset(bl);
    }

    void invokeOperation(Handle handle, DXOperationCallback dXOperationCallback) {
        ObjectManager objectManager = this.context.getObjectManager();
        OperationInstance operationInstance = objectManager.createOperation(handle, dXOperationCallback);
        if (operationInstance == null) {
            throw new DXException("unable to invoke '" + handle.getPath() + "' for '" + handle.getId() + "' because source does not exist");
        }
        operationInstance.invoke();
    }

    <V> void addItemListener(final Handle handle, Class<V> clazz, final DXItemListener<V> dXItemListener) {
        ObjectManager objectManager = this.context.getObjectManager();
        ItemInstance itemInstance = objectManager.getOrCreateItem(handle, clazz);
        ExecutionService executionService = this.context.getExecutionService();
        if (itemInstance != null) {
            final boolean bl = itemInstance.getJobPartition().getJob().getSource().isConnected();
            final boolean bl2 = itemInstance.addItemListener(this.context, dXItemListener);
            final Object object = bl2 ? itemInstance.getChangeObject() : null;
            executionService.addNotification(new Notification(){

                @Override
                void execute() {
                    DXEvent dXEvent;
                    DXBindEvent dXBindEvent = new DXBindEvent(handle.getId());
                    dXItemListener.onBind(dXBindEvent);
                    if (bl) {
                        dXEvent = new DXConnectionEvent(handle.getId(), true);
                        dXItemListener.onConnect((DXConnectionEvent)dXEvent);
                    }
                    if (bl2) {
                        dXEvent = new DXItemUpdateEvent<Object>(handle.getId(), object, true);
                        dXItemListener.onUpdate(dXEvent);
                    }
                }
            });
        } else {
            final DXException dXException = new DXException("item '" + handle.getId() + "' of type '" + clazz.getName() + "' not found");
            executionService.addNotification(new Notification(){

                @Override
                void execute() {
                    DXError dXError = new DXError(handle.getId(), dXException);
                    dXItemListener.onBindError(dXError);
                }
            });
        }
    }

    <V> void removeItemListener(Handle handle, DXItemListener<V> dXItemListener) {
        ObjectManager objectManager = this.context.getObjectManager();
        ItemInstance itemInstance = objectManager.getItem(handle);
        if (itemInstance != null) {
            if (!itemInstance.removeItemListener(this.context, dXItemListener)) {
                this.context.getLogger().log(Level.SEVERE, "Listener cannot be removed because listener has not been added: {0}", handle.getId());
            }
        } else {
            this.context.getLogger().log(Level.SEVERE, "Listener cannot be removed because item is not known: {0}", handle.getId());
        }
    }
}

