/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import javafx.animation.Timeline;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.shape.ClosePath;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.BezierComponent;

public class BezierPathComponent
extends BezierComponent {
    private final Path path;
    private final MoveTo move;
    private final CubicCurveTo topBezier;
    private final LineTo line;
    private final CubicCurveTo bottomBezier;
    private double height;

    public BezierPathComponent(Path path) {
        this.path = path;
        this.move = new MoveTo();
        this.topBezier = new CubicCurveTo();
        this.line = new LineTo();
        this.bottomBezier = new CubicCurveTo();
        path.getElements().setAll((Object[])new PathElement[]{this.move, this.topBezier, this.line, this.bottomBezier, new ClosePath()});
    }

    public double getHeight() {
        return this.height;
    }

    public void setHeight(double d) {
        this.height = d;
    }

    public Path getNode() {
        return this.path;
    }

    @Override
    protected void doMove() {
        double d = this.getStartX();
        double d2 = this.getStartY();
        double d3 = this.getEndX();
        double d4 = this.getEndY();
        this.move.setX(d);
        this.move.setY(d2);
        this.topBezier.setControlX1(this.getControlX1());
        this.topBezier.setControlY1(this.getControlY1());
        this.topBezier.setControlX2(this.getControlX2());
        this.topBezier.setControlY2(this.getControlY2());
        this.topBezier.setX(d3);
        this.topBezier.setY(d4);
        this.line.setX(d3);
        this.line.setY(d4 + this.height);
        this.bottomBezier.setControlX1(this.getControlX2());
        this.bottomBezier.setControlY1(this.getControlY2() + this.height);
        this.bottomBezier.setControlX2(this.getControlX1());
        this.bottomBezier.setControlY2(this.getControlY1() + this.height);
        this.bottomBezier.setX(d);
        this.bottomBezier.setY(d2 + this.height);
    }

    @Override
    protected void doAnimate(Timeline timeline, Duration duration, EventHandler<ActionEvent> eventHandler) {
        double d = this.getStartX();
        double d2 = this.getStartY();
        double d3 = this.getEndX();
        double d4 = this.getEndY();
        this.addKeyFrame(timeline, duration, this.move.xProperty(), d);
        this.addKeyFrame(timeline, duration, this.move.yProperty(), d2);
        this.addKeyFrame(timeline, duration, this.topBezier.controlX1Property(), (2.0 * d + d3) / 3.0);
        this.addKeyFrame(timeline, duration, this.topBezier.controlY1Property(), d2);
        this.addKeyFrame(timeline, duration, this.topBezier.controlX2Property(), (d + 2.0 * d3) / 3.0);
        this.addKeyFrame(timeline, duration, this.topBezier.controlY2Property(), d4);
        this.addKeyFrame(timeline, duration, this.topBezier.xProperty(), d3);
        this.addKeyFrame(timeline, duration, this.topBezier.yProperty(), d4);
        this.addKeyFrame(timeline, duration, this.line.xProperty(), d3);
        this.addKeyFrame(timeline, duration, this.line.yProperty(), d4 + this.height);
        this.addKeyFrame(timeline, duration, this.bottomBezier.controlX1Property(), (2.0 * d3 + d) / 3.0);
        this.addKeyFrame(timeline, duration, this.bottomBezier.controlY1Property(), d4 + this.height);
        this.addKeyFrame(timeline, duration, this.bottomBezier.controlX2Property(), (d3 + 2.0 * d) / 3.0);
        this.addKeyFrame(timeline, duration, this.bottomBezier.controlY2Property(), d2 + this.height);
        this.addKeyFrame(timeline, duration, this.bottomBezier.xProperty(), d);
        this.addKeyFrame(timeline, duration, eventHandler, this.bottomBezier.yProperty(), d2 + this.height);
    }
}

