/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.control;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javafx.animation.Timeline;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.ObservableList;
import javafx.css.PseudoClass;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Region;
import javafx.util.Duration;
import oracle.dbtools.raptor.metrics.control.AreaComponent;
import oracle.dbtools.raptor.metrics.control.BezierComponent;
import oracle.dbtools.raptor.metrics.control.Edge;
import oracle.dbtools.raptor.metrics.control.Graph;
import oracle.dbtools.raptor.metrics.control.GraphComponent;
import oracle.dbtools.raptor.metrics.control.Layout;
import oracle.dbtools.raptor.metrics.control.LocatedEdge;
import oracle.dbtools.raptor.metrics.control.LocatedVertex;
import oracle.dbtools.raptor.metrics.control.RegionComponent;
import oracle.dbtools.raptor.metrics.control.Vertex;

public abstract class AbstractGraphControl<T, G extends Graph<T, V, E>, V extends LocatedVertex<T, V, E>, E extends LocatedEdge<T, V, E>, ER extends BezierComponent>
extends Region {
    private final BooleanProperty showVertexDisplayPanelProperty = new SimpleBooleanProperty((Object)this, "showVertexDisplay", true){

        protected void invalidated() {
            AbstractGraphControl.this.updateUIModel();
        }
    };
    private final ObjectProperty<Function<V, Region>> vertexRepresentationFactoryProperty = new SimpleObjectProperty<Function<V, Region>>((Object)this, "vertexRepresentationFactory"){

        protected void invalidated() {
            AbstractGraphControl.this.updateUIModel();
        }
    };
    private final ObjectProperty<Function<V, Region>> vertexDisplayFactoryProperty = new SimpleObjectProperty<Function<V, Region>>((Object)this, "vertexDisplayFactory"){

        protected void invalidated() {
            AbstractGraphControl.this.updateUIModel();
        }
    };
    private final ObjectProperty<Function<E, Region>> edgeDisplayFactoryProperty = new SimpleObjectProperty<Function<E, Region>>((Object)this, "edgeDisplayFactory"){

        protected void invalidated() {
            AbstractGraphControl.this.updateUIModel();
        }
    };
    private final DoubleProperty maxDisplayWidthProperty = new SimpleDoubleProperty((Object)this, "maxDisplayWidth", 100.0);
    private final BooleanProperty autoShrinkProperty = new SimpleBooleanProperty((Object)this, "autoShrink", false);
    private final ObjectProperty<Duration> animationDurationProperty = new SimpleObjectProperty((Object)this, "animationDuration", (Object)Duration.millis((double)350.0));
    private final Layout<T, G, V, E> layout;
    private final Map<V, UIVertex> vertexMap = new HashMap<V, UIVertex>();
    private final Map<E, UIEdge> edgeMap = new HashMap<E, UIEdge>();
    private DragGeom dragGeom;
    private Rectangle2D physicalBounds;
    private double computedPrefHeight = 600.0;
    private double computedPrefWidth = 600.0;
    private double prefHeight = 600.0;
    private double prefWidth = 600.0;
    private Timeline timeline;
    private final BitSet layoutFlags = new BitSet(5);
    private static final int LAYOUT_UI_PENDING = 1;
    private static final int DONE_FIRST_LAYOUT = 2;
    private static final int INHIBIT_LAYOUT = 3;
    private static final int RECOMPUTE_PREF_HEIGHT = 4;
    private static final int RECOMPUTE_PREF_WIDTH = 5;
    private static final PseudoClass VERTEX_HOVER_CLASS = PseudoClass.getPseudoClass((String)"vertexHover");

    public AbstractGraphControl(Layout<T, G, V, E> layout) {
        this.layout = layout;
        this.setupGraphUpdateHandler((Graph<T, V, E>)layout.getGraph());
        this.setUpVertexDragListeners();
    }

    public double getMaxDisplayWidth() {
        return this.maxDisplayWidthProperty.get();
    }

    public void setMaxDisplayWidth(double d) {
        this.maxDisplayWidthProperty.set(d);
    }

    public DoubleProperty maxDisplayWidthProperty() {
        return this.maxDisplayWidthProperty;
    }

    public boolean isAutoShrink() {
        return this.autoShrinkProperty.get();
    }

    public void setAutoShrink(boolean bl) {
        this.autoShrinkProperty.set(bl);
    }

    public BooleanProperty autoShrinkProperty() {
        return this.autoShrinkProperty;
    }

    public Duration getAnimationDuration() {
        return (Duration)this.animationDurationProperty.get();
    }

    public void setAnimationDuration(Duration duration) {
        this.animationDurationProperty.set((Object)duration);
    }

    public ObjectProperty<Duration> animationDurationProperty() {
        return this.animationDurationProperty;
    }

    public boolean isShowVertexDisplayPanel() {
        return this.showVertexDisplayPanelProperty.get();
    }

    public void setShowVertexDisplayPanel(boolean bl) {
        this.showVertexDisplayPanelProperty.set(bl);
    }

    public BooleanProperty showVertexDisplayPanelProperty() {
        return this.showVertexDisplayPanelProperty;
    }

    public Function<V, Region> getVertexRepresentationFactory() {
        return (Function)this.vertexRepresentationFactoryProperty.get();
    }

    public void setVertexRepresentationFactory(Function<V, Region> function) {
        this.vertexRepresentationFactoryProperty.set(function);
    }

    public ObjectProperty<Function<V, Region>> vertexRepresentationFactoryProperty() {
        return this.vertexRepresentationFactoryProperty;
    }

    public Function<V, Region> getVertexDisplayFactory() {
        return (Function)this.vertexDisplayFactoryProperty.get();
    }

    public void setVertexDisplayFactory(Function<V, Region> function) {
        this.vertexDisplayFactoryProperty.set(function);
    }

    public ObjectProperty<Function<V, Region>> vertexDisplayFactoryProperty() {
        return this.vertexDisplayFactoryProperty;
    }

    public Function<E, Region> getEdgeDisplayFactory() {
        return (Function)this.edgeDisplayFactoryProperty.get();
    }

    public void setEdgeDisplayFactory(Function<E, Region> function) {
        this.edgeDisplayFactoryProperty.set(function);
    }

    public ObjectProperty<Function<E, Region>> edgeDisplayFactoryProperty() {
        return this.edgeDisplayFactoryProperty;
    }

    public G getGraph() {
        return this.layout.getGraph();
    }

    public void requestLayout() {
        if (!this.layoutFlags.get(3)) {
            super.requestLayout();
        }
    }

    protected AreaComponent createDefaultVertexDisplay(V v, double d) {
        return null;
    }

    protected abstract AreaComponent createDefaultVertexRepresentation(V var1);

    protected AreaComponent createDefaultEdgeDisplay(E e, double d) {
        return null;
    }

    protected abstract ER createEdgeRepresentation(E var1);

    protected abstract void layoutUIModel(double var1, double var3);

    protected Collection<V> getVisibleVertices() {
        return ((Graph)this.getGraph()).getVertices();
    }

    protected Collection<E> getVisibleEdges() {
        return ((Graph)this.getGraph()).getEdges();
    }

    protected double computePrefWidth() {
        return this.computedPrefWidth;
    }

    protected double computePrefHeight() {
        return this.computedPrefHeight;
    }

    protected void onCreateVertexDisplay(V v, AreaComponent areaComponent) {
    }

    protected void onCreateVertexRepresentation(V v, AreaComponent areaComponent) {
    }

    protected void onCreateEdgeDisplay(E e, AreaComponent areaComponent) {
    }

    protected boolean isAnimated() {
        return false;
    }

    protected boolean isVertexDraggable() {
        return true;
    }

    protected void setPhysicalBounds(Rectangle2D rectangle2D) {
        double d = rectangle2D.getMinX() + this.snappedLeftInset();
        double d2 = rectangle2D.getMinY() + this.snappedTopInset();
        double d3 = rectangle2D.getWidth();
        double d4 = rectangle2D.getHeight();
        this.physicalBounds = new Rectangle2D(d, d2, d3, d4);
    }

    protected double getPhysicalX(double d) {
        return this.physicalBounds.getMinX() + d * this.physicalBounds.getWidth();
    }

    protected double getPhysicalY(double d) {
        return this.physicalBounds.getMinY() + d * this.physicalBounds.getHeight();
    }

    protected double getPhysicalW(double d) {
        return d * this.physicalBounds.getWidth();
    }

    protected double getPhysicalH(double d) {
        return d * this.physicalBounds.getHeight();
    }

    protected Collection<UIVertex> getUIVertices() {
        return this.vertexMap.values();
    }

    protected Collection<UIEdge> getUIEdges() {
        return this.edgeMap.values();
    }

    protected UIVertex getUIVertex(V v) {
        return this.vertexMap.get(v);
    }

    protected UIEdge getUIEdge(E e) {
        return this.edgeMap.get(e);
    }

    protected void updateUIModel() {
        Object object;
        if (this.timeline != null) {
            this.timeline.stop();
            this.applyLayoutChange();
            this.timeline = null;
        }
        Collection<V> collection = this.getVisibleVertices();
        Collection<E> collection2 = this.getVisibleEdges();
        ObservableList observableList = this.getChildren();
        observableList.clear();
        for (UIVertex object2 : this.getUIVertices()) {
            object2.status = UIStatus.REMOVED;
        }
        for (LocatedVertex locatedVertex : collection) {
            object = this.vertexMap.get(locatedVertex);
            if (object == null) {
                object = new UIVertex();
                this.vertexMap.put((UIVertex)((Object)locatedVertex), (UIVertex)object);
                ((UIVertex)object).vertex = locatedVertex;
                ((UIVertex)object).representation = this.createVertexRepresentation(locatedVertex);
                ((UIVertex)object).display = this.createVertexDisplay(locatedVertex);
                ((UIVertex)object).representation.setOpacity(GraphComponent.Opacity.INCREASING);
                ((UIVertex)object).display.setOpacity(GraphComponent.Opacity.INCREASING);
                this.setupVertexHoverPseudoClass(locatedVertex, ((UIVertex)object).representation.getNode());
                if (((UIVertex)object).display != null) {
                    this.setupVertexHoverPseudoClass(locatedVertex, ((UIVertex)object).display.getNode());
                }
                this.setupVertexDrag(locatedVertex, ((UIVertex)object).representation.getNode());
                ((UIVertex)object).status = UIStatus.NEW;
                continue;
            }
            ((UIVertex)object).status = UIStatus.NOMINAL;
        }
        for (UIVertex uIVertex : this.getUIVertices()) {
            if (uIVertex.status != UIStatus.REMOVED) continue;
            uIVertex.representation.setOpacity(GraphComponent.Opacity.DECREASING);
            if (uIVertex.display == null) continue;
            uIVertex.display.setOpacity(GraphComponent.Opacity.DECREASING);
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            uIEdge.status = UIStatus.REMOVED;
        }
        for (LocatedEdge locatedEdge : collection2) {
            object = this.edgeMap.get(locatedEdge);
            if (object == null) {
                object = new UIEdge();
                this.edgeMap.put(locatedEdge, (UIEdge)object);
                ((UIEdge)object).edge = locatedEdge;
                ((UIEdge)object).representation = this.createEdgeRepresentation(locatedEdge);
                ((UIEdge)object).display = this.createEdgeDisplay(locatedEdge);
                ((GraphComponent)((UIEdge)object).representation).setOpacity(GraphComponent.Opacity.INCREASING);
                if (((UIEdge)object).display != null) {
                    ((UIEdge)object).display.setOpacity(GraphComponent.Opacity.INCREASING);
                }
                ((UIEdge)object).status = UIStatus.NEW;
                continue;
            }
            ((UIEdge)object).status = UIStatus.NOMINAL;
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            if (uIEdge.status != UIStatus.REMOVED) continue;
            ((GraphComponent)uIEdge.representation).setOpacity(GraphComponent.Opacity.DECREASING);
            if (uIEdge.display == null) continue;
            uIEdge.display.setOpacity(GraphComponent.Opacity.DECREASING);
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            ((GraphComponent)uIEdge.representation).addNodeTo((List<Node>)observableList);
        }
        for (UIVertex uIVertex : this.getUIVertices()) {
            uIVertex.representation.addNodeTo((List<Node>)observableList);
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            if (uIEdge.display == null) continue;
            uIEdge.display.addNodeTo((List<Node>)observableList);
        }
        for (UIVertex uIVertex : this.getUIVertices()) {
            if (uIVertex.display == null) continue;
            uIVertex.display.addNodeTo((List<Node>)observableList);
        }
        this.layout.run();
        this.requestLayout();
        this.layoutFlags.set(1);
        this.layoutFlags.set(5);
        this.layoutFlags.set(4);
    }

    protected void layoutChildren() {
        boolean bl = this.layoutFlags.get(1);
        boolean bl2 = this.layoutFlags.get(2);
        boolean bl3 = this.isAnimated() && bl2;
        this.layoutFlags.clear(1);
        if (!bl) {
            return;
        }
        this.layoutUIModel();
        if (bl3) {
            this.animateLayoutChange();
        } else {
            this.applyLayoutChange();
        }
        if (!bl2) {
            this.layoutFlags.set(2);
        }
    }

    protected double computePrefHeight(double d) {
        if (this.layoutFlags.get(4)) {
            this.computedPrefHeight = this.computePrefHeight();
            if (this.isAutoShrink() || this.computedPrefHeight > this.prefHeight) {
                this.prefHeight = this.computedPrefHeight;
            }
            this.layoutFlags.clear(4);
        }
        return this.prefHeight;
    }

    protected double computePrefWidth(double d) {
        if (this.layoutFlags.get(5)) {
            this.computedPrefWidth = this.computePrefWidth();
            if (this.isAutoShrink() || this.computedPrefWidth > this.prefWidth) {
                this.prefWidth = this.computedPrefWidth;
            }
            this.layoutFlags.clear(5);
        }
        return this.prefWidth;
    }

    private void applyLayoutChange() {
        this.tidyModel();
        for (UIVertex object : this.getUIVertices()) {
            object.representation.move();
            if (object.display == null) continue;
            object.display.move();
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            ((GraphComponent)uIEdge.representation).move();
            if (uIEdge.display == null) continue;
            uIEdge.display.move();
        }
    }

    private void animateLayoutChange() {
        this.timeline = new Timeline();
        Duration duration = this.getAnimationDuration();
        for (UIVertex object : this.getUIVertices()) {
            object.representation.animate(this.timeline, duration);
            if (object.display == null) continue;
            object.display.animate(this.timeline, duration);
        }
        for (UIEdge uIEdge : this.getUIEdges()) {
            ((GraphComponent)uIEdge.representation).animate(this.timeline, duration);
            if (uIEdge.display == null) continue;
            uIEdge.display.animate(this.timeline, duration);
        }
        this.timeline.setOnFinished(actionEvent -> {
            this.tidyModel();
            this.timeline = null;
        });
        this.timeline.play();
    }

    private void layoutUIModel() {
        double d = this.computedPrefWidth < this.getWidth() ? this.computedPrefWidth : this.getWidth();
        double d2 = this.getMinWidth();
        double d3 = this.getMaxWidth();
        if (d2 > 0.0 && d < d2) {
            d = d2;
        } else if (d3 > 0.0 && d > d3) {
            d = d3;
        }
        double d4 = this.computedPrefHeight < this.getHeight() ? this.computedPrefHeight : this.getHeight();
        double d5 = this.getMinHeight();
        double d6 = this.getMaxHeight();
        if (d5 > 0.0 && d4 < d5) {
            d4 = d5;
        } else if (d6 > 0.0 && d4 > d6) {
            d4 = d6;
        }
        this.layoutUIModel(d -= this.snappedLeftInset() + this.snappedRightInset(), d4 -= this.snappedTopInset() + this.snappedBottomInset());
    }

    private void tidyModel() {
        ObservableList observableList = this.getChildren();
        ArrayList<UIVertex> arrayList = new ArrayList<UIVertex>();
        for (UIVertex iterator2 : this.getUIVertices()) {
            if (iterator2.status == UIStatus.REMOVED) {
                arrayList.add(iterator2);
                continue;
            }
            iterator2.status = UIStatus.NOMINAL;
            iterator2.representation.setOpacity(GraphComponent.Opacity.CONSTANT);
            if (iterator2.display == null) continue;
            iterator2.display.setOpacity(GraphComponent.Opacity.CONSTANT);
        }
        for (UIVertex uIVertex : arrayList) {
            this.vertexMap.remove(uIVertex.vertex);
            observableList.remove(uIVertex.representation.getNode());
            if (uIVertex.display == null) continue;
            observableList.remove(uIVertex.display.getNode());
        }
        ArrayList arrayList2 = new ArrayList();
        for (UIEdge uIEdge : this.getUIEdges()) {
            if (uIEdge.status == UIStatus.REMOVED) {
                arrayList2.add(uIEdge);
                continue;
            }
            uIEdge.status = UIStatus.NOMINAL;
            ((GraphComponent)uIEdge.representation).setOpacity(GraphComponent.Opacity.CONSTANT);
            if (uIEdge.display == null) continue;
            uIEdge.display.setOpacity(GraphComponent.Opacity.CONSTANT);
        }
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            UIEdge uIEdge;
            uIEdge = (UIEdge)iterator.next();
            this.edgeMap.remove(uIEdge.edge);
            observableList.remove(((GraphComponent)uIEdge.representation).getNode());
            if (uIEdge.display == null) continue;
            observableList.remove(uIEdge.display.getNode());
        }
    }

    private AreaComponent createVertexRepresentation(V v) {
        Function<V, Region> function = this.getVertexRepresentationFactory();
        AreaComponent areaComponent = function != null ? new RegionComponent(function.apply(v)) : this.createDefaultVertexRepresentation(v);
        this.onCreateVertexRepresentation(v, areaComponent);
        return areaComponent;
    }

    private AreaComponent createVertexDisplay(V v) {
        AreaComponent areaComponent = null;
        if (this.isShowVertexDisplayPanel()) {
            Function<V, Region> function = this.getVertexDisplayFactory();
            if (function != null) {
                Region region = function.apply(v);
                region.setMaxWidth(this.getMaxDisplayWidth());
                region.setMinWidth(Double.NEGATIVE_INFINITY);
                areaComponent = new RegionComponent(region);
            } else {
                areaComponent = this.createDefaultVertexDisplay(v, this.getMaxDisplayWidth());
            }
            this.onCreateVertexDisplay(v, areaComponent);
        }
        return areaComponent;
    }

    private AreaComponent createEdgeDisplay(E e) {
        AreaComponent areaComponent;
        Function<E, Region> function = this.getEdgeDisplayFactory();
        if (function != null) {
            Region region = function.apply(e);
            region.setMaxWidth(this.getMaxDisplayWidth());
            areaComponent = new RegionComponent(region);
        } else {
            areaComponent = this.createDefaultEdgeDisplay(e, this.getMaxDisplayWidth());
        }
        this.onCreateEdgeDisplay(e, areaComponent);
        return areaComponent;
    }

    private void setupGraphUpdateHandler(Graph<T, V, E> graph) {
        graph.setUpdateHandler((EventHandler<ActionEvent>)((EventHandler)actionEvent -> this.updateUIModel()));
    }

    private void setupVertexHoverPseudoClass(V v, Node node) {
        node.hoverProperty().addListener((observableValue, bl, bl2) -> {
            for (LocatedEdge locatedEdge : v.getIncidentEdges()) {
                UIEdge uIEdge = this.edgeMap.get(locatedEdge);
                if (uIEdge == null) continue;
                Node node = ((GraphComponent)uIEdge.representation).getNode();
                node.pseudoClassStateChanged(VERTEX_HOVER_CLASS, bl2 != false || this.dragGeom != null && this.dragGeom.vertex == v);
            }
        });
    }

    private void setUpVertexDragListeners() {
        if (this.isVertexDraggable()) {
            this.setOnMouseReleased(mouseEvent -> this.dropVertex());
            this.setOnMouseDragged(mouseEvent -> this.dragVertex(this.getMouseEventY((MouseEvent)mouseEvent)));
        }
    }

    private void setupVertexDrag(V v, Node node) {
        if (this.isVertexDraggable()) {
            node.setOnMousePressed(mouseEvent -> this.beginDragVertex(v, node, this.getMouseEventY((MouseEvent)mouseEvent)));
        }
    }

    private double getMouseEventY(MouseEvent mouseEvent) {
        return this.sceneToLocal(mouseEvent.getSceneX(), mouseEvent.getSceneY()).getY();
    }

    private void beginDragVertex(V v, Node node, double d) {
        if (this.dragGeom == null) {
            this.dragGeom = new DragGeom();
            this.dragGeom.vertex = v;
            this.dragGeom.node = node;
            this.dragGeom.initialMouseY = d;
            this.dragGeom.initialVertexY = ((LocatedVertex)v).getY();
        }
    }

    private void dragVertex(double d) {
        if (this.dragGeom != null) {
            double d2 = this.physicalBounds.getHeight();
            double d3 = this.physicalBounds.getMinY() / d2;
            double d4 = d - this.dragGeom.initialMouseY;
            double d5 = d4 / d2;
            double d6 = this.dragGeom.initialVertexY + d5;
            double d7 = this.dragGeom.node.prefHeight(-1.0) / d2;
            if (d6 - 0.5 * d7 + d3 < 0.0) {
                d6 = 0.5 * d7 - d3;
            } else if (d6 + 0.5 * d7 - d3 > 1.0) {
                d6 = 1.0 - 0.5 * d7 + d3;
            }
            ((LocatedVertex)this.dragGeom.vertex).setY(d6);
            this.layoutFlags.set(3);
            this.layoutUIModel();
            this.applyLayoutChange();
            this.layoutFlags.clear(3);
        }
    }

    private void dropVertex() {
        if (this.dragGeom != null) {
            for (LocatedEdge locatedEdge : ((Vertex)this.dragGeom.vertex).getIncidentEdges()) {
                Node node = ((GraphComponent)this.edgeMap.get((Object)locatedEdge).representation).getNode();
                node.pseudoClassStateChanged(VERTEX_HOVER_CLASS, false);
            }
            this.dragGeom = null;
        }
    }

    protected class UIVertex {
        private V vertex;
        private AreaComponent representation;
        private AreaComponent display;
        private UIStatus status;

        protected UIVertex() {
        }

        protected V getVertex() {
            return this.vertex;
        }

        protected UIStatus getStatus() {
            return this.status;
        }

        protected AreaComponent getRepresentation() {
            return this.representation;
        }

        protected AreaComponent getDisplay() {
            return this.display;
        }
    }

    protected class UIEdge {
        private E edge;
        private ER representation;
        private AreaComponent display;
        private UIStatus status;

        protected UIEdge() {
        }

        protected E getEdge() {
            return this.edge;
        }

        protected UIVertex getSourceUIVertex() {
            return AbstractGraphControl.this.vertexMap.get(((Edge)this.edge).getSource());
        }

        protected UIVertex getDestUIVertex() {
            return AbstractGraphControl.this.vertexMap.get(((Edge)this.edge).getDest());
        }

        protected UIStatus getStatus() {
            return this.status;
        }

        protected ER getRepresentation() {
            return this.representation;
        }

        protected AreaComponent getDisplay() {
            return this.display;
        }
    }

    protected static enum UIStatus {
        NEW,
        REMOVED,
        NOMINAL;

    }

    private class DragGeom {
        private V vertex;
        private Node node;
        private double initialMouseY;
        private double initialVertexY;

        private DragGeom() {
        }
    }
}

