/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.Operations;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.engine.MetaProperty;

abstract class ViewPropertyEditor<T> {
    private final Element<?> consoleElement;
    private final CheckBox special;
    private final CheckBox defaultSpecial;
    private final Button useDefaultButton;
    private final Button resetButton;
    private final ViewProperty<T> property;
    private final ViewProperty<T> defaultProperty;
    private final MetaProperty<T> metaProperty;
    private final BooleanProperty modifiedProperty = new SimpleBooleanProperty(false);
    private boolean originalOverridden;
    private boolean originalDefaultOverridden;
    private T originalValue;
    private T originalDefaultValue;
    private boolean synchingFromDefault;

    ViewPropertyEditor(Element<?> element, ViewProperty<T> viewProperty, ViewProperty<T> viewProperty2) {
        this.consoleElement = element;
        this.defaultProperty = viewProperty2;
        this.property = viewProperty;
        this.metaProperty = viewProperty2.getMeta();
        this.resetButton = this.createButton(MetricsResources.getString("METRICS_CONSOLE_PROPERTY_EDITOR_RESET"));
        this.useDefaultButton = this.createButton(MetricsResources.getString("METRICS_CONSOLE_PROPERTY_EDITOR_USED_DEFAULT"));
        this.defaultSpecial = this.createSpecialCheck(viewProperty2);
        this.special = this.createSpecialCheck(viewProperty);
    }

    void configurePropertyControls() {
        this.originalDefaultOverridden = this.defaultProperty.isOverridden();
        this.originalOverridden = this.property.isOverridden();
        this.originalDefaultValue = this.getCurrentDefaultValue();
        this.originalValue = this.getCurrentValue();
        this.resetButton.setDisable(!this.originalDefaultOverridden);
        this.useDefaultButton.setDisable(!this.originalOverridden);
        this.getDefaultValueProperty().addListener(observable -> {
            this.resetButton.setDisable(false);
            if (this.useDefaultButton.isDisable()) {
                this.synchingFromDefault = true;
                try {
                    this.getValueProperty().setValue(this.getDefaultValueProperty().getValue());
                }
                finally {
                    this.synchingFromDefault = false;
                }
            }
            this.updateStatus();
        });
        if (this.defaultSpecial != null) {
            this.defaultSpecial.setSelected(Objects.equals(this.getDefaultValueProperty().getValue(), this.metaProperty.getSpecialValueEncoding()));
            this.getDefaultControl().setDisable(this.defaultSpecial.isSelected());
            if (this.defaultSpecial.isSelected()) {
                this.getDefaultValueProperty().setValue(this.metaProperty.getHardDefault());
            }
            this.defaultSpecial.selectedProperty().addListener(observable -> {
                this.getDefaultControl().setDisable(this.defaultSpecial.isSelected());
                this.resetButton.setDisable(false);
                if (this.useDefaultButton.isDisable()) {
                    this.synchingFromDefault = true;
                    try {
                        this.special.setSelected(this.defaultSpecial.isSelected());
                    }
                    finally {
                        this.synchingFromDefault = false;
                    }
                }
                this.updateStatus();
            });
        }
        this.getValueProperty().addListener(observable -> {
            if (!this.synchingFromDefault) {
                this.useDefaultButton.setDisable(false);
            }
            this.updateStatus();
        });
        if (this.special != null) {
            this.special.setSelected(Objects.equals(this.getValueProperty().getValue(), this.metaProperty.getSpecialValueEncoding()));
            this.getControl().setDisable(this.special.isSelected());
            if (this.special.isSelected()) {
                this.getValueProperty().setValue(this.getDefaultValueProperty().getValue());
            }
            this.special.selectedProperty().addListener(observable -> {
                this.getControl().setDisable(this.special.isSelected());
                if (!this.synchingFromDefault) {
                    this.useDefaultButton.setDisable(false);
                }
                this.updateStatus();
            });
        }
        this.resetButton.setOnAction(actionEvent -> {
            this.getDefaultValueProperty().setValue(this.metaProperty.getHardDefault());
            if (this.defaultSpecial != null) {
                this.defaultSpecial.setSelected(this.metaProperty.hasSpecialValueHardDefault());
            }
            this.resetButton.setDisable(true);
        });
        this.useDefaultButton.setOnAction(actionEvent -> {
            this.getValueProperty().setValue(this.getDefaultValueProperty().getValue());
            if (this.special != null) {
                this.special.setSelected(this.defaultSpecial.isSelected());
            }
            this.useDefaultButton.setDisable(true);
        });
    }

    abstract Node getControl();

    abstract Node getDefaultControl();

    abstract Property<T> getValueProperty();

    abstract Property<T> getDefaultValueProperty();

    CheckBox getSpecial() {
        return this.special;
    }

    CheckBox getDefaultSpecial() {
        return this.defaultSpecial;
    }

    Button getUseDefaultButton() {
        return this.useDefaultButton;
    }

    Button getResetButton() {
        return this.resetButton;
    }

    ViewProperty<T> getProperty() {
        return this.property;
    }

    ViewProperty<T> getDefaultProperty() {
        return this.defaultProperty;
    }

    ObservableBooleanValue modifiedProperty() {
        return this.modifiedProperty;
    }

    void addChanges(Operations operations) {
        if (this.resetButton.isDisabled()) {
            if (this.originalDefaultOverridden) {
                this.consoleElement.addUseDefaultTypePropertyCall(operations, this.defaultProperty);
            }
        } else if (!Objects.equals(this.getCurrentDefaultValue(), this.originalDefaultValue)) {
            this.consoleElement.addSetTypePropertyCall(operations, this.defaultProperty, this.getCurrentDefaultValue());
        }
        if (this.useDefaultButton.isDisabled()) {
            if (this.originalOverridden) {
                this.consoleElement.addUseDefaultPropertyCall(operations, this.property);
            }
        } else if (!Objects.equals(this.getCurrentValue(), this.originalValue)) {
            this.consoleElement.addSetPropertyCall(operations, this.property, this.getCurrentValue());
        }
    }

    private CheckBox createSpecialCheck(ViewProperty<?> viewProperty) {
        CheckBox checkBox = null;
        MetaProperty<?> metaProperty = viewProperty.getMeta();
        if (metaProperty.hasSpecialValue()) {
            checkBox = new CheckBox(metaProperty.getSpecialValueLabel());
        }
        return checkBox;
    }

    private Button createButton(String string) {
        Button button = new Button(string);
        button.setMaxWidth(Double.MAX_VALUE);
        return button;
    }

    private T getCurrentDefaultValue() {
        Object object = this.defaultSpecial != null && this.defaultSpecial.isSelected() ? this.metaProperty.getSpecialValueEncoding() : this.getDefaultValueProperty().getValue();
        return (T)object;
    }

    private T getCurrentValue() {
        Object object = this.special != null && this.special.isSelected() ? this.metaProperty.getSpecialValueEncoding() : this.getValueProperty().getValue();
        return (T)object;
    }

    private void updateStatus() {
        this.modifiedProperty.set(!Objects.equals(this.getCurrentValue(), this.originalValue) || !Objects.equals(this.getCurrentDefaultValue(), this.originalDefaultValue));
    }
}

