/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.stage.Window;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.dbtools.raptor.metrics.console.BooleanElementPropertyEditor;
import oracle.dbtools.raptor.metrics.console.Element;
import oracle.dbtools.raptor.metrics.console.NumericElementPropertyEditor;
import oracle.dbtools.raptor.metrics.console.Operations;
import oracle.dbtools.raptor.metrics.console.StringElementPropertyEditor;
import oracle.dbtools.raptor.metrics.console.ViewProperty;
import oracle.dbtools.raptor.metrics.console.ViewPropertyEditor;

class ElementEditor
extends GridPane {
    private ObservableBooleanValue modifiedProperty;
    private final List<ViewPropertyEditor<?>> propertyEditors = new ArrayList();

    ElementEditor(Element<?> element) {
        this.initializeUI(element);
    }

    void applyChanges(Window window) {
        Operations operations = new Operations(window);
        for (ViewPropertyEditor<?> viewPropertyEditor : this.propertyEditors) {
            viewPropertyEditor.addChanges(operations);
        }
        operations.callAll();
    }

    ObservableBooleanValue modifiedProperty() {
        return this.modifiedProperty;
    }

    private void initializeUI(Element<?> element) {
        List<ViewProperty<?>> list = element.getProperties();
        List<ViewProperty<?>> list2 = element.getDefaultProperties();
        this.setPadding(new Insets(20.0, 30.0, 20.0, 30.0));
        this.setVgap(15.0);
        this.setHgap(15.0);
        this.setMinWidth(300.0);
        ColumnConstraints columnConstraints = new ColumnConstraints();
        columnConstraints.setHgrow(Priority.NEVER);
        ColumnConstraints columnConstraints2 = new ColumnConstraints();
        columnConstraints2.setHgrow(Priority.ALWAYS);
        ColumnConstraints columnConstraints3 = new ColumnConstraints();
        columnConstraints3.setHgrow(Priority.NEVER);
        this.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{columnConstraints, columnConstraints2, columnConstraints3});
        int n = 0;
        for (int i = 0; i < list.size(); ++i) {
            n = this.addPropertyUI(n, this.createPropertyEditor(element, list.get(i), list2.get(i)));
        }
    }

    private ViewPropertyEditor<?> createPropertyEditor(Element<?> element, ViewProperty<?> viewProperty, ViewProperty<?> viewProperty2) {
        Class<?> clazz = viewProperty.getMeta().getType();
        if (clazz != viewProperty2.getMeta().getType()) {
            throw new IllegalArgumentException();
        }
        ViewPropertyEditor viewPropertyEditor = Number.class.isAssignableFrom(clazz) ? new NumericElementPropertyEditor(element, viewProperty, viewProperty2) : (Boolean.class.isAssignableFrom(clazz) ? new BooleanElementPropertyEditor(element, (ViewProperty<Boolean>)viewProperty, (ViewProperty<Boolean>)viewProperty2) : new StringElementPropertyEditor(element, (ViewProperty<String>)viewProperty, (ViewProperty<String>)viewProperty2));
        viewPropertyEditor.configurePropertyControls();
        return viewPropertyEditor;
    }

    private int addPropertyUI(int n, ViewPropertyEditor<?> viewPropertyEditor) {
        this.modifiedProperty = this.modifiedProperty == null ? viewPropertyEditor.modifiedProperty() : Bindings.or((ObservableBooleanValue)this.modifiedProperty, (ObservableBooleanValue)viewPropertyEditor.modifiedProperty());
        this.propertyEditors.add(viewPropertyEditor);
        Label label = this.createTitleLabel(viewPropertyEditor.getProperty());
        Label label2 = this.createDefaultLabel();
        Node node = this.createRuler();
        this.add((Node)label, 0, n, 3, 1);
        this.add(viewPropertyEditor.getControl(), 1, ++n);
        this.add((Node)viewPropertyEditor.getUseDefaultButton(), 2, n);
        ++n;
        CheckBox checkBox = viewPropertyEditor.getSpecial();
        if (checkBox != null) {
            this.add((Node)checkBox, 1, n);
            ++n;
        }
        this.add((Node)label2, 1, n, 2, 1);
        this.add(viewPropertyEditor.getDefaultControl(), 1, ++n);
        this.add((Node)viewPropertyEditor.getResetButton(), 2, n);
        ++n;
        CheckBox checkBox2 = viewPropertyEditor.getDefaultSpecial();
        if (checkBox2 != null) {
            this.add((Node)checkBox2, 1, n);
            ++n;
        }
        this.add(node, 0, n, 3, 1);
        return ++n;
    }

    private Label createTitleLabel(ViewProperty<?> viewProperty) {
        Label label = new Label(viewProperty.getMeta().getLabel());
        label.setFont(Font.font(null, (FontPosture)FontPosture.ITALIC, (double)14.0));
        label.setUnderline(true);
        return label;
    }

    private Label createDefaultLabel() {
        Label label = new Label(MetricsResources.getString("METRICS_CONSOLE_LABEL_DEFAULT"));
        label.setFont(Font.font(null, (FontPosture)FontPosture.ITALIC, (double)12.0));
        return label;
    }

    private Node createRuler() {
        Label label = new Label("");
        label.setMaxWidth(Double.MAX_VALUE);
        label.setMinHeight(2.0);
        label.setMaxHeight(2.0);
        label.setStyle("-fx-background-color:lightgrey;");
        return label;
    }
}

