/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.net.URI;
import java.util.List;
import javafx.beans.value.ObservableStringValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableSet;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import oracle.dbtools.raptor.metrics.console.AttributeRow;
import oracle.dbtools.raptor.metrics.console.MetaAttribute;
import oracle.dbtools.raptor.metrics.console.Operations;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.console.ViewProperty;

abstract class Element<C extends ViewObject<?>> {
    private final TreeItem<Element<?>> treeItem;
    private final String label;
    private final ObservableList<AttributeRow> childAttributeRows = FXCollections.observableArrayList();

    Element(ObservableSet<C> observableSet) {
        this(null, observableSet);
    }

    Element(String string, ObservableSet<C> observableSet) {
        this.label = string;
        this.treeItem = new TreeItem();
        this.monitorChildViewSet(observableSet);
    }

    public String toString() {
        return this.label;
    }

    URI getId() {
        throw new UnsupportedOperationException();
    }

    String getPath() {
        throw new UnsupportedOperationException();
    }

    ImageView createIconImage() {
        ImageView imageView = null;
        String string = this.getIconPath();
        if (string != null) {
            imageView = new ImageView(new Image(this.getClass().getClassLoader().getResourceAsStream(string)));
        }
        return imageView;
    }

    List<MetaAttribute> getMetaAttributes() {
        throw new UnsupportedOperationException();
    }

    AttributeRow getAttributeRow() {
        return new AttributeRow(this.label, this.createAttributeValues());
    }

    List<MetaAttribute> getChildMetaAttributes() {
        throw new UnsupportedOperationException();
    }

    ObservableList<AttributeRow> getChildAttributeRows() {
        return this.childAttributeRows;
    }

    List<? extends ViewProperty<?>> getProperties() {
        throw new UnsupportedOperationException();
    }

    List<? extends ViewProperty<?>> getDefaultProperties() {
        throw new UnsupportedOperationException();
    }

    boolean maintainChildTreeItems() {
        return true;
    }

    boolean maintainChildAttributeRows() {
        return true;
    }

    List<ObservableStringValue> createAttributeValues() {
        throw new UnsupportedOperationException();
    }

    List<ObservableStringValue> createChildAttributeValues(C c) {
        throw new UnsupportedOperationException();
    }

    Element<?> createChildElement(C c) {
        throw new UnsupportedOperationException();
    }

    String getIconPath() {
        throw new UnsupportedOperationException();
    }

    TreeItem<Element<?>> getTreeItem() {
        return this.treeItem;
    }

    void beforeAddChildItem() {
    }

    void afterRemoveChildItem() {
    }

    <T> void addUseDefaultPropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        throw new UnsupportedOperationException();
    }

    <T> void addSetPropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        throw new UnsupportedOperationException();
    }

    <T> void addUseDefaultTypePropertyCall(Operations operations, ViewProperty<T> viewProperty) {
        throw new UnsupportedOperationException();
    }

    <T> void addSetTypePropertyCall(Operations operations, ViewProperty<T> viewProperty, T t) {
        throw new UnsupportedOperationException();
    }

    private void addToTree(TreeItem<Element<?>> treeItem) {
        if (this.label != null) {
            this.treeItem.setGraphic((Node)this.createIconImage());
        }
        this.treeItem.setValue((Object)this);
        treeItem.getChildren().add(this.treeItem);
    }

    private void monitorChildViewSet(ObservableSet<C> observableSet) {
        if (observableSet != null) {
            observableSet.addListener(change -> {
                if (change.wasAdded()) {
                    if (this.maintainChildTreeItems()) {
                        this.addChildObject((ViewObject)change.getElementAdded());
                    }
                    if (this.maintainChildAttributeRows()) {
                        this.addChildAttributeRow((ViewObject)change.getElementAdded());
                    }
                } else if (change.wasRemoved()) {
                    if (this.maintainChildTreeItems()) {
                        this.removeChildObject((ViewObject)change.getElementRemoved());
                    }
                    if (this.maintainChildAttributeRows()) {
                        this.removeChildAttributeRow((ViewObject)change.getElementRemoved());
                    }
                }
            });
        }
    }

    private void addChildObject(C c) {
        Element<?> element = this.createChildElement(c);
        this.beforeAddChildItem();
        element.addToTree(this.treeItem);
    }

    private void removeChildObject(C c) {
        TreeItem treeItem = null;
        for (TreeItem treeItem2 : this.treeItem.getChildren()) {
            if (!((Element)treeItem2.getValue()).toString().equals(((ViewObject)c).toString())) continue;
            treeItem = treeItem2;
            break;
        }
        if (treeItem != null) {
            this.treeItem.getChildren().remove(treeItem);
            this.afterRemoveChildItem();
        }
    }

    private void addChildAttributeRow(C c) {
        List<ObservableStringValue> list = this.createChildAttributeValues(c);
        this.childAttributeRows.add((Object)new AttributeRow(((ViewObject)c).getPath(), list));
    }

    private void removeChildAttributeRow(C c) {
        int n = -1;
        int n2 = 0;
        for (AttributeRow attributeRow : this.childAttributeRows) {
            if (attributeRow.getKey().equals(((ViewObject)c).getPath())) {
                n = n2;
            }
            ++n2;
        }
        if (n >= 0) {
            this.childAttributeRows.remove(n);
        }
    }
}

