/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.console;

import java.net.URI;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import oracle.dbtools.raptor.metrics.console.ItemTypeView;
import oracle.dbtools.raptor.metrics.console.ItemView;
import oracle.dbtools.raptor.metrics.console.JobTypeView;
import oracle.dbtools.raptor.metrics.console.JobView;
import oracle.dbtools.raptor.metrics.console.SourceTypeView;
import oracle.dbtools.raptor.metrics.console.SourceView;
import oracle.dbtools.raptor.metrics.console.ViewObject;
import oracle.dbtools.raptor.metrics.engine.DXListenerList;
import oracle.dbtools.raptor.metrics.listener.DXActivityEvent;
import oracle.dbtools.raptor.metrics.listener.DXActivityListener;
import oracle.dbtools.raptor.metrics.listener.DXActivityVisitor;
import oracle.dbtools.raptor.metrics.listener.DXBindEvent;
import oracle.dbtools.raptor.metrics.listener.DXError;
import oracle.dbtools.raptor.metrics.listener.EngineObjectChange;
import oracle.dbtools.raptor.metrics.listener.ItemChange;
import oracle.dbtools.raptor.metrics.listener.ItemTypeChange;
import oracle.dbtools.raptor.metrics.listener.JobChange;
import oracle.dbtools.raptor.metrics.listener.JobTypeChange;
import oracle.dbtools.raptor.metrics.listener.OperationChange;
import oracle.dbtools.raptor.metrics.listener.OperationTypeChange;
import oracle.dbtools.raptor.metrics.listener.SourceChange;
import oracle.dbtools.raptor.metrics.listener.SourceTypeChange;

public class ConsoleModel {
    private BooleanProperty boundProperty = new SimpleBooleanProperty((Object)this, "bound", false);
    private final ObservableSet<SourceView> sourcesProperty = FXCollections.observableSet(new HashSet());
    private ObservableMap<URI, ViewObject<?>> objectMap = FXCollections.observableHashMap();
    private final ViewObject.Context viewContext = new ViewObject.Context(){

        @Override
        <V extends ViewObject<? extends EngineObjectChange>> V lookupObject(Class<V> clazz, URI uRI) {
            return ConsoleModel.this.lookupObject(clazz, uRI);
        }
    };

    public boolean isBound() {
        return this.boundProperty.get();
    }

    public ObservableBooleanValue boundProperty() {
        return this.boundProperty;
    }

    public ObservableSet<SourceView> getSources() {
        return this.sourcesProperty;
    }

    public void addActivityListener(DXListenerList dXListenerList) {
        dXListenerList.addActivityListener(new DXActivityListener(){

            @Override
            public void onBind(DXBindEvent dXBindEvent) {
                ConsoleModel.this.boundProperty.set(true);
            }

            @Override
            public void onBindError(DXError dXError) {
                Logger.getLogger(ConsoleModel.class.getName()).log(Level.SEVERE, "bind error", dXError.getException());
            }

            @Override
            public void onUnbind(DXBindEvent dXBindEvent) {
                ConsoleModel.this.boundProperty.set(false);
            }

            @Override
            public void onUpdate(DXActivityEvent dXActivityEvent) {
                Platform.runLater(() -> dXActivityEvent.visitActivities(new DXActivityVisitor(){

                    @Override
                    public void visit(SourceTypeChange sourceTypeChange) {
                        ConsoleModel.this.update(SourceTypeView.class, sourceTypeChange, null);
                    }

                    @Override
                    public void visit(JobTypeChange jobTypeChange) {
                        ConsoleModel.this.update(JobTypeView.class, jobTypeChange, null);
                    }

                    @Override
                    public void visit(ItemTypeChange itemTypeChange) {
                        ConsoleModel.this.update(ItemTypeView.class, itemTypeChange, null);
                    }

                    @Override
                    public void visit(SourceChange sourceChange) {
                        ConsoleModel.this.update(SourceView.class, sourceChange, ConsoleModel.this.sourcesProperty);
                    }

                    @Override
                    public void visit(JobChange jobChange) {
                        ConsoleModel.this.update(JobView.class, jobChange, null);
                    }

                    @Override
                    public void visit(ItemChange itemChange) {
                        ConsoleModel.this.update(ItemView.class, itemChange, null);
                    }

                    @Override
                    public void visit(OperationTypeChange operationTypeChange) {
                    }

                    @Override
                    public void visit(OperationChange operationChange) {
                    }
                }));
            }
        });
    }

    ObservableMap<URI, ViewObject<?>> getObjectMap() {
        return this.objectMap;
    }

    private <T extends EngineObjectChange, V extends ViewObject<T>> void update(Class<V> clazz, T t, ObservableSet<V> observableSet) {
        switch (t.getChangeType()) {
            case ADD: {
                this.add(clazz, t, observableSet);
                break;
            }
            case REMOVE: {
                this.remove(clazz, t, observableSet);
                break;
            }
            case UPDATE: {
                this.update(clazz, t);
            }
        }
    }

    private <T extends EngineObjectChange, V extends ViewObject<T>> void add(Class<V> clazz, T t, ObservableSet<V> observableSet) {
        if (!this.objectMap.containsKey((Object)t.getFocusId())) {
            try {
                ViewObject viewObject = (ViewObject)clazz.newInstance();
                viewObject.onAdd(this.viewContext, t);
                viewObject.onUpdate(t);
                this.objectMap.put((Object)t.getFocusId(), (Object)viewObject);
                if (observableSet != null) {
                    observableSet.add((Object)viewObject);
                }
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                Logger.getLogger(ConsoleModel.class.getName()).log(Level.SEVERE, "unable to create console object '" + clazz.getName() + "'", reflectiveOperationException);
            }
        }
    }

    private <T extends EngineObjectChange, V extends ViewObject<? extends EngineObjectChange>> void remove(Class<V> clazz, T t, ObservableSet<V> observableSet) {
        V v = this.lookupObject(clazz, t.getFocusId());
        if (v != null) {
            ((ViewObject)v).onRemove();
            if (observableSet != null) {
                observableSet.remove(v);
            }
            this.objectMap.remove((Object)t.getFocusId());
        }
    }

    private <T extends EngineObjectChange, V extends ViewObject<T>> void update(Class<V> clazz, T t) {
        V v = this.lookupObject(clazz, t.getFocusId());
        if (v != null) {
            ((ViewObject)v).onUpdate(t);
        }
    }

    private <V extends ViewObject<? extends EngineObjectChange>> V lookupObject(Class<V> clazz, URI uRI) {
        ViewObject viewObject = null;
        Object object = this.objectMap.get((Object)uRI);
        if (object == null) {
            Logger.getLogger(ConsoleModel.class.getName()).log(Level.SEVERE, "object not defined in lookup ''{0}''", uRI);
        } else if (clazz.isAssignableFrom(object.getClass())) {
            viewObject = (ViewObject)object;
        } else {
            Logger.getLogger(ConsoleModel.class.getName()).log(Level.SEVERE, "object ''{0}'' does not have expected type ''{1}''", new Object[]{uRI, clazz.getSimpleName()});
        }
        return (V)viewObject;
    }
}

