/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import oracle.dbtools.raptor.metrics.actionobject.AbstractFileSelectionAction;

public class FileSelection
extends AbstractFileSelectionAction {
    private final StringProperty dialogTitleProperty = new SimpleStringProperty((Object)this, "dialogTitle");
    private final StringProperty fileFilterDescriptionProperty = new SimpleStringProperty((Object)this, "fileFilterDescription");
    private final StringProperty fileExtensionProperty = new SimpleStringProperty((Object)this, "fileExtension");
    private final StringProperty filePathProperty = new SimpleStringProperty((Object)this, "filePath");

    public FileSelection() {
        this.init(new Listener());
    }

    public String getDialogTitle() {
        return (String)this.dialogTitleProperty.get();
    }

    public void setDialogTitle(String string) {
        this.dialogTitleProperty.set((Object)string);
    }

    public StringProperty dialogTitleProperty() {
        return this.dialogTitleProperty;
    }

    public String getFileFilterDescription() {
        return (String)this.fileFilterDescriptionProperty.get();
    }

    public void setFileFilterDescription(String string) {
        this.fileFilterDescriptionProperty.set((Object)string);
    }

    public StringProperty fileFilterDescriptionProperty() {
        return this.fileFilterDescriptionProperty;
    }

    public String getFileExtension() {
        return (String)this.fileExtensionProperty.get();
    }

    public void setFileExtension(String string) {
        this.fileExtensionProperty.set((Object)string);
    }

    public StringProperty fileExtensionProperty() {
        return this.fileExtensionProperty;
    }

    public String getFilePath() {
        return (String)this.filePathProperty.get();
    }

    public ReadOnlyStringProperty filePathProperty() {
        return this.filePathProperty;
    }

    @Override
    public Boolean get() {
        String string = this.getFileExtension();
        List<String> list = string != null ? Arrays.asList(string.split("\\s*\\,\\s*")) : Collections.emptyList();
        File file = this.selectFile(this.getDialogTitle(), this.getFileFilterDescription(), null, list);
        if (file != null) {
            try {
                this.filePathProperty.set((Object)file.getCanonicalPath());
            }
            catch (IOException iOException) {
                Logger.getLogger(FileSelection.class.getName()).log(Level.WARNING, "error converting file to path", iOException);
            }
        }
        return true;
    }

    protected class Listener
    extends AbstractFileSelectionAction.Listener {
        protected Listener() {
        }
    }
}

