/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.metrics.actionobject;

import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskListener;
import oracle.dbtools.raptor.backgroundTask.IRaptorTaskRunMode;
import oracle.dbtools.raptor.backgroundTask.RaptorTask;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskAdapter;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskEvent;
import oracle.dbtools.raptor.backgroundTask.RaptorTaskManager;
import oracle.dbtools.raptor.backgroundTask.TaskException;
import oracle.dbtools.raptor.metrics.MetricsResources;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public abstract class BackgroundTask {
    private volatile boolean cancelled;
    private boolean success;
    private String message;
    private Runnable completionAction;

    public void enqueue() {
        RaptorTask<Void> raptorTask = new RaptorTask<Void>(MetricsResources.getString("METRICS_PERFORM_TASK"), true, IRaptorTaskRunMode.MODAL){

            protected Void doWork() throws TaskException {
                try {
                    BackgroundTask.this.cancelled = false;
                    BackgroundTask.this.doTask(new Context(){

                        @Override
                        public boolean isCancelled() {
                            return BackgroundTask.this.isTaskCancelled();
                        }

                        @Override
                        public void setStatus(boolean bl, String string) {
                            BackgroundTask.this.setTaskStatus(bl, string, null);
                        }

                        @Override
                        public void setStatus(boolean bl, String string, Runnable runnable) {
                            BackgroundTask.this.setTaskStatus(bl, string, runnable);
                        }
                    });
                }
                catch (RuntimeException runtimeException) {
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "background task threw exception", runtimeException);
                    BackgroundTask.this.setTaskStatus(false, MetricsResources.format("METRICS_TASK_FAILURE", runtimeException.getLocalizedMessage()), null);
                    throw new TaskException((Throwable)runtimeException);
                }
                return null;
            }

            public boolean cancel() {
                BackgroundTask.this.cancelled = BackgroundTask.this.cancelTask();
                return BackgroundTask.this.cancelled;
            }
        };
        raptorTask.setCancellable(true);
        raptorTask.getDescriptor().addListener((IRaptorTaskListener)new RaptorTaskAdapter(){

            public void taskFailed(RaptorTaskEvent raptorTaskEvent) {
                BackgroundTask.this.showMessage();
            }

            public void taskFinished(RaptorTaskEvent raptorTaskEvent) {
                BackgroundTask.this.showMessage();
            }
        });
        RaptorTaskManager.getInstance().addTask((RaptorTask)raptorTask);
    }

    protected abstract void doTask(Context var1);

    protected boolean cancelTask() {
        return true;
    }

    private boolean isTaskCancelled() {
        return this.cancelled;
    }

    private void setTaskStatus(boolean bl, String string, Runnable runnable) {
        this.success = bl;
        this.message = string;
        this.completionAction = runnable;
    }

    private void showMessage() {
        SwingUtilities.invokeLater(() -> {
            if (this.success) {
                MessageDialog.information((Component)Ide.getMainWindow(), (Object)this.message, (String)MetricsResources.getString("METRICS_TASK_SUCCESS_TITLE"), null);
            } else {
                MessageDialog.error((Component)Ide.getMainWindow(), (Object)this.message, (String)MetricsResources.getString("METRICS_TASK_ERROR_TITLE"), null);
            }
            if (this.completionAction != null) {
                this.completionAction.run();
            }
        });
    }

    public static interface Context {
        public boolean isCancelled();

        public void setStatus(boolean var1, String var2);

        public void setStatus(boolean var1, String var2, Runnable var3);
    }
}

