/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.tooltip;

import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import net.miginfocom.swing.MigLayout;
import oracle.ide.insight.InsightActionListener;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.tooltip.ToolTipContext;
import oracle.ide.insight.tooltip.ToolTipProvider;
import oracle.javatools.ui.popup.PopupWindow;
import oracle.javatools.ui.popup.PopupWindowListener;
import oracle.javatools.ui.popup.PopupWindowManager;

public final class ToolTipPopup<T> {
    private InsightController.State state = InsightController.State.HIDDEN;
    protected static final int[] POPUP_LOCATIONS = new int[]{4};
    public static final String PROPERTY_VISIBLE = "visible";
    private final List<PropertyChangeListener> propertyChangeListeners = new CopyOnWriteArrayList<PropertyChangeListener>();
    private ToolTipContext toolTipInsightContext;
    private InsightActionL insightActionL = new InsightActionL();
    private PopupWindowL popupWindowL = new PopupWindowL();
    private PopupWindow popup;

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    private void firePropertyChangeEvent(PropertyChangeEvent event) {
        for (PropertyChangeListener l : this.propertyChangeListeners) {
            l.propertyChange(event);
        }
    }

    private void setState(InsightController.State newState) {
        InsightController.State oldState = this.state;
        this.state = newState;
        this.firePropertyChangeEvent(new PropertyChangeEvent(this, PROPERTY_VISIBLE, (Object)oldState, (Object)newState));
    }

    public InsightController.State getState() {
        return this.state;
    }

    public void showPopup(ToolTipContext toolTipInsightContext, Map<ToolTipProvider<T>, List<T>> results) throws Exception {
        try {
            this.toolTipInsightContext = toolTipInsightContext;
            toolTipInsightContext.getAdapter().addInsightActionListener(this.insightActionL);
            JComponent displayComponent = this.createPopupContent(results);
            this.popup = PopupWindowManager.showPopup(toolTipInsightContext.getAdapter().getTextComponent(), (JComponent)displayComponent, (boolean)false, (Rectangle)this.getPopupLocation(), (int[])POPUP_LOCATIONS, (boolean)false);
            this.popup.addPopupWindowListener((PopupWindowListener)this.popupWindowL);
            this.setState(InsightController.State.SHOWING);
        }
        catch (Exception e) {
            this.popupClosed();
            throw e;
        }
    }

    public void updatePopup(ToolTipContext toolTipInsightContext, Map<ToolTipProvider<T>, List<T>> results) throws Exception {
        assert (this.getState() == InsightController.State.SHOWING);
        try {
            this.toolTipInsightContext = toolTipInsightContext;
            JComponent displayComponent = this.createPopupContent(results);
            this.popup.getWindow().getContentPane().removeAll();
            this.popup.getWindow().getContentPane().add(displayComponent);
            this.popup.getWindow().pack();
        }
        catch (Exception e) {
            this.popupClosed();
            throw e;
        }
    }

    private JComponent createPopupContent(Map<ToolTipProvider<T>, List<T>> results) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 1, wrap 1, gapy 0"));
        panel.setBackground(UIManager.getColor("ToolTip.background"));
        panel.setBorder(UIManager.getBorder("ToolTip.border"));
        for (ToolTipProvider<T> provider : results.keySet()) {
            for (T item : results.get(provider)) {
                panel.add(provider.getComponent(item));
            }
        }
        panel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                PopupWindowManager.dismissPopup((PopupWindow)ToolTipPopup.this.popup);
            }
        });
        return panel;
    }

    private Rectangle getPopupLocation() throws BadLocationException {
        Rectangle r = null;
        for (ToolTipProvider provider : this.toolTipInsightContext.getProviders()) {
            Rectangle pr = provider.getDisplayRectangle(this.toolTipInsightContext);
            if (pr == null) continue;
            if (r == null) {
                r = pr;
                continue;
            }
            r.add(pr);
        }
        if (r == null) {
            JTextComponent textComp = this.toolTipInsightContext.getTextComponent();
            r = textComp.modelToView(textComp.getCaretPosition());
        }
        return r;
    }

    private void popupClosed() {
        this.toolTipInsightContext.getAdapter().removeInsightActionListener(this.insightActionL);
        this.setState(InsightController.State.HIDDEN);
        if (this.popup != null) {
            this.popup.removePopupWindowListener((PopupWindowListener)this.popupWindowL);
            this.popup = null;
        }
        this.toolTipInsightContext = null;
    }

    public void closePopup() {
        if (this.state != InsightController.State.SHOWING) {
            return;
        }
        assert (this.popup != null);
        PopupWindowManager.dismissPopup((PopupWindow)this.popup);
    }

    protected class InsightActionL
    implements InsightActionListener {
        protected InsightActionL() {
        }

        public boolean insightActionPerformed(InsightActionListener.Action action, JTextComponent textComponent) {
            if (action == InsightActionListener.Action.CANCEL) {
                ToolTipPopup.this.closePopup();
                return true;
            }
            return false;
        }
    }

    private class PopupWindowL
    implements PopupWindowListener {
        private PopupWindowL() {
        }

        public void popupClosed(PopupWindow popupWindow, int how) {
            ToolTipPopup.this.popupClosed();
        }

        public void parentFocusGained(PopupWindow popupWindow) {
        }

        public void parentFocusLost(PopupWindow popupWindow, boolean isTemporary) {
            ToolTipPopup.this.closePopup();
        }
    }
}

