/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.tooltip;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import oracle.ide.Context;
import oracle.ide.config.Preferences;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.insight.tooltip.ToolTipContext;
import oracle.ide.insight.tooltip.ToolTipInsight;
import oracle.ide.insight.tooltip.ToolTipProvider;
import oracle.ide.insight.tooltip.ToolTipSupport;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.data.StructureChangeEvent;
import oracle.javatools.data.StructureChangeListener;
import oracle.javatools.editor.ActionHookInvoker;
import oracle.javatools.editor.BasicEditorPane;
import oracle.javatools.editor.CharacterTypedListener;
import oracle.javatools.editor.plugins.EditorPlugin;

public final class ToolTipPlugin
implements EditorPlugin {
    private BasicEditorPane editor;
    private final Context context;
    private ToolTipInsight toolTipInsight;
    private Timer popupTimer;
    private final InsightTrigger insightTrigger;
    private final List<ToolTipProvider> providers;
    private final OptionsListener optionsListener = new OptionsListener();
    private final InsightListener insightListener = new InsightListener();
    private ToolTipSupport support;

    public ToolTipPlugin(Context context, List<ToolTipProvider> providers) {
        this.context = context;
        this.providers = providers;
        this.toolTipInsight = ToolTipInsight.getInstance();
        this.insightTrigger = new InsightTrigger();
    }

    public void install(BasicEditorPane editor) {
        if (this.providers.isEmpty()) {
            return;
        }
        this.editor = editor;
        editor.addCharacterTypedListener((CharacterTypedListener)this.insightTrigger);
        editor.addActionHookInvoker((ActionHookInvoker)this.insightTrigger);
        editor.addCaretListener((CaretListener)this.insightTrigger);
        this.popupTimer = new Timer(ToolTipPlugin.getOptions().getParameterPopupDelay(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ToolTipPlugin.this.triggerInsight();
            }
        });
        this.popupTimer.setRepeats(false);
        ToolTipPlugin.getOptions().addStructureChangeListener(this.optionsListener);
        this.toolTipInsight.addPropertyChangeListener(this.insightListener);
        this.support = new ToolTipSupport(this.context, editor);
    }

    public void deinstall(BasicEditorPane editor) {
        if (this.providers.isEmpty()) {
            return;
        }
        this.support.dispose();
        this.popupTimer.stop();
        editor.removeCharacterTypedListener((CharacterTypedListener)this.insightTrigger);
        editor.removeActionHookInvoker((ActionHookInvoker)this.insightTrigger);
        editor.removeCaretListener((CaretListener)this.insightTrigger);
        ToolTipPlugin.getOptions().removeStructureChangeListener(this.optionsListener);
        this.toolTipInsight.removePropertyChangeListener(this.insightListener);
    }

    public void propertyChange(PropertyChangeEvent evt) {
    }

    private void triggerInsight() {
        this.toolTipInsight.show(new ToolTipContext(this.support, this.providers, false));
    }

    private static InsightOptions getOptions() {
        return InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
    }

    private class OptionsListener
    extends StructureChangeListener {
        private OptionsListener() {
        }

        public void structureValuesChanged(StructureChangeEvent e) {
            ToolTipPlugin.this.popupTimer.setDelay(ToolTipPlugin.getOptions().getCompletionPopupDelay());
        }
    }

    private class InsightListener
    implements PropertyChangeListener {
        private InsightListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            assert (SwingUtilities.isEventDispatchThread());
            ToolTipPlugin.this.popupTimer.stop();
        }
    }

    private class InsightTrigger
    implements CharacterTypedListener,
    ActionHookInvoker,
    CaretListener {
        private InsightTrigger() {
        }

        public void characterTyped(BasicEditorPane editorPane, int offset, char typedChar) {
            InsightOptions options = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
            if (!options.isParamaterPopupEnabled()) {
                return;
            }
            if (ToolTipPlugin.this.toolTipInsight.getState() == InsightController.State.HIDDEN) {
                if (this.isTriggerCharacter(Character.valueOf(typedChar))) {
                    ToolTipPlugin.this.popupTimer.restart();
                } else {
                    ToolTipPlugin.this.popupTimer.stop();
                }
            }
        }

        private boolean isTriggerCharacter(Character c) {
            for (ToolTipProvider provider : ToolTipPlugin.this.providers) {
                if (!provider.getTriggerCharacters().contains(c)) continue;
                return true;
            }
            return false;
        }

        public boolean invokeAction(String actionKey) {
            if (actionKey.equals("tooltip-insight")) {
                if (ToolTipPlugin.this.toolTipInsight.getState() == InsightController.State.HIDDEN) {
                    ToolTipPlugin.this.triggerInsight();
                }
                return true;
            }
            return false;
        }

        @Override
        public void caretUpdate(CaretEvent e) {
            if (ToolTipPlugin.this.toolTipInsight.getState() == InsightController.State.SHOWING) {
                ToolTipPlugin.this.toolTipInsight.triggerUpdate();
            }
        }
    }
}

