/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.options;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import oracle.ide.controls.ItemSelectableTracker;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.insight.options.InsightOptionsBundle;
import oracle.ide.panels.ApplyEvent;
import oracle.ide.panels.ApplyListener;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.editor.EditorProperties;
import oracle.javatools.ui.Colors;

public final class CompletionOptionsPanel
extends DefaultTraversablePanel
implements ApplyListener {
    private JCheckBox checkbox_invokeMatching;
    private JCheckBox checkbox_partialMatching;
    private JCheckBox checkbox_typedMatching;
    private JCheckBox checkbox_filterCompletion;
    private JCheckBox checkbox_filterByContains;

    public CompletionOptionsPanel() {
        this.setHelpID("f1_idedidesetcompletion_html");
        this.setLayout(new GridBagLayout());
        this.initializeComponent();
    }

    public void onEntry(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.loadSettingsFrom(options);
    }

    public void onExit(TraversableContext tc) {
        InsightOptions options = this.findOptions(tc);
        this.saveSettingsTo(options);
    }

    private InsightOptions findOptions(TraversableContext tc) {
        InsightOptions options = InsightOptions.getInstance(tc.getPropertyStorage());
        return options;
    }

    public void apply(ApplyEvent event) {
        TraversableContext tc = (TraversableContext)event.getSource();
        InsightOptions options = this.findOptions(tc);
        CompletionOptionsPanel.applyOptions(options);
    }

    public void cancel(ApplyEvent e) {
    }

    public static void applyOptions(InsightOptions options) {
        EditorProperties properties = EditorProperties.getProperties();
        boolean invokeMatching = options.isCompleteSingleInitial();
        boolean partialMatching = options.isCompleteSinglePartial();
        boolean typedMatching = options.isCompleteSingleTyping();
        boolean filterCompletion = options.isCompleteFiltered();
        properties.putBooleanProperty("insight-manual-complete-single", invokeMatching);
        properties.putBooleanProperty("insight-partial-complete-single", partialMatching);
        properties.putBooleanProperty("insight-typed-complete-single", typedMatching);
        properties.putBooleanProperty("insight-filter-matching", filterCompletion);
        boolean newDataMatching = options.isCompleteSingleNewData();
        properties.putBooleanProperty("insight-newdata-complete-single", newDataMatching && invokeMatching);
    }

    void loadSettingsFrom(InsightOptions options) {
        boolean invokeMatching = options.isCompleteSingleInitial();
        boolean partialMatching = options.isCompleteSinglePartial();
        boolean typedMatching = options.isCompleteSingleTyping();
        boolean filterCompletion = options.isCompleteFiltered();
        boolean filterByContains = options.isFilterByContains();
        this.checkbox_invokeMatching.setSelected(invokeMatching);
        this.checkbox_partialMatching.setSelected(partialMatching);
        this.checkbox_typedMatching.setSelected(typedMatching);
        this.checkbox_filterCompletion.setSelected(filterCompletion);
        this.checkbox_filterByContains.setSelected(filterByContains);
    }

    void saveSettingsTo(InsightOptions options) {
        boolean invokeMatching = this.checkbox_invokeMatching.isSelected();
        boolean partialMatching = this.checkbox_partialMatching.isSelected();
        boolean typedMatching = this.checkbox_typedMatching.isSelected();
        boolean filterCompletion = this.checkbox_filterCompletion.isSelected();
        boolean filterByContains = this.checkbox_filterByContains.isSelected();
        options.setCompleteSingleInitial(invokeMatching);
        options.setCompleteSinglePartial(partialMatching);
        options.setCompleteSingleTyping(typedMatching);
        options.setCompleteFiltered(filterCompletion);
        options.setFilterByContains(filterByContains);
    }

    private void initializeComponent() {
        String singleMatchingText = InsightOptionsBundle.get("LABEL_COMPLETE_SINGLE_MATCHING");
        String invokeMatchingText = InsightOptionsBundle.get("LABEL_COMPLETE_INVOKE");
        String partialMatchingText = InsightOptionsBundle.get("LABEL_COMPLETE_PARTIAL");
        String typedMatchingText = InsightOptionsBundle.get("LABEL_COMPLETE_TYPED");
        JLabel label_completeSingleMatching = new JLabel(singleMatchingText);
        this.checkbox_invokeMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_invokeMatching, (String)invokeMatchingText);
        this.checkbox_partialMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_partialMatching, (String)partialMatchingText);
        this.checkbox_typedMatching = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_typedMatching, (String)typedMatchingText);
        String filterCompletionText = InsightOptionsBundle.get("LABEL_FILTER_COMPLETION");
        String filterExplainText = InsightOptionsBundle.get("LABEL_FILTER_EXPLAIN");
        JLabel label_filterExplain = new JLabel(filterExplainText);
        label_filterExplain.setForeground(Colors.HINT_TEXT);
        this.checkbox_filterCompletion = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_filterCompletion, (String)filterCompletionText);
        String filterByContainsText = InsightOptionsBundle.get("LABEL_INSIGHT_FILTER_BY_CONTAINS");
        this.checkbox_filterByContains = new JCheckBox();
        ResourceUtils.resButton((AbstractButton)this.checkbox_filterByContains, (String)filterByContainsText);
        Component[] dependents = new Component[]{this.checkbox_filterByContains};
        new ItemSelectableTracker((ItemSelectable)this.checkbox_filterCompletion, dependents);
        this.setLayout((LayoutManager)new MigLayout("ins 0, gapy 2"));
        this.add(label_completeSingleMatching, "");
        this.add(this.checkbox_invokeMatching, "newline, gapleft 16");
        this.add(this.checkbox_partialMatching, "newline, gapleft 16");
        this.add(this.checkbox_typedMatching, "newline, gapleft 16");
        this.add(this.checkbox_filterCompletion, "newline, gaptop 8");
        this.add(label_filterExplain, "newline, gapleft 16");
        this.add(this.checkbox_filterByContains, "newline, gapleft 16");
    }
}

