/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.filter;

import java.util.ArrayList;
import java.util.List;
import oracle.ide.insight.InsightItem;
import oracle.ide.insight.filter.FilterUtils;
import oracle.ide.insight.filter.InsightFilter;

public final class DefaultInsightFilter<T extends InsightItem>
implements InsightFilter<T> {
    @Override
    public final T findClosestDataItem(List<T> items, String name) {
        return FilterUtils.findClosestDataItem(items, name);
    }

    @Override
    public final List<T> getMatchingDataItems(List<T> items, String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        ArrayList<InsightItem> matchingItems = new ArrayList<InsightItem>();
        for (InsightItem item : items) {
            if (!item.isFilterable()) {
                matchingItems.add(item);
                continue;
            }
            String itemName = item.getName();
            if (!DefaultInsightFilter.startsWithIgnoreCase(itemName, prefix)) continue;
            matchingItems.add(item);
        }
        return matchingItems;
    }

    @Override
    public String findCommonPrefix(List<T> items, String name) {
        return FilterUtils.findCommonPrefix(items, name);
    }

    public static boolean startsWithIgnoreCase(String name1, String name2) {
        return FilterUtils.startsWithIgnoreCase(name1, name2);
    }
}

