/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight.completion;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.IdeAction;
import oracle.ide.insight.DefaultAdapter;
import oracle.ide.insight.InsightController;
import oracle.ide.insight.InsightHook;
import oracle.ide.insight.completion.CompletionContext;
import oracle.ide.insight.completion.CompletionMultiProvider;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.completion.CompletionSupport;
import oracle.ide.keyboard.KeyStrokeContext;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyStrokeMap;
import oracle.ide.keyboard.KeyStrokeOptions;
import oracle.ide.keyboard.KeyStrokes;

public final class DefaultCompletionSupport
extends CompletionSupport<JTextComponent> {
    private final Context context;
    private final CompletionProvider insightProvider;
    private final String insightProviderID;
    private final JTextComponent textComponent;
    private final Map<String, Object> userData = new HashMap<String, Object>();
    private final KeyL keyL = new KeyL();
    private boolean popupEscaped = false;
    private final FocusL focusL = new FocusL();

    public DefaultCompletionSupport(Context context, JTextComponent textComponent, String insightProviderID) {
        super(new DefaultAdapter());
        this.context = context;
        this.insightProviderID = insightProviderID;
        this.textComponent = textComponent;
        this.insightProvider = null;
        this.multiProvider = this.createMultiProvider(insightProviderID, null);
        this.install();
    }

    public DefaultCompletionSupport(Context context, JTextComponent textComponent, CompletionProvider insightProvider) {
        super(new DefaultAdapter());
        this.context = context;
        this.insightProvider = insightProvider;
        this.textComponent = textComponent;
        this.insightProviderID = null;
        this.multiProvider = this.createMultiProvider(null, insightProvider);
        this.install();
    }

    @Override
    protected void install() {
        super.install();
        KeyStrokeOptions kso = Ide.getSettings().getKeyStrokeOptions();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        KeyStrokeContext ksc = kscr.getContext("oracle/ide/ceditor/keymap/accelerators.xml");
        if (ksc != null) {
            IdeAction action;
            KeyStrokeMap ksm = kso.getLocalKeyMap(ksc);
            List keystrokesList = ksm.getKeyStrokesFor((action = IdeAction.find((String)"completion-insight")).getCommandId());
            if (keystrokesList != null) {
                for (KeyStrokes keyStrokes : keystrokesList) {
                    if (keyStrokes.getLength() != 1) continue;
                    KeyStroke keyStroke = keyStrokes.getKeyStroke(0);
                    this.textComponent.getInputMap(0).put(keyStroke, "completion-insight");
                }
                this.textComponent.getActionMap().put("completion-insight", new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (DefaultCompletionSupport.this.isShowOnShortcut()) {
                            DefaultCompletionSupport.this.triggerInsight(CompletionContext.Invoked.MANUAL);
                        }
                    }
                });
            }
            this.textComponent.addKeyListener(this.keyL);
            this.textComponent.addFocusListener(this.focusL);
        }
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    @Override
    public JTextComponent getTextComponent() {
        return this.textComponent;
    }

    public void putObject(String key, Object value) {
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    public Object getObject(String key) {
        return this.userData.get(key);
    }

    private CompletionMultiProvider createMultiProvider(String insightProviderID, CompletionProvider insightProvider) {
        List<CompletionProvider> providers = Collections.emptyList();
        if (insightProvider != null) {
            providers = new ArrayList();
            providers.add(insightProvider);
        } else if (insightProviderID != null) {
            providers = InsightHook.get().insightProviders(insightProviderID);
        }
        return new CompletionMultiProvider(this.controller, providers);
    }

    @Override
    public void deinstall() {
        Object textComponent = this.getAdapter().getTextComponent();
        ((JComponent)textComponent).getActionMap().remove("completion-insight");
        ((Component)textComponent).removeKeyListener(this.keyL);
        ((Component)textComponent).removeFocusListener(this.focusL);
        super.deinstall();
    }

    @Override
    protected boolean isAutoPopup() {
        return super.isAutoPopup() && !this.popupEscaped;
    }

    private class KeyL
    extends KeyAdapter {
        private KeyL() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            DefaultCompletionSupport.this.cancelTimer();
        }

        @Override
        public void keyTyped(KeyEvent event) {
            char typedChar = event.getKeyChar();
            if (event.isActionKey()) {
                return;
            }
            if (event.isControlDown()) {
                return;
            }
            if (event.getKeyChar() == '\u001b') {
                DefaultCompletionSupport.this.popupEscaped = true;
                return;
            }
            if (event.getKeyChar() == ' ' && event.isControlDown()) {
                DefaultCompletionSupport.this.popupEscaped = false;
            }
            if (!DefaultCompletionSupport.this.isAutoPopup()) {
                return;
            }
            if (DefaultCompletionSupport.this.controller.getState() == InsightController.State.HIDDEN) {
                DefaultCompletionSupport.this.timerTrigger(Character.valueOf(typedChar));
            }
        }
    }

    private class FocusL
    extends FocusAdapter {
        private FocusL() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            DefaultCompletionSupport.this.popupEscaped = false;
        }
    }
}

