/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import javax.ide.util.MetaClass;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ide.extension.LazyClassAdapter;
import oracle.ide.insight.completion.CompletionProvider;
import oracle.ide.insight.tooltip.ToolTipProvider;
import oracle.ide.model.Node;
import oracle.ide.util.ClassUtils;
import oracle.javatools.data.HashStructure;

public final class InsightHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "insight");
    private List<InsightProviderReference> providerReferences = new ArrayList<InsightProviderReference>();
    private List<ToolTipInsightProviderReference> toolTipProviderReferences = new ArrayList<ToolTipInsightProviderReference>();
    private Listener listener;

    public static InsightHook get() {
        return (InsightHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    public List<CompletionProvider> insightProviders(String insightProviderID) {
        assert (insightProviderID != null);
        ArrayList<CompletionProvider> providers = new ArrayList<CompletionProvider>();
        for (InsightProviderReference ref : this.providers()) {
            if (!insightProviderID.equals(ref.id)) continue;
            providers.add(ref.getInsightProvider());
        }
        return providers;
    }

    public List<CompletionProvider> insightProviders(Class<? extends Node> nodeType) {
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<CompletionProvider> providers = new ArrayList<CompletionProvider>();
        block0: for (InsightProviderReference ref : this.providers()) {
            for (String refNodeType : ref.nodeTypeList) {
                if (!ClassUtils.isInstanceOf(nodeType, (String)refNodeType)) continue;
                providers.add(ref.getInsightProvider());
                continue block0;
            }
        }
        return providers;
    }

    private Collection<InsightProviderReference> providers() {
        if (this.listener == null) {
            this.listener = new Listener();
            InsightHook.get().addHashStructureHookListener(this.listener);
        }
        Collections.sort(this.providerReferences);
        return this.providerReferences;
    }

    public List<ToolTipProvider> toolTipInsightProviders(Node nodeType) {
        if (nodeType == null) {
            return Collections.emptyList();
        }
        ArrayList<ToolTipProvider> providers = new ArrayList<ToolTipProvider>();
        block0: for (ToolTipInsightProviderReference ref : this.toolTipProviders()) {
            for (String refNodeType : ref.nodeTypeList) {
                if (!ClassUtils.isInstanceOf(nodeType.getClass(), (String)refNodeType)) continue;
                providers.add(ref.getToolTipInsightProvider());
                continue block0;
            }
        }
        return providers;
    }

    private Collection<ToolTipInsightProviderReference> toolTipProviders() {
        if (this.listener == null) {
            this.listener = new Listener();
            InsightHook.get().addHashStructureHookListener(this.listener);
        }
        return this.toolTipProviderReferences;
    }

    private static final class InsightProviderReference
    implements Comparable {
        private final MetaClass<CompletionProvider> insightProviderClass;
        private final int priority;
        private final String id;
        private final List<String> nodeTypeList;

        public InsightProviderReference(MetaClass<CompletionProvider> insightProviderClass, int priority, String id, List<String> nodeTypeList) {
            this.nodeTypeList = nodeTypeList;
            this.priority = priority;
            this.insightProviderClass = insightProviderClass;
            this.id = id;
        }

        public synchronized CompletionProvider getInsightProvider() {
            CompletionProvider insightProvider = null;
            try {
                insightProvider = (CompletionProvider)this.insightProviderClass.newInstance();
            }
            catch (Exception e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create insight InsightProvider provider from class " + this.insightProviderClass.getClassName(), e);
            }
            return insightProvider;
        }

        public int compareTo(Object o) {
            if (o instanceof InsightProviderReference) {
                InsightProviderReference that = (InsightProviderReference)o;
                return Integer.valueOf(this.priority).compareTo(that.priority);
            }
            return 0;
        }
    }

    private class Listener
    implements HashStructureHookListener {
        private Listener() {
        }

        public void listenerAttached(HashStructureHookEvent e) {
            HashStructure hs = e.getCombinedHashStructure();
            if (hs == null) {
                return;
            }
            this.addProviders(hs);
            this.addToolTipProviders(hs);
        }

        public void elementVisited(HashStructureHookEvent e) {
            HashStructure hs = e.getNewElementHashStructure();
            if (hs == null) {
                return;
            }
            this.addProviders(hs);
            this.addToolTipProviders(hs);
        }

        private void addToolTipProviders(HashStructure hash) {
            List providers = hash.getAsList("tooltip-provider");
            if (providers == null) {
                return;
            }
            for (Object o : providers) {
                MetaClass clazz = null;
                try {
                    HashStructure hsProvider = (HashStructure)o;
                    clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                    ArrayList<String> nodeTypeList = new ArrayList<String>();
                    List nodeTypeObjectList = hsProvider.getAsList("node-type");
                    if (nodeTypeObjectList != null) {
                        for (Object nodeElement : nodeTypeObjectList) {
                            String nodeType = ((HashStructure)nodeElement).getString("#text");
                            nodeTypeList.add(nodeType);
                        }
                    }
                    InsightHook.this.toolTipProviderReferences.add(new ToolTipInsightProviderReference((MetaClass<ToolTipProvider>)clazz, nodeTypeList));
                }
                catch (Exception e) {
                    Logger.getLogger("IDE").log(Level.SEVERE, "InsightHook: Cannot create ToolTipInsightProvider " + (clazz == null ? "" : clazz.getClassName()));
                }
            }
        }

        private void addProviders(HashStructure hash) {
            List providers = hash.getAsList("completion-provider");
            if (providers == null) {
                return;
            }
            for (Object o : providers) {
                MetaClass clazz = null;
                try {
                    HashStructure hsProvider = (HashStructure)o;
                    int priority = hsProvider.getInt("priority", 100);
                    String id = hsProvider.getString("id");
                    clazz = LazyClassAdapter.getInstance((HashStructure)hsProvider).getMetaClass("class");
                    ArrayList<String> nodeTypeList = new ArrayList<String>();
                    List nodeTypeObjectList = hsProvider.getAsList("node-type");
                    if (nodeTypeObjectList != null) {
                        for (Object nodeElement : nodeTypeObjectList) {
                            String nodeType = ((HashStructure)nodeElement).getString("#text");
                            nodeTypeList.add(nodeType);
                        }
                    }
                    InsightHook.this.providerReferences.add(new InsightProviderReference((MetaClass<CompletionProvider>)clazz, priority, id, nodeTypeList));
                }
                catch (Exception e) {
                    Logger.getLogger("IDE").log(Level.SEVERE, "InsightHook: Cannot create InsightProvider " + (clazz == null ? "" : clazz.getClassName()));
                }
            }
        }
    }

    private static final class ToolTipInsightProviderReference {
        private final MetaClass<ToolTipProvider> toolTipInsightProviderClass;
        private final List<String> nodeTypeList;

        public ToolTipInsightProviderReference(MetaClass<ToolTipProvider> toolTipInsightProviderClass, List<String> nodeTypeList) {
            this.nodeTypeList = nodeTypeList;
            this.toolTipInsightProviderClass = toolTipInsightProviderClass;
        }

        public synchronized ToolTipProvider getToolTipInsightProvider() {
            ToolTipProvider toolTipInsightProvider = null;
            try {
                toolTipInsightProvider = (ToolTipProvider)this.toolTipInsightProviderClass.newInstance();
            }
            catch (Exception e) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create insight ToolTipInsightProvider provider from class " + this.toolTipInsightProviderClass.getClassName(), e);
            }
            return toolTipInsightProvider;
        }
    }
}

