/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.insight;

import oracle.ide.Addin;
import oracle.ide.Context;
import oracle.ide.ceditor.CodeEditor;
import oracle.ide.ceditor.CodeEditorUtils;
import oracle.ide.config.Preferences;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.insight.options.CompletionOptionsPanel;
import oracle.ide.insight.options.InsightOptions;
import oracle.ide.insight.options.InsightOptionsPanel;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.editor.BasicEditorPane;

public final class InsightAddin
implements Addin,
Controller {
    public static int TOOLTIP_INSIGHT_CMD_ID = IdeAction.find((String)"tooltip-insight").getCommandId();
    private static int COMPLETION_INSIGHT_CMD_ID = IdeAction.find((String)"completion-insight").getCommandId();
    private static int SMART_COMPLETION_INSIGHT_CMD_ID = IdeAction.find((String)"smart-completion-insight").getCommandId();

    public void initialize() {
        InsightOptions insightOptions = InsightOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        InsightOptionsPanel.applyOptions(insightOptions);
        CompletionOptionsPanel.applyOptions(insightOptions);
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        return cmdId == COMPLETION_INSIGHT_CMD_ID || cmdId == SMART_COMPLETION_INSIGHT_CMD_ID || cmdId == TOOLTIP_INSIGHT_CMD_ID;
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        CodeEditor codeEditor = CodeEditorUtils.getCodeEditorFromContext((Context)context);
        if (codeEditor == null && (cmdId == COMPLETION_INSIGHT_CMD_ID || cmdId == SMART_COMPLETION_INSIGHT_CMD_ID || cmdId == TOOLTIP_INSIGHT_CMD_ID)) {
            return true;
        }
        BasicEditorPane editorComponent = CodeEditorUtils.getEditorPaneFromContext((Context)context);
        if (cmdId == COMPLETION_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("completion-insight");
            return true;
        }
        if (cmdId == SMART_COMPLETION_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("smart-completion-insight");
            return true;
        }
        if (cmdId == TOOLTIP_INSIGHT_CMD_ID) {
            editorComponent.requestFocus();
            editorComponent.invokeAction("tooltip-insight");
            return true;
        }
        return false;
    }
}

