/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;

public class OpenSSH_PKCS8KeyPairGenerator {
    private static String publicKey = null;
    private static String privateKey = null;
    private static String privateKeyPath = null;

    public OpenSSH_PKCS8KeyPairGenerator() throws NoSuchAlgorithmException, IOException {
        KeyPair pair = KeyPairGenerator.getInstance("RSA").generateKeyPair();
        PrivateKey privKey = pair.getPrivate();
        PublicKey pubKey = pair.getPublic();
        this.genOpenSSHPublicKey(pubKey);
        this.writePrivateKeytoFile(privKey);
    }

    private void genOpenSSHPublicKey(PublicKey pubKey) throws IOException {
        RSAPublicKey rsaPublicKey = (RSAPublicKey)pubKey;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        dos.writeInt("ssh-rsa".getBytes().length);
        dos.write("ssh-rsa".getBytes());
        dos.writeInt(rsaPublicKey.getPublicExponent().toByteArray().length);
        dos.write(rsaPublicKey.getPublicExponent().toByteArray());
        dos.writeInt(rsaPublicKey.getModulus().toByteArray().length);
        dos.write(rsaPublicKey.getModulus().toByteArray());
        byte[] pubKeyBytes = bos.toByteArray();
        publicKey = "ssh-rsa " + Base64.getEncoder().encodeToString(pubKeyBytes);
    }

    private String foldPrivateKey(String privKey) {
        int privateKeyLen = privKey.length();
        int numCharsLastLine = privateKeyLen % 64;
        StringBuilder sb = new StringBuilder("-----BEGIN PRIVATE KEY-----\n");
        for (int i = 0; i < privateKeyLen - numCharsLastLine; i += 64) {
            sb.append(privKey.substring(i, i + 64) + "\n");
        }
        sb.append(privKey.substring(privateKeyLen - numCharsLastLine));
        sb.append("\n-----END PRIVATE KEY-----");
        return sb.toString();
    }

    private void writePrivateKeytoFile(PrivateKey privKey) throws IOException {
        privateKeyPath = Paths.get(".", new String[0]).toAbsolutePath().normalize().toString() + "/privatesqlcl.key";
        Base64.Encoder encoder = Base64.getEncoder();
        privateKey = this.foldPrivateKey(Base64.getEncoder().encodeToString(privKey.getEncoded()));
        try (FileWriter writer = new FileWriter(privateKeyPath);){
            writer.write(privateKey);
            writer.close();
        }
    }

    public String getPublicKey() {
        return publicKey;
    }

    public String getPrivateKey() {
        return privateKey;
    }

    public String getPrivateKeyPath() {
        return privateKeyPath;
    }
}

