/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsObject;
import com.fasterxml.jackson.jr.stree.JrsString;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.util.AutoBastionUtil;
import org.apache.hc.core5.http.ParseException;

public class BastionHost {
    private static String compartmentId = null;
    private static String subnetId = null;
    private static OCIRESTClient client = null;
    private static String region = null;
    private static boolean isExistingBastion = false;
    private static String existingBastionId = null;

    public BastionHost(String connOCID, OCIRESTClient client, String region) throws IOException, GeneralSecurityException, ParseException {
        AutoBastionUtil autoBastionUtil = new AutoBastionUtil(connOCID, client, region);
        compartmentId = autoBastionUtil.getCompartmentId();
        subnetId = autoBastionUtil.getSubnetOCID();
        BastionHost.client = client;
        BastionHost.region = region;
    }

    private String createBastionReqBody() throws IOException {
        JsonFactory f = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator g = f.createGenerator((Writer)writer);
        g.writeStartObject();
        g.writeStringField("bastionType", "STANDARD");
        g.writeArrayFieldStart("clientCidrBlockAllowList");
        g.writeString("0.0.0.0/0");
        g.writeEndArray();
        g.writeStringField("compartmentId", compartmentId);
        g.writeStringField("name", "BastionSqlcl");
        g.writeStringField("targetSubnetId", subnetId);
        g.writeEndObject();
        g.close();
        return ((Object)writer).toString();
    }

    private String bastionReq(String body, String method, String target) throws GeneralSecurityException, IOException, ParseException {
        String bastionHost = "bastion." + region + ".oci.oraclecloud.com";
        OCIRequest req = new OCIRequest.Builder().host(bastionHost).body(body).method(method).contentType("application/json").target("/20210331/bastions" + target).build();
        return client.getString(req);
    }

    private String createBastion() throws IOException, GeneralSecurityException, ParseException {
        String createBastionBody = this.createBastionReqBody();
        return this.bastionReq(createBastionBody, "post", "");
    }

    private String listBastions() throws IOException, GeneralSecurityException, ParseException {
        String target = "?compartmentId=" + compartmentId + "&bastionLifecycleState=ACTIVE";
        return this.bastionReq(null, "get", target);
    }

    private void checkExistingBastions() throws GeneralSecurityException, IOException, ParseException {
        String listBastionResponse = this.listBastions();
        JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
        JrsArray arr = (JrsArray)json.treeFrom((Object)listBastionResponse);
        if (arr.get(0) != null) {
            Iterator elements = arr.elements();
            while (elements.hasNext()) {
                JrsObject bastionDetails = (JrsObject)elements.next();
                String targetSubnetId = ((JrsString)bastionDetails.get("targetSubnetId")).getValue();
                if (!subnetId.equals(targetSubnetId)) continue;
                existingBastionId = ((JrsString)bastionDetails.get("id")).getValue();
                break;
            }
        }
    }

    private void handleErrors(String bastionReqResponse) throws IOException, SQLException {
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)bastionReqResponse);
        if (map.containsKey("code")) {
            throw new SQLException((String)map.get("code") + ": " + (String)map.get("message"));
        }
    }

    public String getBastionId() throws IOException, GeneralSecurityException, ParseException, SQLException {
        this.checkExistingBastions();
        if (existingBastionId != null) {
            return existingBastionId;
        }
        String bastionReqResponse = this.createBastion();
        this.handleErrors(bastionReqResponse);
        JSON j = JSON.builder().enable(new JSON.Feature[]{JSON.Feature.FAIL_ON_DUPLICATE_MAP_KEYS}).build();
        Map map = j.mapFrom((Object)bastionReqResponse);
        return (String)map.get("id");
    }
}

