/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.commands;

import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.stree.JacksonJrsTreeCodec;
import com.fasterxml.jackson.jr.stree.JrsArray;
import com.fasterxml.jackson.jr.stree.JrsValue;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.GeneralSecurityException;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import oracle.dbtools.commands.CSCommon;
import oracle.dbtools.commands.CommandMessages;
import oracle.dbtools.common.utils.FileUtils;
import oracle.dbtools.core.oci.OCIIdentityClient;
import oracle.dbtools.core.oci.OCIProfile;
import oracle.dbtools.core.oci.OCIProfiles;
import oracle.dbtools.http.CloudStorageUrl;
import oracle.dbtools.oci.OCIRESTClient;
import oracle.dbtools.oci.OCIRequest;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;

public class OCICommand
extends CommandListener
implements IHelp {
    private static final String OCI_CMD = "oci";
    private static final String OCI_CMDU = "OCI";
    private static final String OCI_PROFILE_NAME = "oci.profile.name";
    private static final String OCI_REGION_NAME = "oci.region.name";
    private static final String OCI_SQLCL_CONFIG_FILE = "OCI_SQLCL_CONFIG_FILE";
    private static final String DELETE = "delete";
    private static final String GET = "get";
    private static final String PUT = "put";
    private static final String CLEAR = "clear";
    private static final String NL = "\n";
    private static boolean r1 = false;

    public String getCommand() {
        return OCI_CMDU;
    }

    public String getHelp() {
        return CommandMessages.getString("OCI_CMD_HELP");
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        String[] parts = cmd.getSql().replace(NL, "").split("\\s+");
        if (parts.length == 2 && parts[1].equalsIgnoreCase(OCI_CMD)) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_SYNTAX"));
            ctx.write(CommandMessages.getString("OCI_CONN_HELP"));
            return true;
        }
        if (parts.length == 2 && parts[1].equalsIgnoreCase("-rest")) {
            ctx.write(CommandMessages.getString("OCI_INCORRECT_SYNTAX"));
            ctx.write(CommandMessages.getString("OCI_CONN_REST_HELP"));
            return true;
        }
        if (OCICommand.matches((String)OCI_CMD, (String)cmd.getSql())) {
            block40: {
                int cmdLength = parts.length;
                String subcommand = cmdLength >= 2 ? parts[1] : "";
                String subcmdArgument = cmdLength >= 3 ? parts[2] : "";
                OCIProfiles profiles = null;
                try {
                    OCIProfiles.Builder builder = OCIProfiles.builder();
                    profiles = builder.build();
                }
                catch (IOException e) {
                    ctx.writeln(e.getLocalizedMessage());
                    return true;
                }
                if (cmdLength == 2 && subcommand.equalsIgnoreCase(CLEAR)) {
                    this.handleClear(ctx);
                    return true;
                }
                String profileName = (String)ctx.getProperty(OCI_PROFILE_NAME);
                String regionName = (String)ctx.getProperty(OCI_REGION_NAME);
                OCIProfile profile = null;
                if (profileName != null && (profile = profiles.getProfile(profileName)) == null) {
                    ctx.writeln("Profile " + profileName + " does not exist");
                    return true;
                }
                if (cmdLength > 1 && subcommand.equalsIgnoreCase("compartments")) {
                    this.handleCompartments(ctx, cmdLength, regionName, profile, subcmdArgument);
                    return true;
                }
                if (subcommand.equalsIgnoreCase("region")) {
                    this.handleRegion(ctx, subcmdArgument, profileName, profile);
                    return true;
                }
                if (cmdLength > 1 && subcommand.equalsIgnoreCase("profile") && cmdLength != 3 && cmdLength != 4) {
                    OCICommand.handleListProfiles(ctx, profiles, profileName);
                    return true;
                }
                if ((cmdLength == 3 || cmdLength == 4) && subcommand.equalsIgnoreCase("profile")) {
                    String configFile = cmdLength == 4 ? parts[3] : "";
                    String newProfileName = subcmdArgument;
                    this.handleSetProfile(ctx, subcmdArgument, profiles, configFile, newProfileName);
                    return true;
                }
                if (ctx.getProperty(OCI_PROFILE_NAME) != null && cmdLength > 1 && cmdLength < 6) {
                    String host = null;
                    String method = null;
                    String bodyFile = null;
                    String qualifier = null;
                    String target = null;
                    try {
                        String ct;
                        if (subcommand.equalsIgnoreCase(DELETE) || subcommand.equalsIgnoreCase(GET) || subcommand.equalsIgnoreCase(PUT)) {
                            method = subcommand.toLowerCase();
                            Map props = (Map)ctx.getProperty("cloud.storage");
                            if (props == null || (CloudStorageUrl)props.get("cloud_url") == null) {
                                return true;
                            }
                            if (!method.equals(PUT) && cmdLength == 3) {
                                qualifier = parts[2];
                            } else if (method.equals(PUT) && cmdLength == 3) {
                                bodyFile = parts[2];
                            } else if (method.equals(PUT) && cmdLength == 4) {
                                bodyFile = parts[2];
                                qualifier = parts[3];
                            }
                            CloudStorageUrl csUrl = new CloudStorageUrl(((CloudStorageUrl)props.get("cloud_url")).getFinalUrl());
                            if (qualifier != null) {
                                csUrl.qualifiedUrl(qualifier);
                            }
                            URL url = csUrl.getFinalUrlAsOCI();
                            if (method.equalsIgnoreCase(DELETE) || method.equalsIgnoreCase(GET) || method.equalsIgnoreCase(PUT)) {
                                csUrl.validateUrlAsObject();
                            }
                            host = url.getHost();
                            target = url.getPath();
                            csUrl.dropQualifiedUrl();
                        } else if (cmdLength == 4) {
                            host = subcommand;
                            method = parts[2];
                            target = parts[3];
                        } else if (cmdLength == 5) {
                            host = subcommand;
                            method = parts[2];
                            bodyFile = parts[3];
                            target = parts[4];
                        } else {
                            ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                            return true;
                        }
                        oracle.dbtools.oci.OCIProfiles p = new oracle.dbtools.oci.OCIProfiles();
                        OCIRESTClient client = p.getOciClient((String)ctx.getProperty(OCI_PROFILE_NAME));
                        OCIRequest req = null;
                        if (bodyFile == null) {
                            req = new OCIRequest.Builder().host(host).method(method).target(target).build();
                        } else if (bodyFile != null && !bodyFile.isEmpty()) {
                            File srcFile = new File(bodyFile = ctx.prependCD(bodyFile));
                            if (!srcFile.isFile()) {
                                throw new IOException(bodyFile + " is not a file");
                            }
                            req = new OCIRequest.Builder().host(host).method(method).bodyFile(new File(bodyFile)).target(target).build();
                        }
                        CloseableHttpResponse response = client.getResponse(req);
                        ctx.write("Status:" + response.getCode() + " " + response.getReasonPhrase() + NL);
                        HttpEntity ent = response.getEntity();
                        String string = ct = ent != null && ent.getContentType() != null ? ent.getContentType() : "application/octect";
                        if (ct.equals("application/json")) {
                            String ret = response != null && response.getEntity() != null ? EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8") : "";
                            ctx.write(ret + NL);
                            break block40;
                        }
                        if (ent == null || ent.getContentLength() == 0L) break block40;
                        String responseFileName = req.getFinalPath() == null || req.getFinalPath().trim().equals("") ? "response.oci" : req.getFinalPath();
                        Path responsePath = FileUtils.getNewOrExistingPath((ScriptRunnerContext)ctx, (String)responseFileName);
                        ctx.write(CommandMessages.format("OCI_FILE_SAVED", responsePath.toAbsolutePath()));
                        try (InputStream inputStream = ent.getContent();){
                            Files.copy(inputStream, responsePath, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                    catch (IOException | GeneralSecurityException | ParseException e) {
                        ctx.write(NL + e.getLocalizedMessage() + NL);
                    }
                } else {
                    ctx.write(CommandMessages.getString("OCI_CMD_HELP") + NL);
                }
            }
            return true;
        }
        return false;
    }

    private void handleSetProfile(ScriptRunnerContext ctx, String subcmdArgument, OCIProfiles profiles, String configFile, String newProfileName) {
        if (subcmdArgument.contains("r1")) {
            r1 = true;
        }
        if (!configFile.isEmpty()) {
            ctx.removeProperty(OCI_PROFILE_NAME);
            ctx.removeProperty(OCI_REGION_NAME);
            ctx.putProperty(OCI_SQLCL_CONFIG_FILE, (Object)configFile);
            System.setProperty(OCI_SQLCL_CONFIG_FILE, configFile);
            try {
                OCIProfiles.Builder builder = OCIProfiles.builder();
                profiles = builder.build();
            }
            catch (IOException e) {
                ctx.writeln(e.getLocalizedMessage());
                return;
            }
        }
        try {
            if (profiles.listProfiles().contains(newProfileName)) {
                ctx.removeProperty(OCI_REGION_NAME);
                ctx.putProperty(OCI_PROFILE_NAME, (Object)newProfileName);
                OCIProfile profile = profiles.getProfile(newProfileName);
                HashMap csProps = (HashMap)ctx.getProperty("cloud.storage");
                if (csProps == null) {
                    csProps = new HashMap();
                    ctx.putProperty("cloud.storage", csProps);
                }
                OCICommand.set_region_home(profile, ctx);
                CSCommon.setProfileAndWarn(ctx, newProfileName, true);
            } else {
                ctx.write(CommandMessages.getString("OCI_PROFILE_INVALID"));
            }
        }
        catch (IllegalArgumentException e) {
            ctx.write(CommandMessages.getString("OCI_PEMFILE_INVALID"));
        }
    }

    private static void handleListProfiles(ScriptRunnerContext ctx, OCIProfiles profiles, String profileName) {
        try {
            ctx.write(CommandMessages.getString("OCI_PROFILES"));
            String current = "";
            String mark = "";
            if (profileName != null) {
                current = profileName;
                mark = " ";
            }
            for (String name : profiles.listProfiles()) {
                mark = name.equals(current) ? "*" : " ";
                ctx.write("\t" + mark + name + NL);
            }
        }
        catch (Exception e) {
            ctx.write(e.getMessage() + NL);
        }
    }

    private void handleRegion(ScriptRunnerContext ctx, String subcmdArgument, String profileName, OCIProfile profile) {
        block10: {
            if (profileName == null) {
                ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
            } else if (subcmdArgument.isEmpty() && ctx.getProperty(OCI_REGION_NAME) == null) {
                OCICommand.set_region_home(profile, ctx);
            } else if (!subcmdArgument.isEmpty()) {
                try {
                    String region = subcmdArgument;
                    OCIIdentityClient client = OCIIdentityClient.builder((OCIProfile)profile).build();
                    if (region.equalsIgnoreCase("list")) {
                        client.listRegions().forEach(p -> {
                            ctx.write(p.getRegionName());
                            if (p.isHomeRegion()) {
                                ctx.write("\t(HOME REGION)");
                            }
                            ctx.write(NL);
                        });
                        break block10;
                    }
                    if (client.listRegions().stream().anyMatch(p -> Objects.equals(region, p.getRegionName()))) {
                        ctx.putProperty(OCI_REGION_NAME, (Object)region);
                        ctx.write(CommandMessages.format("OCI_REGION_SET", region));
                        break block10;
                    }
                    ctx.write(CommandMessages.format("OCID_REGION_SUBSCRIBED", subcmdArgument));
                }
                catch (IOException e) {
                    ctx.writeln(e.getLocalizedMessage());
                }
            } else {
                ctx.write(CommandMessages.format("OCI_REGION_SET", ctx.getProperty(OCI_REGION_NAME)));
            }
        }
    }

    private void handleCompartments(ScriptRunnerContext ctx, int cmdLength, String regionName, OCIProfile profile, String arg) {
        if (profile == null) {
            ctx.write(CommandMessages.getString("OCI_PROFILE_NOT_SET"));
        } else if (regionName == null) {
            OCICommand.set_region_home(profile, ctx);
        } else if (cmdLength == 3 && arg.equalsIgnoreCase("list")) {
            OCIIdentityClient client = OCIIdentityClient.builder((OCIProfile)profile).build();
            try {
                client.listCompartments().forEach(arg_0 -> ((ScriptRunnerContext)ctx).writeln(arg_0));
            }
            catch (IOException e) {
                ctx.writeln(e.getLocalizedMessage());
            }
        }
    }

    private void handleClear(ScriptRunnerContext ctx) {
        ctx.write(CommandMessages.getString("OCI_PROFILE_CLEARED") + NL);
        ctx.write(CommandMessages.getString("OCI_REGION_CLEARED"));
        ctx.removeProperty(OCI_PROFILE_NAME);
        ctx.removeProperty(OCI_REGION_NAME);
        this.OCIConnClear(ctx);
        ctx.write(CommandMessages.getString("OCI_CONNECTION_CLEARED"));
        Map csProps = (Map)ctx.getProperty("cloud.storage");
        if (csProps != null) {
            csProps.remove(OCI_PROFILE_NAME);
        }
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    static String set_region_home(OCIProfile profile, ScriptRunnerContext ctx) {
        String region = null;
        if (profile != null) {
            region = profile.getProfileValue("region");
            ctx.putProperty(OCI_REGION_NAME, (Object)region);
            ctx.write("Region set to: " + region + NL);
        } else {
            ctx.writeln("Profile not found");
        }
        return region;
    }

    private Iterator<JrsValue> callOCIEndpoint(String profile, String path, ScriptRunnerContext ctx) throws IOException, GeneralSecurityException, ParseException, IllegalArgumentException {
        oracle.dbtools.oci.OCIProfiles p = new oracle.dbtools.oci.OCIProfiles();
        Iterator elements = null;
        OCIRESTClient client = p.getOciClient(profile);
        Object host = null;
        host = r1 ? "identity.r1.oracleiaas.com" : "identity." + ctx.getProperty(OCI_REGION_NAME) + ".oraclecloud.com";
        OCIRequest request = new OCIRequest.Builder().host((String)host).method(GET).target(path).contentType("application/json").build();
        CloseableHttpResponse response = client.getResponse(request);
        HttpEntity entity = response.getEntity();
        String entityStr = EntityUtils.toString((HttpEntity)entity);
        try {
            JSON json = JSON.std.with((TreeCodec)new JacksonJrsTreeCodec());
            JrsArray array = (JrsArray)json.treeFrom((Object)entityStr);
            elements = array.elements();
        }
        catch (ClassCastException ex) {
            throw new IOException(entityStr);
        }
        return elements;
    }

    private void compartments(String profile, ScriptRunnerContext ctx) throws ParseException, GeneralSecurityException, IOException {
        String tenancyID = null;
        oracle.dbtools.oci.OCIProfiles p = new oracle.dbtools.oci.OCIProfiles();
        Properties profiles = p.getProperties();
        tenancyID = profiles.getProperty(profile + "/tenancy");
        String path = "/20160918/compartments/?compartmentId=" + tenancyID;
        Iterator<JrsValue> elements = this.callOCIEndpoint(profile, path, ctx);
        while (elements.hasNext()) {
            JrsValue element = elements.next();
            String compartmentName = element.get("name").asText();
            ctx.write(compartmentName + NL);
        }
    }

    private void OCIConnClear(ScriptRunnerContext ctx) {
        ScriptExecutor sqlcl = (ScriptExecutor)ctx.getProperty("runner");
        sqlcl.setConn(null);
        ctx.setCurrentConnection(null);
        ctx.setBaseConnection(null);
        ctx.putProperty("script.runner.sqlplus.nolog", (Object)Boolean.TRUE);
        ctx.putProperty("cli.conn.props", null);
    }
}

