/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.txn;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.LockStats;
import com.sleepycat.je.StatsConfig;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.TransactionConfig;
import com.sleepycat.je.TransactionStats;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.txn.DummyLockManager;
import com.sleepycat.je.txn.LatchedLockManager;
import com.sleepycat.je.txn.LockManager;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.txn.SyncedLockManager;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.transaction.xa.Xid;

public class TxnManager {
    static final long NULL_TXN_ID = -1L;
    private static final long FIRST_NEGATIVE_ID = -10L;
    private LockManager lockManager;
    private EnvironmentImpl envImpl;
    private Set<Txn> allTxns;
    private Map<Xid, Txn> allXATxns;
    private Map<Thread, Transaction> thread2Txn;
    private AtomicLong lastUsedLocalTxnId;
    private AtomicLong lastUsedReplicatedTxnId;
    private int nActiveSerializable;
    private long numBegins;
    private long numCommits;
    private long numAborts;
    private long numXAPrepares;
    private long numXACommits;
    private long numXAAborts;

    public TxnManager(EnvironmentImpl envImpl) throws DatabaseException {
        this.lockManager = EnvironmentImpl.getFairLatches() ? new LatchedLockManager(envImpl) : new SyncedLockManager(envImpl);
        if (envImpl.isNoLocking()) {
            this.lockManager = new DummyLockManager(envImpl, this.lockManager);
        }
        this.envImpl = envImpl;
        this.allTxns = new HashSet<Txn>();
        this.allXATxns = Collections.synchronizedMap(new HashMap());
        this.thread2Txn = new ConcurrentHashMap<Thread, Transaction>();
        this.numBegins = 0L;
        this.numCommits = 0L;
        this.numAborts = 0L;
        this.numXAPrepares = 0L;
        this.numXACommits = 0L;
        this.numXAAborts = 0L;
        this.lastUsedLocalTxnId = new AtomicLong(0L);
        this.lastUsedReplicatedTxnId = new AtomicLong(-10L);
    }

    public void setLastTxnId(long lastReplicatedTxnId, long lastLocalId) {
        this.lastUsedReplicatedTxnId.set(lastReplicatedTxnId);
        this.lastUsedLocalTxnId.set(lastLocalId);
    }

    public long getLastLocalTxnId() {
        return this.lastUsedLocalTxnId.get();
    }

    public long getLastReplicatedTxnId() {
        return this.lastUsedReplicatedTxnId.get();
    }

    public long getNextReplicatedTxnId() {
        return this.lastUsedReplicatedTxnId.decrementAndGet();
    }

    long getNextTxnId() {
        assert (!this.envImpl.isReplicated() || !this.envImpl.getReplicator().isMaster());
        return this.lastUsedLocalTxnId.incrementAndGet();
    }

    public void updateFromReplay(long replayTxnId) {
        boolean ok;
        long currentVal;
        assert (replayTxnId < 0L) : "replay txn id is unexpectedly positive " + replayTxnId;
        while (replayTxnId < (currentVal = this.lastUsedReplicatedTxnId.get()) && !(ok = this.lastUsedReplicatedTxnId.weakCompareAndSet(currentVal, replayTxnId))) {
        }
    }

    public Txn txnBegin(Transaction parent, TransactionConfig txnConfig) throws DatabaseException {
        if (parent != null) {
            throw new DatabaseException("Nested transactions are not supported yet.");
        }
        return Txn.createTxn(this.envImpl, txnConfig);
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerTxn(Txn txn) throws DatabaseException {
        Set<Txn> set = this.allTxns;
        synchronized (set) {
            this.allTxns.add(txn);
            if (txn.isSerializableIsolation()) {
                ++this.nActiveSerializable;
            }
            ++this.numBegins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unRegisterTxn(Txn txn, boolean isCommit) throws DatabaseException {
        Set<Txn> set = this.allTxns;
        synchronized (set) {
            this.allTxns.remove(txn);
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(0 - txn.getBudgetedMemorySize());
            if (isCommit) {
                ++this.numCommits;
            } else {
                ++this.numAborts;
            }
            if (txn.isSerializableIsolation()) {
                --this.nActiveSerializable;
            }
        }
    }

    public void registerXATxn(Xid xid, Txn txn, boolean isPrepare) throws DatabaseException {
        if (!this.allXATxns.containsKey(xid)) {
            this.allXATxns.put(xid, txn);
            this.envImpl.getMemoryBudget().updateTxnMemoryUsage(MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        }
        if (isPrepare) {
            ++this.numXAPrepares;
        }
    }

    public void notePrepare() {
        ++this.numXAPrepares;
    }

    void unRegisterXATxn(Xid xid, boolean isCommit) throws DatabaseException {
        if (this.allXATxns.remove(xid) == null) {
            throw new DatabaseException("XA Transaction " + xid + " can not be unregistered.");
        }
        this.envImpl.getMemoryBudget().updateTxnMemoryUsage(0 - MemoryBudget.HASHMAP_ENTRY_OVERHEAD);
        if (isCommit) {
            ++this.numXACommits;
        } else {
            ++this.numXAAborts;
        }
    }

    public Txn getTxnFromXid(Xid xid) throws DatabaseException {
        return this.allXATxns.get(xid);
    }

    public void setTxnForThread(Transaction txn) {
        Thread curThread = Thread.currentThread();
        this.thread2Txn.put(curThread, txn);
    }

    public Transaction unsetTxnForThread() throws DatabaseException {
        Thread curThread = Thread.currentThread();
        return this.thread2Txn.remove(curThread);
    }

    public Transaction getTxnForThread() throws DatabaseException {
        return this.thread2Txn.get(Thread.currentThread());
    }

    public Xid[] XARecover() throws DatabaseException {
        Set<Xid> xidSet = this.allXATxns.keySet();
        Xid[] ret = new Xid[xidSet.size()];
        ret = xidSet.toArray(ret);
        return ret;
    }

    public boolean areOtherSerializableTransactionsActive(Locker excludeLocker) {
        int exclude = excludeLocker != null && excludeLocker.isSerializableIsolation() ? 1 : 0;
        return this.nActiveSerializable - exclude > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirstActiveLsn() throws DatabaseException {
        long firstActive = -1L;
        Set<Txn> set = this.allTxns;
        synchronized (set) {
            Iterator<Txn> iter = this.allTxns.iterator();
            while (iter.hasNext()) {
                long txnFirstActive = iter.next().getFirstActiveLsn();
                if (firstActive == -1L) {
                    firstActive = txnFirstActive;
                    continue;
                }
                if (txnFirstActive == -1L || DbLsn.compareTo(txnFirstActive, firstActive) >= 0) continue;
                firstActive = txnFirstActive;
            }
        }
        return firstActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionStats txnStat(StatsConfig config) throws DatabaseException {
        TransactionStats stats = new TransactionStats();
        Set<Txn> set = this.allTxns;
        synchronized (set) {
            stats.setNBegins(this.numBegins);
            stats.setNCommits(this.numCommits);
            stats.setNAborts(this.numAborts);
            stats.setNXAPrepares(this.numXAPrepares);
            stats.setNXACommits(this.numXACommits);
            stats.setNXAAborts(this.numXAAborts);
            stats.setNActive(this.allTxns.size());
            TransactionStats.Active[] activeSet = new TransactionStats.Active[stats.getNActive()];
            stats.setActiveTxns(activeSet);
            Iterator<Txn> iter = this.allTxns.iterator();
            int i = 0;
            while (iter.hasNext()) {
                Locker txn = iter.next();
                activeSet[i] = new TransactionStats.Active(txn.toString(), txn.getId(), 0L);
                ++i;
            }
            if (config.getClear()) {
                this.numCommits = 0L;
                this.numAborts = 0L;
                this.numXACommits = 0L;
                this.numXAAborts = 0L;
            }
        }
        return stats;
    }

    public LockStats lockStat(StatsConfig config) throws DatabaseException {
        return this.lockManager.lockStat(config);
    }
}

