/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.dbi;

import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.DbInternal;
import com.sleepycat.je.DeadlockException;
import com.sleepycat.je.VerifyConfig;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.incomp.INCompressor;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.Loggable;
import com.sleepycat.je.log.ReplicationContext;
import com.sleepycat.je.log.entry.DbOperationType;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.MapLN;
import com.sleepycat.je.tree.NameLN;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeUtils;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.DbLsn;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbTree
implements Loggable {
    public static final DatabaseId ID_DB_ID = new DatabaseId(0);
    public static final DatabaseId NAME_DB_ID = new DatabaseId(1);
    private static final String ID_DB_NAME = "_jeIdMap";
    private static final String NAME_DB_NAME = "_jeNameMap";
    public static final String UTILIZATION_DB_NAME = "_jeUtilization";
    public static final String REP_OPERATIONS_NAME = "_jeRepOp";
    public static final String VLSN_MAP_DB_NAME = "_vlsnMapDb";
    private static final String[] RESERVED_DB_NAMES = new String[]{"_jeIdMap", "_jeNameMap", "_jeUtilization", "_jeRepOp", "_vlsnMapDb"};
    public static final int NEG_DB_ID_START = -256;
    private AtomicInteger lastAllocatedLocalDbId;
    private AtomicInteger lastAllocatedReplicatedDbId;
    private DatabaseImpl idDatabase;
    private DatabaseImpl nameDatabase;
    private byte flags;
    private static final byte REPLICATED_BIT = 1;
    private EnvironmentImpl envImpl;

    public DbTree() throws DatabaseException {
        this.envImpl = null;
        this.idDatabase = new DatabaseImpl();
        this.idDatabase.setDebugDatabaseName(ID_DB_NAME);
        this.idDatabase.clearKeyPrefixing();
        this.nameDatabase = new DatabaseImpl();
        this.nameDatabase.clearKeyPrefixing();
        this.nameDatabase.setDebugDatabaseName(NAME_DB_NAME);
        this.lastAllocatedLocalDbId = new AtomicInteger();
        this.lastAllocatedReplicatedDbId = new AtomicInteger();
    }

    public DbTree(EnvironmentImpl env, boolean replicationIntended) throws DatabaseException {
        this.envImpl = env;
        this.lastAllocatedLocalDbId = new AtomicInteger(1);
        this.lastAllocatedReplicatedDbId = new AtomicInteger(-256);
        DatabaseConfig idConfig = new DatabaseConfig();
        DbInternal.setDbConfigReplicated(idConfig, false);
        idConfig.setKeyPrefixing(false);
        this.idDatabase = new DatabaseImpl(ID_DB_NAME, new DatabaseId(0), env, idConfig);
        this.idDatabase.clearKeyPrefixing();
        DatabaseConfig nameConfig = new DatabaseConfig();
        nameConfig.setKeyPrefixing(false);
        this.nameDatabase = new DatabaseImpl(NAME_DB_NAME, new DatabaseId(1), env, nameConfig);
        this.nameDatabase.clearKeyPrefixing();
        if (replicationIntended) {
            this.setIsReplicated();
        }
    }

    public int getLastLocalDbId() {
        return this.lastAllocatedLocalDbId.get();
    }

    public int getLastReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.get();
    }

    private int getNextLocalDbId() {
        return this.lastAllocatedLocalDbId.incrementAndGet();
    }

    private int getNextReplicatedDbId() {
        return this.lastAllocatedReplicatedDbId.decrementAndGet();
    }

    public void setLastDbId(int lastReplicatedDbId, int lastLocalDbId) {
        this.lastAllocatedReplicatedDbId.set(lastReplicatedDbId);
        this.lastAllocatedLocalDbId.set(lastLocalDbId);
    }

    private boolean isReplicatedId(int id) {
        return id < -256;
    }

    public void updateFromReplay(DatabaseId replayDbId) {
        boolean ok;
        int currentVal;
        int replayVal = replayDbId.getId();
        assert (replayVal < 0) : "replay node id is unexpectedly positive " + replayDbId;
        while (replayVal < (currentVal = this.lastAllocatedReplicatedDbId.get()) && !(ok = this.lastAllocatedReplicatedDbId.weakCompareAndSet(currentVal, replayVal))) {
        }
    }

    void initExistingEnvironment(EnvironmentImpl envImpl, boolean replicationIntended) throws DatabaseException {
        if (replicationIntended) {
            if (!this.isReplicated()) {
                throw new UnsupportedOperationException("This environment must be converted for replication.Conversion isn't supported yet.");
            }
        } else if (this.isReplicated() && !envImpl.isReadOnly()) {
            throw new DatabaseException("This environment was previously opened for replication. It cannot be re-opened for in read/write mode for standalone operation.");
        }
        this.envImpl = envImpl;
        this.idDatabase.setEnvironmentImpl(envImpl);
        this.nameDatabase.setEnvironmentImpl(envImpl);
    }

    public DatabaseImpl createDb(Locker locker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, databaseHandle, null, null);
    }

    public DatabaseImpl createInternalDb(Locker locker, String databaseName, DatabaseConfig dbConfig) throws DatabaseException {
        DbInternal.setDbConfigReplicated(dbConfig, false);
        dbConfig.setKeyPrefixing(false);
        DatabaseImpl ret = this.doCreateDb(locker, databaseName, dbConfig, null, null, ReplicationContext.NO_REPLICATE);
        ret.clearKeyPrefixing();
        return ret;
    }

    public DatabaseImpl createClientDb(Locker locker, String databaseName, DatabaseConfig dbConfig, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        return this.doCreateDb(locker, databaseName, dbConfig, null, replicatedLN, repContext);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized DatabaseImpl doCreateDb(Locker nameLocker, String databaseName, DatabaseConfig dbConfig, Database databaseHandle, NameLN replicatedLN, ReplicationContext repContext) throws DatabaseException {
        Locker idDbLocker;
        boolean operationOk;
        CursorImpl nameCursor;
        DatabaseImpl newDb;
        block10: {
            DatabaseId newId = null;
            newId = replicatedLN != null ? replicatedLN.getId() : (this.envImpl.isReplicated() && DbInternal.getDbConfigReplicated(dbConfig) ? new DatabaseId(this.getNextReplicatedDbId()) : new DatabaseId(this.getNextLocalDbId()));
            newDb = new DatabaseImpl(databaseName, newId, this.envImpl, dbConfig);
            CursorImpl idCursor = null;
            nameCursor = null;
            operationOk = false;
            idDbLocker = null;
            try {
                try {
                    nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                    NameLN nameLN = null;
                    nameLN = replicatedLN != null ? replicatedLN : new NameLN(newId, this.envImpl, newDb.isReplicated());
                    ReplicationContext useRepContext = repContext;
                    if (repContext == null) {
                        useRepContext = newDb.getOperationRepContext(DbOperationType.CREATE);
                    }
                    nameCursor.putLN(databaseName.getBytes("UTF-8"), nameLN, false, useRepContext);
                    if (databaseHandle != null) {
                        nameLocker.addToHandleMaps(nameLN.getNodeId(), databaseHandle);
                    }
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                    idCursor.putLN(newId.getBytes(), new MapLN(newDb), false, ReplicationContext.NO_REPLICATE);
                    newDb.incrementUseCount();
                    operationOk = true;
                }
                catch (UnsupportedEncodingException UEE) {
                    throw new DatabaseException(UEE);
                }
                Object var16_16 = null;
                if (idCursor == null) break block10;
            }
            catch (Throwable throwable) {
                Object var16_17 = null;
                if (idCursor != null) {
                    idCursor.close();
                }
                if (nameCursor != null) {
                    nameCursor.close();
                }
                if (idDbLocker == null) throw throwable;
                idDbLocker.operationEnd(operationOk);
                throw throwable;
            }
            idCursor.close();
        }
        if (nameCursor != null) {
            nameCursor.close();
        }
        if (idDbLocker == null) return newDb;
        idDbLocker.operationEnd(operationOk);
        return newDb;
    }

    public void optionalModifyDbRoot(DatabaseImpl db) throws DatabaseException {
        if (db.isDeferredWriteMode()) {
            return;
        }
        this.modifyDbRoot(db);
    }

    public void modifyDbRoot(DatabaseImpl db) throws DatabaseException {
        this.modifyDbRoot(db, -1L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void modifyDbRoot(DatabaseImpl db, long ifBeforeLsn, boolean mustExist) throws DatabaseException {
        Object var13_10;
        boolean operationOk;
        CursorImpl cursor;
        BasicLocker idDbLocker;
        block15: {
            block14: {
                if (db.getId().equals(ID_DB_ID) || db.getId().equals(NAME_DB_ID)) {
                    this.envImpl.logMapTreeRoot();
                    return;
                }
                DatabaseEntry keyDbt = new DatabaseEntry(db.getId().getBytes());
                while (true) {
                    idDbLocker = null;
                    cursor = null;
                    operationOk = false;
                    try {
                        try {
                            boolean searchOk;
                            idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                            cursor = new CursorImpl(this.idDatabase, idDbLocker);
                            boolean bl = searchOk = (cursor.searchAndPosition(keyDbt, new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                            if (!searchOk) {
                                if (mustExist) {
                                    throw new DatabaseException("can't find database " + db.getId());
                                }
                                var13_10 = null;
                                if (cursor != null) {
                                    break;
                                }
                                break block14;
                            }
                            if (ifBeforeLsn == -1L || DbLsn.compareTo(cursor.getBIN().getLsn(cursor.getIndex()), ifBeforeLsn) < 0) {
                                MapLN mapLN = (MapLN)cursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                                assert (mapLN != null);
                                RewriteMapLN writeMapLN = new RewriteMapLN(cursor);
                                mapLN.getDatabase().getTree().withRootLatchedExclusive(writeMapLN);
                                operationOk = true;
                            }
                            break block15;
                        }
                        catch (DeadlockException DE) {
                            var13_10 = null;
                            if (cursor != null) {
                                cursor.releaseBIN();
                                cursor.close();
                            }
                            if (idDbLocker == null) continue;
                            ((Locker)idDbLocker).operationEnd(operationOk);
                        }
                    }
                    catch (Throwable throwable) {
                        var13_10 = null;
                        if (cursor != null) {
                            cursor.releaseBIN();
                            cursor.close();
                        }
                        if (idDbLocker == null) throw throwable;
                        ((Locker)idDbLocker).operationEnd(operationOk);
                        throw throwable;
                    }
                }
                cursor.releaseBIN();
                cursor.close();
            }
            if (idDbLocker == null) return;
            ((Locker)idDbLocker).operationEnd(operationOk);
            return;
        }
        var13_10 = null;
        if (cursor != null) {
            cursor.releaseBIN();
            cursor.close();
        }
        if (idDbLocker == null) return;
        ((Locker)idDbLocker).operationEnd(operationOk);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private NameLockResult lockNameLN(Locker locker, String databaseName, String action) throws DatabaseException {
        boolean success;
        NameLockResult result;
        block7: {
            boolean found;
            result = new NameLockResult();
            result.dbImpl = this.getDb(locker, databaseName, null);
            if (result.dbImpl == null) {
                throw new DatabaseNotFoundException("Attempted to " + action + " non-existent database " + databaseName);
            }
            success = false;
            result.nameCursor = new CursorImpl(this.nameDatabase, locker);
            DatabaseEntry key = new DatabaseEntry(databaseName.getBytes("UTF-8"));
            boolean bl = found = (result.nameCursor.searchAndPosition(key, null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
            if (found) break block7;
            result.nameCursor.releaseBIN();
            result.nameCursor.close();
            result.nameCursor = null;
            NameLockResult nameLockResult = result;
            Object var10_11 = null;
            if (success) return nameLockResult;
            this.releaseDb(result.dbImpl);
            if (result.nameCursor == null) return nameLockResult;
            result.nameCursor.releaseBIN();
            result.nameCursor.close();
            return nameLockResult;
        }
        try {
            try {
                result.nameLN = (NameLN)result.nameCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                assert (result.nameLN != null);
                int handleCount = result.dbImpl.getReferringHandleCount();
                if (handleCount <= 0) return result;
                throw new DatabaseException("Can't " + action + " database " + databaseName + "," + handleCount + " open Dbs exist");
            }
            catch (UnsupportedEncodingException UEE) {
                throw new DatabaseException(UEE);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (success) throw throwable;
            this.releaseDb(result.dbImpl);
            if (result.nameCursor == null) throw throwable;
            result.nameCursor.releaseBIN();
            result.nameCursor.close();
            throw throwable;
        }
    }

    public boolean dbRename(Locker locker, String databaseName, String newName) throws DatabaseException {
        boolean bl;
        block7: {
            NameLockResult result;
            CursorImpl nameCursor;
            block5: {
                boolean bl2;
                block6: {
                    nameCursor = null;
                    result = this.lockNameLN(locker, databaseName, "rename");
                    nameCursor = result.nameCursor;
                    if (nameCursor != null) break block5;
                    bl2 = false;
                    Object var8_9 = null;
                    this.releaseDb(result.dbImpl);
                    if (nameCursor == null) break block6;
                    nameCursor.releaseBIN();
                    nameCursor.close();
                }
                return bl2;
            }
            try {
                nameCursor.latchBIN();
                nameCursor.delete(result.dbImpl.getOperationRepContext(DbOperationType.RENAME));
                nameCursor.putLN(newName.getBytes("UTF-8"), new NameLN(result.dbImpl.getId(), this.envImpl, result.dbImpl.isReplicated()), false, result.dbImpl.getOperationRepContext(DbOperationType.RENAME));
                result.dbImpl.setDebugDatabaseName(newName);
                bl = true;
                Object var8_10 = null;
                this.releaseDb(result.dbImpl);
                if (nameCursor == null) break block7;
            }
            catch (UnsupportedEncodingException UEE) {
                try {
                    throw new DatabaseException(UEE);
                }
                catch (Throwable throwable) {
                    block8: {
                        Object var8_11 = null;
                        this.releaseDb(result.dbImpl);
                        if (nameCursor == null) break block8;
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    throw throwable;
                }
            }
            nameCursor.releaseBIN();
            nameCursor.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dbRemove(Locker locker, String databaseName, DatabaseId checkId) throws DatabaseException {
        CursorImpl nameCursor = null;
        NameLockResult result = this.lockNameLN(locker, databaseName, "remove");
        try {
            block4: {
                nameCursor = result.nameCursor;
                if (nameCursor == null) break block4;
                if (checkId == null || checkId.equals(result.nameLN.getId())) break block5;
            }
            Object var7_6 = null;
            if (nameCursor == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (nameCursor == null) throw throwable;
            nameCursor.releaseBIN();
            nameCursor.close();
            throw throwable;
        }
        nameCursor.releaseBIN();
        nameCursor.close();
        {
            block5: {
                return;
            }
            nameCursor.latchBIN();
            nameCursor.delete(result.dbImpl.getOperationRepContext(DbOperationType.REMOVE));
            locker.markDeleteAtTxnEnd(result.dbImpl, true);
        }
        Object var7_7 = null;
        if (nameCursor == null) return;
        nameCursor.releaseBIN();
        nameCursor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long truncate(Locker locker, String databaseName, boolean returnCount) throws DatabaseException {
        long l;
        block12: {
            boolean operationOk;
            DatabaseImpl newDb;
            DatabaseImpl oldDb;
            NameLockResult result;
            BasicLocker idDbLocker;
            CursorImpl nameCursor;
            block11: {
                block9: {
                    long l2;
                    block10: {
                        nameCursor = null;
                        idDbLocker = null;
                        result = this.lockNameLN(locker, databaseName, "truncate");
                        try {
                            nameCursor = result.nameCursor;
                            if (nameCursor != null) break block9;
                            l2 = 0L;
                            Object var18_9 = null;
                            if (nameCursor == null) break block10;
                        }
                        catch (Throwable throwable) {
                            block13: {
                                Object var18_11 = null;
                                if (nameCursor == null) break block13;
                                nameCursor.releaseBIN();
                                nameCursor.close();
                            }
                            throw throwable;
                        }
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    return l2;
                }
                oldDb = result.dbImpl;
                DatabaseId newId = null;
                newId = this.isReplicatedId(oldDb.getId().getId()) ? new DatabaseId(this.getNextReplicatedDbId()) : new DatabaseId(this.getNextLocalDbId());
                newDb = oldDb.cloneDatabase();
                newDb.incrementUseCount();
                newDb.setId(newId);
                newDb.setTree(new Tree(newDb));
                CursorImpl idCursor = null;
                operationOk = false;
                try {
                    idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                    idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                    idCursor.putLN(newId.getBytes(), new MapLN(newDb), false, ReplicationContext.NO_REPLICATE);
                    operationOk = true;
                    Object var13_16 = null;
                    if (idCursor == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var13_17 = null;
                    if (idCursor != null) {
                        idCursor.close();
                    }
                    if (idDbLocker != null) {
                        ((Locker)idDbLocker).operationEnd(operationOk);
                    }
                    throw throwable;
                }
                idCursor.close();
            }
            if (idDbLocker != null) {
                ((Locker)idDbLocker).operationEnd(operationOk);
            }
            result.nameLN.setId(newDb.getId());
            long recordCount = 0L;
            if (returnCount) {
                recordCount = oldDb.count();
            }
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            nameCursor.putCurrent(dataDbt, null, null, oldDb.getOperationRepContext(DbOperationType.TRUNCATE));
            locker.markDeleteAtTxnEnd(oldDb, true);
            locker.markDeleteAtTxnEnd(newDb, false);
            l = recordCount;
            Object var18_10 = null;
            if (nameCursor == null) break block12;
            nameCursor.releaseBIN();
            nameCursor.close();
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deleteMapLN(DatabaseId id) throws DatabaseException {
        boolean done = false;
        while (true) {
            boolean operationOk;
            BasicLocker idDbLocker;
            block13: {
                Object var10_10;
                if (done) {
                    return;
                }
                idDbLocker = null;
                CursorImpl idCursor = null;
                operationOk = false;
                try {
                    try {
                        boolean found;
                        idDbLocker = BasicLocker.createBasicLocker(this.envImpl);
                        idCursor = new CursorImpl(this.idDatabase, idDbLocker);
                        boolean bl = found = (idCursor.searchAndPosition(new DatabaseEntry(id.getBytes()), null, CursorImpl.SearchMode.SET, LockType.WRITE) & 1) != 0;
                        if (found) {
                            MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.WRITE);
                            assert (mapLN != null);
                            DatabaseImpl dbImpl = mapLN.getDatabase();
                            if (!dbImpl.isInUseDuringDbRemove()) {
                                idCursor.latchBIN();
                                idCursor.delete(ReplicationContext.NO_REPLICATE);
                                done = true;
                            }
                        } else {
                            done = true;
                        }
                        operationOk = true;
                    }
                    catch (DeadlockException DE) {
                        var10_10 = null;
                        if (idCursor != null) {
                            idCursor.releaseBIN();
                            idCursor.close();
                        }
                        if (idDbLocker == null) continue;
                        ((Locker)idDbLocker).operationEnd(operationOk);
                        continue;
                    }
                    var10_10 = null;
                    if (idCursor == null) break block13;
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (idCursor != null) {
                        idCursor.releaseBIN();
                        idCursor.close();
                    }
                    if (idDbLocker != null) {
                        ((Locker)idDbLocker).operationEnd(operationOk);
                    }
                    throw throwable;
                }
                idCursor.releaseBIN();
                idCursor.close();
            }
            if (idDbLocker == null) continue;
            ((Locker)idDbLocker).operationEnd(operationOk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl getDb(Locker nameLocker, String databaseName, Database databaseHandle) throws DatabaseException {
        try {
            DatabaseId id;
            block11: {
                if (databaseName.equals(ID_DB_NAME)) {
                    return this.idDatabase;
                }
                if (databaseName.equals(NAME_DB_NAME)) {
                    return this.nameDatabase;
                }
                CursorImpl nameCursor = null;
                id = null;
                try {
                    boolean found;
                    nameCursor = new CursorImpl(this.nameDatabase, nameLocker);
                    DatabaseEntry keyDbt = new DatabaseEntry(databaseName.getBytes("UTF-8"));
                    boolean bl = found = (nameCursor.searchAndPosition(keyDbt, null, CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                    if (found) {
                        NameLN nameLN = (NameLN)nameCursor.getCurrentLNAlreadyLatched(LockType.READ);
                        assert (nameLN != null);
                        id = nameLN.getId();
                        if (databaseHandle != null) {
                            nameLocker.addToHandleMaps(nameLN.getNodeId(), databaseHandle);
                        }
                    }
                    Object var10_10 = null;
                    if (nameCursor == null) break block11;
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (nameCursor != null) {
                        nameCursor.releaseBIN();
                        nameCursor.close();
                    }
                    throw throwable;
                }
                nameCursor.releaseBIN();
                nameCursor.close();
            }
            if (id == null) {
                return null;
            }
            return this.getDb(id, -1L, databaseName);
        }
        catch (UnsupportedEncodingException UEE) {
            throw new DatabaseException(UEE);
        }
    }

    public DatabaseImpl getDb(DatabaseId dbId) throws DatabaseException {
        return this.getDb(dbId, -1L);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout) throws DatabaseException {
        return this.getDb(dbId, lockTimeout, (String)null);
    }

    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, Map<DatabaseId, DatabaseImpl> dbCache) throws DatabaseException {
        if (dbCache.containsKey(dbId)) {
            return dbCache.get(dbId);
        }
        DatabaseImpl db = this.getDb(dbId, lockTimeout, (String)null);
        dbCache.put(dbId, db);
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DatabaseImpl getDb(DatabaseId dbId, long lockTimeout, String dbNameIfAvailable) throws DatabaseException {
        boolean operationOk;
        BasicLocker locker;
        DatabaseImpl foundDbImpl;
        block16: {
            CursorImpl idCursor;
            if (dbId.equals(this.idDatabase.getId())) {
                return this.idDatabase;
            }
            if (dbId.equals(this.nameDatabase.getId())) {
                return this.nameDatabase;
            }
            foundDbImpl = null;
            while (true) {
                Object var13_10;
                locker = null;
                idCursor = null;
                operationOk = false;
                try {
                    try {
                        DatabaseEntry keyDbt;
                        boolean found;
                        locker = BasicLocker.createBasicLocker(this.envImpl);
                        if (lockTimeout != -1L) {
                            locker.setLockTimeout(lockTimeout);
                        }
                        boolean bl = found = ((idCursor = new CursorImpl(this.idDatabase, locker)).searchAndPosition(keyDbt = new DatabaseEntry(dbId.getBytes()), new DatabaseEntry(), CursorImpl.SearchMode.SET, LockType.READ) & 1) != 0;
                        if (found) {
                            MapLN mapLN = (MapLN)idCursor.getCurrentLNAlreadyLatched(LockType.READ);
                            assert (mapLN != null);
                            foundDbImpl = mapLN.getDatabase();
                            foundDbImpl.incrementUseCount();
                        }
                        operationOk = true;
                        var13_10 = null;
                        if (idCursor != null) {
                            break;
                        }
                        break block16;
                    }
                    catch (DeadlockException DE) {
                        var13_10 = null;
                        if (idCursor != null) {
                            idCursor.releaseBIN();
                            idCursor.close();
                        }
                        if (locker == null) continue;
                        ((Locker)locker).operationEnd(operationOk);
                    }
                }
                catch (Throwable throwable) {
                    var13_10 = null;
                    if (idCursor != null) {
                        idCursor.releaseBIN();
                        idCursor.close();
                    }
                    if (locker != null) {
                        ((Locker)locker).operationEnd(operationOk);
                    }
                    throw throwable;
                }
            }
            idCursor.releaseBIN();
            idCursor.close();
        }
        if (locker != null) {
            ((Locker)locker).operationEnd(operationOk);
        }
        if (this.envImpl.isOpen()) {
            this.setDebugNameForDatabaseImpl(foundDbImpl, dbNameIfAvailable);
        }
        return foundDbImpl;
    }

    public void releaseDb(DatabaseImpl db) {
        if (db != null && db != this.idDatabase && db != this.nameDatabase) {
            db.decrementUseCount();
        }
    }

    public void releaseDbs(Map<DatabaseId, DatabaseImpl> dbCache) {
        if (dbCache != null) {
            Iterator<DatabaseImpl> i = dbCache.values().iterator();
            while (i.hasNext()) {
                this.releaseDb(i.next());
            }
        }
    }

    private void setDebugNameForDatabaseImpl(DatabaseImpl dbImpl, String dbName) throws DatabaseException {
        if (dbImpl != null) {
            if (dbName != null) {
                dbImpl.setDebugDatabaseName(dbName);
            } else if (dbImpl.getDebugName() == null) {
                dbImpl.setDebugDatabaseName(this.getDbName(dbImpl.getId()));
            }
        }
    }

    public void rebuildINListMapDb() throws DatabaseException {
        this.idDatabase.getTree().rebuildINList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verify(final VerifyConfig config, PrintStream out) throws DatabaseException {
        boolean ret = true;
        try {
            boolean ok = this.idDatabase.verify(config, this.idDatabase.getEmptyStats());
            if (!ok) {
                ret = false;
            }
            if (!(ok = this.nameDatabase.verify(config, this.nameDatabase.getEmptyStats()))) {
                ret = false;
            }
        }
        catch (DatabaseException DE) {
            ret = false;
        }
        INCompressor iNCompressor = this.envImpl.getINCompressor();
        synchronized (iNCompressor) {
            final LockType lockType = LockType.NONE;
            /*
             * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
             */
            class Traversal
            implements CursorImpl.WithCursor {
                boolean allOk = true;

                Traversal() {
                }

                @Override
                public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                    DatabaseImpl dbImpl;
                    boolean ok;
                    MapLN mapLN = (MapLN)cursor.getCurrentLN(lockType);
                    if (mapLN != null && !mapLN.isDeleted() && !(ok = (dbImpl = mapLN.getDatabase()).verify(config, dbImpl.getEmptyStats()))) {
                        this.allOk = false;
                    }
                    return true;
                }
            }
            Traversal traversal = new Traversal();
            CursorImpl.traverseDbWithCursor(this.idDatabase, lockType, true, traversal);
            if (!traversal.allOk) {
                ret = false;
            }
        }
        return ret;
    }

    public String getDbName(final DatabaseId id) throws DatabaseException {
        if (id.equals(ID_DB_ID)) {
            return ID_DB_NAME;
        }
        if (id.equals(NAME_DB_ID)) {
            return NAME_DB_NAME;
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            String name = null;

            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                if (nameLN != null && nameLN.getId().equals(id)) {
                    try {
                        this.name = new String(key.getData(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new DatabaseException(e);
                    }
                    return false;
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return traversal.name;
    }

    public Map<DatabaseId, String> getDbNamesAndIds() throws DatabaseException {
        final HashMap<DatabaseId, String> nameMap = new HashMap<DatabaseId, String>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traversal
        implements CursorImpl.WithCursor {
            Traversal() {
            }

            @Override
            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                NameLN nameLN = (NameLN)cursor.getCurrentLN(LockType.NONE);
                DatabaseId id = nameLN.getId();
                try {
                    nameMap.put(id, new String(key.getData(), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatabaseException(e);
                }
                return true;
            }
        }
        Traversal traversal = new Traversal();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, false, traversal);
        return nameMap;
    }

    public List<String> getDbNames() throws DatabaseException {
        final ArrayList<String> nameList = new ArrayList<String>();
        CursorImpl.traverseDbWithCursor(this.nameDatabase, LockType.NONE, true, new CursorImpl.WithCursor(){

            public boolean withCursor(CursorImpl cursor, DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
                try {
                    String name = new String(key.getData(), "UTF-8");
                    if (!DbTree.isReservedDbName(name)) {
                        nameList.add(name);
                    }
                    return true;
                }
                catch (UnsupportedEncodingException e) {
                    throw new DatabaseException(e);
                }
            }
        });
        return nameList;
    }

    public List<String> getInternalNoLookupDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(ID_DB_NAME);
        names.add(NAME_DB_NAME);
        return names;
    }

    public List<String> getInternalDbNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(UTILIZATION_DB_NAME);
        return names;
    }

    public static boolean isReservedDbName(String name) {
        for (int i = 0; i < RESERVED_DB_NAMES.length; ++i) {
            if (!RESERVED_DB_NAMES[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    public int getHighestLevel() throws DatabaseException {
        int idHighLevel = this.getHighestLevel(this.idDatabase);
        int nameHighLevel = this.getHighestLevel(this.nameDatabase);
        return nameHighLevel > idHighLevel ? nameHighLevel : idHighLevel;
    }

    public int getHighestLevel(DatabaseImpl dbImpl) throws DatabaseException {
        RootLevel getLevel = new RootLevel(dbImpl);
        dbImpl.getTree().withRootLatchedShared(getLevel);
        return getLevel.getRootLevel();
    }

    private boolean isReplicated() {
        return (this.flags & 1) != 0;
    }

    private void setIsReplicated() {
        this.flags = (byte)(this.flags | 1);
    }

    public void close() {
        this.idDatabase.releaseTreeAdminMemory();
        this.nameDatabase.releaseTreeAdminMemory();
    }

    long getTreeAdminMemory() {
        return this.idDatabase.getTreeAdminMemory() + this.nameDatabase.getTreeAdminMemory();
    }

    @Override
    public int getLogSize() {
        return LogUtils.getIntLogSize() + LogUtils.getIntLogSize() + this.idDatabase.getLogSize() + this.nameDatabase.getLogSize() + 1;
    }

    @Override
    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeInt(logBuffer, this.lastAllocatedLocalDbId.get());
        LogUtils.writeInt(logBuffer, this.lastAllocatedReplicatedDbId.get());
        this.idDatabase.writeToLog(logBuffer);
        this.nameDatabase.writeToLog(logBuffer);
        logBuffer.put(this.flags);
    }

    @Override
    public void readFromLog(ByteBuffer itemBuffer, byte entryVersion) throws LogException {
        this.lastAllocatedLocalDbId.set(LogUtils.readInt(itemBuffer));
        if (entryVersion >= 6) {
            this.lastAllocatedReplicatedDbId.set(LogUtils.readInt(itemBuffer));
        }
        this.idDatabase.readFromLog(itemBuffer, entryVersion);
        this.nameDatabase.readFromLog(itemBuffer, entryVersion);
        this.flags = entryVersion >= 6 ? itemBuffer.get() : (byte)0;
    }

    @Override
    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<dbtree lastLocalDbId = \"");
        sb.append(this.lastAllocatedLocalDbId);
        sb.append("\" lastReplicatedDbId = \"");
        sb.append(this.lastAllocatedReplicatedDbId);
        sb.append("\">");
        sb.append("<idDb>");
        this.idDatabase.dumpLog(sb, verbose);
        sb.append("</idDb><nameDb>");
        this.nameDatabase.dumpLog(sb, verbose);
        sb.append("</nameDb>");
        sb.append("</dbtree>");
    }

    @Override
    public long getTransactionId() {
        return 0L;
    }

    @Override
    public boolean logicalEquals(Loggable other) {
        return false;
    }

    String dumpString(int nSpaces) {
        StringBuffer self = new StringBuffer();
        self.append(TreeUtils.indent(nSpaces));
        self.append("<dbTree lastDbId =\"");
        self.append(this.lastAllocatedLocalDbId);
        self.append("\">");
        self.append('\n');
        self.append(this.idDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append(this.nameDatabase.dumpString(nSpaces + 1));
        self.append('\n');
        self.append("</dbtree>");
        return self.toString();
    }

    public String toString() {
        return this.dumpString(0);
    }

    public void dump() throws DatabaseException {
        this.idDatabase.getTree().dump();
        this.nameDatabase.getTree().dump();
    }

    private static class RootLevel
    implements WithRootLatched {
        private DatabaseImpl db;
        private int rootLevel;

        RootLevel(DatabaseImpl db) {
            this.db = db;
            this.rootLevel = 0;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            IN rootIN = (IN)root.fetchTarget(this.db, null);
            this.rootLevel = rootIN.getLevel();
            return null;
        }

        int getRootLevel() {
            return this.rootLevel;
        }
    }

    private static class NameLockResult {
        CursorImpl nameCursor;
        DatabaseImpl dbImpl;
        NameLN nameLN;

        private NameLockResult() {
        }
    }

    private static class RewriteMapLN
    implements WithRootLatched {
        private CursorImpl cursor;

        RewriteMapLN(CursorImpl cursor) {
            this.cursor = cursor;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            DatabaseEntry dataDbt = new DatabaseEntry(new byte[0]);
            this.cursor.putCurrent(dataDbt, null, null, ReplicationContext.NO_REPLICATE);
            return null;
        }
    }
}

