/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIWriter;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum XMIPropertyType {
    ID(true, true){

        @Override
        public String getAttributeName(XMIWriter writer, XMIProperty property) {
            String name = super.getAttributeName(writer, property);
            if (name == null || name.length() == 0) {
                return writer.getIdAttribute();
            }
            return name;
        }
    }
    ,
    UUID(true, true){

        @Override
        public String getAttributeName(XMIWriter writer, XMIProperty property) {
            return writer.getUUIDAttribute();
        }
    }
    ,
    LABEL(true, true){

        @Override
        public String getAttributeName(XMIWriter writer, XMIProperty property) {
            return writer.getLabelAttribute();
        }
    }
    ,
    PRIMITIVE(true, false),
    ENUMERATION(true, false),
    REFERENCE(false, false),
    COMPOSITE(false, false);

    private boolean m_datatype;
    private boolean m_attributeOnly;

    private XMIPropertyType(boolean datatype, boolean attributeOnly) {
        this.m_datatype = datatype;
        this.m_attributeOnly = attributeOnly;
    }

    public boolean isDatatype() {
        return this.m_datatype;
    }

    public boolean isAttributeOnly() {
        return this.m_attributeOnly;
    }

    public String getAttributeName(XMIWriter writer, XMIProperty property) {
        return property.getName();
    }
}

