/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.DefaultXMIMetaModel;
import oracle.mof.xmi.ResourcesSingleton;
import oracle.mof.xmi.XMIBean;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIMetaModel;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIPropertyType;
import oracle.mof.xmi.XMIType;
import org.xml.sax.Locator;

public class XMIBeanInterchanger
extends DefaultXMIMetaModel {
    private final ClassLoader m_classLoader;
    private final String m_prefix;
    private final Set<String> m_restrictions = new HashSet<String>();
    private final Object[] m_methodArgs = new Object[1];
    private boolean m_useWarningsForMissingClasses;

    public XMIBeanInterchanger(ClassLoader classLoader, String name, String version, String nsPrefix, String nsURI, String[] namespaces, String prefix, String restrictions) {
        super(name, version, nsPrefix, nsURI, namespaces);
        ContractUtils.checkNull(classLoader, "Class loader must not be null");
        ContractUtils.checkNull(prefix, "Prefix must not be null");
        this.m_classLoader = classLoader;
        this.m_prefix = prefix;
        if (restrictions != null) {
            for (String restriction : restrictions.split(",")) {
                this.m_restrictions.add(restriction);
            }
        }
    }

    @Override
    protected XMIType createTypeByName(String name) throws XMIException {
        return new XMIBeanType(name);
    }

    @Override
    protected Object getTypeKey(Object instance) {
        return instance.getClass();
    }

    @Override
    protected XMIType createTypeForKey(Object key) throws XMIException {
        String className = ((Class)key).getName();
        int length = this.m_prefix.length() + 1;
        if (className.length() > length && className.startsWith(this.m_prefix)) {
            return this.getTypeByName(className.substring(this.m_prefix.length()));
        }
        return null;
    }

    public void setUseWarningsForMissingClasses(boolean useWarnings) {
        this.m_useWarningsForMissingClasses = useWarnings;
    }

    private static void throwXMIError(String key, Object ... args) throws XMIException {
        XMIBeanInterchanger.throwXMIException(1, null, key, args);
    }

    private static void throwXMIException(int type, Throwable throwable, String key, Object ... args) throws XMIException {
        throw new XMIException(ResourcesSingleton.getPicker().getString(key, args), throwable, type);
    }

    protected class XMIBeanType
    implements XMIType {
        private final String m_name;
        private final Constructor<?> m_constructor;
        private final ArrayList<XMIBeanProperty> m_properties = new ArrayList();
        private XMIBeanProperty m_idProperty;

        public XMIBeanType(String elementName) throws XMIException {
            this.m_name = elementName;
            HashMap<String, XMIBeanProperty> propertyMap = new HashMap<String, XMIBeanProperty>(16);
            try {
                Class<?> clazz = Class.forName(XMIBeanInterchanger.this.m_prefix + elementName, false, XMIBeanInterchanger.this.m_classLoader);
                this.m_constructor = clazz.getDeclaredConstructor(new Class[0]);
                XMIBean cbean = this.m_constructor.getAnnotation(XMIBean.class);
                if (cbean != null && this.isExcluded(cbean)) {
                    XMIBeanInterchanger.throwXMIError("RestrictedClass.text", elementName, XMIBeanInterchanger.this.getNSURI());
                }
                this.m_constructor.setAccessible(true);
                while (!Object.class.equals(clazz)) {
                    Method[] methods = clazz.getDeclaredMethods();
                    for (int i = methods.length - 1; i >= 0; --i) {
                        Method method = methods[i];
                        XMIBean bean = method.getAnnotation(XMIBean.class);
                        if (bean == null || this.isExcluded(bean)) continue;
                        boolean export = false;
                        Class<?>[] parameterTypes = method.getParameterTypes();
                        Class returnType = method.getReturnType();
                        Class propertyClass = null;
                        if (parameterTypes.length == 0 && returnType != Void.TYPE) {
                            export = true;
                            propertyClass = returnType;
                        } else if (parameterTypes.length == 1 && method.getReturnType() == Void.TYPE) {
                            propertyClass = parameterTypes[0];
                        } else {
                            XMIBeanInterchanger.throwXMIError("InvalidBeanMethod.text", method);
                        }
                        Object name = bean.tag();
                        String key = null;
                        if (bean.type() != XMIPropertyType.ID) {
                            if ("".equals(name)) {
                                name = method.getName();
                                if (!export && (((String)name).startsWith("set") || ((String)name).startsWith("add")) || export && ((String)name).startsWith("get")) {
                                    name = Character.toLowerCase(((String)name).charAt(3)) + ((String)name).substring(4);
                                }
                            }
                            key = name;
                        }
                        XMIPropertyType propertyType = bean.type();
                        boolean multivalued = bean.multivalued();
                        boolean existing = false;
                        XMIBeanProperty property = (XMIBeanProperty)propertyMap.get(key);
                        if (property == null) {
                            property = new XMIBeanProperty(this, (String)name, propertyType, multivalued);
                            propertyMap.put(key, property);
                        } else {
                            if (export && property.hasGetter() || !export && property.hasSetter()) continue;
                            existing = true;
                        }
                        if (export && multivalued) {
                            if (propertyClass.isArray()) {
                                propertyClass = propertyClass.getComponentType();
                            } else if (Iterator.class.isAssignableFrom(propertyClass) || Iterable.class.isAssignableFrom(propertyClass)) {
                                java.lang.reflect.Type grt = method.getGenericReturnType();
                                if (grt instanceof ParameterizedType) {
                                    java.lang.reflect.Type pt;
                                    java.lang.reflect.Type[] pts = ((ParameterizedType)grt).getActualTypeArguments();
                                    if (pts.length == 1 && (pt = pts[0]) instanceof Class) {
                                        propertyClass = (Class)pt;
                                    }
                                } else {
                                    XMIBeanInterchanger.throwXMIError("InvalidBeanMethodParameter.text", method);
                                }
                            } else {
                                XMIBeanInterchanger.throwXMIError("InvalidBeanMethodParameter.text", method);
                            }
                        }
                        if (propertyClass.isArray()) {
                            XMIBeanInterchanger.throwXMIError("InvalidBeanMethodParameter.text", method);
                        }
                        Type type = null;
                        switch (bean.type()) {
                            case ID: {
                                if (!String.class.equals(propertyClass)) {
                                    XMIBeanInterchanger.throwXMIError("InvalidIdMethod.text", method);
                                }
                                type = Type.ID;
                                this.m_idProperty = property;
                                break;
                            }
                            case UUID: {
                                if (!String.class.equals(propertyClass)) {
                                    XMIBeanInterchanger.throwXMIError("InvalidUUIDMethod.text", method);
                                }
                                type = Type.STRING;
                                break;
                            }
                            case LABEL: {
                                if (!String.class.equals(propertyClass)) {
                                    XMIBeanInterchanger.throwXMIError("InvalidLabelMethod.text", method);
                                }
                                type = Type.STRING;
                                break;
                            }
                            case PRIMITIVE: {
                                if (Boolean.TYPE.equals(propertyClass)) {
                                    type = Type.BOOLEAN;
                                    break;
                                }
                                if (Integer.TYPE.equals(propertyClass)) {
                                    type = Type.INTEGER;
                                    break;
                                }
                                if (Long.TYPE.equals(propertyClass)) {
                                    type = Type.LONG;
                                    break;
                                }
                                if (Float.TYPE.equals(propertyClass)) {
                                    type = Type.FLOAT;
                                    break;
                                }
                                if (Double.TYPE.equals(propertyClass)) {
                                    type = Type.DOUBLE;
                                    break;
                                }
                                if (!String.class.equals((Object)propertyClass)) break;
                                type = Type.STRING;
                                break;
                            }
                            case ENUMERATION: {
                                if (propertyClass.isEnum()) {
                                    type = Type.ENUM;
                                    property.setEnumType(propertyClass.asSubclass(Enum.class));
                                    break;
                                }
                                if (!String.class.equals(propertyClass)) break;
                                type = Type.STRING;
                                break;
                            }
                            case REFERENCE: {
                                type = Type.REFERENCE;
                                break;
                            }
                            case COMPOSITE: {
                                type = Type.COMPOSITE;
                            }
                        }
                        if (type == null) {
                            XMIBeanInterchanger.throwXMIError("InvalidBeanMethodParameter.text", method);
                        }
                        if (existing) {
                            if (propertyType != property.getPropertyType() || multivalued != property.isMultivalued() || type != property.getBeanPropertyType() || !propertyClass.equals(property.getPropertyClass())) {
                                XMIBeanInterchanger.throwXMIError("InvalidBeanMethodRedefinition.text", method);
                            }
                        } else {
                            property.setBeanPropertyType(type);
                            property.setPropertyClass(propertyClass);
                        }
                        if (export) {
                            if (bean.type() == XMIPropertyType.PRIMITIVE) {
                                property.setDefaultValue(bean.defaultValue());
                            }
                            property.setGetter(method);
                            continue;
                        }
                        property.setSetter(method);
                    }
                    clazz = clazz.getSuperclass();
                }
                this.m_properties.addAll(propertyMap.values());
                Collections.sort(this.m_properties, XMIProperty.COMPARATOR);
            }
            catch (XMIException e) {
                throw e;
            }
            catch (Exception e) {
                int type = XMIBeanInterchanger.this.m_useWarningsForMissingClasses ? 0 : 1;
                XMIBeanInterchanger.throwXMIException(type, e, "UnknownClass.text", XMIBeanInterchanger.this.getNSURI() + "#" + elementName);
                throw new IllegalArgumentException();
            }
        }

        private boolean isExcluded(XMIBean bean) {
            String[] restrictions = bean.restrictions();
            if (restrictions.length == 0) {
                return false;
            }
            for (String restriction : restrictions) {
                if (!XMIBeanInterchanger.this.m_restrictions.contains(restriction)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Object createInstance(Locator locator) throws XMIException {
            try {
                return this.m_constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                int modifiers = this.m_constructor.getDeclaringClass().getModifiers();
                if (Modifier.isAbstract(modifiers)) {
                    XMIBeanInterchanger.throwXMIError("CreateAbstractInstance.text", this.m_name);
                }
                throw new XMIException(null, e, 2);
            }
        }

        @Override
        public String getId(Object context, Object instance) throws XMIException {
            return "#" + this.m_idProperty.getValue(instance);
        }

        @Override
        public Collection<? extends XMIProperty> getProperties() throws XMIException {
            return this.m_properties;
        }

        @Override
        public XMIMetaModel getMetaModel() {
            return XMIBeanInterchanger.this;
        }

        @Override
        public String getName() {
            return this.m_name;
        }
    }

    private class XMIBeanProperty
    implements XMIProperty {
        private final XMIBeanType m_owningType;
        private final String m_name;
        private final XMIPropertyType m_propertyType;
        private String m_defaultValue;
        private final boolean m_multivalued;
        private Type m_beanPropertyType;
        private Method m_setter;
        private Method m_getter;
        private Class m_propertyClass;
        private XMIType m_type;
        private Class<? extends Enum> m_enumType;

        public XMIBeanProperty(XMIBeanType owningType, String name, XMIPropertyType propertyType, boolean multivalued) {
            this.m_owningType = owningType;
            this.m_name = name;
            this.m_propertyType = propertyType;
            this.m_multivalued = multivalued;
        }

        @Override
        public XMIPropertyType getPropertyType() {
            return this.m_propertyType;
        }

        @Override
        public void addValue(Object instance, Object value) throws XMIException {
            try {
                switch (this.m_beanPropertyType) {
                    case BOOLEAN: {
                        if ("true".equals(value)) {
                            value = Boolean.TRUE;
                            break;
                        }
                        if ("false".equals(value)) {
                            value = Boolean.FALSE;
                            break;
                        }
                        XMIBeanInterchanger.throwXMIError("InvalidBooleanValue.text", value);
                        break;
                    }
                    case INTEGER: {
                        value = Integer.valueOf((String)value);
                        break;
                    }
                    case LONG: {
                        value = Long.valueOf((String)value);
                        break;
                    }
                    case FLOAT: {
                        Float f = Float.valueOf((String)value);
                        if (f.isInfinite() && !"Infinity".equals(value)) {
                            XMIBeanInterchanger.throwXMIError("NumberTooBig.text", value);
                        }
                        value = f;
                        break;
                    }
                    case DOUBLE: {
                        Double d = Double.valueOf((String)value);
                        if (d.isInfinite() && !"Infinity".equals(value)) {
                            XMIBeanInterchanger.throwXMIError("NumberTooBig.text", value);
                        }
                        value = d;
                        break;
                    }
                    case ENUM: {
                        value = Enum.valueOf(this.m_enumType, (String)value);
                    }
                }
                XMIBeanInterchanger.this.m_methodArgs[0] = value;
                try {
                    this.m_setter.invoke(instance, XMIBeanInterchanger.this.m_methodArgs);
                }
                catch (IllegalArgumentException iae) {
                    XMIType type = this.getType();
                    XMIBeanInterchanger.throwXMIError("IncorrectMethodArg.text", type == null ? this.m_propertyType : type.getName());
                }
            }
            catch (XMIException e) {
                throw e;
            }
            catch (InvocationTargetException ite) {
                Throwable t = ite.getTargetException();
                if (t instanceof XMIException) {
                    throw (XMIException)t;
                }
                throw new XMIException(null, t, 1);
            }
            catch (Exception e) {
                throw new XMIException(null, e, 1);
            }
        }

        @Override
        public boolean isMultivalued() {
            return this.m_multivalued;
        }

        @Override
        public XMIBeanType getOwningType() {
            return this.m_owningType;
        }

        @Override
        public String getName() {
            return this.m_name;
        }

        @Override
        public XMIType getType() {
            if (this.m_propertyClass != null) {
                try {
                    this.m_type = XMIBeanInterchanger.this.createTypeForKey(this.m_propertyClass);
                }
                catch (XMIException xMIException) {
                    // empty catch block
                }
                this.m_propertyClass = null;
            }
            return this.m_type;
        }

        @Override
        public Object getValue(Object instance) throws XMIException {
            try {
                Object value = this.m_getter.invoke(instance, new Object[0]);
                if (this.m_defaultValue != null && !this.m_multivalued && value != null && this.m_defaultValue.equals(value = value.toString())) {
                    return null;
                }
                return value;
            }
            catch (Exception e) {
                throw new XMIException(null, e, 1);
            }
        }

        public void setSetter(Method setter) {
            this.m_setter = setter;
            this.m_setter.setAccessible(true);
        }

        public boolean hasSetter() {
            return this.m_setter != null;
        }

        public void setGetter(Method getter) {
            this.m_getter = getter;
            this.m_getter.setAccessible(true);
        }

        public boolean hasGetter() {
            return this.m_getter != null;
        }

        public void setDefaultValue(String defaultValue) {
            if (!"".equals(defaultValue)) {
                this.m_defaultValue = defaultValue;
            }
        }

        public void setBeanPropertyType(Type beanPropertyType) {
            this.m_beanPropertyType = beanPropertyType;
        }

        public Type getBeanPropertyType() {
            return this.m_beanPropertyType;
        }

        public void setEnumType(Class<? extends Enum> enumType) {
            this.m_enumType = enumType;
        }

        public Class getPropertyClass() {
            return this.m_propertyClass;
        }

        public void setPropertyClass(Class propertyClass) {
            this.m_propertyClass = propertyClass;
        }
    }

    private static enum Type {
        ID,
        STRING,
        BOOLEAN,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        ENUM,
        REFERENCE,
        COMPOSITE;

    }
}

