/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.swift.config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.LayerUI;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import oracle.bali.ewt.olaf2.OracleLookAndFeel;
import oracle.dbtools.raptor.controls.listtable.ListTableModel;
import oracle.dbtools.raptor.ui.LayoutControl;
import oracle.dbtools.swift.SwiftResources;
import oracle.dbtools.swift.config.AddSwiftCredentialPanel;
import oracle.dbtools.swift.connection.SwiftConnectionException;
import oracle.dbtools.swift.connection.SwiftConnectionInfo;
import oracle.dbtools.swift.connection.SwiftConnections;
import oracle.dbtools.util.Logger;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.javatools.ui.UIBundle;
import oracle.javatools.ui.table.EditableTableModel;
import oracle.javatools.ui.table.EmptyTableTextLayer;
import oracle.javatools.ui.table.GenericTable;
import oracle.javatools.ui.table.GenericTableModel;
import oracle.javatools.ui.table.ReorderableTableWithTitleBar;
import oracle.javatools.ui.table.TableToolbar;

public class SwiftCredentialsPanel
extends DefaultTraversablePanel
implements LayoutControl {
    private TableModel _model = new EditDefaultTableModel(DEFAULT_DATA, DEFAULT_COLUMNS);
    private GenericTable _table;
    private ReorderableTableWithTitleBar _panel;
    private TableToolbar _toolBar;
    private static String[] DEFAULT_COLUMNS = new String[]{SwiftResources.get("NAMESPACE_URL"), SwiftResources.get("USER_NAME"), SwiftResources.get("PASSWORD"), SwiftResources.get("ENABLED")};
    private static String[] DEFAULT_COLUMN_TOOLTIPS = new String[]{SwiftResources.get("NAMESPACE_URL_TOOLTIP"), SwiftResources.get("USER_NAME_TOOLTIP"), SwiftResources.get("PASSWORD_TOOLTIP"), SwiftResources.get("ENABLED_TOOLTIP")};
    private static String[][] DEFAULT_DATA = new String[][]{{"", "", "", ""}};

    public SwiftCredentialsPanel() {
        this.setHelpID("f1_swift_credentials_html");
        try {
            this.initUI();
        }
        catch (Exception exception) {
            Logger.warn(((Object)((Object)this)).getClass(), (Throwable)exception);
        }
    }

    public void onEntry(TraversableContext traversableContext) {
        super.onEntry(traversableContext);
        SwiftConnectionInfoTableModel swiftConnectionInfoTableModel = new SwiftConnectionInfoTableModel(DEFAULT_COLUMNS, DEFAULT_COLUMN_TOOLTIPS);
        ArrayList<SwiftConnectionInfo> arrayList = new ArrayList<SwiftConnectionInfo>();
        SwiftConnections swiftConnections = SwiftConnections.getInstance();
        for (String string : swiftConnections.listConnections()) {
            arrayList.add(swiftConnections.getConnectionInfo(string));
        }
        swiftConnectionInfoTableModel.setRowList(arrayList);
        this._table.setModel((TableModel)((Object)swiftConnectionInfoTableModel));
        swiftConnectionInfoTableModel.setTable((JTable)this._table);
        this._table.sizeTableToContents();
        swiftConnectionInfoTableModel.setEditable(true);
    }

    public void onExit(TraversableContext traversableContext) throws TraversalException {
        TableModel tableModel = this._table.getModel();
        if (tableModel instanceof SwiftConnectionInfoTableModel) {
            SwiftConnectionInfoTableModel swiftConnectionInfoTableModel = (SwiftConnectionInfoTableModel)((Object)tableModel);
            SwiftConnections swiftConnections = SwiftConnections.getInstance();
            for (String string : swiftConnections.listConnections()) {
                swiftConnections.removeConnection(string);
            }
            for (SwiftConnectionInfo swiftConnectionInfo : swiftConnectionInfoTableModel.getRowList()) {
                try {
                    swiftConnections.addConnection(swiftConnectionInfo.getNamespaceUrl(), swiftConnectionInfo);
                }
                catch (SwiftConnectionException swiftConnectionException) {
                    Logger.severe(((Object)((Object)this)).getClass(), (Throwable)swiftConnectionException);
                }
            }
        }
        super.onExit(traversableContext);
    }

    private void initUI() throws Exception {
        this.setLayout(new BorderLayout());
        JPanel jPanel = LayoutControl.GBC.createPanel();
        int n = 0;
        JLabel jLabel = new JLabel(SwiftResources.get("ORACLE_SWIFT_INFO"));
        jPanel.add((Component)jLabel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.FIRST_LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        jPanel.add((Component)AddSwiftCredentialPanel.getDesc("ORACLE_SWIFT_DESC"), LayoutControl.GBC.gbc((int)0, (int)(++n), (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.X));
        ++n;
        this._table = new GenericTable(this._model);
        JScrollPane jScrollPane = new JScrollPane((Component)this._table);
        JLayer<JScrollPane> jLayer = new JLayer<JScrollPane>(jScrollPane, (LayerUI<JScrollPane>)new EmptyTableTextLayer((JTable)this._table, UIBundle.get((String)"TABLE_NO_DATA")));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add(jLayer);
        this._panel = new ReorderableTableWithTitleBar((JTable)this._table, (JComponent)jPanel2, false, true);
        this._configureGenericTable();
        this._configureToolbar();
        jPanel.add((Component)this._panel, LayoutControl.GBC.gbc((int)0, (int)n, (int)1, (int)1, (LayoutControl.GBC.Inset)LayoutControl.GBC.Inset.LINE_START_COMP, (LayoutControl.GBC.Fill)LayoutControl.GBC.Fill.XY, (LayoutControl.GBC.Spring)LayoutControl.GBC.Spring.XY));
        this.add(jPanel);
    }

    private void _configureGenericTable() {
        this._table.setRowHeader(this._table.createDefaultRowHeader());
        this._table.setSelectAllEnabled(false);
        this._table.setColumnSelectorAvailable(false);
        this._table.sizeTableToContents();
    }

    private void _configureToolbar() {
        this._toolBar = this._panel.getTableToolbar();
        this._toolBar.setAddVisible(true);
        this._toolBar.setDefaultAddAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.ADD_ROW));
        this._toolBar.setDeleteVisible(true);
        this._toolBar.setDefaultDeleteAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DELETE_ROW));
        this._toolBar.setClearVisible(false);
        this._toolBar.setDefaultClearAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.CLEAR));
        this._toolBar.setCopyVisible(false);
        this._toolBar.setDefaultCopyAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.COPY));
        this._toolBar.setPasteVisible(false);
        this._toolBar.setDefaultPasteAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.PASTE));
        this._toolBar.setDuplicateVisible(false);
        this._toolBar.setDefaultDuplicateAction(this._toolBar.getDefaultAction(TableToolbar.ToolAction.DUPLICATE_ROW));
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel((LookAndFeel)new OracleLookAndFeel());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFrame jFrame = new JFrame("Generic Table Demo");
        jFrame.add((Component)((Object)new SwiftCredentialsPanel()));
        jFrame.setDefaultCloseOperation(3);
        jFrame.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        jFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        jFrame.setVisible(true);
    }

    private class EditDefaultTableModel
    extends DefaultTableModel
    implements EditableTableModel,
    GenericTableModel {
        public EditDefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        public int getColumnAlignment(int n) {
            return 2;
        }

        public boolean canHide(int n) {
            return false;
        }

        public void insertColumn(int n, Object object, Object[] objectArray) {
        }

        public void removeColumn(int n) {
        }

        public int duplicateRow(int n, int n2) {
            return 0;
        }

        public int duplicateColumn(int n, int n2) {
            return 0;
        }
    }

    private class SwiftConnectionInfoTableModel
    extends ListTableModel<SwiftConnectionInfo>
    implements EditableTableModel {
        public SwiftConnectionInfoTableModel(String[] stringArray, String[] stringArray2) {
            super(stringArray, stringArray2);
        }

        public Class<?> getColumnClass(int n) {
            Class clazz = null;
            switch (n) {
                case 0: {
                    clazz = String.class;
                    break;
                }
                case 1: {
                    clazz = String.class;
                    break;
                }
                case 2: {
                    clazz = String.class;
                    break;
                }
                case 3: {
                    clazz = Boolean.class;
                    break;
                }
                default: {
                    clazz = super.getColumnClass(n);
                }
            }
            return clazz;
        }

        protected Object getValueAt(SwiftConnectionInfo swiftConnectionInfo, int n) {
            Object object = null;
            switch (n) {
                case 0: {
                    object = swiftConnectionInfo.getNamespaceUrl();
                    break;
                }
                case 1: {
                    object = swiftConnectionInfo.getUserName();
                    break;
                }
                case 2: {
                    object = "********";
                    break;
                }
                case 3: {
                    object = swiftConnectionInfo.isEnabled();
                    break;
                }
                default: {
                    object = null;
                }
            }
            return object;
        }

        protected void setValueAt(Object object, SwiftConnectionInfo swiftConnectionInfo, int n) {
            switch (n) {
                case 0: {
                    swiftConnectionInfo.setNamespaceUrl((String)object);
                    break;
                }
                case 1: {
                    swiftConnectionInfo.setUserName((String)object);
                    break;
                }
                case 2: {
                    swiftConnectionInfo.setUserData(((String)object).toCharArray());
                    break;
                }
                case 3: {
                    swiftConnectionInfo.setEnabled((Boolean)object);
                    break;
                }
            }
        }

        protected boolean isCellEditable(SwiftConnectionInfo swiftConnectionInfo, int n) {
            return true;
        }

        public void addRow(Object[] objectArray) {
            this.getRowList().add(new SwiftConnectionInfo());
            this.fireTableDataChanged();
        }

        public void addColumn(Object object, Object[] objectArray) {
        }

        public void insertRow(int n, Object[] objectArray) {
            this.getRowList().add(n, new SwiftConnectionInfo());
            this.fireTableDataChanged();
        }

        public void insertColumn(int n, Object object, Object[] objectArray) {
        }

        public void removeRow(int n) {
            this.getRowList().remove(n);
            this.fireTableDataChanged();
        }

        public void removeColumn(int n) {
        }

        public int duplicateRow(int n, int n2) {
            return 0;
        }

        public int duplicateColumn(int n, int n2) {
            return 0;
        }
    }
}

