/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.cloud.e1pdb;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.crypto.Cipher;
import oracle.dbtools.raptor.cloud.CloudResources;
import oracle.dbtools.raptor.cloud.e1pdb.CloudConfigurationException;
import oracle.dbtools.raptor.connections.OracleConnectionProcessor;
import oracle.dbtools.raptor.connections.OracleHttpOptions;
import oracle.dbtools.raptor.utils.TCPTNSEntry;
import oracle.dbtools.raptor.utils.TNSHelper;
import oracle.dbtools.util.Logger;
import oracle.dbtools.util.Pair;
import oracle.dbtools.util.Resource;
import oracle.ide.net.FileNativeHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.ide.net.WildcardURLFilter;
import oracle.javatools.util.ModelUtil;
import oracle.security.pki.OraclePKIProvider;

public class CloudProcessor
extends OracleConnectionProcessor {
    private static final String TNS_FILE = "tnsnames.ora";
    private static final String SSO_WALLET = "cwallet.sso";
    private static final String KEY_TYPE = "SSO";
    static final String CONFIG_FILE = "sqldev.cloud.configfile";
    static final String KEYSTORE_PWD = "sqldev.cloud.keystore-password";
    static final String USE_PROXY = "sqldev.cloud.useproxy";
    static final String PROXY_HOST = "sqldev.cloud.proxy.host";
    static final String PROXY_PORT = "sqldev.cloud.proxy.port";
    private static final Pattern HTTPS_PROXY_PATTERN = Pattern.compile("(?i)\\(\\s*https_proxy\\s*=");
    private static final Pattern ADDRESS_PATTERN = Pattern.compile("(?i)(\\(\\s*address\\s*=)");
    private static final Pattern DN_MATCH_PATTERN = Pattern.compile("(?i)ssl_server_dn_match\\s*=\\s*(\\w+)");
    private static final String ADDRESS_UPDATE_PATTERN = "$1";
    static final URLFilter ZIPFILE_FILE = new WildcardURLFilter("*.zip", URLFileSystem.isLocalFileSystemCaseSensitive(), CloudResources.getString("LABEL_ZIP_FILES"));
    private static Map<String, Config> sConfigMapping;

    private static String getServerDnMatch(File file) {
        String string = "false";
        File file2 = new File(file, "sqlnet.ora");
        if (file2.exists()) {
            try (FileReader fileReader = new FileReader(file2);
                 BufferedReader bufferedReader = new BufferedReader(fileReader);){
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    Matcher matcher;
                    if (string2.length() <= 0 || !(matcher = DN_MATCH_PATTERN.matcher(string2)).find()) continue;
                    String string3 = matcher.group(1);
                    if (string3 != null && (string3.equalsIgnoreCase("yes") || string3.equalsIgnoreCase("true") || string3.equalsIgnoreCase("on"))) {
                        string = "true";
                    }
                    break;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return string;
    }

    static Config getCloudConfigForZip(File file) throws CloudConfigurationException {
        if (file == null || !file.exists()) {
            return null;
        }
        String string = file.getAbsolutePath();
        long l = CloudProcessor.lastModified(file);
        Config config = sConfigMapping.get(string);
        if (config == null || l > config.timestamp) {
            config = CloudProcessor.createCloudConfig(file);
            sConfigMapping.put(string, config);
        }
        return config;
    }

    private static Config createCloudConfig(File file) throws CloudConfigurationException {
        WalletConfig walletConfig = null;
        long l = CloudProcessor.lastModified(file);
        File file2 = CloudProcessor.expandZip(file);
        List list = null;
        File file3 = new File(file2, TNS_FILE);
        if (file3.exists()) {
            try {
                list = TNSHelper.parseTnsFile((File)file3);
            }
            catch (IOException iOException) {
                throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_INVALID_TNS"), file.getAbsolutePath()), iOException);
            }
        }
        if (list == null || list.size() == 0) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_INVALID_TNS"), file.getAbsolutePath()));
        }
        File file4 = new File(file2, SSO_WALLET);
        if (!file4.exists()) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", CloudResources.getString("ERROR_REASON_MISSING_KEYSTORE"), file.getAbsolutePath()));
        }
        String string = CloudProcessor.getServerDnMatch(file2);
        walletConfig = new WalletConfig(l, list, string, file4);
        if (!CloudProcessor.testJCE()) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_JCE_CONFIG", System.getProperty("java.home"), CloudResources.getString("JCE_INSTALL_LOCATION")));
        }
        return walletConfig;
    }

    private static long lastModified(File file) {
        FileNativeHelper fileNativeHelper = FileNativeHelper.getInstance();
        if (fileNativeHelper.isLoaded()) {
            return fileNativeHelper.lastModified(file);
        }
        long l = file.lastModified();
        return l != 0L ? l : -1L;
    }

    private static File expandZip(File file) throws CloudConfigurationException {
        File file2 = null;
        try {
            Path path = Files.createTempDirectory(Resource.RAPTOR_USER_TEMP.toPath(), "cloudConfig", new FileAttribute[0]);
            File file3 = path.toFile();
            file3.deleteOnExit();
            try (ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(file));){
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                while (zipEntry != null) {
                    File file4 = new File(file3, zipEntry.getName());
                    file4.deleteOnExit();
                    if (zipEntry.isDirectory()) {
                        file4.mkdir();
                    } else {
                        try (FileOutputStream fileOutputStream = new FileOutputStream(file4);
                             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
                            int n = 0;
                            byte[] byArray = new byte[4096];
                            while ((n = zipInputStream.read(byArray, 0, byArray.length)) > 0) {
                                ((OutputStream)bufferedOutputStream).write(byArray, 0, n);
                            }
                        }
                    }
                    zipInputStream.closeEntry();
                    zipEntry = zipInputStream.getNextEntry();
                }
            }
            file2 = file3;
        }
        catch (IOException iOException) {
            throw new CloudConfigurationException(CloudResources.format("ERROR_INVALID_CONFIG", file.getPath()), iOException);
        }
        return file2;
    }

    static boolean testJCE() {
        int n = 0;
        try {
            n = Cipher.getMaxAllowedKeyLength("AES");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            // empty catch block
        }
        return n > 128;
    }

    public Properties finalizeProperties(Properties properties) {
        Properties properties2 = new Properties();
        String string = properties.getProperty(CONFIG_FILE);
        if (string != null) {
            File file = new File(string);
            try {
                Config config = CloudProcessor.getCloudConfigForZip(file);
                if (config != null) {
                    String string2 = properties.getProperty(KEYSTORE_PWD);
                    properties2.putAll((Map<?, ?>)config.getConfigProperties(string2));
                }
            }
            catch (CloudConfigurationException cloudConfigurationException) {
                Logger.severe(CloudProcessor.class, (Throwable)cloudConfigurationException);
            }
        }
        return properties2;
    }

    public boolean shouldEncrypt(String string) {
        return KEYSTORE_PWD.equals(string) || "oss.password".equals(string);
    }

    protected TCPTNSEntry resolveTNSEntry(String string, Properties properties) {
        TCPTNSEntry tCPTNSEntry = null;
        String string2 = properties.getProperty(CONFIG_FILE);
        if (string2 != null) {
            File file = new File(string2);
            try {
                Config config = CloudProcessor.getCloudConfigForZip(file);
                if (config != null) {
                    tCPTNSEntry = config.getTNSEntry(string);
                }
            }
            catch (CloudConfigurationException cloudConfigurationException) {
                Logger.severe(CloudProcessor.class, (Throwable)cloudConfigurationException);
            }
        }
        return tCPTNSEntry;
    }

    public void validateProperties(Properties properties) throws SQLException {
        File file;
        Config config;
        String string = properties.getProperty(CONFIG_FILE);
        if (string != null && (config = CloudProcessor.getCloudConfigForZip(file = new File(string))) != null) {
            config.validate(properties);
        }
    }

    protected String adjustDescriptor(String string, Properties properties) {
        OracleHttpOptions.ProxyMode proxyMode;
        String string2 = string;
        String string3 = properties.getProperty("sqldev.http.proxymode");
        if (string3 != null) {
            proxyMode = OracleHttpOptions.ProxyMode.valueOf((String)string3);
        } else {
            OracleHttpOptions.ProxyMode proxyMode2 = proxyMode = Boolean.valueOf(properties.getProperty(USE_PROXY)) != false ? OracleHttpOptions.ProxyMode.CUSTOM : OracleHttpOptions.ProxyMode.NONE;
        }
        if (proxyMode != OracleHttpOptions.ProxyMode.NONE && !CloudProcessor.hasProxy(string)) {
            Object object;
            CharSequence charSequence;
            Pair pair = null;
            if (proxyMode == OracleHttpOptions.ProxyMode.CUSTOM) {
                int n;
                charSequence = properties.getProperty("sqldev.http.proxy.host");
                if (charSequence == null) {
                    charSequence = properties.getProperty(PROXY_HOST);
                }
                if ((object = properties.getProperty("sqldev.http.proxy.port")) == null) {
                    object = properties.getProperty(PROXY_PORT);
                }
                Integer n2 = null;
                try {
                    n2 = Integer.valueOf((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                int n3 = n = n2 != null ? n2 : -1;
                if (ModelUtil.hasLength((String)charSequence) && n > 0) {
                    pair = new Pair((Object)charSequence, (Object)n);
                }
            } else if (proxyMode == OracleHttpOptions.ProxyMode.IDE) {
                pair = this.determineProxyForAddress(string);
            }
            if (pair != null) {
                charSequence = new StringBuilder(ADDRESS_UPDATE_PATTERN);
                ((StringBuilder)charSequence).append("(https_proxy=").append((String)pair.first()).append(")");
                ((StringBuilder)charSequence).append("(https_proxy_port=").append(pair.second()).append(")");
                object = ADDRESS_PATTERN.matcher(string);
                string2 = ((Matcher)object).replaceAll(((StringBuilder)charSequence).toString());
            }
        }
        return string2;
    }

    private Pair<String, Integer> determineProxyForAddress(String string) {
        Pair pair;
        block4: {
            pair = null;
            TCPTNSEntry tCPTNSEntry = new TCPTNSEntry("", string);
            String string2 = tCPTNSEntry.getHostname();
            if (string2 != null) {
                try {
                    URI uRI = new URI("https://" + string2 + ":" + tCPTNSEntry.getPortno());
                    ProxySelector proxySelector = ProxySelector.getDefault();
                    List<Proxy> list = proxySelector.select(uRI);
                    if (list == null) break block4;
                    for (Proxy proxy : list) {
                        SocketAddress socketAddress;
                        if (proxy.type() != Proxy.Type.HTTP || !((socketAddress = proxy.address()) instanceof InetSocketAddress)) continue;
                        String string3 = ((InetSocketAddress)socketAddress).getHostString();
                        int n = ((InetSocketAddress)socketAddress).getPort();
                        if (string3 == null || n <= 0) continue;
                        pair = new Pair((Object)string3, (Object)n);
                        break;
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    Logger.warn(CloudProcessor.class, (String)uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
                }
            }
        }
        return pair;
    }

    static boolean hasProxy(String string) {
        Matcher matcher = HTTPS_PROXY_PATTERN.matcher(string);
        return matcher.find();
    }

    static {
        Security.addProvider((Provider)new OraclePKIProvider());
        sConfigMapping = new HashMap<String, Config>();
    }

    static abstract class Config {
        protected final long timestamp;
        protected final Map<String, TCPTNSEntry> tnsEntryMap = new HashMap<String, TCPTNSEntry>();
        protected final Properties props = new Properties();

        protected Config(long l, Collection<TCPTNSEntry> collection, String string) {
            this.timestamp = l;
            for (TCPTNSEntry tCPTNSEntry : collection) {
                this.tnsEntryMap.put(tCPTNSEntry.getName(), tCPTNSEntry);
            }
            this.props.setProperty("oracle.net.ssl_server_dn_match", string);
            this.props.setProperty("oracle.net.ssl_version", "1.2");
        }

        protected Properties getConfigProperties(String string) {
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.props);
            return properties;
        }

        protected abstract void validate(Properties var1) throws SQLException;

        protected Collection<String> getConnectionNames() {
            return this.tnsEntryMap.keySet();
        }

        String getConnectionURL(String string) {
            TCPTNSEntry tCPTNSEntry = this.tnsEntryMap.get(string);
            return tCPTNSEntry != null ? tCPTNSEntry.getJDBCUrl() : null;
        }

        protected TCPTNSEntry getTNSEntry(String string) {
            return this.tnsEntryMap.get(string);
        }
    }

    private static class WalletConfig
    extends Config {
        private final File wallet;

        protected WalletConfig(long l, Collection<TCPTNSEntry> collection, String string, File file) {
            super(l, collection, string);
            this.wallet = file;
        }

        @Override
        protected Properties getConfigProperties(String string) {
            Properties properties = super.getConfigProperties(string);
            String string2 = this.wallet.getAbsolutePath();
            properties.setProperty("javax.net.ssl.keyStoreType", CloudProcessor.KEY_TYPE);
            properties.setProperty("javax.net.ssl.keyStore", string2);
            properties.setProperty("javax.net.ssl.trustStoreType", CloudProcessor.KEY_TYPE);
            properties.setProperty("javax.net.ssl.trustStore", string2);
            return properties;
        }

        @Override
        protected void validate(Properties properties) throws SQLException {
            try (FileInputStream fileInputStream = new FileInputStream(this.wallet);){
                try {
                    KeyStore keyStore = KeyStore.getInstance(CloudProcessor.KEY_TYPE);
                    keyStore.load(fileInputStream, null);
                }
                catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
                    throw new SQLException(exception);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new SQLException(fileNotFoundException);
            }
            catch (IOException iOException) {
                Logger.warn(CloudProcessor.class, (Throwable)iOException);
            }
        }
    }
}

