/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import oracle.ide.panels.Navigable;
import oracle.ide.util.Namespace;

public final class NavigableContext {
    private Namespace _scope;
    private final boolean _detailAsChildren;

    NavigableContext(Namespace scope, boolean detailAsChildren) {
        this._scope = scope;
        this._detailAsChildren = detailAsChildren;
    }

    public Namespace getScope() {
        return this._scope;
    }

    public Namespace setScope(Namespace scope) {
        Namespace oldScope = this._scope;
        this._scope = scope;
        return oldScope;
    }

    public void pushScope(String name, Namespace scope) {
        this._scope.put(name, scope);
        this._scope = scope;
    }

    public void pushScope(String name, Namespace scope, Navigable nav) {
        nav.setDataScope(scope);
        this.pushScope(name, scope);
    }

    public Namespace popScope() {
        Namespace oldScope = this._scope;
        this._scope = this._scope.getParent();
        return oldScope;
    }

    public String pushAnonymousScope(Namespace scope, Navigable nav) {
        String shortLabel = nav.getShortLabel();
        Object scopeName = shortLabel;
        int i = 1;
        while (this._scope.contains((String)scopeName)) {
            scopeName = shortLabel + "[" + Integer.toString(i++) + "]";
        }
        this.pushScope((String)scopeName, scope, nav);
        return scopeName;
    }

    public boolean displayDetailNodesAsChildren() {
        return this._detailAsChildren;
    }
}

