/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.panels;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.ide.Version;
import oracle.ide.controls.JSelectableLabel;
import oracle.ide.controls.WaitCursor;
import oracle.ide.panels.AbstractUIContainer;
import oracle.ide.panels.ExceptionPanel;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.NavigableContext;
import oracle.ide.panels.PanelsArb;
import oracle.ide.panels.ProvidesDebugInformation;
import oracle.ide.panels.ProvidesSearchTags;
import oracle.ide.panels.SavedTreeState;
import oracle.ide.panels.TitledPanel;
import oracle.ide.panels.Traversable;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.AccessibleUtils;
import oracle.javatools.logging.Diagnostics;
import oracle.javatools.ui.ComponentWithTitlebar;
import oracle.javatools.ui.ControlBar;
import oracle.javatools.ui.search.SearchEvent;
import oracle.javatools.ui.search.SearchField;
import oracle.javatools.ui.search.SearchListener;
import oracle.javatools.ui.search.SearchMatcher;

public class MDDPanel
extends AbstractUIContainer {
    private static final Logger LOGGER = Logger.getLogger(MDDPanel.class.getName());
    public static final String CURRENT_TREE1 = "MDDPanel.CURRENT_TREE1";
    public static final String CURRENT_TREE1_MODEL = "MDDPanel.CURRENT_TREE1_MODEL";
    public static final String CURRENT_TREE1_NODE = "MDDPanel.CURRENT_TREE1_NODE";
    public static final String CURRENT_TRAVERSABLE = "MDDPanel.CURRENT_TRAVERSABLE";
    public static final String CURRENT_TRAVERSABLE_HINT_TEXT = "MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT";
    public static final String TREE_PANEL_NORTH = "North";
    public static final String TREE_PANEL_SOUTH = "South";
    public static final String TREE_PANEL_EAST = "East";
    public static final String TREE_PANEL_WEST = "West";
    private static final boolean _debug = Boolean.getBoolean("MDDPanel.debug");
    private final Tcr _tcr = new Tcr();
    private final Tsl _tsl = new Tsl();
    private final DefaultMutableTreeNode root1 = new DefaultMutableTreeNode();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final ComponentWithTitlebar jTree1WithTitleBar = new ComponentWithTitlebar((JComponent)this.jScrollPane1, null, null);
    private final JTree jTree1 = MDDPanel.newJTree(this.root1, this._tcr, this._tsl, PanelsArb.getString(3));
    private final DefaultMutableTreeNode root2;
    private final JScrollPane jScrollPane2;
    private final JTree jTree2;
    private final JPanel _treePanel = new JPanel();
    private final JPanel detailJPanel = new JPanel();
    private final CardLayout mddCardLayout = new CardLayout();
    private final TitledPanel titledPanel;
    private final JSplitPane jSplitPane1;
    private final JSplitPane jSplitPane2;
    private final HashMap _navTravMap = new HashMap();
    private final boolean _useDetailTree;
    private Navigable _curNavigable;
    private Traversable _curTraversable;
    private final ArrayList _compKeys = new ArrayList();
    private int _nextCardLayoutKey = 0;
    private transient boolean _onEntryCalled;
    private int _titleDepth = 1;
    private transient boolean _childComparatorIsSet;
    private Comparator _childComparator;
    private Comparator _defaultChildComparator;
    private boolean _selectionDelay = true;
    private MDDPanelHintHandler _hintHandler;
    private final SearchField _searchField = new SearchField();
    private TreeModel _savedModel;
    private static boolean LOG_FAILED_SEARCHES;
    private static final File FAILED_SEARCH_LOG_FILE;
    private static boolean loggedLabel;
    private ExceptionPanel exceptionPanel = null;

    protected MDDPanel() {
        this((Navigable[])null, false);
    }

    public MDDPanel(Navigable rootNavigable) {
        this(new Navigable[]{rootNavigable});
    }

    public MDDPanel(Navigable[] rootNavigables) {
        this(rootNavigables, false);
    }

    public MDDPanel(Navigable[] rootNavigables, boolean useDetailTree) {
        this.setRootNavigables(rootNavigables);
        this._useDetailTree = useDetailTree;
        this._treePanel.setLayout(new BorderLayout());
        ToolTipManager.sharedInstance().registerComponent(this.jTree1);
        if (useDetailTree) {
            this.root2 = new DefaultMutableTreeNode();
            this.jScrollPane2 = new JScrollPane();
            this.jTree2 = MDDPanel.newJTree(this.root2, this._tcr, this._tsl, PanelsArb.getString(4));
            ToolTipManager.sharedInstance().registerComponent(this.jTree2);
            this.jSplitPane1 = new JSplitPane(0, (Component)this.jTree1WithTitleBar, this.jScrollPane2);
            this.jSplitPane1.setBorder(null);
            this.jSplitPane1.setResizeWeight(0.4);
            this._treePanel.add((Component)this.jSplitPane1, "Center");
            this.titledPanel = null;
            this.jSplitPane2 = new JSplitPane(1, this._treePanel, this.detailJPanel);
        } else {
            this.root2 = null;
            this.jScrollPane2 = null;
            this.jTree2 = null;
            this.jSplitPane1 = null;
            this._treePanel.add((Component)this._searchField, TREE_PANEL_NORTH);
            this._treePanel.add((Component)this.jTree1WithTitleBar, "Center");
            this.titledPanel = this.createTitledPanel(this.detailJPanel);
            this.jSplitPane2 = new JSplitPane(1, this._treePanel, this.titledPanel);
        }
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(565, 310));
        Dimension spMin = new Dimension(20, 20);
        this.jScrollPane1.setMinimumSize(spMin);
        this.jScrollPane1.setBorder(null);
        Dimension spPref = new Dimension(170, 200);
        this.jScrollPane1.setPreferredSize(spPref);
        this.jScrollPane1.getViewport().add((Component)this.jTree1, null);
        if (this.jScrollPane2 != null) {
            this.jScrollPane2.getViewport().add((Component)this.jTree2, null);
            this.jScrollPane2.setMinimumSize(spMin);
            this.jScrollPane2.setPreferredSize(spPref);
            this.jScrollPane2.setBorder(null);
        }
        this.detailJPanel.setMinimumSize(new Dimension(100, 100));
        this.detailJPanel.setPreferredSize(new Dimension(365, 210));
        this.detailJPanel.setLayout(this.mddCardLayout);
        this.jSplitPane2.setDividerSize(7);
        this.add((Component)this.jSplitPane2, "Center");
        this.jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
        this.jScrollPane1.setBorder(BorderFactory.createLineBorder(SystemColor.controlShadow));
        this._hintHandler = new MDDPanelHintHandler();
        this._searchField.setStyle(SearchField.Style.FILTER);
        this._searchField.setTypingDelay(SearchField.TypingDelay.FAST);
        this._searchField.setPrompt(PanelsArb.getString(5));
        this._searchField.addSearchListener(new SearchListener(){

            public void searchPerformed(SearchEvent se) {
                String text = se.isFromClear() ? "" : se.getSearchText();
                MDDPanel.this.applyTreeFilter(text);
            }

            public void searchCategoryChanged(SearchEvent se) {
            }
        });
        this._searchField.setBorder((Border)BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0), this._searchField.getBorder()));
        this._searchField.setKeyEventTargetComponent((Component)this.jTree1);
    }

    public final void setFilterAllowed(boolean filterAllowed) {
        this._searchField.setVisible(filterAllowed);
        if (this._savedModel != null) {
            this.jTree1.setModel(this._savedModel);
            this._savedModel = null;
        }
        this.invalidate();
        this.validate();
    }

    public final boolean isFilterAllowed() {
        return this._searchField.isVisible();
    }

    private void applyTreeFilter(String filterText) {
        if ((filterText == null || filterText.length() == 0) && this._savedModel != null) {
            SavedTreeState state = new SavedTreeState(this.jTree1);
            this.jTree1.setModel(this._savedModel);
            state.restore(this.jTree1);
        } else {
            this.expandAll(this.jTree1, true, true);
            SearchMatcher matcher = SearchMatcher.getPrefixMatcher((CharSequence)filterText, (boolean)true, (boolean)false);
            DefaultMutableTreeNode root = this.cloneTree(this.root1);
            this.filter(root, matcher);
            if (this._savedModel == null) {
                this._savedModel = this.jTree1.getModel();
            }
            this.jTree1.setModel(new DefaultTreeModel(root));
            this.expandAll(this.jTree1, true);
            this.selectMatchingRow(matcher, filterText);
        }
    }

    private void selectMatchingRow(SearchMatcher matcher, String filterText) {
        int selectRowIndex = -1;
        boolean foundPatternMatch = false;
        for (int i = 0; i < this.jTree1.getRowCount(); ++i) {
            TreePath path = this.jTree1.getPathForRow(i);
            DefaultMutableTreeNode last = (DefaultMutableTreeNode)path.getLastPathComponent();
            String text = String.valueOf(last);
            if (text.toLowerCase().equals(filterText)) {
                selectRowIndex = i;
                break;
            }
            if (matcher.matches((CharSequence)text)) {
                if (foundPatternMatch) continue;
                selectRowIndex = i;
                foundPatternMatch = true;
                continue;
            }
            if (foundPatternMatch || selectRowIndex != -1 || !(last.getUserObject() instanceof ProvidesSearchTags)) continue;
            ProvidesSearchTags pstags = (ProvidesSearchTags)last.getUserObject();
            for (String tag : pstags.searchTags()) {
                if (!matcher.matches((CharSequence)tag)) continue;
                selectRowIndex = i;
            }
        }
        if (selectRowIndex != -1) {
            this.setTree1SelectionRow(selectRowIndex);
            return;
        }
        if (this.jTree1.getRowCount() > 0) {
            this.setTree1SelectionRow(0);
        } else {
            this.logFailedSearch(filterText);
        }
    }

    public void expandAll(JTree tree, boolean expand) {
        this.expandAll(tree, expand, false);
    }

    private void expandAll(JTree tree, boolean expand, boolean forceLazyLoading) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        this.expandAll(tree, new TreePath(root), expand, forceLazyLoading);
    }

    private void expandAll(JTree tree, TreePath parent, boolean expand, boolean forceLazyLoading) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)parent.getLastPathComponent();
        if (forceLazyLoading) {
            this.forceChildLoad(node, false);
        }
        if (node.getChildCount() >= 0) {
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path, expand, forceLazyLoading);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    private DefaultMutableTreeNode cloneTree(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode newRoot = new DefaultMutableTreeNode();
        newRoot.setUserObject(root.getUserObject());
        this.cloneTreeChildren(root, newRoot);
        return newRoot;
    }

    private void cloneTreeChildren(DefaultMutableTreeNode original, DefaultMutableTreeNode copy) {
        for (int i = 0; i < original.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)original.getChildAt(i);
            DefaultMutableTreeNode childCopy = new DefaultMutableTreeNode();
            childCopy.setUserObject(child.getUserObject());
            copy.add(childCopy);
            this.cloneTreeChildren(child, childCopy);
        }
    }

    private boolean filter(DefaultMutableTreeNode root, SearchMatcher matcher) {
        boolean matchingChildren = false;
        ArrayList<Integer> nodesToRemove = new ArrayList<Integer>();
        for (int i = 0; i < root.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)root.getChildAt(i);
            if (this.filter(child, matcher)) {
                matchingChildren = true;
                continue;
            }
            nodesToRemove.add(i);
        }
        int removedCount = 0;
        Iterator iterator = nodesToRemove.iterator();
        while (iterator.hasNext()) {
            int i = (Integer)iterator.next();
            root.remove(i - removedCount++);
        }
        if (matchingChildren) {
            return true;
        }
        if (!(root.getUserObject() instanceof Navigable)) {
            return false;
        }
        return MDDPanel.matchesSearch(matcher, (Navigable)root.getUserObject());
    }

    static boolean matchesSearch(SearchMatcher matcher, Navigable navigable) {
        boolean result = false;
        if (navigable != null) {
            if (matcher.matches((CharSequence)navigable.getShortLabel())) {
                result = true;
            } else if (navigable instanceof ProvidesSearchTags) {
                ProvidesSearchTags providesSearchTags = (ProvidesSearchTags)((Object)navigable);
                for (String tag : providesSearchTags.searchTags()) {
                    if (!matcher.matches((CharSequence)tag)) continue;
                    result = true;
                    break;
                }
            }
        }
        return result;
    }

    protected TitledPanel createTitledPanel(JPanel pnl) {
        TitledPanel panel = new TitledPanel(pnl);
        panel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        return panel;
    }

    protected ControlBar getTree1ControlBar() {
        return this.jTree1WithTitleBar.getControlBar();
    }

    protected void setTree1ControlBar(ControlBar controlBar) {
        this.jTree1WithTitleBar.setControlBar(controlBar);
    }

    protected JLabel getTree1TitleLabel() {
        return this.jTree1WithTitleBar.getLabel();
    }

    protected void setTree1TitleLabel(JLabel label) {
        this.jTree1WithTitleBar.setLabel(label);
    }

    @Override
    public boolean displayDetailNodesAsChildren() {
        return !this._useDetailTree;
    }

    @Override
    public void onEntry(TraversableContext tc) {
        this._onEntryCalled = true;
        super.onEntry(tc);
        this.maybeRefreshUI(tc);
        Traversable curTraversable = this.getCurrentTraversable();
        if (curTraversable != null) {
            this.enterTraversable(curTraversable);
        } else {
            Navigable[] rootNavigables = this.getRootNavigables();
            if (rootNavigables != null && rootNavigables.length > 0) {
                this.setTree1SelectionRow(0);
            }
        }
    }

    @Override
    public void onExit(TraversableContext tc) throws TraversalException {
        super.onExit(tc);
        Traversable curTraversable = this.getCurrentTraversable();
        if (curTraversable != null) {
            this.exitTraversable(curTraversable);
        }
        this._tsl._timer.stop();
    }

    public void expandTree1ToDepth(int depth) {
        this.assertOnEntryCalled("expandTree1ToDepth");
        MDDPanel.expandTreeToDepth(this.jTree1, depth);
    }

    public void expandTree1Path(String[] expandPath) {
        this.assertOnEntryCalled("expandTree1Path");
        TreePath treePath = this.convertPath(expandPath);
        if (treePath != null) {
            this.jTree1.expandPath(treePath);
        }
    }

    public void setTree1SelectionRow(int row) {
        this.assertOnEntryCalled("setTree1SelectionRow");
        this.jTree1.setSelectionRow(row);
    }

    public void setTree1SelectionPath(String[] selectionPath, boolean expandPath) {
        this.assertOnEntryCalled("setTree1SelectionPath");
        TreePath treePath = this.convertPath(selectionPath);
        if (treePath != null) {
            this.jTree1.setSelectionPath(treePath);
            if (expandPath) {
                this.jTree1.expandPath(treePath);
            }
        }
    }

    public void setTree1SelectionPath(String[] selectionPath) {
        this.setTree1SelectionPath(selectionPath, false);
    }

    public String[] getTree1SelectionPath() {
        this.assertOnEntryCalled("getTree1SelectionPath");
        TreePath treePath = this.jTree1.getSelectionPath();
        int n = treePath == null ? 1 : treePath.getPathCount();
        String[] res = new String[n - 1];
        for (int i = 1; i < n; ++i) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)treePath.getPathComponent(i);
            Navigable navigable = (Navigable)node.getUserObject();
            res[i - 1] = MDDPanel.getShortLabelFromNavigable(navigable);
        }
        return res;
    }

    public void setMainDividerLocation(double proportionalLocation) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setDividerLocation(proportionalLocation);
        }
    }

    public void setMainDividerSize(int dividerSize) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setDividerSize(dividerSize);
        }
    }

    public void setMainResizeWeight(double weight) {
        if (this.jSplitPane2 != null) {
            this.jSplitPane2.setResizeWeight(weight);
        }
    }

    public void setDetailDividerLocation(double proportionalLocation) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerLocation(proportionalLocation);
        }
    }

    public void setDetailDividerSize(int dividerSize) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerSize(dividerSize);
        }
    }

    public void setDetailResizeWeight(double weight) {
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setResizeWeight(weight);
        }
    }

    public void setTitleDepth(int titleDepth) {
        this._titleDepth = titleDepth;
    }

    public int getTitleDepth() {
        return this._titleDepth;
    }

    public void setChildComparator(Comparator childComparator) {
        this._childComparator = childComparator;
        this._childComparatorIsSet = true;
    }

    public Comparator getChildComparator() {
        return this._childComparator;
    }

    public void setDefaultChildComparator(Comparator defaultChildComparator) {
        this._defaultChildComparator = defaultChildComparator;
        if (!this._childComparatorIsSet) {
            this._childComparator = defaultChildComparator;
        }
    }

    public Comparator getDefaultChildComparator() {
        return this._defaultChildComparator;
    }

    public void addMDDListener(MDDListener listener) {
        this.addListener(MDDListener.class, listener);
    }

    public void removeMDDListener(MDDListener listener) {
        this.removeListener(MDDListener.class, listener);
    }

    public void addTreePanelComponent(Component comp, Object layoutConstraint) {
        if (layoutConstraint != TREE_PANEL_NORTH && layoutConstraint != TREE_PANEL_SOUTH && layoutConstraint != TREE_PANEL_EAST && layoutConstraint != TREE_PANEL_WEST) {
            throw new IllegalArgumentException("Invalid tree panel layout constraint.  Use only the defined constants.");
        }
        this._treePanel.add(comp, layoutConstraint);
    }

    public boolean enableSelectionDelay(boolean selectionDelay) {
        boolean temp = this._selectionDelay;
        this._selectionDelay = selectionDelay;
        return temp;
    }

    @Override
    protected Navigable getCurrentNavigable() {
        return this._curNavigable;
    }

    @Override
    protected Traversable getCurrentTraversable() {
        return this._curTraversable;
    }

    @Override
    protected TraversableContext newTraversableContext() {
        TreePath treePath;
        TraversableContext tc = super.newTraversableContext();
        if (this.jTree1 != null) {
            tc.putDesignTimeObject(CURRENT_TREE1, this.jTree1);
            tc.putDesignTimeObject(CURRENT_TREE1_MODEL, this.jTree1.getModel());
        }
        if ((treePath = this.jTree1.getSelectionPath()) != null) {
            tc.putDesignTimeObject(CURRENT_TREE1_NODE, treePath.getLastPathComponent());
        }
        tc.putDesignTimeObject(CURRENT_TRAVERSABLE, this.getCurrentTraversable());
        return tc;
    }

    @Override
    protected void refreshUI(TraversableContext dataScope) {
        this.root1.removeAllChildren();
        Navigable[] rootNavigables = this.getRootNavigables();
        if (rootNavigables == null) {
            return;
        }
        int n = rootNavigables.length;
        NavigableContext nc = new NavigableContext(dataScope, this.displayDetailNodesAsChildren());
        nc.getScope().put("Navigable.DEFAULT_CHILD_COMPARATOR_KEY", (Object)this._defaultChildComparator);
        rootNavigables = Navigable.sortNavigables(rootNavigables, this._childComparator);
        for (int i = 0; i < n; ++i) {
            Navigable navigable = rootNavigables[i];
            if (navigable == null) continue;
            try {
                DefaultMutableTreeNode treeNode = navigable.createTreeNode(nc);
                if (treeNode == null) continue;
                this.root1.add(treeNode);
                continue;
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Exception during refresh", t);
                if (!(t instanceof ThreadDeath)) continue;
                throw (ThreadDeath)t;
            }
        }
        DefaultTreeModel model = new DefaultTreeModel(this.root1);
        model.addTreeModelListener(this._tsl);
        this.jTree1.setModel(model);
        if (this.jSplitPane1 != null) {
            this.jSplitPane1.setDividerLocation(0.4);
        }
    }

    protected void fireTraversableEntered(TraversableContext tc) {
        MDDEvent event = null;
        Iterator iter = this.getListenerIterator(MDDListener.class);
        while (iter.hasNext()) {
            if (event == null) {
                event = new MDDEvent(tc);
            }
            ((MDDListener)iter.next()).traversableEntered(event);
        }
    }

    protected JSplitPane getMainSplitPane() {
        return this.jSplitPane2;
    }

    protected JSplitPane getDetailSplitPane() {
        return this.jSplitPane1;
    }

    protected JPanel getDetailPanel() {
        return this.detailJPanel;
    }

    private void assertOnEntryCalled(String method) {
        assert (this._onEntryCalled) : "MDDPanel's " + method + " method cannot be called until the onEntry method has been called.  The best way to meet this precondition when using the MDDPanel as a dialog is to create a TDialogLauncher to host the MDDPanel.  When using MDDPanel as its own Traversable, the best way to meet this precondition is to subclass the onEntry method, delegate to super.onEntry, and then call the method in the subclass onEntry implementation.";
    }

    private static String getShortLabelFromNavigable(Navigable navigable) {
        String shortLabel = navigable.getShortLabel();
        if (shortLabel == null) {
            shortLabel = PanelsArb.getString(2);
        }
        return shortLabel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void forceChildLoad(DefaultMutableTreeNode parent, boolean withWaitCursor) {
        if (parent.getUserObject() == null) {
            return;
        }
        Navigable expanded = (Navigable)parent.getUserObject();
        NavigableContext nc = null;
        int isize = parent.getChildCount();
        for (int i = 0; i < isize; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            Object ud = child.getUserObject();
            if (!(ud instanceof NavigableContext)) continue;
            parent.remove(i);
            nc = (NavigableContext)ud;
            break;
        }
        if (nc != null) {
            WaitCursor wc = null;
            if (withWaitCursor) {
                wc = new WaitCursor(this);
                wc.show();
            }
            try {
                nc.setScope(expanded.getDataScope());
                expanded.lazyLoadChildNavigables(parent, nc);
            }
            finally {
                if (withWaitCursor) {
                    wc.hide();
                    wc.dispose();
                }
            }
        }
    }

    private TreePath findPath(TreePath treePath, String[] path, int index) {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        this.forceChildLoad(parent, false);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            Navigable navigable = (Navigable)child.getUserObject();
            String shortLabel = MDDPanel.getShortLabelFromNavigable(navigable);
            if (!shortLabel.equals(path[index])) continue;
            TreePath curPath = treePath.pathByAddingChild(child);
            if (++index < path.length) {
                return this.findPath(curPath, path, index);
            }
            return curPath;
        }
        return null;
    }

    private TreePath convertPath(String[] path) {
        if (path != null && path.length > 0) {
            TreePath rootPath = new TreePath(this.root1);
            return this.findPath(rootPath, path, 0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterTraversable(Traversable traversable) {
        TraversableContext tc = this.newTraversableContext();
        try {
            this.enterTraversableImpl(traversable, tc);
        }
        catch (Exception e) {
            if (this.exceptionPanel == null) {
                this.exceptionPanel = new ExceptionPanel();
            }
            tc.putDesignTimeObject("ExceptionPanel.exception.key", e);
            this.enterTraversableImpl(this.exceptionPanel, tc);
        }
        finally {
            this.fireTraversableEntered(tc);
        }
    }

    private void enterTraversableImpl(Traversable traversable, TraversableContext tc) {
        traversable.onEntry(tc);
        String cardLayoutKey = this.getCardLayoutKey(traversable.getComponent());
        this.mddCardLayout.show(this.detailJPanel, cardLayoutKey);
        if (this.titledPanel != null && this._titleDepth > 0) {
            Object[] path;
            int pathlen;
            TreePath treePath = this.jTree1.getSelectionModel().getLeadSelectionPath();
            String title = null;
            if (treePath != null && (pathlen = (path = treePath.getPath()).length) > 1) {
                int n = Math.min(this._titleDepth, pathlen - 1);
                int start = Math.max(pathlen - this._titleDepth, 1);
                title = path[start].toString();
                for (int i = 1; i < n; ++i) {
                    title = PanelsArb.format(6, title, path[start + i].toString());
                }
            }
            this.titledPanel.setTitle(title);
        }
        this.detailJPanel.validate();
        this._hintHandler.onEntry(traversable, tc);
    }

    private void exitTraversable(Traversable traversable) throws TraversalException {
        TraversableContext tc = this.newTraversableContext();
        try {
            traversable.onExit(tc);
            this._hintHandler.onExit(traversable, tc);
        }
        catch (TraversalException te) {
            throw te;
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception exiting traversable " + traversable, e);
        }
    }

    private String getCardLayoutKey(Component component) {
        String key = this.findCardLayoutKey(component);
        return key != null ? key : this.createCardLayoutKey(component);
    }

    private String findCardLayoutKey(Component component) {
        for (CompKey ck : this._compKeys) {
            if (ck.comp != component) continue;
            return ck.key;
        }
        return null;
    }

    private String createCardLayoutKey(Component component) {
        String key = Integer.toString(this._nextCardLayoutKey++);
        CompKey ck = new CompKey(component, key);
        this._compKeys.add(ck);
        this.detailJPanel.add(component, key);
        return key;
    }

    private Traversable getTraversable(Navigable navigable) {
        if (navigable == null) {
            return null;
        }
        Object navTravKey = navigable.isUsingTraversableDefaultConstructor() ? navigable.getTraversableClass() : navigable;
        if (this._navTravMap.containsKey(navTravKey)) {
            return (Traversable)this._navTravMap.get(navTravKey);
        }
        Traversable traversable = navigable.newTraversable(this);
        this._navTravMap.put(navTravKey, traversable);
        return traversable;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        if (this.jTree1 != null && name != null) {
            this.jTree1.setName(name + " jtree1");
        }
        if (this.jTree2 != null && name != null) {
            this.jTree2.setName(name + " jtree2");
        }
    }

    private static JTree newJTree(DefaultMutableTreeNode root, TreeCellRenderer tcr, Tsl tsl, String name) {
        JTree tree = new JTree(root);
        tree.setCellRenderer(tcr);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.addTreeSelectionListener(tsl);
        tree.addFocusListener(tsl);
        tree.addTreeWillExpandListener(tsl);
        if (tree.getModel() != null) {
            AccessibleUtils.updateAccessibleName(tree, name, false);
        }
        return tree;
    }

    private static void expandTreeToDepth(JTree tree, int depth) {
        TreePath selectedPath = tree.getSelectionPath();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            if (depth <= 0) {
                tree.expandRow(i);
                continue;
            }
            TreePath path = tree.getPathForRow(i);
            if (path != null && path.getPathCount() <= depth) {
                tree.expandRow(i);
                continue;
            }
            tree.collapseRow(i);
        }
        if (selectedPath != null) {
            tree.setSelectionPath(selectedPath);
        } else {
            tree.setSelectionRow(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logFailedSearch(String search) {
        if (!LOG_FAILED_SEARCHES || FAILED_SEARCH_LOG_FILE == null) {
            return;
        }
        BufferedWriter w = null;
        try {
            w = new BufferedWriter(new FileWriter(FAILED_SEARCH_LOG_FILE, true));
            if (!loggedLabel) {
                loggedLabel = true;
                w.append(String.format("Label=%s%n", Version.BUILD_LABEL));
            }
            w.append(String.format("Dialog=[%s],Search=[%s]%n", this.findCurrentDialogTitle(), search));
        }
        catch (IOException iOException) {
        }
        finally {
            if (w != null) {
                try {
                    w.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private String findCurrentDialogTitle() {
        Dialog d = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
        if (d == null) {
            return "Unknown";
        }
        String title = d.getTitle();
        if (title == null || title.length() == 0) {
            return "Unknown";
        }
        return title;
    }

    static {
        loggedLabel = false;
        LOG_FAILED_SEARCHES = Boolean.valueOf(System.getProperty("ide.diagnostics.logFailedMDDSearches", "true"));
        File failedSearchLogFile = null;
        if (LOG_FAILED_SEARCHES && (failedSearchLogFile = Diagnostics.newLockedFile((String)"faileddialogsearches")) == null) {
            LOG_FAILED_SEARCHES = false;
        }
        FAILED_SEARCH_LOG_FILE = failedSearchLogFile;
    }

    private static class Tcr
    implements TreeCellRenderer {
        private final JSelectableLabel _label = new JSelectableLabel();

        private Tcr() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            this._label.setEnabled(tree.isEnabled());
            this._label.setSelected(selected);
            DefaultMutableTreeNode dmtn = (DefaultMutableTreeNode)value;
            Object userObject = dmtn.getUserObject();
            Font font = this._label.getFont();
            if (userObject instanceof Navigable) {
                Navigable navigable = (Navigable)userObject;
                String labelText = MDDPanel.getShortLabelFromNavigable(navigable);
                this._label.setText(labelText);
                this._label.setIcon(navigable.getIcon());
                if (_debug) {
                    StringBuffer buf = new StringBuffer();
                    String toolTipText = navigable.getToolTipText();
                    if (toolTipText != null) {
                        buf.append(toolTipText).append(" (");
                    } else {
                        buf.append("(");
                    }
                    buf.append("Class: ");
                    Class travClass = navigable.getTraversableClass();
                    buf.append(travClass != null ? travClass.getName() : navigable.getClass().getName());
                    if (navigable instanceof ProvidesDebugInformation) {
                        buf.append(" ");
                        buf.append(((ProvidesDebugInformation)((Object)navigable)).debugInformation());
                    }
                    if (navigable instanceof ProvidesSearchTags) {
                        buf.append(" Tags: " + ((ProvidesSearchTags)((Object)navigable)).searchTags());
                    }
                    buf.append(")");
                    this._label.setToolTipText(buf.toString());
                } else {
                    this._label.setToolTipText(navigable.getToolTipText());
                }
                switch (navigable.getDisplayStyle()) {
                    case 0: {
                        font = font.deriveFont(0);
                        break;
                    }
                    case 1: {
                        font = font.deriveFont(1);
                        break;
                    }
                    case 2: {
                        font = font.deriveFont(2);
                    }
                }
            } else if (userObject instanceof NavigableContext) {
                NavigableContext nc = (NavigableContext)userObject;
                this._label.setText("[notloaded]");
            } else {
                this._label.setText(null);
                this._label.setIcon(null);
                this._label.setToolTipText(null);
                font = font.deriveFont(0);
            }
            this._label.setFont(font);
            this._label.setHasFocus(hasFocus);
            return this._label;
        }
    }

    private class Tsl
    implements TreeSelectionListener,
    TreeWillExpandListener,
    TreeModelListener,
    FocusListener,
    ActionListener {
        private TreePath _curTreePath = null;
        private Object _lastTreeWithFocus = null;
        private final HashMap _detailTreeCache;
        private final Timer _timer;
        private TreeSelectionEvent _selectionEvent;

        public Tsl() {
            this._detailTreeCache = MDDPanel.this.jTree2 != null ? new HashMap() : null;
            this._timer = new Timer(250, this);
            this._timer.setRepeats(false);
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (e.isAddedPath()) {
                if (MDDPanel.this._selectionDelay) {
                    this._timer.restart();
                    this._selectionEvent = e;
                } else {
                    this.updateSelection(e);
                }
            }
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            if (MDDPanel.this._curTraversable != null) {
                Object[] children = e.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Traversable traversable;
                    DefaultMutableTreeNode child = (DefaultMutableTreeNode)children[i];
                    Navigable navigable = (Navigable)child.getUserObject();
                    if (navigable != MDDPanel.this._curNavigable || (traversable = MDDPanel.this.getTraversable(navigable)) != MDDPanel.this._curTraversable) continue;
                    MDDPanel.this._curTraversable = null;
                    this._curTreePath = null;
                }
            }
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            boolean isRoot;
            TreePath path = event.getPath();
            boolean bl = isRoot = path.getPathCount() == 1;
            if (isRoot) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            MDDPanel.this.forceChildLoad(node, true);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.updateSelection(this._selectionEvent);
        }

        private void updateSelection(TreeSelectionEvent e) {
            JTree tree = (JTree)e.getSource();
            this.updateSelectedNavigable(tree, e.getNewLeadSelectionPath());
        }

        @Override
        public void focusGained(FocusEvent e) {
            Object treeGainingFocus = e.getSource();
            if (treeGainingFocus == null || this._lastTreeWithFocus != treeGainingFocus) {
                // empty if block
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSelectedNavigable(JTree tree, TreePath newLeadSelectionPath) {
            if (MDDPanel.this._curTraversable != null) {
                try {
                    MDDPanel.this.exitTraversable(MDDPanel.this._curTraversable);
                }
                catch (TraversalException ex) {
                    ex.showMessageDialog(MDDPanel.this);
                    tree.removeTreeSelectionListener(this);
                    tree.removeFocusListener(this);
                    try {
                        tree.expandPath(this._curTreePath);
                        tree.setSelectionPath(this._curTreePath);
                    }
                    finally {
                        tree.addTreeSelectionListener(this);
                        tree.addFocusListener(this);
                    }
                    return;
                }
            }
            Navigable navigable = null;
            Traversable newTraversable = null;
            if (tree == MDDPanel.this.jTree1) {
                navigable = this.unwrapSelectedNavigable(MDDPanel.this.jTree1);
                if (MDDPanel.this.jTree2 == null) {
                    newTraversable = MDDPanel.this.getTraversable(navigable);
                } else {
                    DefaultMutableTreeNode detailRootNode;
                    if (this._detailTreeCache.containsKey(navigable)) {
                        detailRootNode = (DefaultMutableTreeNode)this._detailTreeCache.get(navigable);
                    } else {
                        NavigableContext nc = new NavigableContext(navigable.getDataScope(), MDDPanel.this.displayDetailNodesAsChildren());
                        detailRootNode = navigable.createDetailRootNode(nc);
                        this._detailTreeCache.put(navigable, detailRootNode);
                    }
                    if (MDDPanel.this.jTree2.getModel().getRoot() != detailRootNode) {
                        MDDPanel.this.jTree2.setModel(new DefaultTreeModel(detailRootNode));
                    }
                    newTraversable = MDDPanel.this.getTraversable(navigable);
                }
            } else if (tree == MDDPanel.this.jTree2) {
                navigable = this.unwrapSelectedNavigable(MDDPanel.this.jTree2);
                newTraversable = MDDPanel.this.getTraversable(navigable);
            }
            if (newTraversable != null) {
                MDDPanel.this._curTraversable = newTraversable;
                this._curTreePath = newLeadSelectionPath;
                MDDPanel.this.enterTraversable(newTraversable);
            }
        }

        private Navigable unwrapSelectedNavigable(JTree tree) {
            TreePath treePath = tree.getSelectionPath();
            if (treePath == null) {
                return null;
            }
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            MDDPanel.this._curNavigable = (Navigable)selectedNode.getUserObject();
            return MDDPanel.this._curNavigable;
        }
    }

    private static class MDDPanelHintHandler
    extends WindowAdapter
    implements AWTEventListener {
        private Component _traversableComponent;
        private String _hintText;
        private JEWTDialog _parentDialog;
        private boolean _listenerAdded;

        private MDDPanelHintHandler() {
        }

        public void onEntry(Traversable traversable, TraversableContext tc) {
            if (this._parentDialog == null) {
                this._parentDialog = this.getParentDialog(traversable.getComponent());
                if (this._parentDialog != null) {
                    this._parentDialog.addWindowListener((WindowListener)this);
                }
            }
            if (this._parentDialog != null && tc.contains(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT)) {
                this._hintText = (String)tc.get(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT);
                tc.remove(MDDPanel.CURRENT_TRAVERSABLE_HINT_TEXT);
                this.addListener(traversable);
            }
        }

        public void onExit(Traversable traversable, TraversableContext tc) {
            this.removeListener();
            if (this._parentDialog != null) {
                this._parentDialog.getAccessibleContext().setAccessibleName("");
            }
        }

        @Override
        public void windowClosed(WindowEvent e) {
            this._parentDialog.removeWindowListener((WindowListener)this);
            this.removeListener();
        }

        private void addListener(Traversable traversable) {
            this._traversableComponent = traversable.getComponent();
            if (!this._listenerAdded) {
                Toolkit tk = Toolkit.getDefaultToolkit();
                tk.addAWTEventListener(this, 4L);
                this._listenerAdded = true;
            }
        }

        private void removeListener() {
            Toolkit tk = Toolkit.getDefaultToolkit();
            tk.removeAWTEventListener(this);
            this._listenerAdded = false;
        }

        @Override
        public void eventDispatched(AWTEvent event) {
            int eventID = event.getID();
            switch (eventID) {
                case 1004: {
                    this.whenFocusGained((FocusEvent)event);
                }
            }
        }

        private void whenFocusGained(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            if (this.isComponentInTraversableComponent(e.getComponent())) {
                this._parentDialog.getAccessibleContext().setAccessibleName(this._hintText);
                this.removeListener();
            }
        }

        private JEWTDialog getParentDialog(Component comp) {
            JEWTDialog retval = null;
            Component component = comp;
            while (component.getParent() != null) {
                if (!((component = component.getParent()) instanceof JEWTDialog)) continue;
                retval = (JEWTDialog)component;
                break;
            }
            return retval;
        }

        private boolean isComponentInTraversableComponent(Component comp) {
            boolean retval = false;
            Component component = comp;
            while (component.getParent() != null) {
                if ((component = component.getParent()) != this._traversableComponent) continue;
                retval = true;
                break;
            }
            return retval;
        }
    }

    private class CompKey {
        final Component comp;
        final String key;

        CompKey(Component c, String k) {
            this.comp = c;
            this.key = k;
        }
    }
}

