/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.controls;

import java.awt.Dimension;
import oracle.bali.ewt.text.NumberTextField;

public final class WholeNumberField
extends NumberTextField {
    protected int minColumns;

    public WholeNumberField(int columnWidth) {
        this(0, columnWidth);
    }

    public WholeNumberField(int initialValue, int columnWidth) {
        super((Number)Math.max(0, initialValue), columnWidth);
        this.setDataType(Integer.class);
        this.setSigned(false);
        this.minColumns = columnWidth;
    }

    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        if (this.minColumns > 0) {
            return super.getPreferredSize();
        }
        return super.getMinimumSize();
    }

    public int getValue() {
        Number n = this.getNumber();
        return n != null ? n.intValue() : 0;
    }

    public void setValue(int value) {
        this.setNumber(Math.max(0, value));
    }
}

