/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.spatial.util.ByteOrder;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.Logger;
import oracle.spatial.util.WKAdapter;
import oracle.spatial.util.WKBasis;
import oracle.spatial.util.WKInputStream;

public class WKT
extends WKBasis
implements WKAdapter {
    private static Logger logger = Logger.getLogger("oracle.spatial.util.WKT");

    @Override
    protected void writeByteOrder(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
    }

    protected void write(DataOutputStream dataOutputStream, String string) throws GeometryExceptionWithContext {
        try {
            dataOutputStream.writeBytes(string);
        }
        catch (IOException iOException) {
            throw new GeometryExceptionWithContext(null, "IOException: " + iOException.toString(), null);
        }
    }

    @Override
    protected void writeBeginningOfList(ByteOrder byteOrder, DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "(");
    }

    @Override
    protected void writeBeginningOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "(");
    }

    @Override
    protected void writeGeometrySeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ", ");
    }

    @Override
    protected void writeCoordPairSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ", ");
    }

    @Override
    protected void writeXYSeparator(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, " ");
    }

    @Override
    protected void writeEndOfList(DataOutputStream dataOutputStream) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, ")");
    }

    @Override
    protected void writeByte(DataOutputStream dataOutputStream, int n) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "" + n);
    }

    @Override
    protected void writeDouble(ByteOrder byteOrder, DataOutputStream dataOutputStream, double d) throws GeometryExceptionWithContext {
        this.write(dataOutputStream, "" + d);
    }

    @Override
    protected void writeLabel(DataOutputStream dataOutputStream, int n, int n2, ByteOrder byteOrder) throws GeometryExceptionWithContext {
        switch (n) {
            case 1: {
                if (n2 == 4) break;
                this.write(dataOutputStream, "POINT ");
                break;
            }
            case 2: {
                if (n2 == 5 || n2 == 1000003 || n2 == 1000004) break;
                this.write(dataOutputStream, "LINESTRING ");
                break;
            }
            case 1000001: {
                this.write(dataOutputStream, "CIRCULARSTRING ");
                break;
            }
            case 1000002: {
                this.write(dataOutputStream, "COMPOUNDCURVE ");
                break;
            }
            case 3: {
                if (n2 == 6 || n2 == 1000005) break;
                this.write(dataOutputStream, "POLYGON ");
                break;
            }
            case 1000003: {
                if (n2 == 1000005) break;
                this.write(dataOutputStream, "CURVEPOLYGON ");
                break;
            }
            case 4: {
                this.write(dataOutputStream, "MULTIPOINT ");
                break;
            }
            case 1000004: {
                this.write(dataOutputStream, "MULTICURVE ");
                break;
            }
            case 5: {
                this.write(dataOutputStream, "MULTILINESTRING ");
                break;
            }
            case 1000005: {
                this.write(dataOutputStream, "MULTISURFACE ");
                break;
            }
            case 6: {
                this.write(dataOutputStream, "MULTIPOLYGON ");
                break;
            }
            case 7: {
                this.write(dataOutputStream, "GEOMETRYCOLLECTION ");
                break;
            }
            case 21: {
                this.write(dataOutputStream, "NURBSCURVE ");
                break;
            }
            default: {
                throw new RuntimeException("Unknown tag ID for WKT: " + n);
            }
        }
    }

    @Override
    protected void writeInnerLabel(DataOutputStream dataOutputStream, int n, int n2) throws GeometryExceptionWithContext {
        switch (n) {
            case 91: {
                this.write(dataOutputStream, "DEGREE ");
                break;
            }
            case 92: {
                this.write(dataOutputStream, "CONTROLPOINTS ");
                break;
            }
            case 93: {
                this.write(dataOutputStream, "NURBSPOINT ");
                break;
            }
            case 94: {
                this.write(dataOutputStream, "WEIGHTEDPOINT ");
                break;
            }
            case 95: {
                this.write(dataOutputStream, "WEIGHT ");
                break;
            }
            case 96: {
                this.write(dataOutputStream, "KNOTS ");
                break;
            }
            case 97: {
                this.write(dataOutputStream, "KNOT ");
                break;
            }
            case 98: {
                this.write(dataOutputStream, "VALUE ");
                break;
            }
            case 99: {
                this.write(dataOutputStream, "MULTIPLICITY ");
                break;
            }
            default: {
                throw new RuntimeException("Unknown WKT label " + n);
            }
        }
    }

    @Override
    protected WKInputStream getWKInputStream(String string) {
        return new WKTInputStream(string);
    }

    @Override
    protected WKInputStream getWKInputStream(byte[] byArray) {
        return this.getWKInputStream(new String(byArray));
    }

    public static class CustomStreamTokenizer {
        private Reader reader = null;
        private InputStream input = null;
        private char[] buf = new char[20];
        private int peekc = Integer.MAX_VALUE;
        private static final int NEED_CHAR = Integer.MAX_VALUE;
        private static final int SKIP_LF = 0x7FFFFFFE;
        private boolean pushedBack;
        private boolean forceLower;
        private int LINENO = 1;
        private boolean eolIsSignificantP = false;
        private boolean slashSlashCommentsP = false;
        private boolean slashStarCommentsP = false;
        private byte[] ctype = new byte[256];
        private static final byte CT_WHITESPACE = 1;
        private static final byte CT_DIGIT = 2;
        private static final byte CT_ALPHA = 4;
        private static final byte CT_QUOTE = 8;
        private static final byte CT_COMMENT = 16;
        public int ttype = -4;
        public static final int TT_EOF = -1;
        public static final int TT_EOL = 10;
        public static final int TT_NUMBER = -2;
        public static final int TT_WORD = -3;
        private static final int TT_NOTHING = -4;

        private CustomStreamTokenizer() {
            this.wordChars(97, 122);
            this.wordChars(65, 90);
            this.wordChars(160, 255);
            this.whitespaceChars(0, 32);
            this.commentChar(47);
            this.quoteChar(34);
            this.quoteChar(39);
            this.parseNumbers();
        }

        @Deprecated
        public CustomStreamTokenizer(InputStream inputStream) {
            this();
            if (inputStream == null) {
                throw new NullPointerException();
            }
            this.input = inputStream;
        }

        public CustomStreamTokenizer(Reader reader) {
            this();
            if (reader == null) {
                throw new NullPointerException();
            }
            this.reader = reader;
        }

        public void resetSyntax() {
            int n = this.ctype.length;
            while (--n >= 0) {
                this.ctype[n] = 0;
            }
        }

        public void wordChars(int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            if (n2 >= this.ctype.length) {
                n2 = this.ctype.length - 1;
            }
            while (n <= n2) {
                int n3 = n++;
                this.ctype[n3] = (byte)(this.ctype[n3] | 4);
            }
        }

        public void whitespaceChars(int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            if (n2 >= this.ctype.length) {
                n2 = this.ctype.length - 1;
            }
            while (n <= n2) {
                this.ctype[n++] = 1;
            }
        }

        public void ordinaryChars(int n, int n2) {
            if (n < 0) {
                n = 0;
            }
            if (n2 >= this.ctype.length) {
                n2 = this.ctype.length - 1;
            }
            while (n <= n2) {
                this.ctype[n++] = 0;
            }
        }

        public void ordinaryChar(int n) {
            if (n >= 0 && n < this.ctype.length) {
                this.ctype[n] = 0;
            }
        }

        public void commentChar(int n) {
            if (n >= 0 && n < this.ctype.length) {
                this.ctype[n] = 16;
            }
        }

        public void quoteChar(int n) {
            if (n >= 0 && n < this.ctype.length) {
                this.ctype[n] = 8;
            }
        }

        public void parseNumbers() {
            int n = 48;
            while (n <= 57) {
                int n2 = n++;
                this.ctype[n2] = (byte)(this.ctype[n2] | 2);
            }
            this.ctype[46] = (byte)(this.ctype[46] | 2);
            this.ctype[45] = (byte)(this.ctype[45] | 2);
        }

        public void eolIsSignificant(boolean bl) {
            this.eolIsSignificantP = bl;
        }

        public void slashStarComments(boolean bl) {
            this.slashStarCommentsP = bl;
        }

        public void slashSlashComments(boolean bl) {
            this.slashSlashCommentsP = bl;
        }

        public void lowerCaseMode(boolean bl) {
            this.forceLower = bl;
        }

        private int read() throws IOException {
            if (this.reader != null) {
                return this.reader.read();
            }
            if (this.input != null) {
                return this.input.read();
            }
            throw new IllegalStateException();
        }

        public int nextToken() throws IOException {
            int n;
            if (this.pushedBack) {
                this.pushedBack = false;
                return this.ttype;
            }
            byte[] byArray = this.ctype;
            int n2 = this.peekc;
            if (n2 < 0) {
                n2 = Integer.MAX_VALUE;
            }
            if (n2 == 0x7FFFFFFE) {
                n2 = this.read();
                if (n2 < 0) {
                    this.ttype = -1;
                    return -1;
                }
                if (n2 == 10) {
                    n2 = Integer.MAX_VALUE;
                }
            }
            if (n2 == Integer.MAX_VALUE && (n2 = this.read()) < 0) {
                this.ttype = -1;
                return -1;
            }
            this.ttype = n2;
            this.peekc = Integer.MAX_VALUE;
            int n3 = n = n2 < 256 ? byArray[n2] : 4;
            while ((n & 1) != 0) {
                if (n2 == 13) {
                    ++this.LINENO;
                    if (this.eolIsSignificantP) {
                        this.peekc = 0x7FFFFFFE;
                        this.ttype = 10;
                        return 10;
                    }
                    n2 = this.read();
                    if (n2 == 10) {
                        n2 = this.read();
                    }
                } else {
                    if (n2 == 10) {
                        ++this.LINENO;
                        if (this.eolIsSignificantP) {
                            this.ttype = 10;
                            return 10;
                        }
                    }
                    n2 = this.read();
                }
                if (n2 < 0) {
                    this.ttype = -1;
                    return -1;
                }
                n = n2 < 256 ? byArray[n2] : 4;
            }
            if ((n & 2) != 0) {
                boolean bl = false;
                if (n2 == 45) {
                    n2 = this.read();
                    if (n2 != 46 && (n2 < 48 || n2 > 57)) {
                        this.peekc = n2;
                        this.ttype = 45;
                        return 45;
                    }
                    bl = true;
                }
                boolean bl2 = false;
                while (true) {
                    if (n2 == 46 && !bl2) {
                        bl2 = true;
                    } else if (48 > n2 || n2 > 57) break;
                    n2 = this.read();
                }
                this.peekc = n2;
                this.ttype = -2;
                return -2;
            }
            if ((n & 4) != 0) {
                int n4 = 0;
                do {
                    if (n4 >= this.buf.length) {
                        this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                    }
                    this.buf[n4++] = (char)n2;
                } while (((n = (n2 = this.read()) < 0 ? 1 : (n2 < 256 ? byArray[n2] : 4)) & 6) != 0);
                this.peekc = n2;
                this.ttype = -3;
                return -3;
            }
            if ((n & 8) != 0) {
                this.ttype = n2;
                int n5 = 0;
                int n6 = this.read();
                while (n6 >= 0 && n6 != this.ttype && n6 != 10 && n6 != 13) {
                    if (n6 == 92) {
                        int n7 = n2 = this.read();
                        if (n2 >= 48 && n2 <= 55) {
                            n2 -= 48;
                            int n8 = this.read();
                            if (48 <= n8 && n8 <= 55) {
                                n2 = (n2 << 3) + (n8 - 48);
                                n8 = this.read();
                                if (48 <= n8 && n8 <= 55 && n7 <= 51) {
                                    n2 = (n2 << 3) + (n8 - 48);
                                    n6 = this.read();
                                } else {
                                    n6 = n8;
                                }
                            } else {
                                n6 = n8;
                            }
                        } else {
                            switch (n2) {
                                case 97: {
                                    n2 = 7;
                                    break;
                                }
                                case 98: {
                                    n2 = 8;
                                    break;
                                }
                                case 102: {
                                    n2 = 12;
                                    break;
                                }
                                case 110: {
                                    n2 = 10;
                                    break;
                                }
                                case 114: {
                                    n2 = 13;
                                    break;
                                }
                                case 116: {
                                    n2 = 9;
                                    break;
                                }
                                case 118: {
                                    n2 = 11;
                                }
                            }
                            n6 = this.read();
                        }
                    } else {
                        n2 = n6;
                        n6 = this.read();
                    }
                    if (n5 >= this.buf.length) {
                        this.buf = Arrays.copyOf(this.buf, this.buf.length * 2);
                    }
                    this.buf[n5++] = (char)n2;
                }
                this.peekc = n6 == this.ttype ? Integer.MAX_VALUE : n6;
                return this.ttype;
            }
            if (n2 == 47 && (this.slashSlashCommentsP || this.slashStarCommentsP)) {
                n2 = this.read();
                if (n2 == 42 && this.slashStarCommentsP) {
                    int n9 = 0;
                    while ((n2 = this.read()) != 47 || n9 != 42) {
                        if (n2 == 13) {
                            ++this.LINENO;
                            n2 = this.read();
                            if (n2 == 10) {
                                n2 = this.read();
                            }
                        } else if (n2 == 10) {
                            ++this.LINENO;
                            n2 = this.read();
                        }
                        if (n2 < 0) {
                            this.ttype = -1;
                            return -1;
                        }
                        n9 = n2;
                    }
                    return this.nextToken();
                }
                if (n2 == 47 && this.slashSlashCommentsP) {
                    while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
                    }
                    this.peekc = n2;
                    return this.nextToken();
                }
                if ((byArray[47] & 0x10) != 0) {
                    while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
                    }
                    this.peekc = n2;
                    return this.nextToken();
                }
                this.peekc = n2;
                this.ttype = 47;
                return 47;
            }
            if ((n & 0x10) != 0) {
                while ((n2 = this.read()) != 10 && n2 != 13 && n2 >= 0) {
                }
                this.peekc = n2;
                return this.nextToken();
            }
            this.ttype = n2;
            return this.ttype;
        }

        public void pushBack() {
            if (this.ttype != -4) {
                this.pushedBack = true;
            }
        }

        public int lineno() {
            return this.LINENO;
        }

        public String toString() {
            String string;
            switch (this.ttype) {
                case -1: {
                    string = "EOF";
                    break;
                }
                case 10: {
                    string = "EOL";
                    break;
                }
                case -3: {
                    string = "STRING";
                    break;
                }
                case -2: {
                    string = "n=NUMBER";
                    break;
                }
                case -4: {
                    string = "NOTHING";
                    break;
                }
                default: {
                    if (this.ttype < 256 && (this.ctype[this.ttype] & 8) != 0) {
                        string = "QuotedString";
                        break;
                    }
                    char[] cArray = new char[3];
                    cArray[2] = 39;
                    cArray[0] = 39;
                    cArray[1] = (char)this.ttype;
                    string = new String(cArray);
                    break;
                }
            }
            return "Token[" + string + "], line " + this.LINENO;
        }
    }

    protected class WKTInputStream
    implements WKInputStream {
        protected final StreamTokenizer m_tokenizer;
        protected final List<Integer>[] m_listLengths;
        protected int m_currentParanLevel;
        protected int[] dimension = new int[1];

        public WKTInputStream(String string) {
            this.m_tokenizer = this.tokenizeWKT(string);
            this.m_listLengths = this.readListLengths(this.CustomTokenizeWKT(string), this.dimension);
            this.m_currentParanLevel = 0;
        }

        @Override
        public int getOrdinatesSize() {
            int n = this.getDimensions();
            int n2 = 0;
            for (int i = 0; i < this.m_listLengths.length; ++i) {
                if (this.m_listLengths[i].size() <= 0) continue;
                int n3 = 0;
                for (Integer n4 : this.m_listLengths[i]) {
                    n3 += n4.intValue();
                }
                n2 = n * n3;
            }
            return n2;
        }

        @Override
        public int getDimensions() {
            return this.dimension[0];
        }

        @Override
        public double readDouble(ByteOrder byteOrder) {
            try {
                if (this.m_tokenizer.nextToken() != -2) {
                    throw new RuntimeException("Token type " + this.m_tokenizer.ttype + ": " + this.m_tokenizer.sval);
                }
                double d = this.m_tokenizer.nval;
                if (this.m_tokenizer.nextToken() != -3) {
                    this.m_tokenizer.pushBack();
                } else if (this.m_tokenizer.sval.startsWith("e")) {
                    d = Double.parseDouble(d + this.m_tokenizer.sval);
                } else {
                    throw new RuntimeException("Token(s) " + d + this.m_tokenizer.sval + " unexpected.");
                }
                return d;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public int readLabel(ByteOrder byteOrder, int n) {
            switch (n) {
                case 4: {
                    return 1;
                }
                case 5: {
                    return 2;
                }
                case 6: {
                    return 3;
                }
                case 1000005: {
                    return 1000003;
                }
                case 21: {
                    return 21;
                }
                case 1000002: 
                case 1000003: 
                case 1000004: {
                    try {
                        switch (this.m_tokenizer.nextToken()) {
                            case 40: {
                                this.m_tokenizer.pushBack();
                                return 2;
                            }
                        }
                        String string = this.m_tokenizer.sval;
                        if (string.equalsIgnoreCase("LINESTRING")) {
                            return 2;
                        }
                        if (string.equalsIgnoreCase("CIRCULARSTRING")) {
                            return 1000001;
                        }
                        if (string.equalsIgnoreCase("COMPOUNDCURVE")) {
                            return 1000002;
                        }
                        if (string.equalsIgnoreCase("NURBSCURVE")) {
                            return 21;
                        }
                        throw new RuntimeException("Unknown WKT tag " + string);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
                    }
                }
            }
            try {
                if (this.m_tokenizer.nextToken() != -3) {
                    throw new RuntimeException("Unexpected WKT token.");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
            }
            String string = this.m_tokenizer.sval;
            if (string.equalsIgnoreCase("POINT")) {
                return 1;
            }
            if (string.equalsIgnoreCase("LINESTRING")) {
                return 2;
            }
            if (string.equalsIgnoreCase("CIRCULARSTRING")) {
                return 1000001;
            }
            if (string.equalsIgnoreCase("COMPOUNDCURVE")) {
                return 1000002;
            }
            if (string.equalsIgnoreCase("POLYGON")) {
                return 3;
            }
            if (string.equalsIgnoreCase("CURVEPOLYGON")) {
                return 1000003;
            }
            if (string.equalsIgnoreCase("MULTIPOINT")) {
                return 4;
            }
            if (string.equalsIgnoreCase("MULTICURVE")) {
                return 1000004;
            }
            if (string.equalsIgnoreCase("MULTILINESTRING")) {
                return 5;
            }
            if (string.equalsIgnoreCase("MULTISURFACE")) {
                return 1000005;
            }
            if (string.equalsIgnoreCase("MULTIPOLYGON")) {
                return 6;
            }
            if (string.equalsIgnoreCase("GEOMETRYCOLLECTION")) {
                return 7;
            }
            if (string.equalsIgnoreCase("NURBSCURVE")) {
                return 21;
            }
            throw new RuntimeException("Expected WKT tag, such as POINT, LINESTRING, etc. Found \"" + string + "\", instead.");
        }

        @Override
        public int readInnerLabel() {
            int n = 0;
            try {
                n = this.m_tokenizer.nextToken();
                if (n != 44 && n != 41 && n != -3) {
                    throw new RuntimeException("Unexpected WKT token");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype + " ");
            }
            if (n != -3) {
                if (n == 41) {
                    --this.m_currentParanLevel;
                }
                return n;
            }
            String string = this.m_tokenizer.sval;
            if (string.equalsIgnoreCase("DEGREE")) {
                return 91;
            }
            if (string.equalsIgnoreCase("CONTROLPOINTS")) {
                return 92;
            }
            if (string.equalsIgnoreCase("NURBSPOINT")) {
                return 93;
            }
            if (string.equalsIgnoreCase("WEIGHTEDPOINT")) {
                return 94;
            }
            if (string.equalsIgnoreCase("WEIGHT")) {
                return 95;
            }
            if (string.equalsIgnoreCase("KNOTS")) {
                return 96;
            }
            if (string.equalsIgnoreCase("KNOT")) {
                return 97;
            }
            if (string.equalsIgnoreCase("VALUE")) {
                return 98;
            }
            if (string.equalsIgnoreCase("MULTIPLICITY")) {
                return 99;
            }
            throw new RuntimeException("Unexpected WKT token: " + string + ", instead of DEGREE, CONTROLPOINTS, etc.");
        }

        @Override
        public void readStartList() {
            try {
                if (this.m_tokenizer.nextToken() != 40) {
                    throw new RuntimeException("" + this.m_tokenizer.ttype);
                }
                this.m_listLengths[this.m_currentParanLevel++].remove(0);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public int readStartList(ByteOrder byteOrder) throws RuntimeException {
            try {
                if (this.m_tokenizer.nextToken() != 40) {
                    throw new RuntimeException("Opening parentheses missing " + this.m_tokenizer.ttype);
                }
                return this.m_listLengths[this.m_currentParanLevel++].remove(0);
            }
            catch (Exception exception) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                try {
                    exception.printStackTrace(printWriter);
                    String string = stringWriter.toString();
                    throw new RuntimeException(string);
                }
                catch (Throwable throwable) {
                    try {
                        if (printWriter != null) {
                            printWriter.close();
                            printWriter = null;
                        }
                        if (stringWriter != null) {
                            stringWriter.close();
                            stringWriter = null;
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        throw new RuntimeException(iOException.getMessage());
                    }
                    throw throwable;
                }
            }
        }

        protected List<Integer>[] readListLengths(CustomStreamTokenizer customStreamTokenizer, int[] nArray) {
            List[] listArray = new List[10];
            for (int i = 0; i < 10; ++i) {
                listArray[i] = new ArrayList();
            }
            try {
                int[] nArray2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                int n = 0;
                int n2 = 0;
                boolean bl = false;
                customStreamTokenizer.nextToken();
                do {
                    int n3;
                    if ((n3 = customStreamTokenizer.nextToken()) == -1 && n != 0) {
                        throw new RuntimeException("Missing opening or closing parenthesis");
                    }
                    switch (n3) {
                        case 40: {
                            nArray2[n] = 1;
                            ++n;
                            break;
                        }
                        case 41: {
                            listArray[--n].add(nArray2[n]);
                            if (bl) break;
                            nArray[0] = n2;
                            bl = true;
                            break;
                        }
                        case 44: {
                            int n4 = n - 1;
                            nArray2[n4] = nArray2[n4] + 1;
                            if (bl) break;
                            if (n2 > 1) {
                                nArray[0] = n2;
                                bl = true;
                                break;
                            }
                            n2 = 0;
                            break;
                        }
                        case -2: {
                            ++n2;
                        }
                    }
                } while (n > 0);
                return listArray;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new RuntimeException(iOException);
            }
        }

        @Override
        public void readEndList() {
            --this.m_currentParanLevel;
            try {
                if (this.m_tokenizer.nextToken() != 41) {
                    throw new RuntimeException("Unexpected WKT token, instead of end of list.");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public void readEndListOrSeparator() {
            try {
                int n = this.m_tokenizer.nextToken();
                if (n != 41 && n != 44) {
                    throw new RuntimeException("Unexpected WKT token, instead of end of list or separator.");
                }
                if (n == 41) {
                    --this.m_currentParanLevel;
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public void readSeparator() {
            try {
                if (this.m_tokenizer.nextToken() != 44) {
                    throw new RuntimeException("Unexpected WKT token, instead of separator.");
                }
            }
            catch (Exception exception) {
                throw new RuntimeException("" + this.m_tokenizer.ttype);
            }
        }

        @Override
        public int readByte() throws GeometryExceptionWithContext {
            return -1;
        }

        @Override
        public ByteOrder readByteOrder() throws GeometryExceptionWithContext {
            return ByteOrder.BIG_ENDIAN;
        }

        protected StreamTokenizer tokenizeWKT(String string) {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new BufferedReader(new StringReader(string)));
            streamTokenizer.eolIsSignificant(false);
            streamTokenizer.lowerCaseMode(true);
            streamTokenizer.parseNumbers();
            streamTokenizer.slashSlashComments(false);
            streamTokenizer.slashStarComments(false);
            return streamTokenizer;
        }

        protected CustomStreamTokenizer CustomTokenizeWKT(String string) {
            CustomStreamTokenizer customStreamTokenizer = new CustomStreamTokenizer(new BufferedReader(new StringReader(string)));
            customStreamTokenizer.eolIsSignificant(false);
            customStreamTokenizer.lowerCaseMode(false);
            customStreamTokenizer.parseNumbers();
            customStreamTokenizer.slashSlashComments(false);
            customStreamTokenizer.slashStarComments(false);
            return customStreamTokenizer;
        }
    }
}

