/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;
import oracle.jdbc.internal.OracleConnection;
import oracle.spatial.util.Util;
import oracle.sql.BLOB;
import oracle.sql.Datum;
import oracle.sql.STRUCT;

public class PCPyramidFilter {
    public static void filterPointsUpPyramid(STRUCT sTRUCT, int n) throws IOException, SQLException {
        OracleConnection oracleConnection = sTRUCT.getInternalConnection();
        Datum[] datumArray = sTRUCT.getOracleAttributes();
        int n2 = datumArray[2].intValue();
        String string = datumArray[3].stringValue();
        int n3 = datumArray[7].intValue();
        PCPyramidFilter.filterPointsUpPyramidForAllParentLevels((OraclePreparedStatement)oracleConnection.prepareStatement("select blk_id, points from " + Util.enquoteTableName((Connection)oracleConnection, string) + " where obj_id = ? and gen_blk_id = ?"), (OraclePreparedStatement)oracleConnection.prepareStatement("update " + Util.enquoteTableName((Connection)oracleConnection, string) + " set points = ?, num_points = ?, num_unsorted_points=0 where obj_id = ? and blk_id = ?"), (OraclePreparedStatement)oracleConnection.prepareStatement("select blk_id from " + Util.enquoteTableName((Connection)oracleConnection, string) + " where obj_id = ? and pcblk_min_res = ?"), (OraclePreparedStatement)oracleConnection.prepareStatement("select max(pcblk_min_res) from " + Util.enquoteTableName((Connection)oracleConnection, string) + " where obj_id = ?"), n3, n, n2);
    }

    private static void filterPointsUpPyramidForAllParentLevels(OraclePreparedStatement oraclePreparedStatement, OraclePreparedStatement oraclePreparedStatement2, OraclePreparedStatement oraclePreparedStatement3, OraclePreparedStatement oraclePreparedStatement4, int n, int n2, int n3) throws IOException, SQLException {
        oraclePreparedStatement4.setInt(1, n3);
        OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement4.executeQuery();
        if (!oracleResultSet.next()) {
            throw new RuntimeException();
        }
        int n4 = oracleResultSet.getInt(1);
        for (int i = 2; i <= n4; ++i) {
            PCPyramidFilter.filterPointsUpPyramidForParentLevel(oraclePreparedStatement, oraclePreparedStatement2, oraclePreparedStatement3, n, i, n2 == 1 && i == 2, n3);
        }
    }

    private static void filterPointsUpPyramidForParentLevel(OraclePreparedStatement oraclePreparedStatement, OraclePreparedStatement oraclePreparedStatement2, OraclePreparedStatement oraclePreparedStatement3, int n, int n2, boolean bl, int n3) throws IOException, SQLException {
        oraclePreparedStatement3.setInt(1, n3);
        oraclePreparedStatement3.setInt(2, n2);
        OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement3.executeQuery();
        Vector<Integer> vector = new Vector<Integer>();
        while (oracleResultSet.next()) {
            vector.add(oracleResultSet.getInt(1));
        }
        oracleResultSet.close();
        for (int i = 0; i < vector.size(); ++i) {
            PCPyramidFilter.filterPointsUpPyramidForParentId(oraclePreparedStatement, oraclePreparedStatement2, n, (Integer)vector.get(i), bl, n3);
        }
    }

    private static void filterPointsUpPyramidForParentId(OraclePreparedStatement oraclePreparedStatement, OraclePreparedStatement oraclePreparedStatement2, int n, int n2, boolean bl, int n3) throws IOException, SQLException {
        System.out.println("Filter parent " + n2);
        ChildBlocks childBlocks = new ChildBlocks(oraclePreparedStatement, n2, n, n3);
        Block block = new Block((oracle.jdbc.OracleConnection)oraclePreparedStatement2.getConnection(), n2, n, n3);
        DataOutputStream dataOutputStream = block.getOutputStream();
        DataOutputStream[] dataOutputStreamArray = new DataOutputStream[3];
        int[] nArray = new int[3];
        for (int i = 0; i < 3; ++i) {
            if (childBlocks.m_targetChildBlocks[i] == null) continue;
            dataOutputStreamArray[i] = childBlocks.m_targetChildBlocks[i].getOutputStream();
            nArray[i] = ((ChildBlocks)childBlocks).m_targetChildBlocks[i].m_blkId;
        }
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0, 0, 0};
        childBlocks.filterAllPointsToParent(dataOutputStream, n2, dataOutputStreamArray, nArray, bl, nArray2, nArray3);
        block.executeUpdate(oraclePreparedStatement2);
        if (!bl) {
            for (int i = 0; i < 3; ++i) {
                if (childBlocks.m_targetChildBlocks[i] == null) continue;
                childBlocks.m_targetChildBlocks[i].executeUpdate(oraclePreparedStatement2);
            }
        }
    }

    private static class ChildBlocks {
        private final Block[] m_sourceChildBlocks = new Block[3];
        private final Block[] m_targetChildBlocks = new Block[3];
        private final PointRecord[] m_nextRecordInSourceChildBlocks = new PointRecord[3];

        private ChildBlocks(OraclePreparedStatement oraclePreparedStatement, int n, int n2, int n3) throws IOException, SQLException {
            oraclePreparedStatement.setInt(1, n3);
            oraclePreparedStatement.setInt(2, n);
            OracleResultSet oracleResultSet = (OracleResultSet)oraclePreparedStatement.executeQuery();
            int n4 = 0;
            while (oracleResultSet.next()) {
                this.m_sourceChildBlocks[n4] = new Block(oracleResultSet, n2, n3);
                this.m_targetChildBlocks[n4] = new Block((oracle.jdbc.OracleConnection)oraclePreparedStatement.getConnection(), this.m_sourceChildBlocks[n4].m_blkId, n2, n3);
                this.m_nextRecordInSourceChildBlocks[n4] = new PointRecord(n2);
                this.m_sourceChildBlocks[n4].readNextPointRecord(this.m_nextRecordInSourceChildBlocks[n4]);
                ++n4;
            }
            if (n4 == 2) {
                this.m_sourceChildBlocks[n4] = null;
                this.m_targetChildBlocks[n4] = null;
                this.m_nextRecordInSourceChildBlocks[n4] = null;
            }
            oracleResultSet.close();
        }

        private double getSortedDimVal(int n) {
            if (this.m_nextRecordInSourceChildBlocks[n] == null) {
                return Double.MAX_VALUE;
            }
            return this.m_nextRecordInSourceChildBlocks[n].m_record[1 - 1];
        }

        private int getChildNumWithSmallestSortedDimVal() {
            double d = this.getSortedDimVal(0);
            double d2 = this.getSortedDimVal(1);
            double d3 = this.getSortedDimVal(2);
            if (d < d2) {
                if (d < d3) {
                    return 0;
                }
                return 2;
            }
            if (d2 < d3) {
                return 1;
            }
            return 2;
        }

        private void filterNextPointToParent(DataOutputStream dataOutputStream, int n, DataOutputStream[] dataOutputStreamArray, int[] nArray, boolean bl, int[] nArray2, int[] nArray3) throws IOException {
            int n2 = this.getChildNumWithSmallestSortedDimVal();
            nArray2[0] = nArray2[0] + 1;
            this.m_nextRecordInSourceChildBlocks[n2].writePt(dataOutputStream, n, nArray2[0]);
            if (!this.m_sourceChildBlocks[n2].readNextPointRecord(this.m_nextRecordInSourceChildBlocks[n2])) {
                this.m_nextRecordInSourceChildBlocks[n2] = null;
            } else if (!bl) {
                int n3 = n2;
                int n4 = nArray3[n3] + 1;
                nArray3[n3] = n4;
                this.m_nextRecordInSourceChildBlocks[n2].writePt(dataOutputStreamArray[n2], nArray[n2], n4);
                if (!this.m_sourceChildBlocks[n2].readNextPointRecord(this.m_nextRecordInSourceChildBlocks[n2])) {
                    this.m_nextRecordInSourceChildBlocks[n2] = null;
                }
            }
        }

        private void filterAllPointsToParent(DataOutputStream dataOutputStream, int n, DataOutputStream[] dataOutputStreamArray, int[] nArray, boolean bl, int[] nArray2, int[] nArray3) throws IOException {
            while (this.m_nextRecordInSourceChildBlocks[0] != null || this.m_nextRecordInSourceChildBlocks[1] != null || this.m_nextRecordInSourceChildBlocks[2] != null) {
                this.filterNextPointToParent(dataOutputStream, n, dataOutputStreamArray, nArray, bl, nArray2, nArray3);
            }
        }
    }

    private static class Block {
        private final OracleBlob m_block;
        protected final int m_objId;
        protected final int m_blkId;
        private final DataInputStream m_is;
        private final DataOutputStream m_os;
        private final int m_numDims;
        private long m_pointRecordsLeft;
        private final int m_sort_dim = 1;

        private Block(OracleResultSet oracleResultSet, int n, int n2) throws SQLException {
            this.m_objId = n2;
            this.m_blkId = oracleResultSet.getInt(1);
            this.m_block = oracleResultSet.getBLOB(2);
            this.m_is = new DataInputStream(this.m_block.getBinaryStream());
            this.m_os = null;
            this.m_numDims = n;
            this.m_pointRecordsLeft = this.m_block.length() / (long)((n + 1) * 8);
        }

        private Block(oracle.jdbc.OracleConnection oracleConnection, int n, int n2, int n3) throws SQLException {
            this.m_objId = n3;
            this.m_blkId = n;
            this.m_block = BLOB.createTemporary((Connection)oracleConnection, (boolean)true, (int)10);
            this.m_is = null;
            this.m_os = new DataOutputStream(this.m_block.setBinaryStream(1L));
            this.m_numDims = n2;
            this.m_pointRecordsLeft = -1L;
        }

        private DataOutputStream getOutputStream() throws SQLException {
            return this.m_os;
        }

        private void executeUpdate(OraclePreparedStatement oraclePreparedStatement) throws IOException, SQLException {
            this.m_os.flush();
            oraclePreparedStatement.setBlob(1, (Blob)this.m_block);
            oraclePreparedStatement.setLong(2, this.m_block.length() / (long)((this.m_numDims + 1) * 8));
            oraclePreparedStatement.setInt(3, this.m_objId);
            oraclePreparedStatement.setInt(4, this.m_blkId);
            oraclePreparedStatement.executeUpdate();
        }

        private boolean readNextPointRecord(PointRecord pointRecord) throws IOException {
            if (this.m_pointRecordsLeft == 0L) {
                return false;
            }
            pointRecord.readPt(this.m_is);
            --this.m_pointRecordsLeft;
            return true;
        }
    }

    private static class PointRecord {
        private int m_blkId;
        private int m_ptId;
        private final double[] m_record;

        private PointRecord(int n) {
            this.m_record = new double[n];
        }

        private void readPt(DataInputStream dataInputStream) throws IOException {
            for (int i = 0; i < this.m_record.length; ++i) {
                this.m_record[i] = dataInputStream.readDouble();
            }
            this.m_blkId = dataInputStream.readInt();
            this.m_ptId = dataInputStream.readInt();
        }

        protected void writePt(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
            for (int i = 0; i < this.m_record.length; ++i) {
                dataOutputStream.writeDouble(this.m_record[i]);
            }
            dataOutputStream.writeInt(n);
            dataOutputStream.writeInt(n2);
        }
    }
}

