/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;

public class Las2SqlLdr {
    private static final DecimalFormat f = new DecimalFormat(" 0000000000.00000;-0000000000.00000");
    private static final DecimalFormat h = new DecimalFormat("00000000000000000000");
    private static final DecimalFormat p = new DecimalFormat("00");
    private static final int LAS_ATTR_ALL_ATTRIBUTES_BIN = 101;
    private static final int LAS_ATTR_INTENSITY = 102;
    private static final int LAS_ATTR_RETURN_NUMBER = 103;
    private static final int LAS_ATTR_NUMBER_OF_RETURNS = 104;
    private static final int LAS_ATTR_SCAN_DIRECTION_FLAG = 105;
    private static final int LAS_ATTR_EDGE_OF_FLIGHT_LINE = 106;
    private static final int LAS_ATTR_CLASSIFICATION = 107;
    private static final int LAS_ATTR_SCAN_ANGLE_RANK = 108;
    private static final int LAS_ATTR_USER_DATA = 109;
    private static final int LAS_ATTR_POINT_SOURCE_ID = 110;
    private static final int LAS_ATTR_GPS_TIME = 111;
    private static final int LAS_ATTR_RED = 112;
    private static final int LAS_ATTR_GREEN = 113;
    private static final int LAS_ATTR_BLUE = 114;
    private static final int LAS_ATTR_CLASSIFICATION_FLAGS = 115;
    private static final int LAS_ATTR_SCANNER_CHANNEL = 116;
    private static final int NON_LAS_ATTR_POS_IN_LAS_FILE = 150;
    private static final int LAS10 = 201;
    private static final int LAS11 = 202;
    private static final int LAS12 = 203;
    private static final int LAS13 = 204;
    private static final int LAS14 = 205;
    private static final int LAS_PT_FORMAT0 = 301;
    private static final int LAS_PT_FORMAT1 = 302;
    private static final int LAS_PT_FORMAT2 = 303;
    private static final int LAS_PT_FORMAT3 = 304;
    private static final int LAS_PT_FORMAT4 = 305;
    private static final int LAS_PT_FORMAT5 = 306;
    private static final int LAS_PT_FORMAT6 = 307;
    private static final int LAS_PT_FORMAT7 = 308;
    private static final int LAS_PT_FORMAT8 = 309;
    private static final int LAS_PT_FORMAT9 = 310;
    private static final int LAS_PT_FORMAT10 = 311;

    public static long hilbert_xy2d(long l, long l2, long l3) {
        long l4 = 0L;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = l2;
        long l8 = l3;
        for (long i = l >> 1; i >= 1L; i >>= 1) {
            l4 = (l7 & i) > 0L ? 1 : 0;
            l5 = (l8 & i) > 0L ? 1 : 0;
            l6 += i * i * (3L * l4 ^ l5);
            if (l5 != 0L) continue;
            if (l4 == 1L) {
                l7 = i - 1L - l7;
                l8 = i - 1L - l8;
            }
            long l9 = l7;
            l7 = l8;
            l8 = l9;
        }
        return l6;
    }

    public static long mortonExpand(int n) {
        long l = (long)n & Integer.MAX_VALUE;
        l = (l ^ l << 16) & 0xFFFF0000FFFFL;
        l = (l ^ l << 8) & 0xFF00FF00FF00FFL;
        l = (l ^ l << 4) & 0xF0F0F0F0F0F0F0FL;
        l = (l ^ l << 2) & 0x3333333333333333L;
        l = (l ^ l << 1) & 0x5555555555555555L;
        return l;
    }

    public static long mortonEncode2D(int n, int n2) {
        return (Las2SqlLdr.mortonExpand(n) << 1) + Las2SqlLdr.mortonExpand(n2);
    }

    private static void skipBytes(DataInputStream dataInputStream, long l) throws IOException {
        dataInputStream.skipBytes((int)l);
    }

    private static int getLasVersion(int n, int n2) {
        switch (n) {
            case 1: {
                switch (n2) {
                    case 0: {
                        return 201;
                    }
                    case 1: {
                        return 202;
                    }
                    case 2: {
                        return 203;
                    }
                    case 3: {
                        return 204;
                    }
                    case 4: {
                        return 205;
                    }
                }
                throw new RuntimeException("LAS Version " + n + "." + n2 + " not supported.");
            }
        }
        throw new RuntimeException("LAS Version " + n + "." + n2 + " not supported.");
    }

    public static void readFile(DataInputStream dataInputStream, int[] nArray, BufferedOutputStream bufferedOutputStream) throws IOException {
        byte[] byArray = new byte[8];
        long l = Math.round(Math.pow(2.0, 31.0));
        Las2SqlLdr.skipBytes(dataInputStream, 24L);
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        int n3 = Las2SqlLdr.getLasVersion(n, n2);
        Las2SqlLdr.skipBytes(dataInputStream, 68L);
        int n4 = dataInputStream.readUnsignedByte();
        int n5 = dataInputStream.readUnsignedByte();
        int n6 = n4 + n5 * 256;
        dataInputStream.readFully(byArray, 0, 4);
        long l2 = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        Las2SqlLdr.skipBytes(dataInputStream, 4L);
        int n7 = 301 + dataInputStream.readUnsignedByte();
        int n8 = 12;
        int n9 = 14;
        int n10 = 14;
        int n11 = 15;
        int n12 = 16;
        int n13 = 17;
        int n14 = 18;
        int n15 = 20;
        int n16 = 28;
        switch (n7) {
            case 301: {
                n15 = -1;
                n16 = -1;
                n10 = -1;
                break;
            }
            case 302: {
                n16 = -1;
                n10 = -1;
                break;
            }
            case 303: {
                n15 = -1;
                n16 = 20;
                n10 = -1;
                break;
            }
            case 304: {
                n10 = -1;
                break;
            }
            case 305: {
                n16 = -1;
                n10 = -1;
                break;
            }
            case 306: {
                n10 = -1;
                break;
            }
            case 307: {
                n15 = 22;
                n16 = -1;
                n9 = -1;
                n9 = -1;
                break;
            }
            case 308: {
                n15 = 22;
                n16 = 30;
                n9 = -1;
                n9 = -1;
                break;
            }
            default: {
                throw new RuntimeException("Point format id " + (n7 - 301) + " not yet supported");
            }
        }
        n4 = dataInputStream.readUnsignedByte();
        n5 = dataInputStream.readUnsignedByte();
        int n17 = n4 + n5 * 256;
        byte[] byArray2 = new byte[n17];
        dataInputStream.readFully(byArray, 0, 4);
        long l3 = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
        Las2SqlLdr.skipBytes(dataInputStream, 20L);
        dataInputStream.readFully(byArray, 0, 8);
        double d = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d2 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d3 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d4 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d5 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d6 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d7 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d8 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d9 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d10 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d11 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        dataInputStream.readFully(byArray, 0, 8);
        double d12 = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
        Las2SqlLdr.skipBytes(dataInputStream, l2 - (long)n6);
        long l4 = System.currentTimeMillis();
        int n18 = 0;
        while ((long)n18 < l3) {
            dataInputStream.readFully(byArray2, 0, n17);
            double d13 = (double)(byArray2[3] << 24 | (byArray2[2] & 0xFF) << 16 | (byArray2[1] & 0xFF) << 8 | byArray2[0] & 0xFF) * d + d4;
            double d14 = (double)(byArray2[7] << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF) * d2 + d5;
            double d15 = (double)(byArray2[11] << 24 | (byArray2[10] & 0xFF) << 16 | (byArray2[9] & 0xFF) << 8 | byArray2[8] & 0xFF) * d3 + d6;
            long l5 = Las2SqlLdr.hilbert_xy2d(l, Math.round(d13) + l / 2L, Math.round(d14) + l / 2L);
            int n19 = Las2SqlLdr.getPyramidLevel(n18 + 1);
            if (bufferedOutputStream != null) {
                Las2SqlLdr.writePtToCsvStream(bufferedOutputStream, byArray2, nArray, d13, d14, d15, l5, n19, n8, n9, n10, n11, n12, n13, n14, n15, n16, n18);
            }
            ++n18;
        }
        long l6 = System.currentTimeMillis();
        if (bufferedOutputStream == null) {
            System.out.printf(" %,8.3f s\n", (double)(l6 - l4) / 1000.0);
        }
    }

    public static String printHexBinary(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (byte by : byArray) {
            stringBuilder.append(Long.toHexString(by >> 4 & 0xF));
            stringBuilder.append(Long.toHexString(by & 0xF));
        }
        return stringBuilder.toString();
    }

    private static void writePtToCsvStream(BufferedOutputStream bufferedOutputStream, byte[] byArray, int[] nArray, double d, double d2, double d3, long l, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, long l2) throws IOException {
        bufferedOutputStream.write((f.format(d) + ", " + f.format(d2) + ", " + f.format(d3) + ", " + h.format(l) + ", " + p.format(n)).getBytes());
        block19: for (int i = 0; i < nArray.length; ++i) {
            bufferedOutputStream.write(", ".getBytes());
            switch (nArray[i]) {
                case 101: {
                    bufferedOutputStream.write(Las2SqlLdr.printHexBinary(byArray).getBytes());
                    continue block19;
                }
                case 102: {
                    if (n2 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ((byArray[n2] & 0xFF) + 256 * (byArray[n2 + 1] & 0xFF))).getBytes());
                    continue block19;
                }
                case 103: {
                    if (n3 > -1) {
                        bufferedOutputStream.write(("" + (byArray[n3] >>> 0 & 7)).getBytes());
                        continue block19;
                    }
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3] >>> 0 & 0xF)).getBytes());
                    continue block19;
                }
                case 104: {
                    if (n3 > -1) {
                        bufferedOutputStream.write(("" + (byArray[n3] >>> 3 & 7)).getBytes());
                        continue block19;
                    }
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3] >>> 4 & 0xF)).getBytes());
                    continue block19;
                }
                case 115: {
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3 + 1] >>> 0 & 0xF)).getBytes());
                    continue block19;
                }
                case 116: {
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3 + 1] >>> 4 & 3)).getBytes());
                    continue block19;
                }
                case 105: {
                    if (n3 > -1) {
                        bufferedOutputStream.write(("" + (byArray[n3] >>> 6 & 1)).getBytes());
                        continue block19;
                    }
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3 + 1] >>> 6 & 1)).getBytes());
                    continue block19;
                }
                case 106: {
                    if (n3 > -1) {
                        bufferedOutputStream.write(("" + (byArray[n3] >>> 7 & 1)).getBytes());
                        continue block19;
                    }
                    if (n4 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n3 + 1] >>> 7 & 1)).getBytes());
                    continue block19;
                }
                case 107: {
                    if (n5 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n5] & 0xFF)).getBytes());
                    continue block19;
                }
                case 108: {
                    if (n6 <= -1) continue block19;
                    bufferedOutputStream.write(("" + byArray[n6]).getBytes());
                    continue block19;
                }
                case 109: {
                    if (n7 <= -1) continue block19;
                    bufferedOutputStream.write(("" + (byArray[n7] & 0xFF)).getBytes());
                    continue block19;
                }
                case 110: {
                    if (n8 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ((byArray[n8] & 0xFF) + 256 * (byArray[n8 + 1] & 0xFF))).getBytes());
                    continue block19;
                }
                case 111: {
                    if (n9 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ByteBuffer.wrap(byArray, n9 + 0, 8).order(ByteOrder.LITTLE_ENDIAN).getDouble()).getBytes());
                    continue block19;
                }
                case 112: {
                    if (n10 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ((byArray[n10] & 0xFF) + 256 * (byArray[n10 + 1] & 0xFF))).getBytes());
                    continue block19;
                }
                case 113: {
                    if (n10 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ((byArray[n10 + 2] & 0xFF) + 256 * (byArray[n10 + 3] & 0xFF))).getBytes());
                    continue block19;
                }
                case 114: {
                    if (n10 <= -1) continue block19;
                    bufferedOutputStream.write(("" + ((byArray[n10 + 4] & 0xFF) + 256 * (byArray[n10 + 5] & 0xFF))).getBytes());
                    continue block19;
                }
                case 150: {
                    bufferedOutputStream.write(("" + l2).getBytes());
                    continue block19;
                }
                default: {
                    throw new RuntimeException("Unsupported Attribute");
                }
            }
        }
        bufferedOutputStream.write("\n".getBytes());
    }

    public static int getPyramidLevel(long l) {
        int n = 10;
        int n2 = 1;
        while (l % (long)n <= 0L) {
            n *= 10;
            ++n2;
        }
        return n2;
    }

    public static void readFile(String string, int[] nArray, BufferedOutputStream bufferedOutputStream) {
        try {
            DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(string.compareToIgnoreCase("stdin") == 0 ? System.in : new FileInputStream(string)));
            Las2SqlLdr.readFile(dataInputStream, nArray, bufferedOutputStream);
            if (bufferedOutputStream != null) {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public static void main(String[] stringArray) {
        int n;
        int[] nArray = new int[stringArray.length - 1];
        int n2 = 1;
        for (n = 1; n < stringArray.length; ++n) {
            if (stringArray[n].compareToIgnoreCase("ALL_ATTRIBUTES_BIN") == 0) {
                nArray[n - n2] = 101;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("INTENSITY") == 0) {
                nArray[n - n2] = 102;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("RETURN_NUMBER") == 0) {
                nArray[n - n2] = 103;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("NUMBER_OF_RETURNS") == 0) {
                nArray[n - n2] = 104;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("SCAN_DIRECTION_FLAG") == 0) {
                nArray[n - n2] = 105;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("EDGE_OF_FLIGHT_LINE") == 0) {
                nArray[n - n2] = 106;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("CLASSIFICATION") == 0) {
                nArray[n - n2] = 107;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("CLASSIFICATION_FLAGS") == 0) {
                nArray[n - n2] = 115;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("SCAN_ANGLE_RANK") == 0) {
                nArray[n - n2] = 108;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("SCANNER_CHANNEL") == 0) {
                nArray[n - n2] = 116;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("USER_DATA") == 0) {
                nArray[n - n2] = 109;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("POINT_SOURCE_ID") == 0) {
                nArray[n - n2] = 110;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("GPS_TIME") == 0) {
                nArray[n - n2] = 111;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("RED") == 0) {
                nArray[n - n2] = 112;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("GREEN") == 0) {
                nArray[n - n2] = 113;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("BLUE") == 0) {
                nArray[n - n2] = 114;
                continue;
            }
            if (stringArray[n].compareToIgnoreCase("POS_IN_LAS_FILE") == 0) {
                nArray[n - n2] = 150;
                continue;
            }
            if (stringArray[n].startsWith("!")) {
                ++n2;
                continue;
            }
            throw new RuntimeException("Parameter " + stringArray[n] + " unknown");
        }
        int[] nArray2 = new int[nArray.length - n2 + 1];
        for (n = 0; n < nArray2.length; ++n) {
            nArray2[n] = nArray[n];
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(System.out);
        Las2SqlLdr.readFile(stringArray[0], nArray2, bufferedOutputStream);
    }

    public static class LasFileStream {
        private final DataInputStream m_dis;
        private final long m_numPointRecordsTotal;
        private final int m_pointDataRecordLen;
        private int m_numPoint;
        private int m_numPointRecordsReadFromFile;
        private final byte[] m_bufferPoint;
        private static final long N = Math.round(Math.pow(2.0, 31.0));
        private final double scaleFactorX;
        private final double scaleFactorY;
        private final double scaleFactorZ;
        private final double offsetX;
        private final double offsetY;
        private final double offsetZ;
        private final double minX;
        private final double maxX;
        private final double minY;
        private final double maxY;
        private final double minZ;
        private final double maxZ;
        public long m_totalReadingTime = 0L;

        public LasFileStream(String string) throws IOException {
            this(new DataInputStream(new BufferedInputStream(string.compareToIgnoreCase("stdin") == 0 ? System.in : new FileInputStream(string))));
        }

        public LasFileStream(DataInputStream dataInputStream) throws IOException {
            byte[] byArray = new byte[8];
            this.m_dis = dataInputStream;
            Las2SqlLdr.skipBytes(this.m_dis, 24L);
            int n = this.m_dis.readUnsignedByte();
            int n2 = this.m_dis.readUnsignedByte();
            int n3 = Las2SqlLdr.getLasVersion(n, n2);
            Las2SqlLdr.skipBytes(this.m_dis, 68L);
            int n4 = this.m_dis.readUnsignedByte();
            int n5 = this.m_dis.readUnsignedByte();
            int n6 = n4 + n5 * 256;
            this.m_dis.readFully(byArray, 0, 4);
            long l = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            Las2SqlLdr.skipBytes(this.m_dis, 4L);
            this.m_dis.readUnsignedByte();
            n4 = this.m_dis.readUnsignedByte();
            n5 = this.m_dis.readUnsignedByte();
            this.m_pointDataRecordLen = n4 + n5 * 256;
            this.m_bufferPoint = new byte[this.m_pointDataRecordLen];
            this.m_dis.readFully(byArray, 0, 4);
            this.m_numPointRecordsTotal = byArray[3] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[1] & 0xFF) << 8 | byArray[0] & 0xFF;
            Las2SqlLdr.skipBytes(this.m_dis, 20L);
            this.m_dis.readFully(byArray, 0, 8);
            this.scaleFactorX = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.scaleFactorY = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.scaleFactorZ = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.offsetX = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.offsetY = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.offsetZ = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.maxX = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.minX = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.maxY = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.minY = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.maxZ = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            this.m_dis.readFully(byArray, 0, 8);
            this.minZ = ByteBuffer.wrap(byArray).order(ByteOrder.LITTLE_ENDIAN).getDouble();
            Las2SqlLdr.skipBytes(this.m_dis, l - (long)n6);
            this.m_numPointRecordsReadFromFile = 0;
        }

        public boolean addPoints(PointData pointData) throws IOException {
            long l = pointData.getNumPointsFree();
            if (l > this.m_numPointRecordsTotal - (long)this.m_numPointRecordsReadFromFile) {
                l = this.m_numPointRecordsTotal - (long)this.m_numPointRecordsReadFromFile;
            }
            if (l == 0L) {
                return (long)this.m_numPointRecordsReadFromFile < this.m_numPointRecordsTotal;
            }
            System.out.printf("Reading %,19d points...", l);
            long l2 = System.currentTimeMillis();
            int n = 0;
            while ((long)n < l) {
                this.m_dis.readFully(this.m_bufferPoint, 0, this.m_pointDataRecordLen);
                double d = (double)(this.m_bufferPoint[3] << 24 | (this.m_bufferPoint[2] & 0xFF) << 16 | (this.m_bufferPoint[1] & 0xFF) << 8 | this.m_bufferPoint[0] & 0xFF) * this.scaleFactorX + this.offsetX;
                double d2 = (double)(this.m_bufferPoint[7] << 24 | (this.m_bufferPoint[6] & 0xFF) << 16 | (this.m_bufferPoint[5] & 0xFF) << 8 | this.m_bufferPoint[4] & 0xFF) * this.scaleFactorY + this.offsetY;
                double d3 = (double)(this.m_bufferPoint[11] << 24 | (this.m_bufferPoint[10] & 0xFF) << 16 | (this.m_bufferPoint[9] & 0xFF) << 8 | this.m_bufferPoint[8] & 0xFF) * this.scaleFactorZ + this.offsetZ;
                long l3 = Las2SqlLdr.hilbert_xy2d(N, Math.round(d) + N / 2L, Math.round(d2) + N / 2L);
                pointData.addPoint(d, d2, d3, l3);
                ++n;
            }
            long l4 = System.currentTimeMillis();
            this.m_numPointRecordsReadFromFile = (int)((long)this.m_numPointRecordsReadFromFile + l);
            this.m_totalReadingTime += l4 - l2;
            System.out.printf(" %,8.3f s. ", (double)(l4 - l2) / 1000.0);
            pointData.sortByHilbertValue();
            return (long)this.m_numPointRecordsReadFromFile < this.m_numPointRecordsTotal;
        }

        public boolean hasMore() {
            return (long)this.m_numPoint < this.m_numPointRecordsTotal;
        }
    }

    public static class PointData {
        private final double[] m_x;
        private final double[] m_y;
        private final double[] m_z;
        private final long[] m_hilbert;
        private final Integer[] m_posInDataArray;
        private int m_posMin;
        private int m_posMax;
        private boolean m_isSortedByHilbert;
        public boolean m_morePointsToReadFromLasFile;
        public final LasFileStream m_lasFileStream;
        public long m_totalSortingTime = 0L;

        public PointData(int n, String string) throws IOException {
            this.m_x = new double[n];
            this.m_y = new double[n];
            this.m_z = new double[n];
            this.m_hilbert = new long[n];
            this.m_posInDataArray = new Integer[n];
            for (int i = 0; i < n; ++i) {
                this.m_posInDataArray[i] = i;
            }
            this.m_posMin = n;
            this.m_lasFileStream = new LasFileStream(string);
            this.loadMoreFromLas();
        }

        private void sortByHilbertValue() {
            System.out.printf("Sorting:", new Object[0]);
            long l = System.currentTimeMillis();
            if (!this.m_isSortedByHilbert) {
                Arrays.sort(this.m_posInDataArray, this.m_posMin, this.m_posInDataArray.length, new Comparator<Integer>(){

                    @Override
                    public int compare(Integer n, Integer n2) {
                        if (m_hilbert[n] < m_hilbert[n2]) {
                            return -1;
                        }
                        if (m_hilbert[n] > m_hilbert[n2]) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            this.m_isSortedByHilbert = true;
            long l2 = System.currentTimeMillis();
            this.m_totalSortingTime += l2 - l;
            System.out.printf(" %,8.3f s.", (double)(l2 - l) / 1000.0);
        }

        public int getNumPointsRemaining() {
            return this.m_x.length - this.m_posMin;
        }

        public int getNumPointsFree() {
            return this.m_posMin;
        }

        public void loadMoreFromLas() throws IOException {
            this.m_morePointsToReadFromLasFile = this.m_lasFileStream.addPoints(this);
            this.m_isSortedByHilbert = false;
        }

        public void addPoint(double d, double d2, double d3, long l) {
            int n = this.m_posInDataArray[--this.m_posMin];
            this.m_x[n] = d;
            this.m_y[n] = d2;
            this.m_z[n] = d3;
            this.m_hilbert[n] = l;
        }

        public void subtractPointWithLowestHilbert(SinglePoint singlePoint) {
            int n = this.m_posInDataArray[this.m_posMin++];
            singlePoint.m_x = this.m_x[n];
            singlePoint.m_y = this.m_y[n];
            singlePoint.m_z = this.m_z[n];
            singlePoint.m_hilbert = this.m_hilbert[n];
        }

        public static class MBR {
            public double m_minX;
            public double m_maxX;
            public double m_minY;
            public double m_maxY;

            public void initMBR(SinglePoint singlePoint) {
                this.m_minX = this.m_maxX = singlePoint.m_x;
                this.m_minY = this.m_maxY = singlePoint.m_y;
            }

            public void updateMBR(SinglePoint singlePoint) {
                if (singlePoint.m_x < this.m_minX) {
                    this.m_minX = singlePoint.m_x;
                }
                if (singlePoint.m_x > this.m_maxX) {
                    this.m_maxX = singlePoint.m_x;
                }
                if (singlePoint.m_y < this.m_minY) {
                    this.m_minY = singlePoint.m_y;
                }
                if (singlePoint.m_y > this.m_maxY) {
                    this.m_maxY = singlePoint.m_y;
                }
            }
        }

        public static class SinglePoint {
            public double m_x = Double.NaN;
            public double m_y = Double.NaN;
            public double m_z = Double.NaN;
            public long m_hilbert = -1L;
        }
    }
}

