/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import oracle.spatial.util.Logger;
import oracle.sql.ARRAY;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.STRUCT;

public class JDBCUtil {
    private static Method struct_unwrap = null;
    private static Method clob_unwrap = null;
    private static Method blob_unwrap = null;
    private static Method array_unwrap = null;
    private static Logger logger = Logger.getLogger("oracle.spatial.util.JDBCUtil");

    public static STRUCT getOracleSTRUCT(ResultSet resultSet, int n) throws Exception {
        Object object = resultSet.getObject(n);
        return JDBCUtil.getOracleSTRUCT(object);
    }

    public static STRUCT getOracleSTRUCT(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        STRUCT sTRUCT = null;
        try {
            sTRUCT = (STRUCT)object;
            return sTRUCT;
        }
        catch (ClassCastException classCastException) {
            if (struct_unwrap == null && (struct_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                logger.info("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (struct_unwrap != null) {
                sTRUCT = (STRUCT)struct_unwrap.invoke(object, STRUCT.class);
                return sTRUCT;
            }
            throw classCastException;
        }
    }

    public static CLOB safeCastCLOB(ResultSet resultSet, int n) throws Exception {
        Clob clob = resultSet.getClob(n);
        return JDBCUtil.safeCastCLOB(clob);
    }

    public static CLOB safeCastCLOB(Clob clob) throws Exception {
        if (clob == null) {
            return null;
        }
        CLOB cLOB = null;
        try {
            cLOB = (CLOB)clob;
            return cLOB;
        }
        catch (ClassCastException classCastException) {
            if (clob_unwrap == null && (clob_unwrap = clob.getClass().getMethod("unwrap", Class.class)) != null) {
                logger.info("Got WLS unwrap method for CLOB through introspect.");
            }
            if (clob_unwrap != null) {
                cLOB = (CLOB)clob_unwrap.invoke((Object)clob, CLOB.class);
                return cLOB;
            }
            return null;
        }
    }

    public static BLOB safeCastBLOB(ResultSet resultSet, int n) throws Exception {
        Blob blob = resultSet.getBlob(n);
        return JDBCUtil.safeCastBLOB(blob);
    }

    public static BLOB safeCastBLOB(Blob blob) throws Exception {
        if (blob == null) {
            return null;
        }
        BLOB bLOB = null;
        try {
            bLOB = (BLOB)blob;
            return bLOB;
        }
        catch (ClassCastException classCastException) {
            if (blob_unwrap == null && (blob_unwrap = blob.getClass().getMethod("unwrap", Class.class)) != null) {
                logger.info("Got WLS unwrap method for BLOB through introspect.");
            }
            if (blob_unwrap != null) {
                bLOB = (BLOB)blob_unwrap.invoke((Object)blob, BLOB.class);
                return bLOB;
            }
            return null;
        }
    }

    public static ARRAY safeCastARRAY(ResultSet resultSet, int n) throws Exception {
        Object object = resultSet.getObject(n);
        return JDBCUtil.safeCastARRAY(object);
    }

    public static ARRAY safeCastARRAY(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        ARRAY aRRAY = null;
        try {
            aRRAY = (ARRAY)object;
            return aRRAY;
        }
        catch (ClassCastException classCastException) {
            if (array_unwrap == null && (array_unwrap = object.getClass().getMethod("unwrap", Class.class)) != null) {
                logger.info("Got WLS unwrap method for STRUCT through introspect.");
            }
            if (array_unwrap != null) {
                aRRAY = (ARRAY)array_unwrap.invoke(object, ARRAY.class);
                return aRRAY;
            }
            throw classCastException;
        }
    }
}

