/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import oracle.spatial.util.DBFFileCodePage;
import oracle.spatial.util.ShapefileReaderJGeom;

public class DBFileHdr {
    byte version;
    byte[] last_update = new byte[3];
    int n_records;
    short header_sz;
    short record_sz;
    byte[] unused1;
    byte xct_flag;
    byte encrypt_flag;
    byte[] unused2;
    byte mdx_flag;
    byte lang_drv_id;
    byte[] unused3;
    byte codePageMark;
    static final int size = 32;
    DBFFileCodePage[] lazyCodePage;

    public void fromBuffer(byte[] byArray) throws IOException {
        try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
             DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);){
            ShapefileReaderJGeom.swapBytes(byArray, 4, 4);
            ShapefileReaderJGeom.swapBytes(byArray, 8, 2);
            ShapefileReaderJGeom.swapBytes(byArray, 10, 2);
            this.version = dataInputStream.readByte();
            for (int i = 0; i < 3; ++i) {
                this.last_update[i] = dataInputStream.readByte();
            }
            this.n_records = dataInputStream.readInt();
            this.header_sz = dataInputStream.readShort();
            this.record_sz = dataInputStream.readShort();
            dataInputStream.skipBytes(17);
            this.codePageMark = dataInputStream.readByte();
        }
    }

    public byte getVersion() {
        return this.version;
    }

    public int getNumberOfRecords() {
        return this.n_records;
    }

    public short getHeaderSize() {
        return this.header_sz;
    }

    public short getRecordSize() {
        return this.record_sz;
    }

    public byte getCodePageMark() {
        return this.codePageMark;
    }

    public DBFFileCodePage getCodePage() {
        if (this.lazyCodePage == null) {
            this.lazyCodePage = new DBFFileCodePage[]{DBFFileCodePage.fromCodePageMark(this.getCodePageMark())};
        }
        return this.lazyCodePage[0];
    }
}

