/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import oracle.jdbc.LargeObjectAccessMode;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleBlob;
import oracle.jdbc.OracleClob;
import oracle.jdbc.driver.OracleSQLException;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JGeometry;
import oracle.spatial.type.SdoNumberArray;
import oracle.spatial.util.GML;
import oracle.spatial.util.GML3g;
import oracle.spatial.util.GeometryExceptionWithContext;
import oracle.spatial.util.JDBCAdapter;
import oracle.spatial.util.KML;
import oracle.spatial.util.Util;
import oracle.spatial.util.WKB;
import oracle.spatial.util.WKT;
import oracle.spatial.util.XMLValidator2;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import org.w3c.dom.Node;

public class Adapters {
    protected static final Connection m_conn;
    protected static final WKB m_wkbAdapter;
    protected static final WKT m_wktAdapter;

    public static Struct wkbToSTRUCT(BLOB bLOB) throws SQLException {
        return Adapters.wkbToSTRUCT(bLOB, m_conn);
    }

    public static Struct wkbToSTRUCT(BLOB bLOB, Connection connection) throws SQLException {
        try {
            return Adapters.wkbToSTRUCT2(bLOB, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static Struct wkbToSTRUCT2(BLOB bLOB, Connection connection) throws SQLException, GeometryExceptionWithContext {
        bLOB.open(0);
        byte[] byArray = bLOB.getBytes(1L, (int)bLOB.length());
        bLOB.close();
        return m_wkbAdapter.toStruct(byArray, connection);
    }

    public static Struct wktToSTRUCT(CLOB cLOB) throws SQLException {
        return Adapters.wktToSTRUCT(cLOB, m_conn);
    }

    public static Struct wktToSTRUCT(CLOB cLOB, Connection connection) throws SQLException {
        try {
            return Adapters.wktToSTRUCT2(cLOB, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static Struct wktToSTRUCT2(CLOB cLOB, Connection connection) throws SQLException, GeometryExceptionWithContext {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return m_wktAdapter.toStruct(string, connection);
    }

    public static Struct wktToSTRUCT(String string) throws SQLException {
        Struct struct = Adapters.wktToSTRUCT(string, m_conn);
        return struct;
    }

    public static Struct wktToSTRUCT(String string, Connection connection) throws SQLException {
        try {
            return Adapters.wktToSTRUCT2(string, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static Struct wktToSTRUCT2(String string, Connection connection) throws SQLException, GeometryExceptionWithContext {
        return m_wktAdapter.toStruct(string, connection);
    }

    public static Struct gmlToSTRUCT(String string) throws SQLException {
        return Adapters.gmlToSTRUCT(string, m_conn);
    }

    public static Struct gml311ToSTRUCT(String string) throws SQLException {
        return Adapters.gml311ToSTRUCT(string, m_conn);
    }

    public static Struct kmlToSTRUCT(String string) throws SQLException {
        return Adapters.kmlToSTRUCT(string, m_conn);
    }

    public static Struct buffer(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4) throws SQLException, Exception {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = jGeometry.buffer(nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue(), nUMBER4.doubleValue());
        if (jGeometry2 == null) {
            return null;
        }
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    public static Struct simplifyVW(Struct struct, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3) throws SQLException, Exception {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = JGeometry.simplifyVW((JGeometry)jGeometry, (double)nUMBER.doubleValue(), (boolean)true, (double)1.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0, (double)1.0, (double)nUMBER2.doubleValue(), (double)nUMBER3.doubleValue());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Struct getNurbsApprox(Struct struct) throws SQLException, Exception {
        boolean bl = false;
        boolean bl2 = false;
        String string = null;
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        if (struct == null) {
            return null;
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        if (jGeometry.getType() % 10 != 2 && jGeometry.getType() % 10 != 4 && jGeometry.getType() % 10 != 6) {
            return struct;
        }
        try {
            string = " select mdsys.mdprvt_srid.is_geodetic(?) from dual ";
            preparedStatement = m_conn.prepareStatement(string);
            preparedStatement.setInt(1, jGeometry.getSRID());
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                bl2 = resultSet.getString(1).equalsIgnoreCase("TRUE");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Error: " + exception.getMessage());
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                    preparedStatement = null;
                }
            }
            catch (SQLException sQLException) {
                System.out.println(sQLException.getMessage());
            }
        }
        if (bl2) {
            throw new Exception("ORA-13107: operation not supported for Non-Uniform Rational B-Spline type");
        }
        for (int i = 0; i < jGeometry.getElemInfo().length; i += 3) {
            if (jGeometry.getElemInfo()[i + 1] != 2 || jGeometry.getElemInfo()[i + 2] != 3) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return struct;
        }
        JGeometry jGeometry2 = JGeometry.getNurbsApprox((JGeometry)jGeometry);
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    public static String anyInteract(Struct struct, Struct struct2, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        Object object;
        Object object2;
        boolean bl = false;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        JGeometry jGeometry2 = JGeometry.loadJS((Struct)struct2, (int)n, (double)d, (double)d2);
        if (string.equals("TRUE") && !jGeometry.isLRSGeometry() && !jGeometry2.isLRSGeometry() && ((double[])(object2 = jGeometry.getMBR())).length != ((double[])(object = jGeometry2.getMBR())).length) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        object2 = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        object = jGeometry2.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        bl = object2.anyInteract((J3D_Geometry)object, nUMBER5.doubleValue(), string);
        if (bl) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static NUMBER distance(Struct struct, Struct struct2, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        Object object;
        Object object2;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        JGeometry jGeometry2 = JGeometry.loadJS((Struct)struct2, (int)n, (double)d, (double)d2);
        if (!(!string.equals("TRUE") || jGeometry.isLRSGeometry() || jGeometry2.isLRSGeometry() || ((double[])(object2 = jGeometry.getMBR())).length == ((double[])(object = jGeometry2.getMBR())).length && ((double[])object2).length == 6 && ((double[])object).length == 6)) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        object2 = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        object = jGeometry2.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        NUMBER nUMBER6 = new NUMBER(object2.distance((J3D_Geometry)object, nUMBER5.doubleValue(), string, d, d2, d3));
        return nUMBER6;
    }

    public static NUMBER length(Struct struct, NUMBER nUMBER, String string, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6) throws Exception {
        Object object;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER4 != null) {
                d3 = nUMBER4.doubleValue();
            }
            if (nUMBER2 != null) {
                d = nUMBER2.doubleValue();
            }
            if (nUMBER3 != null) {
                d2 = nUMBER3.doubleValue();
            }
            if (nUMBER5 != null) {
                n = nUMBER5.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        if (string.equals("TRUE") && !jGeometry.isLRSGeometry() && ((double[])(object = jGeometry.getMBR())).length != 6) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        if (jGeometry.getElemInfo() == null) {
            object = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]);
        } else if (jGeometry.isLRSGeometry()) {
            int n2 = jGeometry.getDimensions();
            int n3 = 1;
            --n2;
            int[] nArray = new int[jGeometry.getElemInfo().length];
            nArray[0] = 1;
            for (int i = 1; i < jGeometry.getElemInfo().length; ++i) {
                nArray[i] = i % 3 == 0 ? jGeometry.getElemInfo()[i] - (jGeometry.getElemInfo()[i] - 1) / (n2 + n3) : jGeometry.getElemInfo()[i];
            }
            double[] dArray = new double[n2 * jGeometry.getOrdinatesArray().length / (n2 + n3)];
            for (int i = 0; i < jGeometry.getOrdinatesArray().length / (n2 + n3); ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray[n2 * i + j] = jGeometry.getOrdinatesArray()[(n2 + n3) * i + j];
                }
            }
            object = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray);
        } else {
            object = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        }
        NUMBER nUMBER7 = new NUMBER(object.length(nUMBER.intValue(), nUMBER6.doubleValue(), string, d, d2, d3));
        return nUMBER7;
    }

    public static NUMBER area(Struct struct, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        Object object;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        if (string.equals("TRUE") && !jGeometry.isLRSGeometry() && ((double[])(object = jGeometry.getMBR())).length != 6) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        object = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        NUMBER nUMBER6 = new NUMBER(object.area(nUMBER5.doubleValue(), string, d, d2, d3));
        return nUMBER6;
    }

    public static NUMBER volume(Struct struct, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        Object object;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        if (string.equals("TRUE") && !jGeometry.isLRSGeometry() && ((double[])(object = jGeometry.getMBR())).length != 6) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        object = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        NUMBER nUMBER6 = new NUMBER(object.volume(nUMBER5.doubleValue(), string, d, d2, d3));
        return nUMBER6;
    }

    public static String validateGeom(Struct struct, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6) throws Exception {
        Object object;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        String string2 = "FALSE";
        if (nUMBER.intValue() > 0) {
            if (nUMBER4 != null) {
                d3 = nUMBER4.doubleValue();
            }
            if (nUMBER2 != null) {
                d = nUMBER2.doubleValue();
            }
            if (nUMBER3 != null) {
                d2 = nUMBER3.doubleValue();
            }
            if (nUMBER5 != null) {
                n = nUMBER5.intValue();
            }
            string2 = "TRUE";
        }
        JGeometry jGeometry = null;
        try {
            jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        }
        catch (SQLException sQLException) {
            if ("Expecting java.sql.Struct type but could not find it".equalsIgnoreCase(sQLException.getMessage())) {
                return "13199 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            if ("Wrong ElemInfo array type".equalsIgnoreCase(sQLException.getMessage())) {
                return "13033 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            if ("Wrong ordinates array type".equalsIgnoreCase(sQLException.getMessage())) {
                return "13034 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            if ("An invalid null value is found in LRS sdo_ordinates".equalsIgnoreCase(sQLException.getMessage())) {
                return "13331 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            if ("An invalid sdo_gtype is found".equalsIgnoreCase(sQLException.getMessage())) {
                return "13031 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            if ("Point Geometry has missing ordinates".equalsIgnoreCase(sQLException.getMessage())) {
                return "13032 Loading from Database Issue:" + sQLException.getMessage() + " Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
            }
            throw sQLException;
        }
        if (string2.equals("TRUE") && !jGeometry.isLRSGeometry() && ((double[])(object = jGeometry.getMBR())).length != 6) {
            return "13355 SDO_ORDINATE_ARRAY not grouped by number of dimensions specified Point:0,Edge:0,Ring:0,Polygon:0,Comp-Surf:0,Solid:0,Multi:0,";
        }
        String string3 = "";
        if (jGeometry == null) {
            string3 = "13032: Invalid NULL  SDO_GEOMETRY object;,0,0,0,0,0,0,0";
        } else {
            object = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
            boolean bl = string.equals("TRUE");
            string3 = object.validate(bl, nUMBER6.doubleValue(), string2);
        }
        if (string3.substring(0, 4).equals("TRUE")) {
            return "TRUE";
        }
        String string4 = string3.substring(0, 5);
        String string5 = string3.substring(string3.indexOf(";") + 1);
        String string6 = "";
        String string7 = "";
        string7 = string7.concat(string4).concat(" ");
        int n2 = 0;
        int n3 = 0;
        while (string5.indexOf(",") != -1) {
            string6 = string5.substring(string5.indexOf(",") + 1);
            if (string6.indexOf(",") == -1) {
                n3 = Integer.valueOf(string6);
            } else {
                String string8 = string6.substring(0, string6.indexOf(","));
                n3 = Integer.valueOf(string8);
                string6 = string6.substring(string6.indexOf(","));
            }
            string5 = string6;
            switch (n2 + 1) {
                case 1: {
                    string7 = string7.concat("Point:");
                    break;
                }
                case 2: {
                    string7 = string7.concat("Edge:");
                    break;
                }
                case 3: {
                    string7 = string7.concat("Ring:");
                    break;
                }
                case 4: {
                    string7 = string7.concat("Polygon:");
                    break;
                }
                case 5: {
                    string7 = string7.concat("Comp-Surf:");
                    break;
                }
                case 6: {
                    string7 = string7.concat("Solid:");
                    break;
                }
                case 7: {
                    string7 = string7.concat("Multi:");
                }
            }
            string7 = string7.concat(String.valueOf(n3)).concat(",");
            ++n2;
        }
        return string7;
    }

    public static Struct closestPoints(Struct struct, Struct struct2, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        Object object;
        Object object2;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        ArrayList arrayList = new ArrayList();
        J3D_Geometry j3D_Geometry = null;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        JGeometry jGeometry2 = JGeometry.loadJS((Struct)struct2, (int)n, (double)d, (double)d2);
        if (!(!string.equals("TRUE") || jGeometry.isLRSGeometry() || jGeometry2.isLRSGeometry() || ((double[])(object2 = jGeometry.getMBR())).length == ((double[])(object = jGeometry2.getMBR())).length && ((double[])object2).length == 6 && ((double[])object).length == 6)) {
            throw new DataException("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        object2 = jGeometry.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        arrayList = object2.closestPoints((J3D_Geometry)(object = jGeometry2.getElemInfo() == null ? (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : (Object)new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray())), nUMBER5.doubleValue(), string, d, d2, d3);
        if (arrayList == null) {
            return null;
        }
        J3D_Geometry j3D_Geometry2 = (J3D_Geometry)arrayList.get(0);
        J3D_Geometry j3D_Geometry3 = (J3D_Geometry)arrayList.get(1);
        double[] dArray = new double[6];
        int[] nArray = new int[3];
        dArray[0] = j3D_Geometry2.getOrdinatesArray()[0];
        dArray[1] = j3D_Geometry2.getOrdinatesArray()[1];
        dArray[2] = j3D_Geometry2.getOrdinatesArray()[2];
        dArray[3] = j3D_Geometry3.getOrdinatesArray()[0];
        dArray[4] = j3D_Geometry3.getOrdinatesArray()[1];
        dArray[5] = j3D_Geometry3.getOrdinatesArray()[2];
        nArray[0] = 1;
        nArray[1] = 1;
        nArray[2] = 2;
        j3D_Geometry = new J3D_Geometry(5, j3D_Geometry2.getSRID(), nArray, dArray);
        return JGeometry.store((JGeometry)j3D_Geometry, (Connection)m_conn);
    }

    public static Struct affineTransforms(Struct struct, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, String string2, Struct struct2, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6, String string3, Struct struct3, Struct struct4, NUMBER nUMBER7, NUMBER nUMBER8, String string4, NUMBER nUMBER9, NUMBER nUMBER10, NUMBER nUMBER11, NUMBER nUMBER12, NUMBER nUMBER13, NUMBER nUMBER14, String string5, Struct struct5, Struct struct6, NUMBER nUMBER15, String string6, SdoNumberArray sdoNumberArray, SdoNumberArray sdoNumberArray2) throws Exception {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = struct2 == null ? null : JGeometry.loadJS((Struct)struct2);
        JGeometry jGeometry3 = struct3 == null ? null : JGeometry.loadJS((Struct)struct3);
        JGeometry jGeometry4 = struct4 == null ? null : JGeometry.loadJS((Struct)struct4);
        JGeometry jGeometry5 = struct5 == null ? null : JGeometry.loadJS((Struct)struct5);
        JGeometry jGeometry6 = struct6 == null ? null : JGeometry.loadJS((Struct)struct6);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (string.equals("TRUE")) {
            bl = true;
        }
        if (string2.equals("TRUE")) {
            bl2 = true;
        }
        if (string3.equals("TRUE")) {
            bl3 = true;
        }
        if (string4.equals("TRUE")) {
            bl4 = true;
        }
        if (string5.equals("TRUE")) {
            bl5 = true;
        }
        if (string6.equals("TRUE")) {
            bl6 = true;
        }
        double[] dArray = new double[1];
        double[] dArray2 = new double[3];
        if (sdoNumberArray2 != null && sdoNumberArray != null) {
            dArray[0] = sdoNumberArray2.getArray()[0].doubleValue();
            for (int i = 0; i < sdoNumberArray.length(); ++i) {
                dArray2[i] = sdoNumberArray.getArray()[i].doubleValue();
            }
        } else {
            dArray = null;
            dArray2 = null;
        }
        JGeometry jGeometry7 = jGeometry.affineTransforms(bl, nUMBER.doubleValue(), nUMBER2.doubleValue(), nUMBER3.doubleValue(), bl2, jGeometry2, nUMBER4.doubleValue(), nUMBER5.doubleValue(), nUMBER6 == null ? 0.0 : nUMBER6.doubleValue(), bl3, jGeometry3, jGeometry4, nUMBER7.doubleValue(), nUMBER8.intValue(), bl4, nUMBER9.doubleValue(), nUMBER10.doubleValue(), nUMBER11.doubleValue(), nUMBER12.doubleValue(), nUMBER13.doubleValue(), nUMBER14.doubleValue(), bl5, jGeometry5, jGeometry6, nUMBER15.intValue(), bl6, dArray2, dArray);
        return JGeometry.store((JGeometry)jGeometry7, (Connection)m_conn);
    }

    public static Struct gmlToSTRUCT(String string, String string2) throws SQLException {
        GML.setsrsNameSpace(string2);
        GML.setConnection(m_conn);
        Struct struct = Adapters.gmlToSTRUCT(string, m_conn);
        GML.setsrsNameSpace(null);
        GML.setConnection(null);
        return struct;
    }

    @Deprecated
    public static Struct gmlToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
        dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)1);
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static Struct gmlToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string, m_conn);
    }

    public static Struct gmlToSTRUCT(CLOB cLOB, String string) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string2, string);
    }

    public static Struct gml311ToSTRUCT(String string, String string2) throws SQLException {
        GML3g.setsrsNameSpace(string2);
        GML3g.setConnection(m_conn);
        Struct struct = Adapters.gml311ToSTRUCT(string, m_conn);
        GML3g.setsrsNameSpace(null);
        GML3g.setConnection(null);
        return struct;
    }

    @Deprecated
    public static Struct gml311ToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
        dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)1);
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML3g.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static Struct gml311ToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string, m_conn);
    }

    public static Struct gml311ToSTRUCT(CLOB cLOB, String string) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string2, string);
    }

    public static Struct kmlToSTRUCT(String string, Connection connection) throws SQLException {
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
        dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)1);
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = KML.fromNodeToGeometry(node);
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static Struct kmlToSTRUCT(CLOB cLOB) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.kmlToSTRUCT(string, m_conn);
    }

    public static BLOB structToWkb(Struct struct) throws SQLException {
        return Adapters.structToWkb(struct, m_conn);
    }

    public static BLOB structToWkb(Struct struct, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkb2(struct, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static BLOB structToWkb2(Struct struct, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (struct == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wkbAdapter.fromStruct(struct);
            BLOB bLOB = BLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            bLOB.open(1);
            OutputStream outputStream = bLOB.getBinaryOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            bLOB.close();
            return bLOB;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static CLOB structToWkt(Struct struct) throws SQLException {
        return Adapters.structToWkt(struct, m_conn);
    }

    public static String structToWktString(Struct struct) throws SQLException {
        try {
            return Adapters.structToWktString2(struct);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    public static CLOB structToWkt(Struct struct, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkt2(struct, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static CLOB structToWkt2(Struct struct, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (struct == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wktAdapter.fromStruct(struct);
            CLOB cLOB = CLOB.createTemporary((Connection)connection, (boolean)true, (int)10);
            cLOB.open(1);
            OutputStream outputStream = cLOB.getAsciiOutputStream();
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            cLOB.close();
            return cLOB;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    protected static String structToWktString2(Struct struct) throws SQLException, GeometryExceptionWithContext {
        if (struct == null) {
            return null;
        }
        byte[] byArray = m_wktAdapter.fromStruct(struct);
        if (byArray.length > 4000) {
            return new String(byArray, 0, 4000);
        }
        return new String(byArray);
    }

    public static String validateWkt(CLOB cLOB) {
        return Adapters.validateWkt(cLOB, m_conn);
    }

    public static String validateWkt(CLOB cLOB, Connection connection) {
        try {
            Adapters.wktToSTRUCT2(cLOB, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static String validateWkt(String string) {
        return Adapters.validateWkt(string, m_conn);
    }

    public static String validateWkt(String string, Connection connection) {
        try {
            Adapters.wktToSTRUCT2(string, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static String validateWkb(BLOB bLOB) {
        return Adapters.validateWkb(bLOB, m_conn);
    }

    public static String validateWkb(BLOB bLOB, Connection connection) {
        try {
            Adapters.wkbToSTRUCT2(bLOB, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NUMBER validate_layer_with_context_3D(String string, String string2, String string3, NUMBER nUMBER, String string4, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5, NUMBER nUMBER6, NUMBER nUMBER7) throws SQLSyntaxErrorException, SQLException, Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        Statement statement2 = null;
        String string5 = null;
        String string6 = null;
        Object var16_16 = null;
        Statement statement3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = nUMBER.intValue();
        try {
            string2 = Util.enquoteNameSQLName(m_conn, string2);
            string = Util.enquoteTableName(m_conn, string);
            string3 = Util.enquoteTableName(m_conn, string3);
        }
        catch (SQLException sQLException) {
            return new NUMBER(0);
        }
        try {
            m_conn.setAutoCommit(false);
            statement = m_conn.createStatement();
            string5 = "SELECT rowid, " + Util.enquoteNameSQLName(m_conn, string2) + "  FROM " + Util.enquoteTableName(m_conn, string);
            resultSet = statement.executeQuery(string5);
            string6 = "INSERT INTO " + Util.enquoteTableName(m_conn, string3) + " VALUES (?,?)";
            statement3 = m_conn.prepareStatement(string6);
            while (resultSet.next()) {
                RowId rowId = resultSet.getRowId(1);
                Object object = null;
                object = resultSet.getObject(2);
                ++n2;
                String string7 = null;
                string7 = object != null ? Adapters.validateGeom((Struct)object, string4, nUMBER2, nUMBER3, nUMBER4, nUMBER5, nUMBER6, nUMBER7) : "NULL";
                if (!string7.substring(0, 4).equals("TRUE")) {
                    statement3.setRowId(1, rowId);
                    statement3.setString(2, string7);
                    statement3.executeUpdate();
                }
                if (++n != n3) continue;
                m_conn.commit();
                n = 0;
            }
            statement3 = m_conn.prepareStatement("INSERT INTO " + Util.enquoteTableName(m_conn, string3) + " VALUES (NULL, ?)");
            statement3.setString(1, "Rows Processed " + String.valueOf(n2));
            statement3.executeUpdate();
            m_conn.commit();
        }
        catch (OracleSQLException oracleSQLException) {
            NUMBER nUMBER8 = new NUMBER(0);
            return nUMBER8;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            NUMBER nUMBER9 = new NUMBER(0);
            return nUMBER9;
        }
        catch (SQLException sQLException) {
            NUMBER nUMBER10 = new NUMBER(0);
            return nUMBER10;
        }
        catch (Exception exception) {
            NUMBER nUMBER11 = new NUMBER(0);
            return nUMBER11;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (OracleSQLException oracleSQLException) {
                return new NUMBER(0);
            }
            catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
                return new NUMBER(0);
            }
            catch (SQLException sQLException) {
                return new NUMBER(0);
            }
            catch (Exception exception) {
                return new NUMBER(0);
            }
        }
        return new NUMBER(n2);
    }

    public static Struct centroid_3d(Struct struct, NUMBER nUMBER) throws Exception, SQLException {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = null;
        j3D_Geometry2 = j3D_Geometry.centroid3d(nUMBER.doubleValue());
        if (j3D_Geometry2 == null) {
            return null;
        }
        JGeometry jGeometry2 = new JGeometry(j3D_Geometry2.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1], j3D_Geometry2.getOrdinatesArray()[2], j3D_Geometry2.getSRID());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    public static Struct extrusion2(Struct struct, SdoNumberArray sdoNumberArray, SdoNumberArray sdoNumberArray2, NUMBER nUMBER, NUMBER nUMBER2) throws Exception, SQLException {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = null;
        double[] dArray = new double[sdoNumberArray.length()];
        double[] dArray2 = new double[sdoNumberArray2.length()];
        try {
            int n = nUMBER2 == null ? 0 : nUMBER2.intValue();
            if (sdoNumberArray.length() == 1) {
                jGeometry2 = J3D_Geometry.extrusion((JGeometry)jGeometry, (double)sdoNumberArray.getArray()[0].doubleValue(), (double)sdoNumberArray2.getArray()[0].doubleValue(), (Connection)m_conn, (double)nUMBER.doubleValue(), (int)n);
            } else {
                int n2;
                for (n2 = 0; n2 < sdoNumberArray.length(); ++n2) {
                    dArray[n2] = sdoNumberArray.getArray()[n2].doubleValue();
                }
                for (n2 = 0; n2 < sdoNumberArray2.length(); ++n2) {
                    dArray2[n2] = sdoNumberArray2.getArray()[n2].doubleValue();
                }
                jGeometry2 = J3D_Geometry.extrusion((JGeometry)jGeometry, (double[])dArray, (double[])dArray2, (Connection)m_conn, (double)nUMBER.doubleValue(), (int)n);
            }
        }
        catch (Exception exception) {
            String string = exception.toString();
            string = string.substring(string.indexOf(" ") + 1);
            int n = 0;
            n = string.length() == 5 ? Integer.valueOf(string.substring(string.indexOf(" ") + 1)).intValue() : Integer.valueOf(string.substring(0, 5)).intValue();
            jGeometry2 = new JGeometry(n, 0, new int[]{1, 1, 1}, new double[]{0.0, 0.0, 0.0});
            return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
        }
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    public static Struct ringUnionApprox(Struct struct, NUMBER nUMBER) throws Exception, SQLException {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = Adapters.ringUnion(jGeometry, nUMBER.doubleValue());
        return JGeometry.store((JGeometry)jGeometry2, (Connection)m_conn);
    }

    private static void compStarts(double[] dArray, int[] nArray, int[] nArray2, int n, double d) {
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n2 = dArray.length / 2;
        for (int i = 0; i < n2 - 1; ++i) {
            d3 = dArray[2 * i];
            double d7 = dArray[2 * i + 1];
            if (i == 0 || d3 <= d2 + d) {
                if (i > 0 && Math.abs(d3 - d2) < d && d7 > d5) continue;
                d5 = d7;
                d2 = d3;
                nArray[n] = i;
            }
            if (i != 0 && !(d3 >= d4 - d) || i > 0 && Math.abs(d3 - d4) < d && d7 < d6) continue;
            d4 = d3;
            d6 = d7;
            nArray2[n] = i;
        }
    }

    private static int getNextIdx(double[] dArray, int n, double d, double d2, double d3) {
        double d4;
        int n2;
        int n3 = dArray.length / 2;
        int n4 = n;
        if (Adapters.samePt(dArray[2 * n], dArray[2 * n + 1], d2, d, d3)) {
            n4 = (n4 + 1) % (dArray.length / 2);
        }
        int n5 = n4;
        double d5 = dArray[2 * n4];
        double d6 = dArray[2 * n4 + 1];
        double d7 = Math.abs(d6 - d);
        int n6 = n5;
        for (n2 = 1; n2 < n3; ++n2) {
            d4 = d5 - dArray[2 * (n6 = (n6 + 1) % n3)];
            double d8 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 > d3) break;
            d4 = d - dArray[2 * n6 + 1];
            double d9 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 >= d7) break;
            n5 = n6;
        }
        n6 = n5;
        for (n2 = 1; n2 < n3; ++n2) {
            d4 = d5 - dArray[2 * (n6 = (n6 - 1 + n3) % n3)];
            double d10 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 > d3) break;
            d4 = d - dArray[2 * n6 + 1];
            double d11 = d4 = d4 < 0.0 ? -d4 : d4;
            if (d4 >= d7) break;
            n5 = n4;
        }
        return n5;
    }

    private static void getFirstPt(double[][] dArray, int[] nArray, int n, boolean bl, int[] nArray2, double[] dArray2, double[] dArray3) {
        double d = 0.0;
        double d2 = 0.0;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                double d3 = dArray[i][2 * n2];
                double d4 = dArray[i][2 * n2 + 1];
                if (i != 0 && !(d3 < d)) continue;
                d = d3;
                d2 = d4;
                nArray2[0] = i;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                double d5 = dArray[i][2 * n3];
                double d6 = dArray[i][2 * n3 + 1];
                if (i != 0 && !(d5 > d)) continue;
                d = d5;
                d2 = d6;
                nArray2[0] = i;
            }
        }
        dArray2[0] = d;
        dArray3[0] = d2;
    }

    private static boolean betterCand(double d, double d2, double d3, double d4, double d5, double d6, double d7) {
        if (d < 0.0) {
            return false;
        }
        if (Math.abs(d - d4) < d7) {
            if (Math.abs(d) < d7) {
                if (d2 > 0.0 && d5 > 0.0 || d2 < 0.0 && d5 < 0.0) {
                    return Math.abs(d2) < Math.abs(d5);
                }
                return d5 < 0.0;
            }
            if (Math.abs(d2) < d7) {
                return true;
            }
            if (Math.abs(d5) < d7) {
                return false;
            }
            if (d2 > 0.0 && d5 > 0.0 || d2 < 0.0 && d5 < 0.0) {
                return Math.abs(d2) < Math.abs(d5);
            }
            return d5 < 0.0;
        }
        if (Math.abs(d2) < d7 && d < d4) {
            return true;
        }
        return d3 > d6;
    }

    private static boolean getNextPt(double[][] dArray, int[] nArray, int[] nArray2, int[] nArray3, int n, boolean bl, double d, double[] dArray2, double[] dArray3) {
        boolean bl2 = false;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = -1.0;
        double d7 = -1.0;
        int n2 = 0;
        int n3 = -1;
        int n4 = 0;
        double d8 = dArray2[0];
        double d9 = dArray3[0];
        n3 = -1;
        if (bl) {
            for (int i = 0; i < n; ++i) {
                int n5;
                double d10;
                if (nArray3[i] == -1) continue;
                int n6 = dArray[i].length / 2;
                while (!Adapters.samePt(dArray[i], nArray3[i], nArray2[i], d) && !((d10 = dArray[i][2 * (n5 = nArray3[i])]) >= d8)) {
                    nArray3[i] = (nArray3[i] + 1) % n6;
                }
                n2 = nArray3[i] != nArray[i] ? nArray3[i] : Adapters.getNextIdx(dArray[i], nArray3[i], d9, d8, d);
                double d11 = dArray[i][2 * n2 + 1];
                d10 = dArray[i][2 * n2];
                if (d10 < d8) continue;
                double d12 = d10 - dArray2[0];
                double d13 = dArray3[0] - d11;
                double d14 = Math.abs(d13) < d ? 0.0 : (Math.abs(d12) < d ? (d13 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : d13 / d12);
                if (n3 != -1 && !Adapters.betterCand(d12, d13, d14, d6, d7, d5, d)) continue;
                n3 = i;
                d2 = d11;
                d4 = d10;
                d5 = d14;
                d6 = d12;
                d7 = d13;
                n4 = Adapters.samePt(dArray[i], n2, nArray2[n3], d) ? -1 : (n2 + 1) % n6;
            }
            nArray3[n3] = n4;
            dArray2[0] = d4;
            dArray3[0] = d2;
        } else {
            for (int i = 0; i < n; ++i) {
                int n7;
                double d15;
                if (nArray3[i] == -1) continue;
                int n8 = dArray[i].length / 2;
                while (!Adapters.samePt(dArray[i], nArray3[i], nArray[i], d) && !((d15 = dArray[i][2 * (n7 = nArray3[i])]) <= d8)) {
                    nArray3[i] = (nArray3[i] + 1) % n8;
                }
                n2 = nArray3[i] != nArray2[i] ? nArray3[i] : Adapters.getNextIdx(dArray[i], nArray3[i], d9, d8, d);
                double d16 = dArray[i][2 * n2 + 1];
                d15 = dArray[i][2 * n2];
                if (d15 > d8) continue;
                double d17 = dArray2[0] - d15;
                double d18 = d16 - dArray3[0];
                double d19 = Math.abs(d18) < d ? 0.0 : (Math.abs(d17) < d ? (d18 > 0.0 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY) : d18 / d17);
                if (n3 != -1 && !Adapters.betterCand(d17, d18, d19, d6, d7, d5, d)) continue;
                n3 = i;
                d3 = d16;
                d4 = d15;
                d5 = d19;
                d6 = d17;
                d7 = d18;
                n4 = Adapters.samePt(dArray[i], n2, nArray[n3], d) ? -1 : (n2 + 1) % n8;
            }
            nArray3[n3] = n4;
            dArray2[0] = d4;
            dArray3[0] = d3;
        }
        return n3 != -1;
    }

    private static boolean samePt(double d, double d2, double d3, double d4, double d5) {
        double d6 = d - d3;
        double d7 = d2 - d4;
        d6 = d6 < 0.0 ? -d6 : d6;
        d7 = d7 < 0.0 ? -d7 : d7;
        return d7 < d5 && d6 < d5;
    }

    private static boolean samePt(double[] dArray, int n, int n2, double d) {
        return Adapters.samePt(dArray[2 * n], dArray[2 * n + 1], dArray[2 * n2], dArray[2 * n2 + 1], d);
    }

    protected static JGeometry ringUnion(JGeometry jGeometry, double d) {
        int n;
        int n2;
        JGeometry jGeometry2 = jGeometry;
        JGeometry[] jGeometryArray = jGeometry.getElements();
        int n3 = jGeometryArray.length;
        int[] nArray = new int[n3];
        int[] nArray2 = new int[n3];
        int[] nArray3 = new int[n3];
        double[] dArray = new double[1];
        double[] dArray2 = new double[1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        double[] dArray5 = new double[1];
        double[] dArray6 = new double[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = jGeometryArray[n2].getOrdinatesArray();
        }
        for (int i = 0; i < n3; ++i) {
            Adapters.compStarts(dArrayArray[i], nArray, nArray2, i, d);
        }
        double[] dArray7 = new double[jGeometry.getOrdinatesArray().length];
        int[] nArray6 = new int[]{1, 1003, 1};
        Adapters.getFirstPt(dArrayArray, nArray, n3, true, nArray5, dArray3, dArray4);
        Adapters.getFirstPt(dArrayArray, nArray2, n3, false, nArray4, dArray5, dArray6);
        for (n2 = 0; n2 < n3; ++n2) {
            nArray3[n2] = nArray[n2];
        }
        dArray[0] = dArray3[0];
        dArray2[0] = dArray4[0];
        n2 = 0;
        while (n2 < dArray7.length) {
            n = 1;
            dArray7[2 * n2] = dArray[0];
            dArray7[2 * n2 + 1] = dArray2[0];
            if (n2 > 0) {
                int n4 = n = !Adapters.samePt(dArray7, n2, n2 - 1, d) ? 1 : 0;
            }
            if (Adapters.samePt(dArray[0], dArray2[0], dArray5[0], dArray6[0], d) || !Adapters.getNextPt(dArrayArray, nArray, nArray2, nArray3, n3, true, d, dArray, dArray2)) break;
            if (n == 0) continue;
            ++n2;
        }
        for (n = 0; n < n3; ++n) {
            nArray3[n] = nArray2[n];
        }
        nArray3[nArray4[0]] = (nArray3[nArray4[0]] + 1) % (dArrayArray[nArray4[0]].length / 2);
        dArray[0] = dArray5[0];
        dArray2[0] = dArray6[0];
        while (n2 < dArray7.length) {
            n = 1;
            dArray7[2 * n2] = dArray[0];
            dArray7[2 * n2 + 1] = dArray2[0];
            if (n2 > 0) {
                int n5 = n = !Adapters.samePt(dArray7, n2, n2 - 1, d) ? 1 : 0;
            }
            if (Adapters.samePt(dArray[0], dArray2[0], dArray3[0], dArray4[0], d) || !Adapters.getNextPt(dArrayArray, nArray, nArray2, nArray3, n3, false, d, dArray, dArray2)) break;
            if (n == 0) continue;
            ++n2;
        }
        if (!Adapters.samePt(dArray7, n2 - 1, 0, d)) {
            dArray7[2 * n2] = dArray7[0];
            dArray7[2 * n2 + 1] = dArray7[1];
            ++n2;
        }
        double[] dArray8 = new double[2 * n2];
        for (int i = 0; i < 2 * n2; ++i) {
            dArray8[i] = dArray7[i];
        }
        jGeometry2 = new JGeometry(2003, jGeometry.getSRID(), nArray6, dArray8);
        return jGeometry2;
    }

    public static Struct extract3d(Struct struct, String string) throws Exception {
        JGeometry jGeometry = struct == null ? null : JGeometry.loadJS((Struct)struct);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = j3D_Geometry.getElementByLabel(string);
        return JGeometry.store((JGeometry)j3D_Geometry2, (Connection)m_conn);
    }

    public static String getlabelbyelement(Struct struct, Struct struct2, NUMBER nUMBER) throws Exception {
        JGeometry jGeometry = struct == null ? null : JGeometry.loadJS((Struct)struct);
        JGeometry jGeometry2 = struct2 == null ? null : JGeometry.loadJS((Struct)struct2);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = jGeometry2.getElemInfo() == null ? new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        String string = "";
        string = j3D_Geometry.getLabelByElement(j3D_Geometry2, nUMBER.doubleValue());
        return string;
    }

    public static String inside3d(Struct struct, Struct struct2, String string, NUMBER nUMBER, NUMBER nUMBER2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws Exception {
        boolean bl = false;
        double d = 6378137.0;
        double d2 = 0.003352810664747;
        double d3 = 1.0;
        int n = 0;
        if (string.equals("TRUE")) {
            if (nUMBER3 != null) {
                d3 = nUMBER3.doubleValue();
            }
            if (nUMBER != null) {
                d = nUMBER.doubleValue();
            }
            if (nUMBER2 != null) {
                d2 = nUMBER2.doubleValue();
            }
            if (nUMBER4 != null) {
                n = nUMBER4.intValue();
            }
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct, (int)n, (double)d, (double)d2);
        JGeometry jGeometry2 = JGeometry.loadJS((Struct)struct2, (int)n, (double)d, (double)d2);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        J3D_Geometry j3D_Geometry2 = jGeometry2.getElemInfo() == null ? new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getPoint()[0], jGeometry2.getPoint()[1], jGeometry2.getPoint()[2]) : new J3D_Geometry(jGeometry2.getType(), jGeometry2.getSRID(), jGeometry2.getElemInfo(), jGeometry2.getOrdinatesArray());
        bl = j3D_Geometry.inside3d(j3D_Geometry2, nUMBER5.doubleValue(), string);
        if (bl) {
            return "TRUE";
        }
        return "FALSE";
    }

    public static void readpts(BLOB bLOB, int n, int n2, Ptclass[] ptclassArray, NUMBER nUMBER) throws SQLException, IOException {
        int n3 = Math.round(bLOB.length() / (long)n) - (n2 + 1) * 8;
        DataInputStream dataInputStream = new DataInputStream(bLOB.getBinaryStream());
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            byte[] byArray = null;
            for (int j = 0; j < n2; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
            if (n3 > 0) {
                if (nUMBER.intValue() == 1) {
                    byArray = new byte[n3];
                    dataInputStream.readFully(byArray);
                } else {
                    dataInputStream.skipBytes(n3);
                }
            }
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            ptclassArray[i] = new Ptclass(dArray, n2, n4, n5, byArray);
        }
    }

    public static void writepts(BLOB bLOB, int n, int n2, Ptclass[] ptclassArray, NUMBER nUMBER) throws SQLException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(bLOB.setBinaryStream(1L));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dataOutputStream.writeDouble(ptclassArray[i].ords[j]);
            }
            if (ptclassArray[i].m_customDims != null && nUMBER.intValue() == 1) {
                dataOutputStream.write(ptclassArray[i].m_customDims, 0, ptclassArray[i].m_customDims.length);
            }
            dataOutputStream.writeInt(ptclassArray[i].ptn_id);
            dataOutputStream.writeInt(ptclassArray[i].pt_id);
        }
        dataOutputStream.close();
    }

    public static BLOB pctrclip(Struct struct, Struct struct2, BLOB bLOB, NUMBER nUMBER, NUMBER nUMBER2, BLOB bLOB2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws SQLException, IOException, Exception {
        BLOB bLOB3 = BLOB.createTemporary((Connection)m_conn, (boolean)true, (int)10);
        int n = nUMBER2.intValue();
        double d = nUMBER4.doubleValue();
        Struct struct3 = struct2;
        int n2 = nUMBER.intValue();
        Ptclass[] ptclassArray = new Ptclass[n2];
        Ptclass[] ptclassArray2 = new Ptclass[n2];
        Adapters.readpts(bLOB, n2, n, ptclassArray, nUMBER5);
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        double[] dArray = null;
        double[] dArray2 = null;
        int n3 = 0;
        if (struct2 != null) {
            Object[] objectArray = struct2.getAttributes();
            dArray = ((OracleArray)objectArray[0]).getDoubleArray();
            dArray2 = ((OracleArray)objectArray[1]).getDoubleArray();
            if (dArray != null && dArray2 != null) {
                int n4 = n3 = dArray.length < dArray2.length ? dArray.length : dArray2.length;
            }
            if (n3 > n - 3) {
                n3 = n - 3;
            }
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            J3D_Geometry j3D_Geometry2;
            boolean bl = false;
            if (n3 > 0) {
                for (int j = 0; j < n3; ++j) {
                    if (!(dArray[j] > ptclassArray[i].ords[j + 3] + d) && !(dArray2[j] + d < ptclassArray[i].ords[j + 3])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl || !j3D_Geometry.anyInteract(j3D_Geometry2 = new J3D_Geometry(3001, j3D_Geometry.getSRID(), ptclassArray[i].ords[0], ptclassArray[i].ords[1], ptclassArray[i].ords[2]), d)) continue;
            ptclassArray2[n5++] = ptclassArray[i];
        }
        if (n5 > 0) {
            Adapters.writepts(bLOB3, n5, n, ptclassArray2, nUMBER5);
        }
        return bLOB3;
    }

    public static Struct expandG3Dgeoms(Struct struct) throws Exception {
        JGeometry jGeometry = struct == null ? null : JGeometry.loadJS((Struct)struct);
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        j3D_Geometry = J3D_Geometry.expandGeom((J3D_Geometry)j3D_Geometry2);
        return JGeometry.store((JGeometry)j3D_Geometry, (Connection)m_conn);
    }

    public static Object[] toGeo3DLRSInfo(Struct struct) throws Exception {
        Object[] objectArray = new Object[2];
        J3D_Geometry j3D_Geometry = null;
        double[] dArray = null;
        int n = 0;
        if (struct == null) {
            Object var5_5 = null;
            objectArray[0] = null;
            objectArray[1] = null;
            return objectArray;
        }
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        if (jGeometry.getElemInfo() == null) {
            j3D_Geometry = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]);
        } else if (jGeometry.isLRSGeometry()) {
            int n2 = jGeometry.getDimensions();
            int n3 = 1;
            --n2;
            int[] nArray = new int[jGeometry.getElemInfo().length];
            nArray[0] = 1;
            for (int i = 1; i < jGeometry.getElemInfo().length; ++i) {
                nArray[i] = i % 3 == 0 ? jGeometry.getElemInfo()[i] - (jGeometry.getElemInfo()[i] - 1) / (n2 + n3) : jGeometry.getElemInfo()[i];
            }
            double[] dArray2 = new double[n2 * jGeometry.getOrdinatesArray().length / (n2 + n3)];
            dArray = new double[jGeometry.getOrdinatesArray().length / (n2 + n3)];
            for (int i = 0; i < jGeometry.getOrdinatesArray().length / (n2 + n3); ++i) {
                for (int j = 0; j < n2; ++j) {
                    dArray2[n2 * i + j] = jGeometry.getOrdinatesArray()[(n2 + n3) * i + j];
                }
                dArray[n] = jGeometry.getOrdinatesArray()[(n2 + n3) * i + n2];
                ++n;
            }
            j3D_Geometry = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray2);
        } else {
            j3D_Geometry = new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        }
        objectArray[0] = j3D_Geometry;
        objectArray[1] = dArray;
        return objectArray;
    }

    public static Struct toGeo3DLRSStruct(Object[] objectArray) throws Exception {
        JGeometry jGeometry = null;
        J3D_Geometry j3D_Geometry = null;
        double[] dArray = new double[3];
        int n = 0;
        int n2 = 0;
        if (objectArray[0] == null || objectArray[1] == null) {
            return null;
        }
        j3D_Geometry = (J3D_Geometry)objectArray[0];
        double[] dArray2 = (double[])objectArray[1];
        int n3 = j3D_Geometry.getDimensions();
        if (n3 == 3) {
            dArray = j3D_Geometry.getLabelPointXYZ();
        }
        int[] nArray = new int[j3D_Geometry.getElemInfo().length];
        for (int i = 0; i < j3D_Geometry.getElemInfo().length; ++i) {
            nArray[i] = i % 3 == 0 ? j3D_Geometry.getElemInfo()[i] + (j3D_Geometry.getElemInfo()[i] - 1) / n3 : j3D_Geometry.getElemInfo()[i];
        }
        double[] dArray3 = new double[(n3 + 1) * (j3D_Geometry.getOrdinatesArray().length / n3)];
        for (int i = 0; i < j3D_Geometry.getOrdinatesArray().length / n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                dArray3[n] = j3D_Geometry.getOrdinatesArray()[n3 * i + j];
                ++n;
            }
            dArray3[n] = dArray2[n2];
            ++n;
            ++n2;
        }
        if (j3D_Geometry.getDimensions() == 3) {
            jGeometry = Double.isNaN(dArray[0]) && Double.isNaN(dArray[1]) && Double.isNaN(dArray[2]) ? new JGeometry(4000 + j3D_Geometry.getType(), j3D_Geometry.getSRID(), nArray, dArray3) : new JGeometry(4000 + j3D_Geometry.getType(), j3D_Geometry.getSRID(), dArray[0], dArray[1], dArray[2], nArray, dArray3);
            jGeometry.setLRMDimension(4);
        } else if (j3D_Geometry.getDimensions() == 2) {
            jGeometry = new JGeometry(3000 + j3D_Geometry.getType(), j3D_Geometry.getSRID(), nArray, dArray3);
            jGeometry.setLRMDimension(3);
        }
        return JGeometry.store(jGeometry, (Connection)m_conn);
    }

    public static Struct gmlToSTRUCT(String string, NUMBER nUMBER) throws SQLException {
        return Adapters.gmlToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gmlToSTRUCT(String string, String string2, NUMBER nUMBER) throws SQLException {
        GML.setsrsNameSpace(string2);
        GML.setConnection(m_conn);
        Struct struct = Adapters.gmlToSTRUCT(string, m_conn, nUMBER);
        GML.setsrsNameSpace(null);
        GML.setConnection(null);
        return struct;
    }

    public static Struct gmlToSTRUCT(String string, Connection connection, NUMBER nUMBER) throws SQLException {
        GML.setConnection(connection);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
        dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)1);
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML.fromNodeToGeometry(node, nUMBER.intValue());
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static Struct gmlToSTRUCT(CLOB cLOB, NUMBER nUMBER) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gmlToSTRUCT(CLOB cLOB, String string, NUMBER nUMBER) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gmlToSTRUCT(string2, string, nUMBER);
    }

    public static Struct gml311ToSTRUCT(String string, NUMBER nUMBER) throws SQLException {
        return Adapters.gml311ToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gml311ToSTRUCT(String string, String string2, NUMBER nUMBER) throws SQLException {
        GML3g.setsrsNameSpace(string2);
        GML3g.setConnection(m_conn);
        Struct struct = Adapters.gml311ToSTRUCT(string, m_conn, nUMBER);
        GML3g.setsrsNameSpace(null);
        GML3g.setConnection(null);
        return struct;
    }

    public static Struct gml311ToSTRUCT(String string, Connection connection, NUMBER nUMBER) throws SQLException {
        GML3g.setConnection(connection);
        DOMParser dOMParser = new DOMParser();
        dOMParser.setAttribute("oracle.xml.parser.XMLParser.ExpandEntityRef", (Object)false);
        dOMParser.setAttribute("oracle.xdkjava.security.entityExpansionDepth", (Object)1);
        StringReader stringReader = new StringReader(string);
        try {
            dOMParser.parse((Reader)stringReader);
            XMLDocument xMLDocument = dOMParser.getDocument();
            Node node = xMLDocument.getFirstChild();
            JGeometry jGeometry = GML3g.fromNodeToGeometry(node, nUMBER.intValue());
            return JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.toString());
        }
    }

    public static Struct gml311ToSTRUCT(CLOB cLOB, NUMBER nUMBER) throws SQLException {
        cLOB.open(0);
        String string = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gml311ToSTRUCT(CLOB cLOB, String string, NUMBER nUMBER) throws SQLException {
        cLOB.open(0);
        String string2 = cLOB.getSubString(1L, (int)cLOB.length());
        cLOB.close();
        return Adapters.gml311ToSTRUCT(string2, string, nUMBER);
    }

    public static Struct wktToSTRUCT(OracleClob oracleClob) throws SQLException {
        return Adapters.wktToSTRUCT(oracleClob, m_conn);
    }

    public static Struct wktToSTRUCT(OracleClob oracleClob, Connection connection) throws SQLException {
        try {
            return Adapters.wktToSTRUCT2(oracleClob, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static Struct wktToSTRUCT2(OracleClob oracleClob, Connection connection) throws SQLException, GeometryExceptionWithContext {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return m_wktAdapter.toStruct(string, connection);
    }

    public static Struct wkbToSTRUCT(OracleBlob oracleBlob) throws SQLException {
        return Adapters.wkbToSTRUCT(oracleBlob, m_conn);
    }

    public static Struct wkbToSTRUCT(OracleBlob oracleBlob, Connection connection) throws SQLException {
        try {
            return Adapters.wkbToSTRUCT2(oracleBlob, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static Struct wkbToSTRUCT2(OracleBlob oracleBlob, Connection connection) throws SQLException, GeometryExceptionWithContext {
        oracleBlob.open(LargeObjectAccessMode.MODE_READONLY);
        byte[] byArray = oracleBlob.getBytes(1L, (int)oracleBlob.length());
        oracleBlob.close();
        return m_wkbAdapter.toStruct(byArray, connection);
    }

    public static OracleBlob structToWkbJS(Struct struct) throws SQLException {
        return Adapters.structToWkbJS(struct, m_conn);
    }

    public static OracleBlob structToWkbJS(Struct struct, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkb2JS(struct, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static OracleBlob structToWkb2JS(Struct struct, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (struct == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wkbAdapter.fromStruct(struct);
            OracleBlob oracleBlob = (OracleBlob)connection.createBlob();
            oracleBlob.open(LargeObjectAccessMode.MODE_READWRITE);
            OutputStream outputStream = oracleBlob.setBinaryStream(0L);
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            oracleBlob.close();
            return oracleBlob;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static OracleClob structToWktJS(Struct struct) throws SQLException {
        return Adapters.structToWktJS(struct, m_conn);
    }

    public static OracleClob structToWktJS(Struct struct, Connection connection) throws SQLException {
        try {
            return Adapters.structToWkt2JS(struct, connection);
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            throw new RuntimeException(geometryExceptionWithContext.toString() + ": " + geometryExceptionWithContext.getSpecifics());
        }
    }

    protected static OracleClob structToWkt2JS(Struct struct, Connection connection) throws SQLException, GeometryExceptionWithContext {
        if (struct == null) {
            return null;
        }
        if (connection == null) {
            throw new RuntimeException("conn is null.");
        }
        try {
            byte[] byArray = m_wktAdapter.fromStruct(struct);
            OracleClob oracleClob = (OracleClob)connection.createClob();
            oracleClob.open(LargeObjectAccessMode.MODE_READWRITE);
            OutputStream outputStream = oracleClob.setAsciiStream(0L);
            outputStream.write(byArray);
            outputStream.flush();
            outputStream.close();
            oracleClob.close();
            return oracleClob;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.toString());
        }
    }

    public static String validateWkb(OracleBlob oracleBlob) {
        return Adapters.validateWkb(oracleBlob, m_conn);
    }

    public static String validateWkb(OracleBlob oracleBlob, Connection connection) {
        try {
            Adapters.wkbToSTRUCT2(oracleBlob, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static String validateWkt(OracleClob oracleClob) {
        return Adapters.validateWkt(oracleClob, m_conn);
    }

    public static String validateWkt(OracleClob oracleClob, Connection connection) {
        try {
            Adapters.wktToSTRUCT2(oracleClob, connection);
            return "TRUE";
        }
        catch (GeometryExceptionWithContext geometryExceptionWithContext) {
            return geometryExceptionWithContext.getOracleErrorMessage() + " " + geometryExceptionWithContext.getContext();
        }
        catch (Exception exception) {
            return "FALSE";
        }
    }

    public static Struct gml311ToSTRUCT(OracleClob oracleClob) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gml311ToSTRUCT(string, m_conn);
    }

    public static Struct gml311ToSTRUCT(OracleClob oracleClob, NUMBER nUMBER) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gml311ToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gml311ToSTRUCT(OracleClob oracleClob, String string) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string2 = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gml311ToSTRUCT(string2, string);
    }

    public static Struct gml311ToSTRUCT(OracleClob oracleClob, String string, NUMBER nUMBER) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string2 = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gml311ToSTRUCT(string2, string, nUMBER);
    }

    public static Struct gmlToSTRUCT(OracleClob oracleClob) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gmlToSTRUCT(string, m_conn);
    }

    public static Struct gmlToSTRUCT(OracleClob oracleClob, NUMBER nUMBER) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gmlToSTRUCT(string, m_conn, nUMBER);
    }

    public static Struct gmlToSTRUCT(OracleClob oracleClob, String string) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string2 = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gmlToSTRUCT(string2, string);
    }

    public static Struct gmlToSTRUCT(OracleClob oracleClob, String string, NUMBER nUMBER) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string2 = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.gmlToSTRUCT(string2, string, nUMBER);
    }

    public static Struct kmlToSTRUCT(OracleClob oracleClob) throws SQLException {
        oracleClob.open(LargeObjectAccessMode.MODE_READONLY);
        String string = oracleClob.getSubString(1L, (int)oracleClob.length());
        oracleClob.close();
        return Adapters.kmlToSTRUCT(string, m_conn);
    }

    public static OracleBlob pctrclipJS(Struct struct, Struct struct2, OracleBlob oracleBlob, NUMBER nUMBER, NUMBER nUMBER2, OracleBlob oracleBlob2, NUMBER nUMBER3, NUMBER nUMBER4, NUMBER nUMBER5) throws SQLException, IOException, Exception {
        OracleBlob oracleBlob3 = (OracleBlob)m_conn.createBlob();
        int n = nUMBER2.intValue();
        double d = nUMBER4.doubleValue();
        Struct struct3 = struct2;
        int n2 = nUMBER.intValue();
        Ptclass[] ptclassArray = new Ptclass[n2];
        Ptclass[] ptclassArray2 = new Ptclass[n2];
        Adapters.readptsJS(oracleBlob, n2, n, ptclassArray, nUMBER5);
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        J3D_Geometry j3D_Geometry = jGeometry.getElemInfo() == null ? new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getPoint()[0], jGeometry.getPoint()[1], jGeometry.getPoint()[2]) : new J3D_Geometry(jGeometry.getType(), jGeometry.getSRID(), jGeometry.getElemInfo(), jGeometry.getOrdinatesArray());
        double[] dArray = null;
        double[] dArray2 = null;
        int n3 = 0;
        if (struct2 != null) {
            Object[] objectArray = struct2.getAttributes();
            dArray = ((OracleArray)objectArray[0]).getDoubleArray();
            dArray2 = ((OracleArray)objectArray[1]).getDoubleArray();
            if (dArray != null && dArray2 != null) {
                int n4 = n3 = dArray.length < dArray2.length ? dArray.length : dArray2.length;
            }
            if (n3 > n - 3) {
                n3 = n - 3;
            }
        }
        int n5 = 0;
        for (int i = 0; i < n2; ++i) {
            J3D_Geometry j3D_Geometry2;
            boolean bl = false;
            if (n3 > 0) {
                for (int j = 0; j < n3; ++j) {
                    if (!(dArray[j] > ptclassArray[i].ords[j + 3] + d) && !(dArray2[j] + d < ptclassArray[i].ords[j + 3])) continue;
                    bl = true;
                    break;
                }
            }
            if (bl || !j3D_Geometry.anyInteract(j3D_Geometry2 = new J3D_Geometry(3001, j3D_Geometry.getSRID(), ptclassArray[i].ords[0], ptclassArray[i].ords[1], ptclassArray[i].ords[2]), d)) continue;
            ptclassArray2[n5++] = ptclassArray[i];
        }
        if (n5 > 0) {
            Adapters.writeptsJS(oracleBlob3, n5, n, ptclassArray2, nUMBER5);
        }
        return oracleBlob3;
    }

    public static void readptsJS(OracleBlob oracleBlob, int n, int n2, Ptclass[] ptclassArray, NUMBER nUMBER) throws SQLException, IOException {
        int n3 = Math.round(oracleBlob.length() / (long)n) - (n2 + 1) * 8;
        DataInputStream dataInputStream = new DataInputStream(oracleBlob.getBinaryStream());
        double[] dArray = new double[n2];
        for (int i = 0; i < n; ++i) {
            byte[] byArray = null;
            for (int j = 0; j < n2; ++j) {
                dArray[j] = dataInputStream.readDouble();
            }
            if (n3 > 0) {
                if (nUMBER.intValue() == 1) {
                    byArray = new byte[n3];
                    dataInputStream.readFully(byArray);
                } else {
                    dataInputStream.skipBytes(n3);
                }
            }
            int n4 = dataInputStream.readInt();
            int n5 = dataInputStream.readInt();
            ptclassArray[i] = new Ptclass(dArray, n2, n4, n5, byArray);
        }
    }

    public static void writeptsJS(OracleBlob oracleBlob, int n, int n2, Ptclass[] ptclassArray, NUMBER nUMBER) throws SQLException, IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(oracleBlob.setBinaryStream(1L));
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dataOutputStream.writeDouble(ptclassArray[i].ords[j]);
            }
            if (ptclassArray[i].m_customDims != null && nUMBER.intValue() == 1) {
                dataOutputStream.write(ptclassArray[i].m_customDims, 0, ptclassArray[i].m_customDims.length);
            }
            dataOutputStream.writeInt(ptclassArray[i].ptn_id);
            dataOutputStream.writeInt(ptclassArray[i].pt_id);
        }
        dataOutputStream.close();
    }

    public static String validateXMLRecord(CLOB cLOB, String string) throws Exception {
        String string2 = null;
        if (cLOB == null || string == null) {
            string2 = "NULL";
            return string2;
        }
        XMLValidator2 xMLValidator2 = new XMLValidator2(m_conn);
        try {
            xMLValidator2.schemaValidate(cLOB, string);
            string2 = "TRUE";
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    public static String validateXMLRecord(OracleClob oracleClob, String string) throws Exception {
        String string2 = null;
        if (oracleClob == null || string == null) {
            string2 = "NULL";
            return string2;
        }
        XMLValidator2 xMLValidator2 = new XMLValidator2(m_conn);
        try {
            xMLValidator2.schemaValidate(oracleClob, string);
            string2 = "TRUE";
        }
        catch (Exception exception) {
            string2 = exception.getMessage();
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NUMBER validateXSDXMLLayer(String string, String string2, String string3, String string4, NUMBER nUMBER) throws SQLSyntaxErrorException, SQLException, Exception {
        ResultSet resultSet = null;
        Statement statement = null;
        Statement statement2 = null;
        Statement statement3 = null;
        int n = 0;
        int n2 = 0;
        int n3 = nUMBER.intValue();
        try {
            string2 = Util.enquoteNameSQLName(m_conn, string2);
            string = Util.enquoteTableName(m_conn, string);
            string4 = Util.enquoteTableName(m_conn, string4);
        }
        catch (SQLException sQLException) {
            return new NUMBER(0);
        }
        XMLValidator2 xMLValidator2 = new XMLValidator2(m_conn);
        try {
            m_conn.setAutoCommit(false);
            statement = m_conn.createStatement();
            resultSet = statement.executeQuery("SELECT rowid, " + Util.enquoteNameSQLName(m_conn, string2) + " FROM " + Util.enquoteTableName(m_conn, string));
            statement3 = m_conn.prepareStatement("INSERT INTO " + Util.enquoteTableName(m_conn, string4) + " VALUES (?,?)");
            while (resultSet.next()) {
                Object object;
                RowId rowId = resultSet.getRowId(1);
                CLOB cLOB = null;
                if (resultSet.getObject(2) != null) {
                    object = null;
                    object = JDBCAdapter.getXMLType(resultSet.getObject(2));
                    cLOB = object.getClobVal();
                }
                ++n2;
                object = null;
                if (cLOB != null) {
                    try {
                        xMLValidator2.schemaValidate((OracleClob)cLOB, string3);
                    }
                    catch (Exception exception) {
                        object = exception.getMessage();
                    }
                } else {
                    object = "NULL";
                }
                if (object != null) {
                    statement3.setRowId(1, rowId);
                    statement3.setString(2, (String)object);
                    statement3.executeUpdate();
                }
                if (++n != n3) continue;
                m_conn.commit();
                n = 0;
            }
            statement3 = m_conn.prepareStatement("INSERT INTO " + Util.enquoteTableName(m_conn, string4) + " VALUES (NULL, ?)");
            statement3.setString(1, "Rows Processed " + String.valueOf(n2));
            statement3.executeUpdate();
            m_conn.commit();
        }
        catch (OracleSQLException oracleSQLException) {
            NUMBER nUMBER2 = new NUMBER(0);
            return nUMBER2;
        }
        catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
            NUMBER nUMBER3 = new NUMBER(0);
            return nUMBER3;
        }
        catch (SQLException sQLException) {
            NUMBER nUMBER4 = new NUMBER(0);
            return nUMBER4;
        }
        catch (Exception exception) {
            NUMBER nUMBER5 = new NUMBER(0);
            return nUMBER5;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                    resultSet = null;
                }
                if (statement2 != null) {
                    statement2.close();
                }
                if (statement3 != null) {
                    statement3.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (OracleSQLException oracleSQLException) {
                return new NUMBER(0);
            }
            catch (SQLSyntaxErrorException sQLSyntaxErrorException) {
                return new NUMBER(0);
            }
            catch (SQLException sQLException) {
                return new NUMBER(0);
            }
            catch (Exception exception) {
                return new NUMBER(0);
            }
        }
        return new NUMBER(n2);
    }

    public static Clob encodePolylineAsClob(Struct struct, NUMBER nUMBER) throws SQLException, Exception {
        JGeometry jGeometry = JGeometry.loadJS((Struct)struct);
        Clob clob = null;
        String string = JGeometry.encodePolyline((double[])jGeometry.getOrdinatesArray(), (int)nUMBER.intValue());
        clob = m_conn.createClob();
        clob.setString(1L, string);
        return clob;
    }

    public static Struct decodePolylineAsGeom(Clob clob, NUMBER nUMBER, NUMBER nUMBER2) throws SQLException, Exception {
        int n = 2;
        STRUCT sTRUCT = null;
        String string = clob.getSubString(1L, (int)clob.length());
        double[] dArray = JGeometry.decodePolyline((String)string, (int)nUMBER2.intValue());
        JGeometry jGeometry = JGeometry.createLinearLineString((double[])dArray, (int)n, (int)nUMBER.intValue());
        if (jGeometry != null) {
            sTRUCT = JGeometry.store((JGeometry)jGeometry, (Connection)m_conn);
        }
        return sTRUCT;
    }

    static {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection("jdbc:default:connection:");
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_conn = connection;
        m_wkbAdapter = new WKB();
        m_wktAdapter = new WKT();
    }

    static class Ptclass {
        protected double[] ords;
        protected int ptn_id;
        protected int pt_id;
        protected byte[] m_customDims;

        Ptclass(double[] dArray, int n, int n2, int n3, byte[] byArray) {
            this.ords = new double[n];
            for (int i = 0; i < n; ++i) {
                this.ords[i] = dArray[i];
            }
            this.ptn_id = n2;
            this.pt_id = n3;
            this.m_customDims = byArray;
        }
    }
}

