/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.liberty.v12;

import java.net.URLEncoder;
import java.security.PrivateKey;
import java.util.Date;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.liberty.v12.IDPProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v12.LibDSigUtils;
import oracle.security.xmlsec.liberty.v12.LibRequestMessage;
import oracle.security.xmlsec.liberty.v12.LibertyInitializer;
import oracle.security.xmlsec.liberty.v12.LibertyUtils;
import oracle.security.xmlsec.liberty.v12.OldProvidedNameIdentifier;
import oracle.security.xmlsec.liberty.v12.SPProvidedNameIdentifier;
import oracle.security.xmlsec.saml.SAMLInitializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegisterNameIdentifierRequest
extends LibRequestMessage {
    public RegisterNameIdentifierRequest(Element element) throws DOMException {
        super(element);
    }

    public RegisterNameIdentifierRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public RegisterNameIdentifierRequest(Document owner) throws DOMException {
        super(owner, "urn:liberty:iff:2003-08", "RegisterNameIdentifierRequest");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:liberty:iff:2003-08");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:1.0:protocol");
    }

    public RegisterNameIdentifierRequest(Document owner, String requestId, Date issueInstant, String providerId) throws DOMException {
        this(owner);
        this.setRequestID(requestId);
        this.setIssueInstant(issueInstant);
        this.setProviderID(providerId);
    }

    public void setIDPProvidedNameIdentifier(IDPProvidedNameIdentifier idpNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)idpNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public IDPProvidedNameIdentifier getIDPProvidedNameIdentifier() {
        return (IDPProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "urn:liberty:iff:2003-08", "IDPProvidedNameIdentifier");
    }

    public void setSPProvidedNameIdentifier(SPProvidedNameIdentifier spNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)spNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public SPProvidedNameIdentifier getSPProvidedNameIdentifier() {
        return (SPProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "urn:liberty:iff:2003-08", "SPProvidedNameIdentifier");
    }

    public void setOldProvidedNameIdentifier(OldProvidedNameIdentifier oldNameId) {
        LibertyUtils.setChildElement((XMLElement)this, (XMLElement)oldNameId, this.getChildElementsNSURIs(), this.getChildElementsLocalNames());
    }

    public OldProvidedNameIdentifier getOldProvidedNameIdentifier() {
        return (OldProvidedNameIdentifier)LibertyUtils.getChildElement((XMLElement)this, "urn:liberty:iff:2003-08", "OldProvidedNameIdentifier");
    }

    public void setRelayState(String value) throws DOMException {
        LibertyUtils.insertChildElementWithText((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState", this.getChildElementsNSURIs(), this.getChildElementsLocalNames(), value, true);
    }

    public String getRelayState() {
        return LibertyUtils.collectTextFromChild((XMLElement)this, "urn:liberty:iff:2003-08", "RelayState");
    }

    public String toURLString(PrivateKey key, String sigAlg) throws SigningException {
        int last;
        String relayState;
        OldProvidedNameIdentifier oldni;
        SPProvidedNameIdentifier spni;
        IDPProvidedNameIdentifier idpni;
        String providerID;
        StringBuffer queryBuffer = new StringBuffer();
        String requestID = this.getRequestID();
        if (requestID != null) {
            queryBuffer.append("RequestID=");
            queryBuffer.append(URLEncoder.encode(requestID));
            queryBuffer.append('&');
        }
        queryBuffer.append("MajorVersion=1&MinorVersion=2&");
        Date issueInstant = this.getIssueInstant();
        if (issueInstant != null) {
            queryBuffer.append("IssueInstant=");
            queryBuffer.append(URLEncoder.encode(XMLUtils.formatDateTime((Date)issueInstant)));
            queryBuffer.append('&');
        }
        if ((providerID = this.getProviderID()) != null) {
            queryBuffer.append("ProviderID=");
            queryBuffer.append(URLEncoder.encode(providerID));
            queryBuffer.append('&');
        }
        if ((idpni = this.getIDPProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = idpni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("IDPNameQualifier=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = idpni.getFormat()) != null) {
                queryBuffer.append("IDPNameFormat=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = idpni.getValue()) != null) {
                queryBuffer.append("IDPProvidedNameIdentifier=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((spni = this.getSPProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = spni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("SPNameQualifier=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = spni.getFormat()) != null) {
                queryBuffer.append("SPNameFormat=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = spni.getValue()) != null) {
                queryBuffer.append("SPProvidedNameIdentifier=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((oldni = this.getOldProvidedNameIdentifier()) != null) {
            String nameValue;
            String nameFormat;
            String nameQualifier = oldni.getNameQualifier();
            if (nameQualifier != null) {
                queryBuffer.append("OldNameQualifier=");
                queryBuffer.append(URLEncoder.encode(nameQualifier));
                queryBuffer.append('&');
            }
            if ((nameFormat = oldni.getFormat()) != null) {
                queryBuffer.append("OldNameFormat=");
                queryBuffer.append(URLEncoder.encode(nameFormat));
                queryBuffer.append('&');
            }
            if ((nameValue = oldni.getValue()) != null) {
                queryBuffer.append("OldProvidedNameIdentifier=");
                queryBuffer.append(URLEncoder.encode(nameValue));
                queryBuffer.append('&');
            }
        }
        if ((relayState = this.getRelayState()) != null) {
            queryBuffer.append("RelayState=");
            queryBuffer.append(URLEncoder.encode(relayState));
            queryBuffer.append('&');
        }
        if (key != null && sigAlg != null) {
            queryBuffer.append("SigAlg=");
            queryBuffer.append(URLEncoder.encode(sigAlg));
            String toBeSigned = queryBuffer.toString();
            String sigValue = LibDSigUtils.signURL(toBeSigned, key, sigAlg);
            queryBuffer.append("&Signature=");
            queryBuffer.append(sigValue);
        }
        if ((last = queryBuffer.length() - 1) >= 0 && queryBuffer.charAt(last) == '&') {
            queryBuffer.deleteCharAt(last);
        }
        return queryBuffer.toString();
    }

    @Override
    protected String[] getChildElementsNSURIs() {
        return new String[]{"urn:oasis:names:tc:SAML:1.0:protocol", "http://www.w3.org/2000/09/xmldsig#", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08", "urn:liberty:iff:2003-08"};
    }

    @Override
    protected String[] getChildElementsLocalNames() {
        return new String[]{"RespondWith", "Signature", "Extension", "ProviderID", "IDPProvidedNameIdentifier", "SPProvidedNameIdentifier", "OldProvidedNameIdentifier", "RelayState"};
    }

    static {
        SAMLInitializer.initialize((int)1, (int)1);
        LibertyInitializer.initialize();
    }
}

